/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.file.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.file.dao.FmUpFileMapper;
import com.yqbsoft.laser.service.file.domain.FmUpFileDomain;
import com.yqbsoft.laser.service.file.domain.FmUpFileReDomain;
import com.yqbsoft.laser.service.file.model.FmUpFile;
import com.yqbsoft.laser.service.file.service.FmUpFileService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FmUpFileServiceImpl
extends BaseServiceImpl
implements FmUpFileService {
    private static final String SYS_CODE = "fm.FILE.FmUpFileServiceImpl";
    private FmUpFileMapper fmUpFileMapper;

    public void setFmUpFileMapper(FmUpFileMapper fmUpFileMapper) {
        this.fmUpFileMapper = fmUpFileMapper;
    }

    private Date getSysDate() {
        try {
            return this.fmUpFileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpFileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFmUpFile(FmUpFileDomain fmUpFileDomain) {
        if (null == fmUpFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)fmUpFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFmUpFileDefault(FmUpFile fmUpFile) {
        if (null == fmUpFile) {
            return;
        }
        if (null == fmUpFile.getDataState()) {
            fmUpFile.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == fmUpFile.getGmtCreate()) {
            fmUpFile.setGmtCreate(date);
        }
        fmUpFile.setGmtModified(date);
        if (StringUtils.isBlank((String)fmUpFile.getUpfileCode())) {
            fmUpFile.setUpfileCode(this.getNo(null, "FmUpFile", "fmUpFile", fmUpFile.getTenantCode()));
        }
    }

    private int getFmUpFileMaxCode() {
        int code = 0;
        try {
            return this.fmUpFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpFileServiceImpl.getFmUpFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFmUpFileUpdataDefault(FmUpFile fmUpFile) {
        if (null == fmUpFile) {
            return;
        }
        fmUpFile.setGmtModified(this.getSysDate());
    }

    private void saveFmUpFileModel(FmUpFile fmUpFile) throws ApiException {
        if (null == fmUpFile) {
            return;
        }
        try {
            this.fmUpFileMapper.insert(fmUpFile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.saveFmUpFileModel.ex", (Throwable)e);
        }
    }

    private void saveFmUpFileBatchModel(List<FmUpFile> fmUpFileList) throws ApiException {
        if (null == fmUpFileList || fmUpFileList.isEmpty()) {
            return;
        }
        try {
            this.fmUpFileMapper.insertBatch(fmUpFileList);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.saveFmUpFileBatchModel.ex", (Throwable)e);
        }
    }

    private FmUpFile getFmUpFileModelById(Integer upfileId) {
        if (null == upfileId) {
            return null;
        }
        try {
            return this.fmUpFileMapper.selectByPrimaryKey(upfileId);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpFileServiceImpl.getFmUpFileModelById", (Throwable)e);
            return null;
        }
    }

    private FmUpFile getFmUpFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.fmUpFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpFileServiceImpl.getFmUpFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delFmUpFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUpFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.delFmUpFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.delFmUpFileModelByCode.num");
        }
    }

    private void deleteFmUpFileModel(Integer upfileId) throws ApiException {
        if (null == upfileId) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUpFileMapper.deleteByPrimaryKey(upfileId);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.deleteFmUpFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.deleteFmUpFileModel.num");
        }
    }

    private void updateFmUpFileModel(FmUpFile fmUpFile) throws ApiException {
        if (null == fmUpFile) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUpFileMapper.updateByPrimaryKey(fmUpFile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.updateFmUpFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.updateFmUpFileModel.num");
        }
    }

    private void updateStateFmUpFileModel(Integer upfileId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == upfileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("upfileId", upfileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fmUpFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.updateStateFmUpFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.updateStateFmUpFileModel.null");
        }
    }

    private void updateStateFmUpFileModelByCode(String tenantCode, String upfileCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)upfileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upfileCode", upfileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fmUpFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.updateStateFmUpFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.updateStateFmUpFileModelByCode.null");
        }
    }

    private FmUpFile makeFmUpFile(FmUpFileDomain fmUpFileDomain, FmUpFile fmUpFile) {
        if (null == fmUpFileDomain) {
            return null;
        }
        if (null == fmUpFile) {
            fmUpFile = new FmUpFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fmUpFile, (Object)fmUpFileDomain);
            return fmUpFile;
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpFileServiceImpl.makeFmUpFile", (Throwable)e);
            return null;
        }
    }

    private FmUpFileReDomain makeFmUpFileReDomain(FmUpFile fmUpFile) {
        if (null == fmUpFile) {
            return null;
        }
        FmUpFileReDomain fmUpFileReDomain = new FmUpFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)fmUpFileReDomain, (Object)fmUpFile);
            return fmUpFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpFileServiceImpl.makeFmUpFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<FmUpFile> queryFmUpFileModelPage(Map<String, Object> parammap) {
        try {
            return this.fmUpFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpFileServiceImpl.queryFmUpFileModel", (Throwable)e);
            return null;
        }
    }

    private int countFmUpFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fmUpFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpFileServiceImpl.countFmUpFile", (Throwable)e);
        }
        return i;
    }

    private FmUpFile createFmUpFile(FmUpFileDomain fmUpFileDomain) {
        String msg = this.checkFmUpFile(fmUpFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.saveFmUpFile.checkFmUpFile", msg);
        }
        FmUpFile fmUpFile = this.makeFmUpFile(fmUpFileDomain, null);
        this.setFmUpFileDefault(fmUpFile);
        return fmUpFile;
    }

    @Override
    public String saveFmUpFile(FmUpFileDomain fmUpFileDomain) throws ApiException {
        FmUpFile fmUpFile = this.createFmUpFile(fmUpFileDomain);
        this.saveFmUpFileModel(fmUpFile);
        return fmUpFile.getUpfileCode();
    }

    @Override
    public String saveFmUpFileBatch(List<FmUpFileDomain> fmUpFileDomainList) throws ApiException {
        if (null == fmUpFileDomainList || fmUpFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<FmUpFile> fmUpFileList = new ArrayList<FmUpFile>();
        String code = "";
        for (FmUpFileDomain fmUpFileDomain : fmUpFileDomainList) {
            FmUpFile fmUpFile = this.createFmUpFile(fmUpFileDomain);
            code = fmUpFile.getUpfileCode();
            fmUpFileList.add(fmUpFile);
        }
        this.saveFmUpFileBatchModel(fmUpFileList);
        return code;
    }

    @Override
    public void updateFmUpFileState(Integer upfileId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == upfileId) {
            return;
        }
        this.updateStateFmUpFileModel(upfileId, dataState, oldDataState, map);
    }

    @Override
    public void updateFmUpFileStateByCode(String tenantCode, String upfileCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)upfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateFmUpFileModelByCode(tenantCode, upfileCode, dataState, oldDataState, map);
    }

    @Override
    public void updateFmUpFile(FmUpFileDomain fmUpFileDomain) throws ApiException {
        String msg = this.checkFmUpFile(fmUpFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.updateFmUpFile.checkFmUpFile", msg);
        }
        FmUpFile oldFmUpFile = this.getFmUpFileModelById(fmUpFileDomain.getUpfileId());
        if (null == oldFmUpFile) {
            throw new ApiException("fm.FILE.FmUpFileServiceImpl.updateFmUpFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FmUpFile fmUpFile = this.makeFmUpFile(fmUpFileDomain, oldFmUpFile);
        this.setFmUpFileUpdataDefault(fmUpFile);
        this.updateFmUpFileModel(fmUpFile);
    }

    @Override
    public FmUpFile getFmUpFile(Integer upfileId) {
        if (null == upfileId) {
            return null;
        }
        return this.getFmUpFileModelById(upfileId);
    }

    @Override
    public void deleteFmUpFile(Integer upfileId) throws ApiException {
        if (null == upfileId) {
            return;
        }
        this.deleteFmUpFileModel(upfileId);
    }

    @Override
    public QueryResult<FmUpFile> queryFmUpFilePage(Map<String, Object> map) {
        List<FmUpFile> fmUpFileList = this.queryFmUpFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFmUpFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fmUpFileList);
        return queryResult;
    }

    @Override
    public FmUpFile getFmUpFileByCode(String tenantCode, String upfileCode) throws ApiException {
        if (StringUtils.isBlank((String)upfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upfileCode", upfileCode);
        return this.getFmUpFileModelByCode(map);
    }

    @Override
    public void deleteFmUpFileByCode(String tenantCode, String upfileCode) throws ApiException {
        if (StringUtils.isBlank((String)upfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upfileCode", upfileCode);
        this.delFmUpFileModelByCode(map);
    }
}

