/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.controller;

import com.yqbsoft.laser.service.flowable.entity.HistanceInstanceEntity;
import com.yqbsoft.laser.service.flowable.entity.ParamObj;
import com.yqbsoft.laser.service.flowable.entity.ProcessInstanceEntity;
import com.yqbsoft.laser.service.flowable.entity.ProcessStatusEntity;
import com.yqbsoft.laser.service.flowable.entity.TaskInstanceEntity;
import com.yqbsoft.laser.service.flowable.service.IProcess;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flowableTest"})
public class FlowableController {
    @Autowired
    IProcess process;

    @PostMapping(value={"/startProcess"})
    public ProcessInstanceEntity startProcess(@RequestBody ParamObj paramObj) {
        return this.process.startProcess(paramObj);
    }

    @GetMapping(value={"/getTaskInstance"})
    public List<TaskInstanceEntity> taskInstance(String assignee) {
        return this.process.taskInstance(assignee);
    }

    @PutMapping(value={"/handleTask"})
    public String handleTask(@RequestBody ParamObj paramObj) {
        this.process.handleTask(paramObj);
        return "success";
    }

    @GetMapping(value={"/queryProcessStatus"})
    public List<ProcessStatusEntity> queryProcessStatus(String processInstanceId) {
        return this.process.queryProcessStatus(processInstanceId);
    }

    @GetMapping(value={"/queryProcessVariables"})
    public Map<String, Object> queryProcessVariables(String processInstanceId) {
        return this.process.queryProcessVariables(processInstanceId);
    }

    @GetMapping(value={"/queryHistoryProcess"})
    public List<HistanceInstanceEntity> queryHistoryProcess(String assignee) {
        return this.process.queryHistoryProcess(assignee);
    }

    @GetMapping(value={"/genProcessDiagram"})
    public void genProcessDiagram(HttpServletResponse httpServletResponse, String processInstanceId) throws Exception {
        this.process.genProcessDiagram(httpServletResponse, processInstanceId);
    }

    @GetMapping(value={"/isExistHistoricProcessInstance"})
    public boolean isExistHistoricProcessInstance(String processInstanceId) {
        return this.process.isExistHistoricProcessInstance(processInstanceId);
    }

    @GetMapping(value={"/isProcessFinished"})
    public boolean isProcessFinished(String processInstanceId) {
        return this.process.isProcessFinished(processInstanceId);
    }

    @GetMapping(value={"/isExistRunningProcessInstance"})
    public boolean isExistRunningProcessInstance(String processInstanceId) {
        return this.process.isExistRunningProcessInstance(processInstanceId);
    }

    @PutMapping(value={"/suspendProcessInstance"})
    public String suspendProcessInstance(String processInstanceId) {
        this.process.suspendProcessInstance(processInstanceId);
        return "\u6d41\u7a0b " + processInstanceId + " \u5df2\u7ecf\u6302\u8d77";
    }

    @PutMapping(value={"/terminateProcessInstance"})
    public String terminateProcessInstance(ParamObj paramObj) {
        this.process.terminateProcessInstance(paramObj);
        return "\u6d41\u7a0b " + paramObj.getProcessInstanceId() + " \u5df2\u7ecf\u7ec8\u6b62";
    }

    @PutMapping(value={"/activateProcessInstance"})
    public String activateProcessInstance(String processInstanceId) {
        this.process.activateProcessInstance(processInstanceId);
        return "\u6d41\u7a0b " + processInstanceId + " \u5df2\u7ecf\u6fc0\u6d3b";
    }

    @PutMapping(value={"/deleteProcessInstance"})
    public String deleteProcessInstance(ParamObj paramObj) {
        this.process.deleteProcessInstance(paramObj);
        return "\u6d41\u7a0b " + paramObj.getProcessInstanceId() + " \u5df2\u7ecf\u5220\u9664";
    }

    @PutMapping(value={"/rollback"})
    public String rollbackTask(String taskId, String targetTaskKey) {
        this.process.rollbackTask(taskId, targetTaskKey);
        return "\u6d41\u7a0b\u56de\u9000\u6210\u529f";
    }
}

