/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import java.io.Serializable;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;

public class DeleteProcessInstanceCmd
implements Command<Void>,
Serializable {
    String processInstanceId;
    String deleteReason;
    boolean cascade = true;

    public DeleteProcessInstanceCmd() {
    }

    public DeleteProcessInstanceCmd(String processInstanceId, String deleteReason) {
        this.deleteReason = deleteReason;
        this.processInstanceId = processInstanceId;
    }

    public DeleteProcessInstanceCmd(String processInstanceId, String deleteReason, boolean cascade) {
        this.deleteReason = deleteReason;
        this.processInstanceId = processInstanceId;
        this.cascade = cascade;
    }

    public Void execute(CommandContext commandContext) {
        ExecutionEntity entity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager((CommandContext)commandContext).findById(this.processInstanceId);
        if (entity != null) {
            if (entity.isDeleted()) {
                return null;
            }
            if (Flowable5Util.isFlowable5ProcessDefinitionId((CommandContext)commandContext, (String)entity.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler handler = Flowable5Util.getFlowable5CompatibilityHandler();
                handler.deleteProcessInstance(this.processInstanceId, this.deleteReason);
            } else {
                CommandContextUtil.getExecutionEntityManager((CommandContext)commandContext).deleteProcessInstance(entity.getProcessInstanceId(), this.deleteReason, this.cascade);
            }
        }
        return null;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getDeleteReason() {
        return this.deleteReason;
    }

    public boolean isCascade() {
        return this.cascade;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    public void setCascade(boolean cascade) {
        this.cascade = cascade;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteProcessInstanceCmd)) {
            return false;
        }
        DeleteProcessInstanceCmd other = (DeleteProcessInstanceCmd)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCascade() != other.isCascade()) {
            return false;
        }
        String this$processInstanceId = this.getProcessInstanceId();
        String other$processInstanceId = other.getProcessInstanceId();
        if (this$processInstanceId == null ? other$processInstanceId != null : !this$processInstanceId.equals(other$processInstanceId)) {
            return false;
        }
        String this$deleteReason = this.getDeleteReason();
        String other$deleteReason = other.getDeleteReason();
        return !(this$deleteReason == null ? other$deleteReason != null : !this$deleteReason.equals(other$deleteReason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteProcessInstanceCmd;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCascade() ? 79 : 97);
        String $processInstanceId = this.getProcessInstanceId();
        result = result * 59 + ($processInstanceId == null ? 43 : $processInstanceId.hashCode());
        String $deleteReason = this.getDeleteReason();
        result = result * 59 + ($deleteReason == null ? 43 : $deleteReason.hashCode());
        return result;
    }

    public String toString() {
        return "DeleteProcessInstanceCmd(processInstanceId=" + this.getProcessInstanceId() + ", deleteReason=" + this.getDeleteReason() + ", cascade=" + this.isCascade() + ")";
    }
}

