/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.flowable.entity.HistanceInstanceEntity;
import com.yqbsoft.laser.service.flowable.entity.ParamObj;
import com.yqbsoft.laser.service.flowable.entity.ProcessInstanceEntity;
import com.yqbsoft.laser.service.flowable.entity.ProcessStatusEntity;
import com.yqbsoft.laser.service.flowable.entity.TaskInstanceEntity;
import com.yqbsoft.laser.service.flowable.service.IProcess;
import com.yqbsoft.laser.service.flowable.service.impl.DeleteProcessInstanceCmd;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.task.Comment;
import org.flowable.image.ProcessDiagramGenerator;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IProcessImpl
implements IProcess {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    ManagementService managementService;

    @Override
    public ProcessInstanceEntity startProcess(ParamObj paramObj) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("resourceId", paramObj.getResourceId());
        variables.put("requestUser", paramObj.getRequestUser());
        variables.put("juniorAdmin", paramObj.getJuniorAdmin());
        variables.put("seniorAdmin", paramObj.getSeniorAdmin());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("processTest", variables);
        ProcessInstanceEntity entity = new ProcessInstanceEntity();
        entity.setProcessDeploymentId(processInstance.getDeploymentId());
        entity.setProcessInstanceId(processInstance.getProcessInstanceId());
        entity.setActivityId(processInstance.getActivityId());
        return entity;
    }

    @Override
    public List<TaskInstanceEntity> taskInstance(String assignee) {
        ArrayList<TaskInstanceEntity> entities = new ArrayList<TaskInstanceEntity>();
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskAssignee(assignee)).orderByTaskCreateTime()).desc()).list();
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            tasks.stream().forEach(task -> {
                TaskInstanceEntity entity = new TaskInstanceEntity();
                String id = task.getId();
                entity.setCreateTime(task.getCreateTime());
                entity.setTaskName(task.getName());
                entity.setProcessInstanceId(task.getProcessInstanceId());
                entity.setTaskId(id);
                Map processVariables = this.taskService.getVariables(id);
                entity.setRequestUser(processVariables.get("requestUser").toString());
                entity.setResourceId(processVariables.get("resourceId").toString());
                entities.add(entity);
            });
        }
        return entities;
    }

    @Override
    public void handleTask(ParamObj paramObj) {
        HashMap<String, String> taskVariables = new HashMap<String, String>();
        String approved = paramObj.isApproved() ? "Y" : "N";
        taskVariables.put("approved", approved);
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("approved", approved);
        map.put("comment", paramObj.getComment());
        try {
            String json = objectMapper.writeValueAsString(map);
            this.taskService.addComment(paramObj.getTaskId(), null, json);
            this.taskService.complete(paramObj.getTaskId(), taskVariables);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ProcessStatusEntity> queryProcessStatus(String processInstanceId) {
        ArrayList<ProcessStatusEntity> result = new ArrayList<ProcessStatusEntity>();
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
        if (CollectionUtils.isEmpty((Collection)historicTaskInstances)) {
            throw new RuntimeException("Process instance [" + processInstanceId + "] not exist");
        }
        for (HistoricTaskInstance hti : historicTaskInstances) {
            String taskId = hti.getId();
            String taskName = hti.getName();
            String assignee = hti.getAssignee();
            Date createTime = hti.getCreateTime();
            String comment = null;
            String approved = null;
            List comments = this.taskService.getTaskComments(taskId);
            if (!CollectionUtils.isEmpty((Collection)comments) && null != (comment = ((Comment)comments.get(0)).getFullMessage())) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    Map data = (Map)mapper.readValue(comment, Map.class);
                    approved = data.get("approved").toString();
                    comment = data.get("comment").toString();
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            }
            ProcessStatusEntity pd = new ProcessStatusEntity();
            pd.setTaskName(taskName);
            pd.setAssignee(assignee);
            pd.setCreateTime(createTime);
            pd.setApproved(approved);
            pd.setComment(comment);
            pd.setTaskId(hti.getId());
            pd.setProcessInstanceId(hti.getProcessInstanceId());
            result.add(pd);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryProcessVariables(String processInstanceId) {
        List historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).list();
        if (historicVariableInstances == null) {
            throw new RuntimeException("Process instance [" + processInstanceId + "] not exist");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (HistoricVariableInstance var : historicVariableInstances) {
            ret.put(var.getVariableName(), var.getValue());
        }
        return ret;
    }

    @Override
    public List<HistanceInstanceEntity> queryHistoryProcess(String assignee) {
        ArrayList<HistanceInstanceEntity> result = new ArrayList<HistanceInstanceEntity>();
        List activities = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().taskAssignee(assignee).finished().orderByHistoricActivityInstanceEndTime().desc()).list();
        for (HistoricActivityInstance h : activities) {
            HistanceInstanceEntity d = new HistanceInstanceEntity();
            d.setProcessInstanceId(h.getProcessInstanceId());
            d.setTaskId(h.getTaskId());
            d.setStartTime(h.getStartTime());
            d.setEndTime(h.getEndTime());
            result.add(d);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void genProcessDiagram(HttpServletResponse httpServletResponse, String processInstanceId) throws Exception {
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (pi == null) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u8be5\u6d41\u7a0b\u6216\u5219\u6d41\u7a0b\u5df2\u7ecf\u8d70\u5b8c");
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId())).singleResult();
        String InstanceId = task.getProcessInstanceId();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(InstanceId).list();
        ArrayList activityIds = new ArrayList();
        ArrayList flows = new ArrayList();
        for (Execution exe : executions) {
            List ids = this.runtimeService.getActiveActivityIds(exe.getId());
            activityIds.addAll(ids);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(pi.getProcessDefinitionId());
        ProcessEngineConfiguration engineConf = this.processEngine.getProcessEngineConfiguration();
        ProcessDiagramGenerator diagramGenerator = engineConf.getProcessDiagramGenerator();
        InputStream in = diagramGenerator.generateDiagram(bpmnModel, "png", activityIds, flows, engineConf.getActivityFontName(), engineConf.getLabelFontName(), engineConf.getAnnotationFontName(), engineConf.getClassLoader(), 1.0, true);
        ServletOutputStream out = null;
        byte[] buf = new byte[1024];
        int length = 0;
        try {
            out = httpServletResponse.getOutputStream();
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public boolean isExistHistoricProcessInstance(String processInstanceId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        return historicProcessInstance != null;
    }

    @Override
    public boolean isExistRunningProcessInstance(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        return processInstance != null;
    }

    @Override
    public void suspendProcessInstance(String processInstanceId) {
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
    }

    @Override
    public void terminateProcessInstance(ParamObj paramObj) {
        this.runtimeService.deleteProcessInstance(paramObj.getProcessInstanceId(), paramObj.getDeleteReason());
    }

    @Override
    public void activateProcessInstance(String processInstanceId) {
        this.runtimeService.activateProcessInstanceById(processInstanceId);
    }

    @Override
    public void deleteProcessInstance(ParamObj paramObj) {
        long count = this.runtimeService.createExecutionQuery().processInstanceId(paramObj.getProcessInstanceId()).count();
        if (count > 0L) {
            DeleteProcessInstanceCmd cmd = new DeleteProcessInstanceCmd(paramObj.getProcessInstanceId(), paramObj.getDeleteReason(), true);
            this.managementService.executeCommand((Command)cmd);
        } else {
            this.historyService.deleteHistoricProcessInstance(paramObj.getProcessInstanceId());
        }
    }

    @Override
    public void rollbackTask(String taskId, String targetTaskKey) {
        Task currentTask = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (currentTask == null) {
            return;
        }
        ArrayList<String> key = new ArrayList<String>();
        key.add(currentTask.getTaskDefinitionKey());
        this.runtimeService.createChangeActivityStateBuilder().processInstanceId(currentTask.getProcessInstanceId()).moveActivityIdsToSingleActivityId(key, targetTaskKey).changeState();
    }

    @Override
    public boolean isProcessFinished(String processInstanceId) {
        return this.historyService.createHistoricProcessInstanceQuery().finished().processInstanceId(processInstanceId).count() > 0L;
    }
}

