/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.framework.flowable.core.behavior.script.impl;

import com.yqbsoft.laser.service.flowable.api.dept.DeptApi;
import com.yqbsoft.laser.service.flowable.api.dept.dto.DeptRespDTO;
import com.yqbsoft.laser.service.flowable.api.user.AdminUserApi;
import com.yqbsoft.laser.service.flowable.api.user.dto.AdminUserRespDTO;
import com.yqbsoft.laser.service.flowable.framework.flowable.core.behavior.script.BpmTaskAssignScript;
import com.yqbsoft.laser.service.flowable.service.BpmProcessInstanceService;
import com.yqbsoft.laser.service.flowable.util.collection.SetUtils;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Resource;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.Assert;

public abstract class BpmTaskAssignLeaderAbstractScript
implements BpmTaskAssignScript {
    @Resource
    private AdminUserApi adminUserApi;
    @Resource
    private DeptApi deptApi;
    @Resource
    @Lazy
    private BpmProcessInstanceService bpmProcessInstanceService;

    protected Set<String> calculateTaskCandidateUsers(DelegateExecution execution, int level) {
        Assert.isTrue((level > 0 ? 1 : 0) != 0, (String)"level \u5fc5\u987b\u5927\u4e8e 0");
        ProcessInstance processInstance = this.bpmProcessInstanceService.getProcessInstance(execution.getProcessInstanceId());
        String startUserId = processInstance.getStartUserId();
        DeptRespDTO dept = null;
        for (int i = 0; i < level; ++i) {
            if (dept == null) {
                dept = this.getStartUserDept(startUserId);
                if (dept != null) continue;
                return Collections.emptySet();
            }
            DeptRespDTO parentDept = this.deptApi.getDept(dept.getParentId());
            if (parentDept == null) break;
            dept = parentDept;
        }
        return dept.getLeaderUserId() != null ? SetUtils.asSet(dept.getLeaderUserId()) : Collections.emptySet();
    }

    private DeptRespDTO getStartUserDept(String startUserId) {
        AdminUserRespDTO startUser = this.adminUserApi.getUser(startUserId);
        if (startUser.getDeptId() == null) {
            return null;
        }
        return this.deptApi.getDept(startUser.getDeptId());
    }
}

