/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.framework.flowable.core.listener;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.ImmutableSet;
import com.yqbsoft.laser.service.flowable.service.BpmActivityService;
import com.yqbsoft.laser.service.flowable.service.BpmTaskService;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.AbstractFlowableEngineEventListener;
import org.flowable.engine.delegate.event.FlowableActivityCancelledEvent;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class BpmTaskEventListener
extends AbstractFlowableEngineEventListener {
    private static final Logger log = LoggerFactory.getLogger(BpmTaskEventListener.class);
    @Resource
    @Lazy
    private BpmTaskService taskService;
    @Resource
    @Lazy
    private BpmActivityService activityService;
    public static final Set<FlowableEngineEventType> TASK_EVENTS = ImmutableSet.builder().add((Object)FlowableEngineEventType.TASK_CREATED).add((Object)FlowableEngineEventType.TASK_ASSIGNED).add((Object)FlowableEngineEventType.TASK_COMPLETED).add((Object)FlowableEngineEventType.ACTIVITY_CANCELLED).build();

    public BpmTaskEventListener() {
        super(TASK_EVENTS);
    }

    protected void taskCreated(FlowableEngineEntityEvent event) {
        this.taskService.createTaskExt((Task)event.getEntity());
    }

    protected void taskCompleted(FlowableEngineEntityEvent event) {
        this.taskService.updateTaskExtComplete((Task)event.getEntity());
    }

    protected void taskAssigned(FlowableEngineEntityEvent event) {
        this.taskService.updateTaskExtAssign((Task)event.getEntity());
    }

    protected void activityCancelled(FlowableActivityCancelledEvent event) {
        List<HistoricActivityInstance> activityList = this.activityService.getHistoricActivityListByExecutionId(event.getExecutionId());
        if (CollUtil.isEmpty(activityList)) {
            log.error("[activityCancelled][\u4f7f\u7528 executionId({}) \u67e5\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u5b9e\u4f8b]", (Object)event.getExecutionId());
            return;
        }
        activityList.forEach(activity -> {
            if (StrUtil.isEmpty((CharSequence)activity.getTaskId())) {
                return;
            }
            this.taskService.updateTaskExtCancel(activity.getTaskId());
        });
    }
}

