/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.convert.BpmFormConvert;
import com.yqbsoft.laser.service.flowable.dao.BpmFormMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmFormDO;
import com.yqbsoft.laser.service.flowable.dto.BpmModelMetaInfoRespDTO;
import com.yqbsoft.laser.service.flowable.enums.BpmModelFormTypeEnum;
import com.yqbsoft.laser.service.flowable.pojo.PageResult;
import com.yqbsoft.laser.service.flowable.service.BpmFormService;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.util.json.JsonUtils;
import com.yqbsoft.laser.service.flowable.vo.BpmFormCreateReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmFormPageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmFormUpdateReqVO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;

@Validated
public class BpmFormServiceImpl
extends BaseServiceImpl
implements BpmFormService {
    @Resource
    private BpmFormMapper formMapper;

    @Override
    public Long createForm(BpmFormCreateReqVO createReqVO) {
        this.checkFields(createReqVO.getFields());
        BpmFormDO form = BpmFormConvert.INSTANCE.convert(createReqVO);
        this.formMapper.insert(form);
        return form.getId();
    }

    @Override
    public void updateForm(BpmFormUpdateReqVO updateReqVO) {
        this.checkFields(updateReqVO.getFields());
        this.validateFormExists(updateReqVO.getId());
        BpmFormDO updateObj = BpmFormConvert.INSTANCE.convert(updateReqVO);
        this.formMapper.updateById(updateObj);
    }

    @Override
    public void deleteForm(Long id) {
        this.validateFormExists(id);
        this.formMapper.deleteById(id);
    }

    private void validateFormExists(Long id) {
        if (this.formMapper.selectById(id) == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.FORM_NOT_EXISTS);
        }
    }

    @Override
    public BpmFormDO getForm(Long id) {
        return (BpmFormDO)this.formMapper.selectById(id);
    }

    @Override
    public List<BpmFormDO> getFormList() {
        return this.formMapper.selectList();
    }

    @Override
    public List<BpmFormDO> getFormList1(Collection<Long> ids) {
        return this.formMapper.selectBatchIds(ids);
    }

    @Override
    public PageResult<BpmFormDO> getFormPage(BpmFormPageReqVO pageReqVO) {
        return this.formMapper.selectPage(pageReqVO);
    }

    @Override
    public BpmFormDO checkFormConfig(String configStr) {
        BpmModelMetaInfoRespDTO metaInfo = JsonUtils.parseObject(configStr, BpmModelMetaInfoRespDTO.class);
        if (metaInfo == null || metaInfo.getFormType() == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_DEPLOY_FAIL_FORM_NOT_CONFIG);
        }
        if (Objects.equals(metaInfo.getFormType(), BpmModelFormTypeEnum.NORMAL.getType())) {
            BpmFormDO form = this.getForm(metaInfo.getFormId());
            if (form == null) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.FORM_NOT_EXISTS);
            }
            return form;
        }
        return null;
    }

    private void checkFields(List<String> fields) {
    }
}

