/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.api.dept.DeptApi;
import com.yqbsoft.laser.service.flowable.api.dept.dto.DeptRespDTO;
import com.yqbsoft.laser.service.flowable.api.user.AdminUserApi;
import com.yqbsoft.laser.service.flowable.api.user.dto.AdminUserRespDTO;
import com.yqbsoft.laser.service.flowable.convert.BpmProcessInstanceConvert;
import com.yqbsoft.laser.service.flowable.dao.BpmProcessInstanceExtMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmProcessDefinitionExtDO;
import com.yqbsoft.laser.service.flowable.domain.BpmProcessInstanceExtDO;
import com.yqbsoft.laser.service.flowable.dto.BpmProcessInstanceCreateReqDTO;
import com.yqbsoft.laser.service.flowable.enums.BpmProcessInstanceDeleteReasonEnum;
import com.yqbsoft.laser.service.flowable.enums.BpmProcessInstanceResultEnum;
import com.yqbsoft.laser.service.flowable.enums.BpmProcessInstanceStatusEnum;
import com.yqbsoft.laser.service.flowable.framework.bpm.core.event.BpmProcessInstanceResultEventPublisher;
import com.yqbsoft.laser.service.flowable.pojo.PageResult;
import com.yqbsoft.laser.service.flowable.service.BpmMessageService;
import com.yqbsoft.laser.service.flowable.service.BpmProcessDefinitionService;
import com.yqbsoft.laser.service.flowable.service.BpmProcessInstanceService;
import com.yqbsoft.laser.service.flowable.service.BpmTaskService;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessInstanceCancelReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessInstanceCreateReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessInstanceMyPageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessInstancePageItemRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessInstanceRespVO;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.delegate.event.FlowableCancelledEvent;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class BpmProcessInstanceServiceImpl
extends BaseServiceImpl
implements BpmProcessInstanceService {
    private static final Logger log = LoggerFactory.getLogger(BpmProcessInstanceServiceImpl.class);
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private BpmProcessInstanceExtMapper processInstanceExtMapper;
    @Resource
    @Lazy
    private BpmTaskService taskService;
    @Resource
    private BpmProcessDefinitionService processDefinitionService;
    @Resource
    private HistoryService historyService;
    @Resource
    private AdminUserApi adminUserApi;
    @Resource
    private DeptApi deptApi;
    @Resource
    private BpmProcessInstanceResultEventPublisher processInstanceResultEventPublisher;
    @Resource
    private BpmMessageService messageService;

    @Override
    public ProcessInstance getProcessInstance(String id) {
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(id).singleResult();
    }

    @Override
    public List<ProcessInstance> getProcessInstances(Set<String> ids) {
        return this.runtimeService.createProcessInstanceQuery().processInstanceIds(ids).list();
    }

    @Override
    public PageResult<BpmProcessInstancePageItemRespVO> getMyProcessInstancePage(String userId, BpmProcessInstanceMyPageReqVO pageReqVO) {
        PageResult<BpmProcessInstanceExtDO> pageResult = this.processInstanceExtMapper.selectPage(userId, pageReqVO);
        if (CollUtil.isEmpty(pageResult.getList())) {
            return new PageResult<BpmProcessInstancePageItemRespVO>(pageResult.getTotal());
        }
        List<String> processInstanceIds = CollectionUtils.convertList(pageResult.getList(), BpmProcessInstanceExtDO::getProcessInstanceId);
        Map<String, List<Task>> taskMap = this.taskService.getTaskMapByProcessInstanceIds1(processInstanceIds);
        return BpmProcessInstanceConvert.INSTANCE.convertPage(pageResult, taskMap);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createProcessInstance(String userId, @Valid BpmProcessInstanceCreateReqVO createReqVO) {
        ProcessDefinition definition = this.processDefinitionService.getProcessDefinition(createReqVO.getProcessDefinitionId());
        return this.createProcessInstance0(userId, definition, createReqVO.getVariables(), null);
    }

    @Override
    public String createProcessInstance2(String userId, @Valid BpmProcessInstanceCreateReqDTO createReqDTO) {
        ProcessDefinition definition = this.processDefinitionService.getActiveProcessDefinition(createReqDTO.getProcessDefinitionKey());
        return this.createProcessInstance0(userId, definition, createReqDTO.getVariables(), createReqDTO.getBusinessKey());
    }

    @Override
    public BpmProcessInstanceRespVO getProcessInstanceVO(String id) {
        HistoricProcessInstance processInstance = this.getHistoricProcessInstance(id);
        if (processInstance == null) {
            return null;
        }
        BpmProcessInstanceExtDO processInstanceExt = this.processInstanceExtMapper.selectByProcessInstanceId(id);
        Assert.notNull((Object)processInstanceExt, (String)"\u6d41\u7a0b\u5b9e\u4f8b\u62d3\u5c55({}) \u4e0d\u5b58\u5728", (Object[])new Object[]{id});
        ProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(processInstance.getProcessDefinitionId());
        Assert.notNull((Object)processDefinition, (String)"\u6d41\u7a0b\u5b9a\u4e49({}) \u4e0d\u5b58\u5728", (Object[])new Object[]{processInstance.getProcessDefinitionId()});
        BpmProcessDefinitionExtDO processDefinitionExt = this.processDefinitionService.getProcessDefinitionExt(processInstance.getProcessDefinitionId());
        Assert.notNull((Object)processDefinitionExt, (String)"\u6d41\u7a0b\u5b9a\u4e49\u62d3\u5c55({}) \u4e0d\u5b58\u5728", (Object[])new Object[]{id});
        String bpmnXml = this.processDefinitionService.getProcessDefinitionBpmnXML(processInstance.getProcessDefinitionId());
        AdminUserRespDTO startUser = this.adminUserApi.getUser(processInstance.getStartUserId());
        DeptRespDTO dept = null;
        if (startUser != null) {
            dept = this.deptApi.getDept(startUser.getDeptId());
        }
        return BpmProcessInstanceConvert.INSTANCE.convert2(processInstance, processInstanceExt, processDefinition, processDefinitionExt, bpmnXml, startUser, dept);
    }

    @Override
    public void cancelProcessInstance(String userId, @Valid BpmProcessInstanceCancelReqVO cancelReqVO) {
        ProcessInstance instance = this.getProcessInstance(cancelReqVO.getId());
        if (instance == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_INSTANCE_CANCEL_FAIL_NOT_EXISTS);
        }
        if (!Objects.equals(instance.getStartUserId(), String.valueOf(userId))) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_INSTANCE_CANCEL_FAIL_NOT_SELF);
        }
        this.deleteProcessInstance(cancelReqVO.getId(), BpmProcessInstanceDeleteReasonEnum.CANCEL_TASK.format(cancelReqVO.getReason()));
    }

    @Override
    public HistoricProcessInstance getHistoricProcessInstance(String id) {
        return (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(id).singleResult();
    }

    @Override
    public List<HistoricProcessInstance> getHistoricProcessInstances(Set<String> ids) {
        return this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(ids).list();
    }

    @Override
    public void createProcessInstanceExt(ProcessInstance instance) {
        ProcessDefinition definition = this.processDefinitionService.getProcessDefinition2(instance.getProcessDefinitionId());
        BpmProcessInstanceExtDO instanceExtDO = new BpmProcessInstanceExtDO().setProcessInstanceId(instance.getId()).setProcessDefinitionId(definition.getId()).setName(instance.getProcessDefinitionName()).setStartUserId(Long.valueOf(instance.getStartUserId())).setCategory(definition.getCategory()).setStatus(BpmProcessInstanceStatusEnum.RUNNING.getStatus()).setResult(BpmProcessInstanceResultEnum.PROCESS.getResult());
        this.processInstanceExtMapper.insert(instanceExtDO);
    }

    @Override
    public void updateProcessInstanceExtCancel(FlowableCancelledEvent event) {
        if (BpmProcessInstanceDeleteReasonEnum.isRejectReason((String)event.getCause())) {
            return;
        }
        HistoricProcessInstance processInstance = this.getHistoricProcessInstance(event.getProcessInstanceId());
        BpmProcessInstanceExtDO instanceExtDO = new BpmProcessInstanceExtDO().setProcessInstanceId(event.getProcessInstanceId()).setEndTime(LocalDateTime.now()).setStatus(BpmProcessInstanceStatusEnum.FINISH.getStatus()).setResult(BpmProcessInstanceResultEnum.CANCEL.getResult());
        this.processInstanceExtMapper.updateByProcessInstanceId(instanceExtDO);
        this.processInstanceResultEventPublisher.sendProcessInstanceResultEvent(BpmProcessInstanceConvert.INSTANCE.convert((Object)this, processInstance, instanceExtDO.getResult()));
    }

    @Override
    public void updateProcessInstanceExtComplete(ProcessInstance instance) {
        HistoricProcessInstance processInstance = this.getHistoricProcessInstance(instance.getId());
        BpmProcessInstanceExtDO instanceExtDO = new BpmProcessInstanceExtDO().setProcessInstanceId(instance.getProcessInstanceId()).setEndTime(LocalDateTime.now()).setStatus(BpmProcessInstanceStatusEnum.FINISH.getStatus()).setResult(BpmProcessInstanceResultEnum.APPROVE.getResult());
        this.processInstanceExtMapper.updateByProcessInstanceId(instanceExtDO);
        this.messageService.sendMessageWhenProcessInstanceApprove(BpmProcessInstanceConvert.INSTANCE.convert2ApprovedReq(instance));
        this.processInstanceResultEventPublisher.sendProcessInstanceResultEvent(BpmProcessInstanceConvert.INSTANCE.convert((Object)this, processInstance, instanceExtDO.getResult()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateProcessInstanceExtReject(String id, String reason) {
        ProcessInstance processInstance = this.getProcessInstance(id);
        this.deleteProcessInstance(id, StrUtil.format((CharSequence)BpmProcessInstanceDeleteReasonEnum.REJECT_TASK.format(reason), (Object[])new Object[0]));
        BpmProcessInstanceExtDO instanceExtDO = new BpmProcessInstanceExtDO().setProcessInstanceId(id).setStatus(BpmProcessInstanceStatusEnum.FINISH.getStatus()).setResult(BpmProcessInstanceResultEnum.REJECT.getResult());
        this.processInstanceExtMapper.updateByProcessInstanceId(instanceExtDO);
        this.messageService.sendMessageWhenProcessInstanceReject(BpmProcessInstanceConvert.INSTANCE.convert2RejectReq(processInstance, reason));
        this.processInstanceResultEventPublisher.sendProcessInstanceResultEvent(BpmProcessInstanceConvert.INSTANCE.convert((Object)this, processInstance, instanceExtDO.getResult()));
    }

    private void deleteProcessInstance(String id, String reason) {
        this.runtimeService.deleteProcessInstance(id, reason);
    }

    private String createProcessInstance0(String userId, ProcessDefinition definition, Map<String, Object> variables, String businessKey) {
        if (definition == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_DEFINITION_NOT_EXISTS);
        }
        if (definition.isSuspended()) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_DEFINITION_IS_SUSPENDED);
        }
        ProcessInstance instance = this.runtimeService.startProcessInstanceById(definition.getId(), businessKey, variables);
        this.runtimeService.setProcessInstanceName(instance.getId(), definition.getName());
        this.processInstanceExtMapper.updateByProcessInstanceId(new BpmProcessInstanceExtDO().setProcessInstanceId(instance.getId()).setFormVariables(variables));
        return instance.getId();
    }
}

