/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.annotations.VisibleForTesting;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.api.dept.DeptApi;
import com.yqbsoft.laser.service.flowable.api.dept.PostApi;
import com.yqbsoft.laser.service.flowable.api.dept.dto.DeptRespDTO;
import com.yqbsoft.laser.service.flowable.api.dict.DictDataApi;
import com.yqbsoft.laser.service.flowable.api.permission.PermissionApi;
import com.yqbsoft.laser.service.flowable.api.permission.RoleApi;
import com.yqbsoft.laser.service.flowable.api.user.AdminUserApi;
import com.yqbsoft.laser.service.flowable.api.user.dto.AdminUserRespDTO;
import com.yqbsoft.laser.service.flowable.convert.BpmTaskAssignRuleConvert;
import com.yqbsoft.laser.service.flowable.dao.BpmTaskAssignRuleMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmTaskAssignRuleDO;
import com.yqbsoft.laser.service.flowable.domain.BpmUserGroupDO;
import com.yqbsoft.laser.service.flowable.enums.BpmTaskAssignRuleTypeEnum;
import com.yqbsoft.laser.service.flowable.enums.CommonStatusEnum;
import com.yqbsoft.laser.service.flowable.framework.flowable.core.behavior.script.BpmTaskAssignScript;
import com.yqbsoft.laser.service.flowable.service.BpmModelService;
import com.yqbsoft.laser.service.flowable.service.BpmProcessDefinitionService;
import com.yqbsoft.laser.service.flowable.service.BpmTaskAssignRuleService;
import com.yqbsoft.laser.service.flowable.service.BpmUserGroupService;
import com.yqbsoft.laser.service.flowable.util.FlowableUtils;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.util.json.JsonUtils;
import com.yqbsoft.laser.service.flowable.util.object.ObjectUtils;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskAssignRuleCreateReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskAssignRuleRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmTaskAssignRuleUpdateReqVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.delegate.DelegateExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.validation.annotation.Validated;

@Validated
public class BpmTaskAssignRuleServiceImpl
extends BaseServiceImpl
implements BpmTaskAssignRuleService {
    private static final Logger log = LoggerFactory.getLogger(BpmTaskAssignRuleServiceImpl.class);
    @Resource
    private BpmTaskAssignRuleMapper taskRuleMapper;
    @Resource
    @Lazy
    private BpmModelService modelService;
    @Resource
    @Lazy
    private BpmProcessDefinitionService processDefinitionService;
    @Resource
    private BpmUserGroupService userGroupService;
    @Resource
    private RoleApi roleApi;
    @Resource
    private DeptApi deptApi;
    @Resource
    private PostApi postApi;
    @Resource
    private AdminUserApi adminUserApi;
    @Resource
    private DictDataApi dictDataApi;
    @Resource
    private PermissionApi permissionApi;
    private Map<Long, BpmTaskAssignScript> scriptMap = Collections.emptyMap();

    @Resource
    public void setScripts(List<BpmTaskAssignScript> scripts) {
        this.scriptMap = CollectionUtils.convertMap(scripts, script -> script.getEnum().getId());
    }

    @Override
    public List<BpmTaskAssignRuleDO> getTaskAssignRuleListByProcessDefinitionId(String processDefinitionId, String taskDefinitionKey) {
        return this.taskRuleMapper.selectListByProcessDefinitionId(processDefinitionId, taskDefinitionKey);
    }

    @Override
    public List<BpmTaskAssignRuleDO> getTaskAssignRuleListByModelId(String modelId) {
        return this.taskRuleMapper.selectListByModelId(modelId);
    }

    @Override
    public List<BpmTaskAssignRuleRespVO> getTaskAssignRuleList(String modelId, String processDefinitionId) {
        List<BpmTaskAssignRuleDO> rules = Collections.emptyList();
        BpmnModel model = null;
        if (StrUtil.isNotEmpty((CharSequence)modelId)) {
            rules = this.getTaskAssignRuleListByModelId(modelId);
            model = this.modelService.getBpmnModel(modelId);
        } else if (StrUtil.isNotEmpty((CharSequence)processDefinitionId)) {
            rules = this.getTaskAssignRuleListByProcessDefinitionId(processDefinitionId, null);
            model = this.processDefinitionService.getBpmnModel(processDefinitionId);
        }
        if (model == null) {
            return Collections.emptyList();
        }
        List<UserTask> userTasks = FlowableUtils.getBpmnModelElements(model, UserTask.class);
        if (CollUtil.isEmpty(userTasks)) {
            return Collections.emptyList();
        }
        return BpmTaskAssignRuleConvert.INSTANCE.convertList(userTasks, rules);
    }

    @Override
    public Long createTaskAssignRule(@Valid BpmTaskAssignRuleCreateReqVO reqVO) {
        this.validTaskAssignRuleOptions(reqVO.getType(), reqVO.getOptions());
        BpmTaskAssignRuleDO existRule = this.taskRuleMapper.selectListByModelIdAndTaskDefinitionKey(reqVO.getModelId(), reqVO.getTaskDefinitionKey());
        if (existRule != null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_ASSIGN_RULE_EXISTS, reqVO.getModelId(), reqVO.getTaskDefinitionKey());
        }
        BpmTaskAssignRuleDO rule = BpmTaskAssignRuleConvert.INSTANCE.convert(reqVO).setProcessDefinitionId("");
        this.taskRuleMapper.insert(rule);
        return rule.getId();
    }

    @Override
    public void updateTaskAssignRule(@Valid BpmTaskAssignRuleUpdateReqVO reqVO) {
        this.validTaskAssignRuleOptions(reqVO.getType(), reqVO.getOptions());
        BpmTaskAssignRuleDO existRule = (BpmTaskAssignRuleDO)this.taskRuleMapper.selectById(reqVO.getId());
        if (existRule == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_ASSIGN_RULE_NOT_EXISTS);
        }
        if (!Objects.equals("", existRule.getProcessDefinitionId())) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_UPDATE_FAIL_NOT_MODEL);
        }
        this.taskRuleMapper.updateById(BpmTaskAssignRuleConvert.INSTANCE.convert(reqVO));
    }

    @Override
    public boolean isTaskAssignRulesEquals(String modelId, String processDefinitionId) {
        List<BpmTaskAssignRuleRespVO> modelRules = this.getTaskAssignRuleList(modelId, null);
        List<BpmTaskAssignRuleRespVO> processInstanceRules = this.getTaskAssignRuleList(null, processDefinitionId);
        if (modelRules.size() != processInstanceRules.size()) {
            return false;
        }
        Map<String, BpmTaskAssignRuleRespVO> processInstanceRuleMap = CollectionUtils.convertMap(processInstanceRules, BpmTaskAssignRuleRespVO::getTaskDefinitionKey);
        for (BpmTaskAssignRuleRespVO modelRule : modelRules) {
            BpmTaskAssignRuleRespVO processInstanceRule = processInstanceRuleMap.get(modelRule.getTaskDefinitionKey());
            if (processInstanceRule == null) {
                return false;
            }
            if (ObjectUtil.equals((Object)modelRule.getType(), (Object)processInstanceRule.getType()) && ObjectUtil.equal(modelRule.getOptions(), processInstanceRule.getOptions())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void copyTaskAssignRules(String fromModelId, String toProcessDefinitionId) {
        List<BpmTaskAssignRuleRespVO> rules = this.getTaskAssignRuleList(fromModelId, null);
        if (CollUtil.isEmpty(rules)) {
            return;
        }
        List<BpmTaskAssignRuleDO> newRules = BpmTaskAssignRuleConvert.INSTANCE.convertList2(rules);
        newRules.forEach(rule -> rule.setProcessDefinitionId(toProcessDefinitionId).setId(null).setCreateTime(null).setUpdateTime(null));
        this.taskRuleMapper.insertBatch(newRules);
    }

    @Override
    public void checkTaskAssignRuleAllConfig(String id) {
        List<BpmTaskAssignRuleRespVO> taskAssignRules = this.getTaskAssignRuleList(id, null);
        if (CollUtil.isEmpty(taskAssignRules)) {
            return;
        }
        taskAssignRules.forEach(rule -> {
            if (CollUtil.isEmpty(rule.getOptions())) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_DEPLOY_FAIL_TASK_ASSIGN_RULE_NOT_CONFIG, rule.getTaskDefinitionName());
            }
        });
    }

    private void validTaskAssignRuleOptions(Integer type, Set<String> options) {
        if (Objects.equals(type, BpmTaskAssignRuleTypeEnum.ROLE.getType())) {
            this.roleApi.validRoleList(options);
        } else if (ObjectUtils.equalsAny(type, BpmTaskAssignRuleTypeEnum.DEPT_MEMBER.getType(), BpmTaskAssignRuleTypeEnum.DEPT_LEADER.getType())) {
            this.deptApi.validateDeptList(options);
        } else if (Objects.equals(type, BpmTaskAssignRuleTypeEnum.POST.getType())) {
            this.postApi.validPostList(options);
        } else if (Objects.equals(type, BpmTaskAssignRuleTypeEnum.USER.getType())) {
            this.adminUserApi.validateUserList(options);
        } else if (Objects.equals(type, BpmTaskAssignRuleTypeEnum.USER_GROUP.getType())) {
            this.userGroupService.validUserGroups(options);
        } else if (Objects.equals(type, BpmTaskAssignRuleTypeEnum.SCRIPT.getType())) {
            this.dictDataApi.validateDictDataList("bpm_task_assign_script", CollectionUtils.convertSet(options, String::valueOf));
        } else {
            throw new IllegalArgumentException(CharSequenceUtil.format((CharSequence)"\u672a\u77e5\u7684\u89c4\u5219\u7c7b\u578b({})", (Object[])new Object[]{type}));
        }
    }

    @Override
    public Set<String> calculateTaskCandidateUsers(DelegateExecution execution) {
        BpmTaskAssignRuleDO rule = this.getTaskRule(execution);
        return this.calculateTaskCandidateUsers(execution, rule);
    }

    @VisibleForTesting
    BpmTaskAssignRuleDO getTaskRule(DelegateExecution execution) {
        List<BpmTaskAssignRuleDO> taskRules = this.getTaskAssignRuleListByProcessDefinitionId(execution.getProcessDefinitionId(), execution.getCurrentActivityId());
        if (CollUtil.isEmpty(taskRules)) {
            throw new FlowableException(CharSequenceUtil.format((CharSequence)"\u6d41\u7a0b\u4efb\u52a1({}/{}/{}) \u627e\u4e0d\u5230\u7b26\u5408\u7684\u4efb\u52a1\u89c4\u5219", (Object[])new Object[]{execution.getId(), execution.getProcessDefinitionId(), execution.getCurrentActivityId()}));
        }
        if (taskRules.size() > 1) {
            throw new FlowableException(CharSequenceUtil.format((CharSequence)"\u6d41\u7a0b\u4efb\u52a1({}/{}/{}) \u627e\u5230\u8fc7\u591a\u4efb\u52a1\u89c4\u5219({})", (Object[])new Object[]{execution.getId(), execution.getProcessDefinitionId(), execution.getCurrentActivityId()}));
        }
        return taskRules.get(0);
    }

    @VisibleForTesting
    Set<String> calculateTaskCandidateUsers(DelegateExecution execution, BpmTaskAssignRuleDO rule) {
        Set<String> assigneeUserIds = null;
        if (Objects.equals(BpmTaskAssignRuleTypeEnum.ROLE.getType(), rule.getType())) {
            assigneeUserIds = this.calculateTaskCandidateUsersByRole(rule);
        } else if (Objects.equals(BpmTaskAssignRuleTypeEnum.DEPT_MEMBER.getType(), rule.getType())) {
            assigneeUserIds = this.calculateTaskCandidateUsersByDeptMember(rule);
        } else if (Objects.equals(BpmTaskAssignRuleTypeEnum.DEPT_LEADER.getType(), rule.getType())) {
            assigneeUserIds = this.calculateTaskCandidateUsersByDeptLeader(rule);
        } else if (Objects.equals(BpmTaskAssignRuleTypeEnum.POST.getType(), rule.getType())) {
            assigneeUserIds = this.calculateTaskCandidateUsersByPost(rule);
        } else if (Objects.equals(BpmTaskAssignRuleTypeEnum.USER.getType(), rule.getType())) {
            assigneeUserIds = this.calculateTaskCandidateUsersByUser(rule);
        } else if (Objects.equals(BpmTaskAssignRuleTypeEnum.USER_GROUP.getType(), rule.getType())) {
            assigneeUserIds = this.calculateTaskCandidateUsersByUserGroup(rule);
        } else if (Objects.equals(BpmTaskAssignRuleTypeEnum.SCRIPT.getType(), rule.getType())) {
            assigneeUserIds = this.calculateTaskCandidateUsersByScript(execution, rule);
        }
        this.removeDisableUsers(assigneeUserIds);
        if (CollUtil.isEmpty(assigneeUserIds)) {
            log.error("[calculateTaskCandidateUsers][\u6d41\u7a0b\u4efb\u52a1({}/{}/{}) \u4efb\u52a1\u89c4\u5219({}) \u627e\u4e0d\u5230\u5019\u9009\u4eba]", new Object[]{execution.getId(), execution.getProcessDefinitionId(), execution.getCurrentActivityId(), JsonUtils.toJsonString(rule)});
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_CREATE_FAIL_NO_CANDIDATE_USER);
        }
        return assigneeUserIds;
    }

    private Set<String> calculateTaskCandidateUsersByRole(BpmTaskAssignRuleDO rule) {
        return this.permissionApi.getUserRoleIdListByRoleIds(rule.getOptions());
    }

    private Set<String> calculateTaskCandidateUsersByDeptMember(BpmTaskAssignRuleDO rule) {
        List<AdminUserRespDTO> users = this.adminUserApi.getUserListByDeptIds(rule.getOptions());
        return CollectionUtils.convertSet(users, AdminUserRespDTO::getId);
    }

    private Set<String> calculateTaskCandidateUsersByDeptLeader(BpmTaskAssignRuleDO rule) {
        List<DeptRespDTO> depts = this.deptApi.getDeptList(rule.getOptions());
        return CollectionUtils.convertSet(depts, DeptRespDTO::getLeaderUserId);
    }

    private Set<String> calculateTaskCandidateUsersByPost(BpmTaskAssignRuleDO rule) {
        List<AdminUserRespDTO> users = this.adminUserApi.getUsersByPostIds(rule.getOptions());
        return CollectionUtils.convertSet(users, AdminUserRespDTO::getId);
    }

    private Set<String> calculateTaskCandidateUsersByUser(BpmTaskAssignRuleDO rule) {
        return rule.getOptions();
    }

    private Set<String> calculateTaskCandidateUsersByUserGroup(BpmTaskAssignRuleDO rule) {
        List<BpmUserGroupDO> userGroups = this.userGroupService.getUserGroupList(rule.getOptions());
        HashSet<String> userIds = new HashSet<String>();
        userGroups.forEach(group -> userIds.addAll(group.getMemberUserIds()));
        return userIds;
    }

    private Set<String> calculateTaskCandidateUsersByScript(DelegateExecution execution, BpmTaskAssignRuleDO rule) {
        ArrayList scripts = new ArrayList(rule.getOptions().size());
        rule.getOptions().forEach(id -> {
            BpmTaskAssignScript script = this.scriptMap.get(id);
            if (script == null) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.TASK_ASSIGN_SCRIPT_NOT_EXISTS, id);
            }
            scripts.add(script);
        });
        HashSet<String> userIds = new HashSet<String>();
        scripts.forEach(script -> CollUtil.addAll((Collection)userIds, script.calculateTaskCandidateUsers(execution)));
        return userIds;
    }

    @VisibleForTesting
    void removeDisableUsers(Set<String> assigneeUserIds) {
        if (CollUtil.isEmpty(assigneeUserIds)) {
            return;
        }
        Map<String, AdminUserRespDTO> userMap = this.adminUserApi.getUserMap(assigneeUserIds);
        assigneeUserIds.removeIf(id -> {
            AdminUserRespDTO user = (AdminUserRespDTO)userMap.get(id);
            return user == null || !CommonStatusEnum.ENABLE.getStatus().equals(user.getStatus());
        });
    }
}

