/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.convert.BpmUserGroupConvert;
import com.yqbsoft.laser.service.flowable.dao.BpmUserGroupMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmUserGroupDO;
import com.yqbsoft.laser.service.flowable.enums.CommonStatusEnum;
import com.yqbsoft.laser.service.flowable.pojo.PageResult;
import com.yqbsoft.laser.service.flowable.service.BpmUserGroupService;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.vo.BpmUserGroupCreateReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmUserGroupPageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmUserGroupUpdateReqVO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;

@Validated
public class BpmUserGroupServiceImpl
extends BaseServiceImpl
implements BpmUserGroupService {
    @Resource
    private BpmUserGroupMapper userGroupMapper;

    @Override
    public Long createUserGroup(BpmUserGroupCreateReqVO createReqVO) {
        BpmUserGroupDO userGroup = BpmUserGroupConvert.INSTANCE.convert(createReqVO);
        this.userGroupMapper.insert(userGroup);
        return userGroup.getId();
    }

    @Override
    public void updateUserGroup(BpmUserGroupUpdateReqVO updateReqVO) {
        this.validateUserGroupExists(updateReqVO.getId());
        BpmUserGroupDO updateObj = BpmUserGroupConvert.INSTANCE.convert(updateReqVO);
        this.userGroupMapper.updateById(updateObj);
    }

    @Override
    public void deleteUserGroup(Long id) {
        this.validateUserGroupExists(id);
        this.userGroupMapper.deleteById(id);
    }

    private void validateUserGroupExists(Long id) {
        if (this.userGroupMapper.selectById(id) == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.USER_GROUP_NOT_EXISTS);
        }
    }

    @Override
    public BpmUserGroupDO getUserGroup(Long id) {
        return (BpmUserGroupDO)this.userGroupMapper.selectById(id);
    }

    @Override
    public List<BpmUserGroupDO> getUserGroupList(Collection<String> ids) {
        return this.userGroupMapper.selectBatchIds(ids);
    }

    @Override
    public List<BpmUserGroupDO> getUserGroupListByStatus(Integer status) {
        return this.userGroupMapper.selectListByStatus(status);
    }

    @Override
    public PageResult<BpmUserGroupDO> getUserGroupPage(BpmUserGroupPageReqVO pageReqVO) {
        return this.userGroupMapper.selectPage(pageReqVO);
    }

    @Override
    public void validUserGroups(Set<String> ids) {
        if (CollUtil.isEmpty(ids)) {
            return;
        }
        List userGroups = this.userGroupMapper.selectBatchIds(ids);
        Map<Long, BpmUserGroupDO> userGroupMap = CollectionUtils.convertMap(userGroups, BpmUserGroupDO::getId);
        ids.forEach(id -> {
            BpmUserGroupDO userGroup = (BpmUserGroupDO)userGroupMap.get(id);
            if (userGroup == null) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.USER_GROUP_NOT_EXISTS);
            }
            if (!CommonStatusEnum.ENABLE.getStatus().equals(userGroup.getStatus())) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.USER_GROUP_IS_DISABLE, userGroup.getName());
            }
        });
    }
}

