/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.framework.flowable.core.listener;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.ImmutableSet;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.flowable.dao.BpmProcessDefinitionExtMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmProcessDefinitionExtDO;
import com.yqbsoft.laser.service.flowable.dto.BpmModelMetaInfoRespDTO;
import com.yqbsoft.laser.service.flowable.service.BpmActivityService;
import com.yqbsoft.laser.service.flowable.service.BpmModelService;
import com.yqbsoft.laser.service.flowable.service.BpmProcessDefinitionService;
import com.yqbsoft.laser.service.flowable.service.BpmTaskService;
import com.yqbsoft.laser.service.flowable.util.json.JsonUtils;
import com.yqbsoft.laser.service.organize.model.OrgEmployee;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.AbstractFlowableEngineEventListener;
import org.flowable.engine.delegate.event.FlowableActivityCancelledEvent;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.repository.Model;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class BpmTaskEventListener
extends AbstractFlowableEngineEventListener {
    private static final Logger log = LoggerFactory.getLogger(BpmTaskEventListener.class);
    @Resource
    @Lazy
    private BpmTaskService taskService;
    @Resource
    @Lazy
    private BpmProcessDefinitionService bpmProcessDefinitionService;
    @Resource
    @Lazy
    private BpmModelService bpmModelService;
    @Resource
    private InternalRouter internalRouter;
    @Resource
    @Lazy
    private BpmActivityService activityService;
    public static final Set<FlowableEngineEventType> TASK_EVENTS = ImmutableSet.builder().add((Object)FlowableEngineEventType.TASK_CREATED).add((Object)FlowableEngineEventType.TASK_ASSIGNED).add((Object)FlowableEngineEventType.TASK_COMPLETED).add((Object)FlowableEngineEventType.ACTIVITY_CANCELLED).build();
    @Resource
    BpmProcessDefinitionExtMapper bpmProcessDefinitionExtMapper;

    public BpmTaskEventListener() {
        super(TASK_EVENTS);
    }

    protected void taskCreated(FlowableEngineEntityEvent event) {
        Object o;
        HashMap<String, String> map;
        log.error("\u4efb\u52a1\u521b\u5efa\u76d1\u542c============================");
        Task entity = (Task)event.getEntity();
        log.error("================" + entity.getProcessDefinitionId() + "===========" + entity.getProcessInstanceId() + "=======");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", entity.getProcessDefinitionId());
        List<BpmProcessDefinitionExtDO> query = this.bpmProcessDefinitionExtMapper.query(parameters);
        Model modelBykey = this.bpmModelService.getModelById(query.get(0).getModelId());
        BpmModelMetaInfoRespDTO bpmModelMetaInfoRespDTO = JsonUtils.parseObject(modelBykey.getMetaInfo(), BpmModelMetaInfoRespDTO.class);
        String notifyType = bpmModelMetaInfoRespDTO.getNotifyType();
        OrgEmployee employee = this.getemployee(entity);
        if (StringUtils.contains((CharSequence)notifyType, (CharSequence)"\u77ed\u4fe1\u901a\u77e5")) {
            map = new HashMap<String, String>();
            map.put("phone", employee.getEmployeePhone());
            map.put("msg", "\u6709\u4efb\u52a1\u9700\u8981\u5ba1\u6279!");
            o = this.internalRouter.inInvoke("mns.mns.sendMnsNativeCJ", map);
            log.error("================" + o.toString() + "==================");
        }
        if (StringUtils.contains((CharSequence)notifyType, (CharSequence)"\u90ae\u4ef6\u901a\u77e5")) {
            map = new HashMap();
            map.put("email", employee.getEmployeeEmail());
            map.put("subject", "\u5ba1\u6279");
            map.put("msg", "\u6709\u4efb\u52a1\u9700\u8981\u5ba1\u6279!");
            o = this.internalRouter.inInvoke("mns.mns.sendEmailNativeCJ", map);
            log.error("================" + o.toString() + "==================");
        }
        this.taskService.createTaskExt1((Task)event.getEntity());
    }

    private OrgEmployee getemployee(Task entity) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", entity.getAssignee());
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String emp = (String)this.internalRouter.inInvoke("org.employee.queryEmployeePage", parma);
        SupQueryResult empPage = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(emp, QueryResult.class);
        List emps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)empPage.getList()), OrgEmployee.class);
        if (emps.size() > 0) {
            return (OrgEmployee)emps.get(0);
        }
        log.error("===============\u83b7\u53d6\u4efb\u52a1\u5206\u914d\u4eba\u9519\u8bef======================");
        return null;
    }

    protected void taskCompleted(FlowableEngineEntityEvent event) {
        log.error("\u4efb\u52a1\u5b8c\u6210\u76d1\u542c============================");
        this.taskService.updateTaskExtComplete1((Task)event.getEntity());
    }

    protected void taskAssigned(FlowableEngineEntityEvent event) {
        log.error("\u4efb\u52a1\u5206\u914d\u76d1\u542c============================");
        this.taskService.updateTaskExtAssign1((Task)event.getEntity());
    }

    protected void activityCancelled(FlowableActivityCancelledEvent event) {
        List<HistoricActivityInstance> activityList = this.activityService.getHistoricActivityListByExecutionId1(event.getExecutionId());
        if (CollUtil.isEmpty(activityList)) {
            log.error("[activityCancelled][\u4f7f\u7528 executionId({}) \u67e5\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u5b9e\u4f8b]", (Object)event.getExecutionId());
            return;
        }
        activityList.forEach(activity -> {
            if (StrUtil.isEmpty((CharSequence)activity.getTaskId())) {
                return;
            }
            this.taskService.updateTaskExtCancel(activity.getTaskId());
        });
    }
}

