/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.util.validation;

import com.yqbsoft.laser.service.flowable.framework.core.IntArrayValuable;
import com.yqbsoft.laser.service.flowable.util.validation.InEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class InEnumValidator
implements ConstraintValidator<InEnum, Integer> {
    private List<Integer> values;

    public void initialize(InEnum annotation) {
        IntArrayValuable[] values = annotation.value().getEnumConstants();
        this.values = values.length == 0 ? Collections.emptyList() : Arrays.stream(values[0].array()).boxed().collect(Collectors.toList());
    }

    public boolean isValid(Integer value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (this.values.contains(value)) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate().replaceAll("\\{value}", this.values.toString())).addConstraintViolation();
        return false;
    }
}

