/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.dao.BpmFormMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmFormDO;
import com.yqbsoft.laser.service.flowable.dto.BpmModelMetaInfoRespDTO;
import com.yqbsoft.laser.service.flowable.enums.BpmModelFormTypeEnum;
import com.yqbsoft.laser.service.flowable.pojo.PageResult;
import com.yqbsoft.laser.service.flowable.service.BpmFormService;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.util.json.JsonUtils;
import com.yqbsoft.laser.service.flowable.vo.BpmFormCreateReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmFormPageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmFormUpdateReqVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;

@Validated
public class BpmFormServiceImpl
extends BaseServiceImpl
implements BpmFormService {
    @Resource
    private BpmFormMapper formMapper;

    @Override
    public Long createForm(BpmFormCreateReqVO createReqVO) {
        this.checkFields(JsonUtils.parseArray(createReqVO.getFields(), String.class));
        BpmFormDO form = new BpmFormDO();
        form.setConf(createReqVO.getConf());
        form.setFields(createReqVO.getFields());
        form.setName(createReqVO.getName());
        form.setRemark(createReqVO.getRemark());
        form.setStatus(createReqVO.getStatus());
        form.setTenantId(createReqVO.getTenantId());
        this.formMapper.insert(form);
        return form.getId();
    }

    @Override
    public void updateForm(BpmFormUpdateReqVO updateReqVO) {
        this.checkFields(JsonUtils.parseArray(updateReqVO.getFields(), String.class));
        this.validateFormExists(updateReqVO.getId());
        BpmFormDO form = new BpmFormDO();
        form.setConf(updateReqVO.getConf());
        form.setFields(updateReqVO.getFields());
        form.setName(updateReqVO.getName());
        form.setRemark(updateReqVO.getRemark());
        form.setStatus(updateReqVO.getStatus());
        this.formMapper.updateByPrimaryKeySelective(form);
    }

    @Override
    public void deleteForm(Long id) {
        this.validateFormExists(id);
        this.formMapper.deleteByPrimaryKey(id);
    }

    private void validateFormExists(Long id) {
        if (this.formMapper.selectByPrimaryKey(id) == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.FORM_NOT_EXISTS);
        }
    }

    @Override
    public BpmFormDO getForm(Long id) {
        return this.formMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<BpmFormDO> getFormList() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        return this.formMapper.query(parameters);
    }

    @Override
    public List<BpmFormDO> getFormList1(Collection<Long> ids) {
        List<Long> list = ids.stream().collect(Collectors.toList());
        return this.formMapper.queryByIds(list);
    }

    @Override
    public PageResult<BpmFormDO> getFormPage(BpmFormPageReqVO pageReqVO) {
        PageResult<BpmFormDO> pageResult = new PageResult<BpmFormDO>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (pageReqVO.getPageNo() != null && pageReqVO.getPageSize() != null) {
            parameters.put("startRow", (pageReqVO.getPageNo() - 1) * pageReqVO.getPageSize());
            parameters.put("rows", pageReqVO.getPageSize());
        }
        if (pageReqVO.getName() != null) {
            parameters.put("name", pageReqVO.getName());
        }
        if (pageReqVO.getMemberCode() != null) {
            parameters.put("memberCode", pageReqVO.getMemberCode());
        }
        if (pageReqVO.getChannelCode() != null) {
            parameters.put("channelCode", pageReqVO.getChannelCode());
        }
        List<BpmFormDO> query = this.formMapper.query(parameters);
        int count = this.formMapper.count(parameters);
        pageResult.setList(query);
        pageResult.setTotal(Long.valueOf(count));
        return pageResult;
    }

    @Override
    public BpmFormDO checkFormConfig(String configStr) {
        BpmModelMetaInfoRespDTO metaInfo = JsonUtils.parseObject(configStr, BpmModelMetaInfoRespDTO.class);
        if (metaInfo == null || metaInfo.getFormType() == null) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.MODEL_DEPLOY_FAIL_FORM_NOT_CONFIG);
        }
        if (Objects.equals(metaInfo.getFormType(), BpmModelFormTypeEnum.NORMAL.getType())) {
            BpmFormDO form = this.getForm(metaInfo.getFormId());
            if (form == null) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.FORM_NOT_EXISTS);
            }
            return form;
        }
        return null;
    }

    private void checkFields(List<String> fields) {
    }
}

