/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.flowable.convert.BpmUserGroupConvert;
import com.yqbsoft.laser.service.flowable.dao.BpmUserGroupMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmUserGroupDO;
import com.yqbsoft.laser.service.flowable.domain.UmWorkingGroupDomain;
import com.yqbsoft.laser.service.flowable.enums.CommonStatusEnum;
import com.yqbsoft.laser.service.flowable.pojo.PageResult;
import com.yqbsoft.laser.service.flowable.service.BpmUserGroupService;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.vo.BpmUserGroupCreateReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmUserGroupPageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmUserGroupUpdateReqVO;
import com.yqbsoft.laser.service.organize.model.OrgEmployee;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.user.domain.UmGroupDomain;
import com.yqbsoft.laser.service.user.model.UmGroupMem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;

@Validated
public class BpmUserGroupServiceImpl
extends BaseServiceImpl
implements BpmUserGroupService {
    @Autowired
    InternalRouter internalRouter;
    @Resource
    private BpmUserGroupMapper userGroupMapper;

    @Override
    public Long createUserGroup(BpmUserGroupCreateReqVO createReqVO) {
        BpmUserGroupDO userGroup = BpmUserGroupConvert.INSTANCE.convert(createReqVO);
        this.userGroupMapper.insert(userGroup);
        return userGroup.getId();
    }

    @Override
    public void updateUserGroup(BpmUserGroupUpdateReqVO updateReqVO) {
        this.validateUserGroupExists(updateReqVO.getId());
        BpmUserGroupDO updateObj = BpmUserGroupConvert.INSTANCE.convert(updateReqVO);
        this.userGroupMapper.updateByPrimaryKeySelective(updateObj);
    }

    @Override
    public void deleteUserGroup(Long id) {
        this.validateUserGroupExists(id);
        this.userGroupMapper.deleteByPrimaryKey(id);
    }

    private void validateUserGroupExists(Long id) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("groupCode", id.toString());
        map.put("tenantCode", "733997198045540435");
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String s = (String)this.internalRouter.inInvoke("um.workingGroupService.queryGroupPage", parma);
        SupQueryResult groupPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(s, QueryResult.class);
        if (null == groupPage.getList() || groupPage.getList().size() <= 0) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.USER_GROUP_NOT_EXISTS);
        }
    }

    @Override
    public BpmUserGroupDO getUserGroup(Long id) {
        BpmUserGroupDO bpmUserGroupDO = new BpmUserGroupDO();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("groupCode", id.toString());
        map.put("tenantCode", "733997198045540435");
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String s = (String)this.internalRouter.inInvoke("um.workingGroupService.queryGroupPage", parma);
        SupQueryResult groupPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(s, QueryResult.class);
        if (null == groupPage) {
            return null;
        }
        List groups = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)groupPage.getList()), UmWorkingGroupDomain.class);
        String groupemp = (String)this.internalRouter.inInvoke("um.group.queryGroupMemPage", parma);
        SupQueryResult groupempPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(groupemp, QueryResult.class);
        if (null == groupempPage) {
            return null;
        }
        List groupemps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)groupempPage.getList()), UmGroupMem.class);
        bpmUserGroupDO.setName(((UmWorkingGroupDomain)((Object)groups.get(0))).getGroupName());
        bpmUserGroupDO.setId(Long.valueOf(((UmWorkingGroupDomain)((Object)groups.get(0))).getGroupCode()));
        List collect = groupemps.stream().map(g -> g.getMemberScode()).collect(Collectors.toList());
        bpmUserGroupDO.setMemberUserIds(JsonUtil.buildNormalBinder().toJson(collect));
        return bpmUserGroupDO;
    }

    @Override
    public List<BpmUserGroupDO> getUserGroupList(Collection<String> ids) {
        ArrayList<BpmUserGroupDO> bpmUserGroupDOS = new ArrayList<BpmUserGroupDO>();
        String groupCodes = BpmUserGroupServiceImpl.extracted(ids);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("groupCode", groupCodes);
        map.put("tenantCode", "733997198045540435");
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String s = (String)this.internalRouter.inInvoke("um.workingGroupService.queryGroupPage", parma);
        SupQueryResult groupPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(s, QueryResult.class);
        List groups = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)groupPage.getList()), UmWorkingGroupDomain.class);
        String groupemp = (String)this.internalRouter.inInvoke("um.group.queryGroupMemPage", parma);
        SupQueryResult groupempPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(groupemp, QueryResult.class);
        if (null == groupempPage) {
            return null;
        }
        List groupemps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)groupempPage.getList()), UmGroupMem.class);
        for (UmWorkingGroupDomain group : groups) {
            BpmUserGroupDO bpmUserGroupDO = new BpmUserGroupDO();
            List<String> collect = groupemps.stream().filter(e -> group.getGroupCode().equals(e.getGroupCode())).map(e -> e.getMemberScode()).collect(Collectors.toList());
            String extracted = BpmUserGroupServiceImpl.extracted(collect);
            HashMap<String, String> emap = new HashMap<String, String>();
            emap.put("employeeCode", extracted);
            emap.put("tenantCode", "733997198045540435");
            HashMap<String, String> eparma = new HashMap<String, String>();
            eparma.put("map", JsonUtil.buildNonDefaultBinder().toJson(emap));
            String emps = (String)this.internalRouter.inInvoke("org.employee.queryEmployeePage", eparma);
            SupQueryResult empPage = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(emps, QueryResult.class);
            List employees = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)empPage.getList()), OrgEmployee.class);
            List json = employees.stream().map(e -> e.getUserCode()).collect(Collectors.toList());
            String s1 = JsonUtil.buildNonDefaultBinder().toJson(json);
            bpmUserGroupDO.setMemberUserIds(s1);
            bpmUserGroupDO.setId((long)group.getGroupId());
            bpmUserGroupDO.setName(group.getGroupName());
            bpmUserGroupDOS.add(bpmUserGroupDO);
        }
        return bpmUserGroupDOS;
    }

    @Override
    public List<BpmUserGroupDO> getUserGroupListByStatus(Integer status) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("status", status);
        return this.userGroupMapper.query(parameters);
    }

    @Override
    public PageResult<BpmUserGroupDO> getUserGroupPage(BpmUserGroupPageReqVO pageReqVO) {
        PageResult<BpmUserGroupDO> pageResult = new PageResult<BpmUserGroupDO>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (pageReqVO.getPageNo() != null && pageReqVO.getPageSize() != null) {
            parameters.put("startRow", (pageReqVO.getPageNo() - 1) * pageReqVO.getPageSize());
            parameters.put("rows", pageReqVO.getPageSize());
        }
        if (pageReqVO.getName() != null) {
            parameters.put("name", pageReqVO.getName());
        }
        if (pageReqVO.getMemberCode() != null) {
            parameters.put("memberCode", pageReqVO.getMemberCode());
        }
        if (pageReqVO.getChannelCode() != null) {
            parameters.put("channelCode", pageReqVO.getChannelCode());
        }
        if (pageReqVO.getStatus() != null) {
            parameters.put("status", pageReqVO.getStatus());
        }
        if (pageReqVO.getCreateTime() != null) {
            parameters.put("createTime", pageReqVO.getCreateTime());
        }
        List<BpmUserGroupDO> query = this.userGroupMapper.query(parameters);
        int count = this.userGroupMapper.count(parameters);
        pageResult.setList(query);
        pageResult.setTotal(Long.valueOf(count));
        return pageResult;
    }

    @Override
    public void validUserGroups(Set<String> ids) {
        if (CollUtil.isEmpty(ids)) {
            return;
        }
        String groupCodes = BpmUserGroupServiceImpl.extracted(ids);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("groupCode", groupCodes);
        map.put("tenantCode", "733997198045540435");
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String s = (String)this.internalRouter.inInvoke("um.workingGroupService.queryGroupPage", parma);
        SupQueryResult groupPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(s, QueryResult.class);
        List groups = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)groupPage.getList()), UmWorkingGroupDomain.class);
        Map<String, UmWorkingGroupDomain> userGroupMap = CollectionUtils.convertMap(groups, UmGroupDomain::getGroupCode);
        ids.forEach(id -> {
            UmWorkingGroupDomain userGroup = (UmWorkingGroupDomain)((Object)((Object)userGroupMap.get(id)));
            if (userGroup == null) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.USER_GROUP_NOT_EXISTS);
            }
            if (CommonStatusEnum.ENABLE.getStatus().equals(userGroup.getDataState())) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.USER_GROUP_IS_DISABLE, userGroup.getGroupName());
            }
        });
    }

    public static String extracted(Collection<String> ids) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String id : ids) {
            stringBuilder.append(id).append(",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

