/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gd.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gd.dao.GdRsinfoFileMapper;
import com.yqbsoft.laser.service.gd.dao.GdRsinfoMapper;
import com.yqbsoft.laser.service.gd.domain.GdRsinfoDomain;
import com.yqbsoft.laser.service.gd.domain.GdRsinfoFileDomain;
import com.yqbsoft.laser.service.gd.domain.GdRsinfoFileReDomain;
import com.yqbsoft.laser.service.gd.domain.GdRsinfoReDomain;
import com.yqbsoft.laser.service.gd.model.GdRsinfo;
import com.yqbsoft.laser.service.gd.model.GdRsinfoFile;
import com.yqbsoft.laser.service.gd.service.GdRsinfoService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GdRsinfoServiceImpl
extends BaseServiceImpl
implements GdRsinfoService {
    private static final String SYS_CODE = "gd.GdRsinfoServiceImpl";
    private GdRsinfoMapper gdRsinfoMapper;
    private GdRsinfoFileMapper gdRsinfoFileMapper;

    public void setGdRsinfoMapper(GdRsinfoMapper gdRsinfoMapper) {
        this.gdRsinfoMapper = gdRsinfoMapper;
    }

    public void setGdRsinfoFileMapper(GdRsinfoFileMapper gdRsinfoFileMapper) {
        this.gdRsinfoFileMapper = gdRsinfoFileMapper;
    }

    private Date getSysDate() {
        try {
            return this.gdRsinfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRsinfo(GdRsinfoDomain gdRsinfoDomain) {
        if (null == gdRsinfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gdRsinfoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRsinfoDefault(GdRsinfo gdRsinfo) {
        if (null == gdRsinfo) {
            return;
        }
        if (null == gdRsinfo.getDataState()) {
            gdRsinfo.setDataState(1);
        }
        Date date = this.getSysDate();
        if (null == gdRsinfo.getGmtCreate()) {
            gdRsinfo.setGmtCreate(date);
        }
        if (null == gdRsinfo.getDataOpbillstate()) {
            gdRsinfo.setDataOpbillstate(0);
        }
        gdRsinfo.setGmtModified(date);
        if (StringUtils.isBlank((String)gdRsinfo.getRsinfoCode())) {
            gdRsinfo.setRsinfoCode(this.getNo(null, "GdRsinfo", "gdRsinfo", gdRsinfo.getTenantCode()));
        }
    }

    private int getRsinfoMaxCode() {
        int code = 0;
        try {
            return this.gdRsinfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.getRsinfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRsinfoUpdataDefault(GdRsinfo gdRsinfo) {
        if (null == gdRsinfo) {
            return;
        }
        gdRsinfo.setGmtModified(this.getSysDate());
    }

    private void saveRsinfoModel(GdRsinfo gdRsinfo) throws ApiException {
        if (null == gdRsinfo) {
            return;
        }
        try {
            this.gdRsinfoMapper.insert(gdRsinfo);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.saveRsinfoModel.ex", (Throwable)e);
        }
    }

    private void saveRsinfoBatchModel(List<GdRsinfo> gdRsinfoList) throws ApiException {
        if (null == gdRsinfoList || gdRsinfoList.isEmpty()) {
            return;
        }
        try {
            this.gdRsinfoMapper.insertBatch(gdRsinfoList);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.saveRsinfoBatchModel.ex", (Throwable)e);
        }
    }

    private GdRsinfo getRsinfoModelById(Integer rsinfoId) {
        if (null == rsinfoId) {
            return null;
        }
        try {
            return this.gdRsinfoMapper.selectByPrimaryKey(rsinfoId);
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.getRsinfoModelById", (Throwable)e);
            return null;
        }
    }

    private GdRsinfo getRsinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gdRsinfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.getRsinfoModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRsinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gdRsinfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.delRsinfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gd.GdRsinfoServiceImpl.delRsinfoModelByCode.num");
        }
    }

    private void deleteRsinfoModel(Integer rsinfoId) throws ApiException {
        if (null == rsinfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.gdRsinfoMapper.deleteByPrimaryKey(rsinfoId);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.deleteRsinfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gd.GdRsinfoServiceImpl.deleteRsinfoModel.num");
        }
    }

    private void updateRsinfoModel(GdRsinfo gdRsinfo) throws ApiException {
        if (null == gdRsinfo) {
            return;
        }
        int i = 0;
        try {
            i = this.gdRsinfoMapper.updateByPrimaryKey(gdRsinfo);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateRsinfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateRsinfoModel.num");
        }
    }

    private void updateStateRsinfoModel(Integer rsinfoId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == rsinfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rsinfoId", rsinfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.gdRsinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateStateRsinfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateStateRsinfoModel.null");
        }
    }

    private void updateStateRsinfoModelByCode(String tenantCode, String rsinfoCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsinfoCode", rsinfoCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.gdRsinfoMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateStateRsinfoModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateStateRsinfoModelByCode.null");
        }
    }

    private void updateObStateByCode(String tenantCode, String rsinfoCode, Integer dataOpbillstate, Integer oldDataOpbillstate, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoCode) || null == dataOpbillstate) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsinfoCode", rsinfoCode);
        map.put("dataOpbillstate", dataOpbillstate);
        map.put("oldDataOpbillstate", oldDataOpbillstate);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.gdRsinfoMapper.updateObStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateStateRsinfoModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateStateRsinfoModelByCode.null");
        }
    }

    private GdRsinfo makeRsinfo(GdRsinfoDomain gdRsinfoDomain, GdRsinfo gdRsinfo) {
        if (null == gdRsinfoDomain) {
            return null;
        }
        if (null == gdRsinfo) {
            gdRsinfo = new GdRsinfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gdRsinfo, (Object)gdRsinfoDomain);
            return gdRsinfo;
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.makeRsinfo", (Throwable)e);
            return null;
        }
    }

    private GdRsinfoReDomain makeGdRsinfoReDomain(GdRsinfo gdRsinfo) {
        if (null == gdRsinfo) {
            return null;
        }
        GdRsinfoReDomain gdRsinfoReDomain = new GdRsinfoReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gdRsinfoReDomain, (Object)gdRsinfo);
            return gdRsinfoReDomain;
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.makeGdRsinfoReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GdRsinfo> queryRsinfoModelPage(Map<String, Object> parammap) {
        try {
            return this.gdRsinfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.queryRsinfoModel", (Throwable)e);
            return null;
        }
    }

    private int countRsinfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gdRsinfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.countRsinfo", (Throwable)e);
        }
        return i;
    }

    private GdRsinfo createGdRsinfo(GdRsinfoDomain gdRsinfoDomain) {
        String msg = this.checkRsinfo(gdRsinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gd.GdRsinfoServiceImpl.saveRsinfo.checkRsinfo", msg);
        }
        GdRsinfo gdRsinfo = this.makeRsinfo(gdRsinfoDomain, null);
        this.setRsinfoDefault(gdRsinfo);
        return gdRsinfo;
    }

    private String checkRsinfoFile(GdRsinfoFileDomain gdRsinfoFileDomain) {
        if (null == gdRsinfoFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gdRsinfoFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRsinfoFileDefault(GdRsinfoFile gdRsinfoFile) {
        if (null == gdRsinfoFile) {
            return;
        }
        if (null == gdRsinfoFile.getDataState()) {
            gdRsinfoFile.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == gdRsinfoFile.getGmtCreate()) {
            gdRsinfoFile.setGmtCreate(date);
        }
        gdRsinfoFile.setGmtModified(date);
        if (StringUtils.isBlank((String)gdRsinfoFile.getRsinfoFileCode())) {
            gdRsinfoFile.setRsinfoFileCode(this.getNo(null, "GdRsinfoFile", "gdRsinfoFile", gdRsinfoFile.getTenantCode()));
        }
    }

    private int getRsinfoFileMaxCode() {
        int code = 0;
        try {
            return this.gdRsinfoFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.getRsinfoFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRsinfoFileUpdataDefault(GdRsinfoFile gdRsinfoFile) {
        if (null == gdRsinfoFile) {
            return;
        }
        gdRsinfoFile.setGmtModified(this.getSysDate());
    }

    private void saveRsinfoFileModel(GdRsinfoFile gdRsinfoFile) throws ApiException {
        if (null == gdRsinfoFile) {
            return;
        }
        try {
            this.gdRsinfoFileMapper.insert(gdRsinfoFile);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.saveRsinfoFileModel.ex", (Throwable)e);
        }
    }

    private void saveRsinfoFileBatchModel(List<GdRsinfoFile> gdRsinfoFileList) throws ApiException {
        if (null == gdRsinfoFileList || gdRsinfoFileList.isEmpty()) {
            return;
        }
        try {
            this.gdRsinfoFileMapper.insertBatch(gdRsinfoFileList);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.saveRsinfoFileBatchModel.ex", (Throwable)e);
        }
    }

    private GdRsinfoFile getRsinfoFileModelById(Integer rsinfoFileId) {
        if (null == rsinfoFileId) {
            return null;
        }
        try {
            return this.gdRsinfoFileMapper.selectByPrimaryKey(rsinfoFileId);
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.getRsinfoFileModelById", (Throwable)e);
            return null;
        }
    }

    private GdRsinfoFile getRsinfoFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gdRsinfoFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.getRsinfoFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRsinfoFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gdRsinfoFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.delRsinfoFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gd.GdRsinfoServiceImpl.delRsinfoFileModelByCode.num");
        }
    }

    private void delRsinfoFileModelByRsinfoCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gdRsinfoFileMapper.delByRsinfoCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.delRsinfoFileModelByRsinfoCode.ex", (Throwable)e);
        }
    }

    private void deleteRsinfoFileModel(Integer rsinfoFileId) throws ApiException {
        if (null == rsinfoFileId) {
            return;
        }
        int i = 0;
        try {
            i = this.gdRsinfoFileMapper.deleteByPrimaryKey(rsinfoFileId);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.deleteRsinfoFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gd.GdRsinfoServiceImpl.deleteRsinfoFileModel.num");
        }
    }

    private void updateRsinfoFileModel(GdRsinfoFile gdRsinfoFile) throws ApiException {
        if (null == gdRsinfoFile) {
            return;
        }
        int i = 0;
        try {
            i = this.gdRsinfoFileMapper.updateByPrimaryKey(gdRsinfoFile);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateRsinfoFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateRsinfoFileModel.num");
        }
    }

    private void updateStateRsinfoFileModel(Integer rsinfoFileId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == rsinfoFileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rsinfoFileId", rsinfoFileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.gdRsinfoFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateStateRsinfoFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateStateRsinfoFileModel.null");
        }
    }

    private void updateStateRsinfoFileModelByCode(String tenantCode, String rsinfoFileCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoFileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsinfoFileCode", rsinfoFileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.gdRsinfoFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateStateRsinfoFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateStateRsinfoFileModelByCode.null");
        }
    }

    private GdRsinfoFile makeRsinfoFile(GdRsinfoFileDomain gdRsinfoFileDomain, GdRsinfoFile gdRsinfoFile) {
        if (null == gdRsinfoFileDomain) {
            return null;
        }
        if (null == gdRsinfoFile) {
            gdRsinfoFile = new GdRsinfoFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gdRsinfoFile, (Object)gdRsinfoFileDomain);
            return gdRsinfoFile;
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.makeRsinfoFile", (Throwable)e);
            return null;
        }
    }

    private GdRsinfoFileReDomain makeGdRsinfoFileReDomain(GdRsinfoFile gdRsinfoFile) {
        if (null == gdRsinfoFile) {
            return null;
        }
        GdRsinfoFileReDomain gdRsinfoFileReDomain = new GdRsinfoFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gdRsinfoFileReDomain, (Object)gdRsinfoFile);
            return gdRsinfoFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.makeGdRsinfoFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GdRsinfoFile> queryRsinfoFileModelPage(Map<String, Object> parammap) {
        try {
            return this.gdRsinfoFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.queryRsinfoFileModel", (Throwable)e);
            return null;
        }
    }

    private int countRsinfoFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gdRsinfoFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gd.GdRsinfoServiceImpl.countRsinfoFile", (Throwable)e);
        }
        return i;
    }

    private GdRsinfoFile createGdRsinfoFile(GdRsinfoFileDomain gdRsinfoFileDomain) {
        String msg = this.checkRsinfoFile(gdRsinfoFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gd.GdRsinfoServiceImpl.saveRsinfoFile.checkRsinfoFile", msg);
        }
        GdRsinfoFile gdRsinfoFile = this.makeRsinfoFile(gdRsinfoFileDomain, null);
        this.setRsinfoFileDefault(gdRsinfoFile);
        return gdRsinfoFile;
    }

    @Override
    public String saveRsinfo(GdRsinfoDomain gdRsinfoDomain) throws ApiException {
        GdRsinfo gdRsinfo = this.createGdRsinfo(gdRsinfoDomain);
        if (ListUtil.isNotEmpty(gdRsinfoDomain.getGdRsinfoFileDomainList())) {
            this.saveFileBatchByRsinfo(gdRsinfoDomain.getGdRsinfoFileDomainList(), gdRsinfo);
        }
        this.saveRsinfoModel(gdRsinfo);
        return gdRsinfo.getRsinfoCode();
    }

    @Override
    public String saveRsinfoBatch(List<GdRsinfoDomain> gdRsinfoDomainList) throws ApiException {
        if (null == gdRsinfoDomainList || gdRsinfoDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GdRsinfo> gdRsinfoList = new ArrayList<GdRsinfo>();
        String code = "";
        for (GdRsinfoDomain gdRsinfoDomain : gdRsinfoDomainList) {
            GdRsinfo gdRsinfo = this.createGdRsinfo(gdRsinfoDomain);
            code = gdRsinfo.getRsinfoCode();
            gdRsinfoList.add(gdRsinfo);
        }
        this.saveRsinfoBatchModel(gdRsinfoList);
        return code;
    }

    @Override
    public void updateRsinfoState(Integer rsinfoId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == rsinfoId) {
            return;
        }
        this.updateStateRsinfoModel(rsinfoId, dataState, oldDataState, map);
    }

    @Override
    public void updateRsinfoStateByCode(String tenantCode, String rsinfoCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRsinfoModelByCode(tenantCode, rsinfoCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRsinfo(GdRsinfoDomain gdRsinfoDomain) throws ApiException {
        String msg = this.checkRsinfo(gdRsinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateRsinfo.checkRsinfo", msg);
        }
        GdRsinfo oldGdRsinfo = this.getRsinfoModelById(gdRsinfoDomain.getRsinfoId());
        if (null == oldGdRsinfo) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateRsinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GdRsinfo gdRsinfo = this.makeRsinfo(gdRsinfoDomain, oldGdRsinfo);
        this.setRsinfoUpdataDefault(gdRsinfo);
        gdRsinfo.setDataState(1);
        this.updateRsinfoModel(gdRsinfo);
        this.delRsinfoFileModelByRsinfoCode(this.getQueryMapParam("rsinfoCode,tenantCode", new Object[]{gdRsinfo.getRsinfoCode(), gdRsinfo.getTenantCode()}));
        if (ListUtil.isNotEmpty(gdRsinfoDomain.getGdRsinfoFileDomainList())) {
            this.saveFileBatchByRsinfo(gdRsinfoDomain.getGdRsinfoFileDomainList(), gdRsinfo);
        }
    }

    @Override
    public GdRsinfo getRsinfo(Integer rsinfoId) {
        if (null == rsinfoId) {
            return null;
        }
        GdRsinfo rsinfoModel = this.getRsinfoModelById(rsinfoId);
        List<GdRsinfoFile> gdRsinfoFiles = this.queryRsinfoFileModelPage(this.getQueryMapParam("rsinfoCode,tenantCode", new Object[]{rsinfoModel.getRsinfoCode(), rsinfoModel.getTenantCode()}));
        rsinfoModel.setGdRsinfoFileList(gdRsinfoFiles);
        return rsinfoModel;
    }

    @Override
    public void deleteRsinfo(Integer rsinfoId) throws ApiException {
        if (null == rsinfoId) {
            return;
        }
        GdRsinfo rsinfo = this.getRsinfo(rsinfoId);
        this.deleteRsinfoModel(rsinfoId);
        this.delRsinfoFileModelByRsinfoCode(this.getQueryMapParam("rsinfoCode,tenantCode", new Object[]{rsinfo.getRsinfoCode(), rsinfo.getTenantCode()}));
    }

    @Override
    public QueryResult<GdRsinfo> queryRsinfoPage(Map<String, Object> map) {
        List<GdRsinfo> gdRsinfoList = this.queryRsinfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRsinfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        for (GdRsinfo gdRsinfo : gdRsinfoList) {
            List<GdRsinfoFile> gdRsinfoFiles = this.queryRsinfoFileModelPage(this.getQueryMapParam("rsinfoCode,tenantCode", new Object[]{gdRsinfo.getRsinfoCode(), gdRsinfo.getTenantCode()}));
            gdRsinfo.setGdRsinfoFileList(gdRsinfoFiles);
        }
        queryResult.setList(gdRsinfoList);
        return queryResult;
    }

    @Override
    public GdRsinfo getRsinfoByCode(String tenantCode, String rsinfoCode) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsinfoCode", rsinfoCode);
        return this.getRsinfoModelByCode(map);
    }

    @Override
    public void deleteRsinfoByCode(String tenantCode, String rsinfoCode) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsinfoCode", rsinfoCode);
        this.delRsinfoModelByCode(map);
    }

    @Override
    public String saveRsinfoFile(GdRsinfoFileDomain gdRsinfoFileDomain) throws ApiException {
        GdRsinfoFile gdRsinfoFile = this.createGdRsinfoFile(gdRsinfoFileDomain);
        this.saveRsinfoFileModel(gdRsinfoFile);
        return gdRsinfoFile.getRsinfoFileCode();
    }

    @Override
    public String saveRsinfoFileBatch(List<GdRsinfoFileDomain> gdRsinfoFileDomainList) throws ApiException {
        if (null == gdRsinfoFileDomainList || gdRsinfoFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GdRsinfoFile> gdRsinfoFileList = new ArrayList<GdRsinfoFile>();
        String code = "";
        for (GdRsinfoFileDomain gdRsinfoFileDomain : gdRsinfoFileDomainList) {
            GdRsinfoFile gdRsinfoFile = this.createGdRsinfoFile(gdRsinfoFileDomain);
            code = gdRsinfoFile.getRsinfoFileCode();
            gdRsinfoFileList.add(gdRsinfoFile);
        }
        this.saveRsinfoFileBatchModel(gdRsinfoFileList);
        return code;
    }

    private String saveFileBatchByRsinfo(List<GdRsinfoFileDomain> gdRsinfoFileDomainList, GdRsinfo gdRsinfo) throws ApiException {
        if (null == gdRsinfoFileDomainList || gdRsinfoFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GdRsinfoFile> gdRsinfoFileList = new ArrayList<GdRsinfoFile>();
        String code = "";
        for (GdRsinfoFileDomain gdRsinfoFileDomain : gdRsinfoFileDomainList) {
            if (StringUtils.isNotBlank((String)gdRsinfoFileDomain.getRsinfoFileUrl())) {
                gdRsinfo.setDataPic(gdRsinfoFileDomain.getRsinfoFileUrl());
            }
            GdRsinfoFile gdRsinfoFile = this.createGdRsinfoFile(gdRsinfoFileDomain);
            gdRsinfoFile.setRsinfoCode(gdRsinfo.getRsinfoCode());
            gdRsinfoFile.setGoodsCode(gdRsinfo.getGoodsCode());
            gdRsinfoFile.setMemberCode(gdRsinfo.getMemberCode());
            gdRsinfoFile.setMemberName(gdRsinfo.getMemberName());
            code = gdRsinfoFile.getRsinfoFileCode();
            gdRsinfoFileList.add(gdRsinfoFile);
        }
        this.saveRsinfoFileBatchModel(gdRsinfoFileList);
        return code;
    }

    @Override
    public void updateRsinfoFileState(Integer rsinfoFileId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == rsinfoFileId) {
            return;
        }
        this.updateStateRsinfoFileModel(rsinfoFileId, dataState, oldDataState, map);
    }

    @Override
    public void updateRsinfoFileStateByCode(String tenantCode, String rsinfoFileCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRsinfoFileModelByCode(tenantCode, rsinfoFileCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRsinfoFile(GdRsinfoFileDomain gdRsinfoFileDomain) throws ApiException {
        String msg = this.checkRsinfoFile(gdRsinfoFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateRsinfoFile.checkRsinfoFile", msg);
        }
        GdRsinfoFile oldGdRsinfoFile = this.getRsinfoFileModelById(gdRsinfoFileDomain.getRsinfoFileId());
        if (null == oldGdRsinfoFile) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateRsinfoFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GdRsinfoFile gdRsinfoFile = this.makeRsinfoFile(gdRsinfoFileDomain, oldGdRsinfoFile);
        this.setRsinfoFileUpdataDefault(gdRsinfoFile);
        this.updateRsinfoFileModel(gdRsinfoFile);
    }

    @Override
    public GdRsinfoFile getRsinfoFile(Integer rsinfoFileId) {
        if (null == rsinfoFileId) {
            return null;
        }
        return this.getRsinfoFileModelById(rsinfoFileId);
    }

    @Override
    public void deleteRsinfoFile(Integer rsinfoFileId) throws ApiException {
        if (null == rsinfoFileId) {
            return;
        }
        this.deleteRsinfoFileModel(rsinfoFileId);
    }

    @Override
    public QueryResult<GdRsinfoFile> queryRsinfoFilePage(Map<String, Object> map) {
        List<GdRsinfoFile> gdRsinfoFileList = this.queryRsinfoFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRsinfoFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gdRsinfoFileList);
        return queryResult;
    }

    @Override
    public GdRsinfoFile getRsinfoFileByCode(String tenantCode, String rsinfoFileCode) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsinfoFileCode", rsinfoFileCode);
        return this.getRsinfoFileModelByCode(map);
    }

    @Override
    public void deleteRsinfoFileByCode(String tenantCode, String rsinfoFileCode) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsinfoFileCode", rsinfoFileCode);
        this.delRsinfoFileModelByCode(map);
    }

    @Override
    public void updateSotrByCode(String tenantCode, String rsinfoCode, Integer goodsSort) throws ApiException {
        this.updateSotrByCodeModel(tenantCode, rsinfoCode, goodsSort);
    }

    private void updateSotrByCodeModel(String tenantCode, String rsinfoCode, Integer goodsSort) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoCode) || null == goodsSort) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsinfoCode", rsinfoCode);
        map.put("goodsSort", goodsSort);
        int i = 0;
        try {
            i = this.gdRsinfoMapper.updateSotrByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateSotrByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateSotrByCodeModel.null");
        }
    }

    @Override
    public void updateOpbillstateByCode(String tenantCode, String rsinfoCode, Integer dataOpbillstate) throws ApiException {
        this.updateOpbillstateByCodeModel(tenantCode, rsinfoCode, dataOpbillstate);
    }

    private void updateOpbillstateByCodeModel(String tenantCode, String rsinfoCode, Integer dataOpbillstate) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoCode) || null == dataOpbillstate) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rsinfoCode", rsinfoCode);
        map.put("dataOpbillstate", dataOpbillstate);
        int i = 0;
        try {
            i = this.gdRsinfoMapper.updateOpbillstateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateOpbillstateByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gd.GdRsinfoServiceImpl.updateOpbillstateByCodeModel.null");
        }
    }

    @Override
    public void updateRsinfoDataOpbillstateeByCode(String tenantCode, String rsinfoCode, Integer dataOpbillstate, Integer oldDataOpbillstate, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)rsinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateObStateByCode(tenantCode, rsinfoCode, dataOpbillstate, oldDataOpbillstate, map);
    }
}

