/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gt.dao.GtGiftValueMapper;
import com.yqbsoft.laser.service.gt.domain.GtGiftValueDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftValueReDomain;
import com.yqbsoft.laser.service.gt.model.GtGiftValue;
import com.yqbsoft.laser.service.gt.service.GtGiftValueService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GtGiftValueServiceImpl
extends BaseServiceImpl
implements GtGiftValueService {
    private static final String SYS_CODE = "gt.GIFT.GtGiftValueServiceImpl";
    private GtGiftValueMapper gtGiftValueMapper;

    public void setGtGiftValueMapper(GtGiftValueMapper gtGiftValueMapper) {
        this.gtGiftValueMapper = gtGiftValueMapper;
    }

    private Date getSysDate() {
        try {
            return this.gtGiftValueMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftValueServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGiftValue(GtGiftValueDomain gtGiftValueDomain) {
        if (null == gtGiftValueDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gtGiftValueDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGiftValueDefault(GtGiftValue gtGiftValue) {
        if (null == gtGiftValue) {
            return;
        }
        if (null == gtGiftValue.getDataState()) {
            gtGiftValue.setDataState(0);
        }
        if (null == gtGiftValue.getGmtCreate()) {
            gtGiftValue.setGmtCreate(this.getSysDate());
        }
        gtGiftValue.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)gtGiftValue.getGiftValueCode())) {
            gtGiftValue.setGiftValueCode(this.createUUIDString());
        }
    }

    private int getGiftValueMaxCode() {
        int code = 0;
        try {
            return this.gtGiftValueMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftValueServiceImpl.getGiftValueMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGiftValueUpdataDefault(GtGiftValue gtGiftValue) {
        if (null == gtGiftValue) {
            return;
        }
        gtGiftValue.setGmtModified(this.getSysDate());
    }

    private void saveGiftValueModel(GtGiftValue gtGiftValue) throws ApiException {
        if (null == gtGiftValue) {
            return;
        }
        try {
            this.gtGiftValueMapper.insert(gtGiftValue);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.saveGiftValueModel.ex", (Throwable)e);
        }
    }

    private void saveGiftValueBatchModel(List<GtGiftValue> gtGiftValueList) throws ApiException {
        if (null == gtGiftValueList || gtGiftValueList.isEmpty()) {
            return;
        }
        try {
            this.gtGiftValueMapper.insertBatch(gtGiftValueList);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.saveGiftValueBatchModel.ex", (Throwable)e);
        }
    }

    private GtGiftValue getGiftValueModelById(Integer giftValueId) {
        if (null == giftValueId) {
            return null;
        }
        try {
            return this.gtGiftValueMapper.selectByPrimaryKey(giftValueId);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftValueServiceImpl.getGiftValueModelById", (Throwable)e);
            return null;
        }
    }

    private GtGiftValue getGiftValueModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gtGiftValueMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftValueServiceImpl.getGiftValueModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGiftValueModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftValueMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.delGiftValueModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.delGiftValueModelByCode.num");
        }
    }

    private void deleteGiftValueModel(Integer giftValueId) throws ApiException {
        if (null == giftValueId) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftValueMapper.deleteByPrimaryKey(giftValueId);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.deleteGiftValueModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.deleteGiftValueModel.num");
        }
    }

    private void updateGiftValueModel(GtGiftValue gtGiftValue) throws ApiException {
        if (null == gtGiftValue) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftValueMapper.updateByPrimaryKeySelective(gtGiftValue);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.updateGiftValueModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.updateGiftValueModel.num");
        }
    }

    private void updateStateGiftValueModel(Integer giftValueId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == giftValueId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftValueId", giftValueId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftValueMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.updateStateGiftValueModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.updateStateGiftValueModel.null");
        }
    }

    private void updateStateGiftValueModelByCode(String tenantCode, String giftValueCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)giftValueCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftValueCode", giftValueCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftValueMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.updateStateGiftValueModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.updateStateGiftValueModelByCode.null");
        }
    }

    private GtGiftValue makeGiftValue(GtGiftValueDomain gtGiftValueDomain, GtGiftValue gtGiftValue) {
        if (null == gtGiftValueDomain) {
            return null;
        }
        if (null == gtGiftValue) {
            gtGiftValue = new GtGiftValue();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftValue, (Object)gtGiftValueDomain);
            return gtGiftValue;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftValueServiceImpl.makeGiftValue", (Throwable)e);
            return null;
        }
    }

    private GtGiftValueReDomain makeGtGiftValueReDomain(GtGiftValue gtGiftValue) {
        if (null == gtGiftValue) {
            return null;
        }
        GtGiftValueReDomain gtGiftValueReDomain = new GtGiftValueReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftValueReDomain, (Object)gtGiftValue);
            return gtGiftValueReDomain;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftValueServiceImpl.makeGtGiftValueReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GtGiftValue> queryGiftValueModelPage(Map<String, Object> parammap) {
        try {
            return this.gtGiftValueMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftValueServiceImpl.queryGiftValueModel", (Throwable)e);
            return null;
        }
    }

    private int countGiftValue(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftValueMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftValueServiceImpl.countGiftValue", (Throwable)e);
        }
        return i;
    }

    private GtGiftValue createGtGiftValue(GtGiftValueDomain gtGiftValueDomain) {
        String msg = this.checkGiftValue(gtGiftValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.saveGiftValue.checkGiftValue", msg);
        }
        GtGiftValue gtGiftValue = this.makeGiftValue(gtGiftValueDomain, null);
        this.setGiftValueDefault(gtGiftValue);
        return gtGiftValue;
    }

    @Override
    public String saveGiftValue(GtGiftValueDomain gtGiftValueDomain) throws ApiException {
        GtGiftValue gtGiftValue = this.createGtGiftValue(gtGiftValueDomain);
        this.saveGiftValueModel(gtGiftValue);
        return gtGiftValue.getGiftValueCode();
    }

    @Override
    public String saveGiftValueBatch(List<GtGiftValueDomain> gtGiftValueDomainList) throws ApiException {
        if (null == gtGiftValueDomainList || gtGiftValueDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GtGiftValue> gtGiftValueList = new ArrayList<GtGiftValue>();
        String code = "";
        for (GtGiftValueDomain gtGiftValueDomain : gtGiftValueDomainList) {
            GtGiftValue gtGiftValue = this.createGtGiftValue(gtGiftValueDomain);
            code = gtGiftValue.getGiftValueCode();
            gtGiftValueList.add(gtGiftValue);
        }
        this.saveGiftValueBatchModel(gtGiftValueList);
        return code;
    }

    @Override
    public void updateGiftValueState(Integer giftValueId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftValueModel(giftValueId, dataState, oldDataState);
    }

    @Override
    public void updateGiftValueStateByCode(String tenantCode, String giftValueCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftValueModelByCode(tenantCode, giftValueCode, dataState, oldDataState);
    }

    @Override
    public void updateGiftValue(GtGiftValueDomain gtGiftValueDomain) throws ApiException {
        String msg = this.checkGiftValue(gtGiftValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.updateGiftValue.checkGiftValue", msg);
        }
        GtGiftValue oldGtGiftValue = this.getGiftValueModelById(gtGiftValueDomain.getGiftValueId());
        if (null == oldGtGiftValue) {
            throw new ApiException("gt.GIFT.GtGiftValueServiceImpl.updateGiftValue.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GtGiftValue gtGiftValue = this.makeGiftValue(gtGiftValueDomain, oldGtGiftValue);
        this.setGiftValueUpdataDefault(gtGiftValue);
        this.updateGiftValueModel(gtGiftValue);
    }

    @Override
    public GtGiftValue getGiftValue(Integer giftValueId) {
        return this.getGiftValueModelById(giftValueId);
    }

    @Override
    public void deleteGiftValue(Integer giftValueId) throws ApiException {
        this.deleteGiftValueModel(giftValueId);
    }

    @Override
    public QueryResult<GtGiftValue> queryGiftValuePage(Map<String, Object> map) {
        List<GtGiftValue> gtGiftValueList = this.queryGiftValueModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGiftValue(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gtGiftValueList);
        return queryResult;
    }

    @Override
    public GtGiftValue getGiftValueByCode(String tenantCode, String giftValueCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftValueCode", giftValueCode);
        return this.getGiftValueModelByCode(map);
    }

    @Override
    public void deleteGiftValueByCode(String tenantCode, String giftValueCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftValueCode", giftValueCode);
        this.delGiftValueModelByCode(map);
    }
}

