/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gt.dao.GtGiftFileMapper;
import com.yqbsoft.laser.service.gt.domain.GtGiftFileDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftFileReDomain;
import com.yqbsoft.laser.service.gt.model.GtGiftFile;
import com.yqbsoft.laser.service.gt.service.GtGiftFileService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GtGiftFileServiceImpl
extends BaseServiceImpl
implements GtGiftFileService {
    private static final String SYS_CODE = "gt.GIFT.GtGiftFileServiceImpl";
    private GtGiftFileMapper gtGiftFileMapper;

    public void setGtGiftFileMapper(GtGiftFileMapper gtGiftFileMapper) {
        this.gtGiftFileMapper = gtGiftFileMapper;
    }

    private Date getSysDate() {
        try {
            return this.gtGiftFileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftFileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGiftFile(GtGiftFileDomain gtGiftFileDomain) {
        if (null == gtGiftFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gtGiftFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGiftFileDefault(GtGiftFile gtGiftFile) {
        if (null == gtGiftFile) {
            return;
        }
        if (null == gtGiftFile.getDataState()) {
            gtGiftFile.setDataState(0);
        }
        if (null == gtGiftFile.getGmtCreate()) {
            gtGiftFile.setGmtCreate(this.getSysDate());
        }
        gtGiftFile.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)gtGiftFile.getGiftFileCode())) {
            gtGiftFile.setGiftFileCode(this.createUUIDString());
        }
    }

    private int getGiftFileMaxCode() {
        int code = 0;
        try {
            return this.gtGiftFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftFileServiceImpl.getGiftFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGiftFileUpdataDefault(GtGiftFile gtGiftFile) {
        if (null == gtGiftFile) {
            return;
        }
        gtGiftFile.setGmtModified(this.getSysDate());
    }

    private void saveGiftFileModel(GtGiftFile gtGiftFile) throws ApiException {
        if (null == gtGiftFile) {
            return;
        }
        try {
            this.gtGiftFileMapper.insert(gtGiftFile);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.saveGiftFileModel.ex", (Throwable)e);
        }
    }

    private void saveGiftFileBatchModel(List<GtGiftFile> gtGiftFileList) throws ApiException {
        if (null == gtGiftFileList || gtGiftFileList.isEmpty()) {
            return;
        }
        try {
            this.gtGiftFileMapper.insertBatch(gtGiftFileList);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.saveGiftFileBatchModel.ex", (Throwable)e);
        }
    }

    private GtGiftFile getGiftFileModelById(Integer giftFileId) {
        if (null == giftFileId) {
            return null;
        }
        try {
            return this.gtGiftFileMapper.selectByPrimaryKey(giftFileId);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftFileServiceImpl.getGiftFileModelById", (Throwable)e);
            return null;
        }
    }

    private GtGiftFile getGiftFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gtGiftFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftFileServiceImpl.getGiftFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGiftFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.delGiftFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.delGiftFileModelByCode.num");
        }
    }

    private void delGiftFileModelByGiftCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.gtGiftFileMapper.delByGiftCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.delGiftFileModelByGiftCode.ex", (Throwable)e);
        }
    }

    private void delGiftFileModelByGiftCodeAndSkuCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.gtGiftFileMapper.delByGiftCodeAndSkuCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.delGiftFileModelByGiftCode.ex", (Throwable)e);
        }
    }

    private void deleteGiftFileModel(Integer giftFileId) throws ApiException {
        if (null == giftFileId) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftFileMapper.deleteByPrimaryKey(giftFileId);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.deleteGiftFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.deleteGiftFileModel.num");
        }
    }

    private void updateGiftFileModel(GtGiftFile gtGiftFile) throws ApiException {
        if (null == gtGiftFile) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftFileMapper.updateByPrimaryKeySelective(gtGiftFile);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.updateGiftFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.updateGiftFileModel.num");
        }
    }

    private void updateStateGiftFileModel(Integer giftFileId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == giftFileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftFileId", giftFileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.updateStateGiftFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.updateStateGiftFileModel.null");
        }
    }

    private void updateStateGiftFileModelByCode(String tenantCode, String giftFileCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)giftFileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftFileCode", giftFileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.updateStateGiftFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.updateStateGiftFileModelByCode.null");
        }
    }

    private GtGiftFile makeGiftFile(GtGiftFileDomain gtGiftFileDomain, GtGiftFile gtGiftFile) {
        if (null == gtGiftFileDomain) {
            return null;
        }
        if (null == gtGiftFile) {
            gtGiftFile = new GtGiftFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftFile, (Object)gtGiftFileDomain);
            return gtGiftFile;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftFileServiceImpl.makeGiftFile", (Throwable)e);
            return null;
        }
    }

    private GtGiftFileReDomain makeGtGiftFileReDomain(GtGiftFile gtGiftFile) {
        if (null == gtGiftFile) {
            return null;
        }
        GtGiftFileReDomain gtGiftFileReDomain = new GtGiftFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftFileReDomain, (Object)gtGiftFile);
            return gtGiftFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftFileServiceImpl.makeGtGiftFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GtGiftFile> queryGiftFileModelPage(Map<String, Object> parammap) {
        try {
            return this.gtGiftFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftFileServiceImpl.queryGiftFileModel", (Throwable)e);
            return null;
        }
    }

    private int countGiftFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftFileServiceImpl.countGiftFile", (Throwable)e);
        }
        return i;
    }

    private GtGiftFile createGtGiftFile(GtGiftFileDomain gtGiftFileDomain) {
        String msg = this.checkGiftFile(gtGiftFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.saveGiftFile.checkGiftFile", msg);
        }
        GtGiftFile gtGiftFile = this.makeGiftFile(gtGiftFileDomain, null);
        this.setGiftFileDefault(gtGiftFile);
        return gtGiftFile;
    }

    @Override
    public String saveGiftFile(GtGiftFileDomain gtGiftFileDomain) throws ApiException {
        GtGiftFile gtGiftFile = this.createGtGiftFile(gtGiftFileDomain);
        this.saveGiftFileModel(gtGiftFile);
        return gtGiftFile.getGiftFileCode();
    }

    @Override
    public String saveGiftFileBatch(List<GtGiftFileDomain> gtGiftFileDomainList) throws ApiException {
        if (null == gtGiftFileDomainList || gtGiftFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GtGiftFile> gtGiftFileList = new ArrayList<GtGiftFile>();
        String code = "";
        for (GtGiftFileDomain gtGiftFileDomain : gtGiftFileDomainList) {
            GtGiftFile gtGiftFile = this.createGtGiftFile(gtGiftFileDomain);
            code = gtGiftFile.getGiftFileCode();
            gtGiftFileList.add(gtGiftFile);
        }
        this.saveGiftFileBatchModel(gtGiftFileList);
        return code;
    }

    @Override
    public void updateGiftFileState(Integer giftFileId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftFileModel(giftFileId, dataState, oldDataState);
    }

    @Override
    public void updateGiftFileStateByCode(String tenantCode, String giftFileCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftFileModelByCode(tenantCode, giftFileCode, dataState, oldDataState);
    }

    @Override
    public void updateGiftFile(GtGiftFileDomain gtGiftFileDomain) throws ApiException {
        String msg = this.checkGiftFile(gtGiftFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.updateGiftFile.checkGiftFile", msg);
        }
        GtGiftFile oldGtGiftFile = this.getGiftFileModelById(gtGiftFileDomain.getGiftFileId());
        if (null == oldGtGiftFile) {
            throw new ApiException("gt.GIFT.GtGiftFileServiceImpl.updateGiftFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GtGiftFile gtGiftFile = this.makeGiftFile(gtGiftFileDomain, oldGtGiftFile);
        this.setGiftFileUpdataDefault(gtGiftFile);
        this.updateGiftFileModel(gtGiftFile);
    }

    @Override
    public GtGiftFile getGiftFile(Integer giftFileId) {
        return this.getGiftFileModelById(giftFileId);
    }

    @Override
    public void deleteGiftFile(Integer giftFileId) throws ApiException {
        this.deleteGiftFileModel(giftFileId);
    }

    @Override
    public QueryResult<GtGiftFile> queryGiftFilePage(Map<String, Object> map) {
        List<GtGiftFile> gtGiftFileList = this.queryGiftFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGiftFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gtGiftFileList);
        return queryResult;
    }

    @Override
    public GtGiftFile getGiftFileByCode(String tenantCode, String giftFileCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftFileCode", giftFileCode);
        return this.getGiftFileModelByCode(map);
    }

    @Override
    public void deleteGiftFileByCode(String tenantCode, String giftFileCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftFileCode", giftFileCode);
        this.delGiftFileModelByCode(map);
    }

    @Override
    public void deleteGiftFileByGiftCode(String tenantCode, String giftCode) throws ApiException {
        Map giftMap = this.getQueryParamMap("giftCode,tenantCode", new Object[]{giftCode, tenantCode});
        this.delGiftFileModelByGiftCode(giftMap);
    }

    @Override
    public void deleteGiftFileByGiftCodeAndSkuCode(Map<String, Object> map) throws ApiException {
        this.delGiftFileModelByGiftCodeAndSkuCode(map);
    }
}

