/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gt.dao.GtGiftSendMapper;
import com.yqbsoft.laser.service.gt.dao.GtGiftSendlistMapper;
import com.yqbsoft.laser.service.gt.domain.GtGiftSendDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftSendReDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftSendlistDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserBean;
import com.yqbsoft.laser.service.gt.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.gt.model.GtGiftSend;
import com.yqbsoft.laser.service.gt.model.GtGiftSendlist;
import com.yqbsoft.laser.service.gt.service.GtGiftSendService;
import com.yqbsoft.laser.service.gt.service.GtGiftSendlistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GtGiftSendServiceImpl
extends BaseServiceImpl
implements GtGiftSendService {
    private static final String SYS_CODE = "gt.GIFT.GtGiftSendServiceImpl";
    private GtGiftSendMapper gtGiftSendMapper;
    private GtGiftSendlistMapper gtGiftSendlistMapper;
    private GtGiftSendlistService gtGiftSendlistService;

    public void setGtGiftSendMapper(GtGiftSendMapper gtGiftSendMapper) {
        this.gtGiftSendMapper = gtGiftSendMapper;
    }

    public void setGtGiftSendlistMapper(GtGiftSendlistMapper gtGiftSendlistMapper) {
        this.gtGiftSendlistMapper = gtGiftSendlistMapper;
    }

    public void setGtGiftSendlistService(GtGiftSendlistService gtGiftSendlistService) {
        this.gtGiftSendlistService = gtGiftSendlistService;
    }

    private Date getSysDate() {
        try {
            return this.gtGiftSendMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSendServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGiftSend(GtGiftSendDomain gtGiftSendDomain) {
        if (null == gtGiftSendDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gtGiftSendDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGiftSendDefault(GtGiftSend gtGiftSend) {
        if (null == gtGiftSend) {
            return;
        }
        if (null == gtGiftSend.getDataState()) {
            gtGiftSend.setDataState(0);
        }
        if (null == gtGiftSend.getGmtCreate()) {
            gtGiftSend.setGmtCreate(this.getSysDate());
        }
        gtGiftSend.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)gtGiftSend.getGiftSendCode())) {
            gtGiftSend.setGiftSendCode(this.createUUIDString());
        }
    }

    private int getGiftSendMaxCode() {
        int code = 0;
        try {
            return this.gtGiftSendMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSendServiceImpl.getGiftSendMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGiftSendUpdataDefault(GtGiftSend gtGiftSend) {
        if (null == gtGiftSend) {
            return;
        }
        gtGiftSend.setGmtModified(this.getSysDate());
    }

    private void saveGiftSendModel(GtGiftSend gtGiftSend) throws ApiException {
        if (null == gtGiftSend) {
            return;
        }
        try {
            this.gtGiftSendMapper.insert(gtGiftSend);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.saveGiftSendModel.ex", (Throwable)e);
        }
    }

    private void saveGiftSendBatchModel(List<GtGiftSend> gtGiftSendList) throws ApiException {
        if (null == gtGiftSendList || gtGiftSendList.isEmpty()) {
            return;
        }
        try {
            this.gtGiftSendMapper.insertBatch(gtGiftSendList);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.saveGiftSendBatchModel.ex", (Throwable)e);
        }
    }

    private GtGiftSend getGiftSendModelById(Integer giftSendId) {
        if (null == giftSendId) {
            return null;
        }
        try {
            return this.gtGiftSendMapper.selectByPrimaryKey(giftSendId);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSendServiceImpl.getGiftSendModelById", (Throwable)e);
            return null;
        }
    }

    private GtGiftSend getGiftSendModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gtGiftSendMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSendServiceImpl.getGiftSendModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGiftSendModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftSendMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.delGiftSendModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.delGiftSendModelByCode.num");
        }
    }

    private void deleteGiftSendModel(Integer giftSendId) throws ApiException {
        if (null == giftSendId) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftSendMapper.deleteByPrimaryKey(giftSendId);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.deleteGiftSendModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.deleteGiftSendModel.num");
        }
    }

    private void updateGiftSendModel(GtGiftSend gtGiftSend) throws ApiException {
        if (null == gtGiftSend) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftSendMapper.updateByPrimaryKeySelective(gtGiftSend);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateGiftSendModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateGiftSendModel.num");
        }
    }

    private void updateStateGiftSendModel(Integer giftSendId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == giftSendId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftSendId", giftSendId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftSendMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateStateGiftSendModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateStateGiftSendModel.null");
        }
    }

    private void updateVerifyStateGiftSendModel(Integer giftSendId, Integer verifyState, Integer oldVerifyState) throws ApiException {
        if (null == giftSendId || null == verifyState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftSendId", giftSendId);
        map.put("verifyState", verifyState);
        map.put("oldVerifyState", oldVerifyState);
        int i = 0;
        try {
            i = this.gtGiftSendMapper.updateVerifyStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateVerifyStateGiftSendModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateVerifyStateGiftSendModel.null");
        }
    }

    private void updateStateGiftSendModelByCode(String tenantCode, String giftSendCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)giftSendCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftSendCode", giftSendCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftSendMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateStateGiftSendModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateStateGiftSendModelByCode.null");
        }
    }

    private void updateStateGiftSendModelByMap(String tenantCode, String giftSendCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)giftSendCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftSendCode", giftSendCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.gtGiftSendMapper.updateStateByMap(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateStateGiftSendModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateStateGiftSendModelByCode.null");
        }
    }

    private GtGiftSend makeGiftSend(GtGiftSendDomain gtGiftSendDomain, GtGiftSend gtGiftSend) {
        if (null == gtGiftSendDomain) {
            return null;
        }
        if (null == gtGiftSend) {
            gtGiftSend = new GtGiftSend();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftSend, (Object)gtGiftSendDomain);
            return gtGiftSend;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSendServiceImpl.makeGiftSend", (Throwable)e);
            return null;
        }
    }

    private GtGiftSendReDomain makeGtGiftSendReDomain(GtGiftSend gtGiftSend) {
        if (null == gtGiftSend) {
            return null;
        }
        GtGiftSendReDomain gtGiftSendReDomain = new GtGiftSendReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftSendReDomain, (Object)gtGiftSend);
            return gtGiftSendReDomain;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSendServiceImpl.makeGtGiftSendReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GtGiftSend> queryGiftSendModelPage(Map<String, Object> parammap) {
        try {
            return this.gtGiftSendMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSendServiceImpl.queryGiftSendModel", (Throwable)e);
            return null;
        }
    }

    private int countGiftSend(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftSendMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftSendServiceImpl.countGiftSend", (Throwable)e);
        }
        return i;
    }

    private GtGiftSend createGtGiftSend(GtGiftSendDomain gtGiftSendDomain) {
        String msg = this.checkGiftSend(gtGiftSendDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.saveGiftSend.checkGiftSend", msg);
        }
        GtGiftSend gtGiftSend = this.makeGiftSend(gtGiftSendDomain, null);
        this.setGiftSendDefault(gtGiftSend);
        if (StringUtils.isBlank((String)gtGiftSendDomain.getGiftSendBatch())) {
            String no = this.getNo("0", "GtGiftSend", "giftSendBatchNo", gtGiftSendDomain.getTenantCode());
            gtGiftSend.setGiftSendBatch(no);
        }
        return gtGiftSend;
    }

    @Override
    public String saveGiftSend(GtGiftSendDomain gtGiftSendDomain) throws ApiException {
        GtGiftSend gtGiftSend = this.createGtGiftSend(gtGiftSendDomain);
        this.saveGiftSendModel(gtGiftSend);
        String sendCode = gtGiftSend.getGiftSendCode();
        List<GtGiftSendlistDomain> gtGiftSendlistDomainList = gtGiftSendDomain.getGtGiftSendlistDomain();
        if (null != gtGiftSendlistDomainList && gtGiftSendlistDomainList.size() > 0) {
            for (GtGiftSendlistDomain gtGiftSendlistReDomain : gtGiftSendlistDomainList) {
                gtGiftSendlistReDomain.setGiftSendCode(sendCode);
                gtGiftSendlistReDomain.setTenantCode(gtGiftSend.getTenantCode());
            }
            this.gtGiftSendlistService.saveGiftSendlistBatch(gtGiftSendlistDomainList);
        }
        if (1 == gtGiftSend.getSendState()) {
            this.send(gtGiftSend);
        }
        return sendCode;
    }

    @Override
    public String saveGiftSendBatch(List<GtGiftSendDomain> gtGiftSendDomainList) throws ApiException {
        if (null == gtGiftSendDomainList || gtGiftSendDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GtGiftSend> gtGiftSendList = new ArrayList<GtGiftSend>();
        String code = "";
        for (GtGiftSendDomain gtGiftSendDomain : gtGiftSendDomainList) {
            GtGiftSend gtGiftSend = this.createGtGiftSend(gtGiftSendDomain);
            code = gtGiftSend.getGiftSendCode();
            gtGiftSendList.add(gtGiftSend);
        }
        this.saveGiftSendBatchModel(gtGiftSendList);
        return code;
    }

    @Override
    public void updateGiftSendState(Integer giftSendId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftSendModel(giftSendId, dataState, oldDataState);
    }

    @Override
    public void updateGiftSendVerifyState(Integer giftSendId, Integer verifyState, Integer oldVerifyState) throws ApiException {
        this.updateVerifyStateGiftSendModel(giftSendId, verifyState, oldVerifyState);
    }

    @Override
    public void updateGiftSendStateByCode(String tenantCode, String giftSendCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftSendModelByCode(tenantCode, giftSendCode, dataState, oldDataState);
    }

    @Override
    public void updateGiftSendStateByMap(String tenantCode, String giftSendCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGiftSendModelByMap(tenantCode, giftSendCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGiftSend(GtGiftSendDomain gtGiftSendDomain) throws ApiException {
        String msg = this.checkGiftSend(gtGiftSendDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateGiftSend.checkGiftSend", msg);
        }
        GtGiftSend oldGtGiftSend = this.getGiftSendModelById(gtGiftSendDomain.getGiftSendId());
        if (null == oldGtGiftSend) {
            throw new ApiException("gt.GIFT.GtGiftSendServiceImpl.updateGiftSend.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        Integer oldVerifyState = oldGtGiftSend.getVerifyState();
        GtGiftSend gtGiftSend = this.makeGiftSend(gtGiftSendDomain, oldGtGiftSend);
        this.setGiftSendUpdataDefault(gtGiftSend);
        this.updateGiftSendModel(gtGiftSend);
        String sendCode = gtGiftSend.getGiftSendCode();
        if (StringUtils.isBlank((String)gtGiftSendDomain.getEditFlag()) && "1".equals(gtGiftSendDomain.getEditFlag())) {
            this.gtGiftSendlistMapper.delByGiftSendCode(this.getQueryParamMap("giftSendCode,tenantCode", new Object[]{sendCode, gtGiftSend.getTenantCode()}));
            List<GtGiftSendlistDomain> gtGiftSendlistDomainList = gtGiftSendDomain.getGtGiftSendlistDomain();
            if (null != gtGiftSendlistDomainList && gtGiftSendlistDomainList.size() > 0) {
                for (GtGiftSendlistDomain gtGiftSendlistReDomain : gtGiftSendlistDomainList) {
                    gtGiftSendlistReDomain.setGiftSendCode(sendCode);
                    gtGiftSendlistReDomain.setTenantCode(gtGiftSend.getTenantCode());
                }
                this.gtGiftSendlistService.saveGiftSendlistBatch(gtGiftSendlistDomainList);
            }
        }
        if (oldVerifyState == 1 && gtGiftSend.getVerifyState() == 2) {
            this.send(gtGiftSend);
            this.sendPhone(gtGiftSendDomain);
        }
    }

    void sendPhone(GtGiftSendDomain gtGiftSendDomain) {
        String distinctPhoneNumbers = "";
        if (ListUtil.isEmpty(gtGiftSendDomain.getGtGiftSendlistDomain())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("giftSendCode", gtGiftSendDomain.getGiftSendCode());
            map.put("tenantCode", gtGiftSendDomain.getTenantCode());
            QueryResult<GtGiftSendlist> gtGiftSendlistQueryResult = this.gtGiftSendlistService.queryGiftSendlistPage(map);
            distinctPhoneNumbers = gtGiftSendlistQueryResult.getList().stream().map(GtGiftSendlist::getGiftSendlistPhone).distinct().collect(Collectors.joining(","));
        } else {
            distinctPhoneNumbers = gtGiftSendDomain.getGtGiftSendlistDomain().stream().map(GtGiftSendlistDomain::getGiftSendlistPhone).distinct().collect(Collectors.joining(","));
        }
        this.sendMnslist(distinctPhoneNumbers, gtGiftSendDomain.getTenantCode());
    }

    private void sendMnslist(String distinctPhoneNumbers, String tenantCode) {
        if (StringUtils.isNotBlank((String)distinctPhoneNumbers)) {
            MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
            mnsMnslistDomainBean.setMnslistBustype("gift");
            mnsMnslistDomainBean.setMnslistBusname("\u793c\u5305\u53d1\u9001");
            mnsMnslistDomainBean.setDataTenant(tenantCode);
            mnsMnslistDomainBean.setTenantCode(tenantCode);
            mnsMnslistDomainBean.setMnslistContent("gift");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("imsgSuserCode", "sys");
            map.put("imsgSuserName", "sys");
            ArrayList receiverList = new ArrayList();
            HashMap<String, String> listReceiver = new HashMap<String, String>();
            listReceiver.put("telphone", distinctPhoneNumbers);
            receiverList.add(listReceiver);
            map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
            HashMap<String, String> paramMap1 = new HashMap<String, String>();
            paramMap1.put("telphone", distinctPhoneNumbers);
            paramMap1.put("mnslistBustype", mnsMnslistDomainBean.getMnslistBustype());
            map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap1));
            mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
            this.logger.info("mnsMnslistDomainBean===", (Object)JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
            this.inAsyncInvoke("mns.ser.sendMnslist", pmap);
        }
    }

    private void send(GtGiftSend gtGiftSend) {
        if (null == gtGiftSend) {
            return;
        }
        ArrayList<GtGiftUserBean> gtGiftUserBeanList = new ArrayList<GtGiftUserBean>();
        if (0 == gtGiftSend.getSendState()) {
            GtGiftUserBean gtGiftUserBean = new GtGiftUserBean();
            try {
                BeanUtils.copyAllPropertys((Object)gtGiftUserBean, (Object)gtGiftSend);
            }
            catch (Exception e) {
                this.logger.error("gt.GIFT.GtGiftSendServiceImpl.makeGtGiftUserDomain.e", (Throwable)e);
            }
            gtGiftUserBean.setGiftUserType("2");
            gtGiftUserBean.setMemberBcode(gtGiftSend.getCompanyCode());
            gtGiftUserBean.setMemberBname(gtGiftSend.getCompanyShortname());
            gtGiftUserBean.setGiftUserNum(gtGiftSend.getGiftSendAllnum());
            gtGiftUserBean.setSendState(gtGiftSend.getSendState());
            gtGiftUserBean.setGiftSendCode(gtGiftSend.getGiftSendCode());
            gtGiftUserBean.setGiftSendName(gtGiftSend.getGiftSendName());
            gtGiftUserBean.setGiftStart(gtGiftSend.getGiftCardSdate());
            gtGiftUserBean.setGiftEnd(gtGiftSend.getGiftCardEnddate());
            gtGiftUserBean.setDataState(1);
            gtGiftUserBeanList.add(gtGiftUserBean);
        }
        HashMap<String, Object> sendListMap = new HashMap<String, Object>();
        sendListMap.put("giftSendCode", gtGiftSend.getGiftSendCode());
        sendListMap.put("tenantCode", gtGiftSend.getTenantCode());
        List<GtGiftSendlist> gtGiftSendlistDomainList = this.gtGiftSendlistMapper.query(sendListMap);
        if (null != gtGiftSendlistDomainList && gtGiftSendlistDomainList.size() > 0) {
            for (GtGiftSendlist gtGiftSendlist : gtGiftSendlistDomainList) {
                GtGiftUserBean gtGiftUserBean1 = new GtGiftUserBean();
                try {
                    BeanUtils.copyAllPropertys((Object)gtGiftUserBean1, (Object)gtGiftSend);
                }
                catch (Exception e) {
                    this.logger.error("gt.GIFT.GtGiftSendServiceImpl.makeGtGiftUserDomain.e", (Throwable)e);
                }
                gtGiftUserBean1.setGiftUserType("1");
                gtGiftUserBean1.setMemberBcode(gtGiftSendlist.getEmployeeCode());
                gtGiftUserBean1.setMemberBname(gtGiftSendlist.getEmployeeName());
                gtGiftUserBean1.setEmployeeCode(gtGiftSendlist.getEmployeeCode());
                gtGiftUserBean1.setEmployeeName(gtGiftSendlist.getEmployeeName());
                gtGiftUserBean1.setGiftUserPhone(gtGiftSendlist.getGiftSendlistPhone());
                gtGiftUserBean1.setGiftStart(gtGiftSend.getGiftCardSdate());
                gtGiftUserBean1.setGiftEnd(gtGiftSend.getGiftCardEnddate());
                gtGiftUserBean1.setGiftSendlistCode(gtGiftSendlist.getGiftSendlistCode());
                gtGiftUserBean1.setGiftUserNum(gtGiftSendlist.getGiftNum());
                gtGiftUserBean1.setDataState(4);
                gtGiftUserBeanList.add(gtGiftUserBean1);
            }
        }
        this.saveGiftUserAndList(gtGiftUserBeanList);
    }

    private void saveGiftUserAndList(List<GtGiftUserBean> gtGiftUserBeanList) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("gtGiftUserBeanList", JsonUtil.buildNormalBinder().jsonObject(gtGiftUserBeanList));
        this.inAsyncInvoke("gt.gtgiftuserlist.saveGiftUserAndList", paramMap);
    }

    @Override
    public GtGiftSend getGiftSend(Integer giftSendId) {
        return this.getGiftSendModelById(giftSendId);
    }

    @Override
    public void deleteGiftSend(Integer giftSendId) throws ApiException {
        this.deleteGiftSendModel(giftSendId);
    }

    @Override
    public QueryResult<GtGiftSend> queryGiftSendPage(Map<String, Object> map) {
        List<GtGiftSend> gtGiftSendList = this.queryGiftSendModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGiftSend(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gtGiftSendList);
        return queryResult;
    }

    @Override
    public GtGiftSend getGiftSendByCode(String tenantCode, String giftSendCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftSendCode", giftSendCode);
        return this.getGiftSendModelByCode(map);
    }

    @Override
    public void deleteGiftSendByCode(String tenantCode, String giftSendCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftSendCode", giftSendCode);
        this.delGiftSendModelByCode(map);
    }
}

