/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigDomain;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigListReDomain;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigReDomain;
import com.yqbsoft.laser.service.oauthserver.domain.UmUserBean;
import com.yqbsoft.laser.service.oauthserver.domain.UserSessionBean;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthConfigService;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthLoginService;
import com.yqbsoft.laser.service.oauthserver.token.cache.GroupUtil;
import com.yqbsoft.laser.service.oauthserver.token.cache.OAuthTokenCacheImpl;
import com.yqbsoft.laser.service.oauthserver.token.process.OAuthTokenDeleteProcess;
import com.yqbsoft.laser.service.oauthserver.util.CommonUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.PhoneFormatCheckUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public class OsOAuthLoginServiceImpl
extends BaseServiceImpl
implements OsOAuthLoginService {
    public static final String SYS_CODE = "os.OAUTHSERVER.OsOAuthLoginServiceImpl";
    private OsOAuthConfigService osOAuthConfigService;
    String cacheUserkey = "os-UmUser";
    String cacheInfokey = "os-UmUserInfo";
    String cacheOpkey = "os-UpOpPermission";
    String cacheInfoUpdatekey = "os-UmUserInfoUpdate";
    public static final String TAGFIX = ",";

    public OsOAuthConfigService getOsOAuthConfigService() {
        return this.osOAuthConfigService;
    }

    public void setOsOAuthConfigService(OsOAuthConfigService osOAuthConfigService) {
        this.osOAuthConfigService = osOAuthConfigService;
    }

    @Override
    public String getLoginPage(String uri, String browType, String clientId, String tenantCode) {
        OsOAuthConfigReDomain osOAuthConfigReDomain = this.osOAuthConfigService.getOAuthConfigAll(tenantCode, clientId);
        if (null == osOAuthConfigReDomain) {
            return "\u975e\u6cd5\u5ba2\u6237\u7aef";
        }
        String url = CommonUtil.getRes().getString("com.loginSub.url");
        String red_url = CommonUtil.getRes().getString("com.authAuthorizePage.url");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<!DOCTYPE HTML>");
        buffer.append("<HTML lang=\"en\">");
        buffer.append("<HEAD>");
        buffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        buffer.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
        buffer.append("<title>OPEN\u6388\u6743\u5b89\u5168\u767b\u5f55</title>");
        buffer.append("<style type=\"text/css\">");
        buffer.append("table {border: 0;width: 100%;}tr {border: 1px solid #333;}td {height: 30px;}.center-box {width: 400px;margin: 50px auto;overflow: hidden;}.buttongroup {text-align: center;}.buttongroup input {margin: 10px 20px;}");
        buffer.append("</style>");
        buffer.append("</HEAD>");
        buffer.append("<BODY>");
        buffer.append("<div class=\"center-box\">");
        buffer.append("<form id = \"f1\" method=\"post\">");
        buffer.append("<table>");
        buffer.append("<tr><td>Username:</td>");
        buffer.append("<td><input type=\"text\" id=\"userName\" name=\"userName\"> *</td>");
        buffer.append("<input id=\"loginNum\" type=\"hidden\" value=\"\">");
        buffer.append("</tr><tr><td>Passowrd:</td><td><input type=\"password\" id=\"userPasswd\" name=\"userPasswd\"> *</td></tr>");
        buffer.append("<tr><td colspan=\"2\" class=\"buttongroup\">");
        buffer.append("<input type=\"button\" onclick=\"onLogin()\" value=\"\u63d0\u4ea4\" name=\"Login\"> <input type=\"reset\" name=\"Reset\">");
        buffer.append("</td></tr>");
        buffer.append("</table></form></div></BODY></HTML>");
        buffer.append("<script type=\"text/javascript\">");
        buffer.append("var userName,userPasswd,xmlHttpRequest;function createXmlHttpRequest(){if(window.ActiveXObject){return new ActiveXObject(\"Microsoft.XMLHTTP\");}else if(window.XMLHttpRequest){return new XMLHttpRequest();}}function onLogin(){userName = document.getElementById('userName').value;userPasswd = document.getElementById('userPasswd').value;");
        buffer.append("var url = \"" + url + "\";");
        buffer.append("xmlHttpRequest = createXmlHttpRequest();xmlHttpRequest.onreadystatechange = zswFun;xmlHttpRequest.open(\"POST\",url,true);xmlHttpRequest.send(null);}function zswFun(){if(xmlHttpRequest.readyState == 4 && xmlHttpRequest.status == 200){var b = xmlHttpRequest.responseText;var re = eval('('+b+')');var ret = re.os.oauthserver_validateLogin_response.result;var resultArray = ret.split(\":\");if(resultArray.length>0&&resultArray[0] == \"success\"){");
        buffer.append("window.location.href=\"" + red_url + "&code=\"+resultArray[1]+\"&uri=\"+'" + uri + "'+'&clientId='+'" + clientId + "';");
        buffer.append("}else{alert(\"\u767b\u5f55\u5931\u8d25\uff01\");}}}");
        buffer.append("</script>");
        return buffer.toString();
    }

    @Override
    public UserSessionBean validateLogin(String userName, String userPasswd, String browType, String proappCode, String tenantCode) {
        String isValid = "1";
        if (PhoneFormatCheckUtils.isPhoneLegal((String)userName)) {
            isValid = "2";
        }
        return this.dologin(userName, userPasswd, browType, proappCode, tenantCode, isValid, null, null, null, null, null);
    }

    private List<String> getQuality(String quality, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)quality)) {
            return null;
        }
        String[] qualityS = quality.split(TAGFIX);
        if (null == qualityS) {
            return null;
        }
        ArrayList<String> listAll = new ArrayList<String>();
        for (String string : qualityS) {
            String platkey = string + "-" + "00000000";
            String key = string + "-" + tenantCode;
            List list = DisUtil.getMapListJson((String)"UmQualityProapp-list", (String)key, String.class);
            if (ListUtil.isEmpty((Collection)list)) {
                list = DisUtil.getMapListJson((String)"UmQualityProapp-list", (String)platkey, String.class);
            }
            if (!ListUtil.isNotEmpty((Collection)list)) continue;
            listAll.addAll(list);
        }
        return listAll;
    }

    private boolean checkquality(String quality, String proappCode, String tenantCode) {
        List<String> list;
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)quality)) {
            quality = "buy";
        }
        String platbuykey = "buy-00000000";
        String buykey = "buy-" + tenantCode;
        List buylist = DisUtil.getMapListJson((String)"UmQualityProapp-list", (String)buykey, String.class);
        if (ListUtil.isEmpty((Collection)buylist)) {
            buylist = DisUtil.getMapListJson((String)"UmQualityProapp-list", (String)platbuykey, String.class);
        }
        if (ListUtil.isEmpty(list = this.getQuality(quality, tenantCode)) && ListUtil.isEmpty((Collection)buylist)) {
            return false;
        }
        ArrayList<String> checklist = new ArrayList<String>();
        if (ListUtil.isNotEmpty((Collection)buylist)) {
            for (String string : buylist) {
                if (!com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)string)) continue;
                checklist.add(string);
            }
        }
        if (ListUtil.isNotEmpty(list)) {
            for (String string : list) {
                if (!com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)string)) continue;
                checklist.add(string);
            }
        }
        if (ListUtil.isEmpty(checklist)) {
            return false;
        }
        return checklist.contains(proappCode);
    }

    private boolean checkQualityTginfo(String quality, String proappCode, String tenantCode) {
        String tg;
        String key;
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)quality) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)proappCode) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tenantCode)) {
            return true;
        }
        String[] qualityS = quality.split(TAGFIX);
        if (null == qualityS) {
            return true;
        }
        for (String string : qualityS) {
            key = string + "-" + proappCode + "-" + tenantCode;
            tg = DisUtil.getMap((String)"UmQualityProapp-model", (String)key);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tg)) {
                key = string + "-" + proappCode + "-" + "00000000";
                tg = DisUtil.getMap((String)"UmQualityProapp-model", (String)key);
            }
            if (!"1".equals(tg)) continue;
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.checkQualityTginfo.tg", (Object)tg);
            return false;
        }
        key = "buy-" + proappCode + "-" + tenantCode;
        tg = DisUtil.getMap((String)"UmQualityProapp-model", (String)key);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tg)) {
            key = "buy-" + proappCode + "-" + "00000000";
            tg = DisUtil.getMap((String)"UmQualityProapp-model", (String)key);
        }
        if ("1".equals(tg)) {
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.checkQualityTginfo.tg.false", (Object)(tg + "-" + quality + "-" + proappCode + "-" + tenantCode));
            return false;
        }
        return true;
    }

    private boolean checkTginfo(String quality, String proappCode, String tginfoCode, String tenantCode, UserSessionBean userSesionBean) {
        if (null == userSesionBean) {
            return false;
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)tginfoCode)) {
            return true;
        }
        if (this.checkQualityTginfo(quality, proappCode, tenantCode)) {
            return true;
        }
        String userinfoCode = userSesionBean.getUserPcode();
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userinfoCode)) {
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.validateLogin.checkTginfo", (Object)JsonUtil.buildNormalBinder().toJson((Object)userSesionBean));
            return false;
        }
        String memberCode = DisUtil.getMap((String)"CmsTginfo-mem", (String)(tginfoCode + "-" + tenantCode));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)memberCode)) {
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.validateLogin.memberCode", (Object)memberCode);
            return false;
        }
        if (null != userSesionBean.getUserinfoParentMap() && com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)userSesionBean.getUserinfoParentMap().get(memberCode))) {
            return true;
        }
        String companyStr = DisUtil.getMap((String)"OrgEmployee-userinfoCode", (String)(userinfoCode + "-" + tenantCode));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)companyStr)) {
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.validateLogin.companyStr", null);
            return false;
        }
        String[] companys = companyStr.split(TAGFIX);
        for (int i = 0; i < companys.length; ++i) {
            String company = companys[i];
            if (!this.check(company, memberCode, tenantCode)) continue;
            return true;
        }
        return false;
    }

    private boolean check(String company, String memberCode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)company)) {
            return false;
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)memberCode)) {
            return false;
        }
        String cacheuserinfoCode = SupDisUtil.getMap((String)"OrgCompany-companyCode", (String)(company + "-" + tenantCode));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)cacheuserinfoCode)) {
            return false;
        }
        if (memberCode.equals(cacheuserinfoCode)) {
            return true;
        }
        String companyPcode = SupDisUtil.getMap((String)"OrgCompany-companyPcode", (String)(company + "-" + tenantCode));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)companyPcode)) {
            return false;
        }
        return this.check(companyPcode, memberCode, tenantCode);
    }

    private Map<String, String> mapCopy(Map<String, UserSessionBean> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        HashMap<String, String> rmap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            rmap.put(key, map.get(key).getTicketTokenid());
        }
        return rmap;
    }

    private UserSessionBean dologin(String userName, String userPasswd, String browType, String proappCode, String tenantCode, String isValid, String tginfoCode, String orgUserCode, String openid, String memberCode, String channelCode) {
        long star = System.currentTimeMillis();
        String msg = this.checkparam(userName, userPasswd, browType, proappCode, tenantCode);
        UserSessionBean userSession = new UserSessionBean();
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)msg)) {
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.null", (Object)"\u53c2\u6570\u4e3a\u7a7a\uff01");
            userSession.setFlag(false);
            userSession.setMsg(msg);
            return userSession;
        }
        long end = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.1", (Object)(end - star));
        OsOAuthConfigReDomain osOAuthConfigReDomain = null;
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)tginfoCode)) {
            osOAuthConfigReDomain = (OsOAuthConfigReDomain)DisUtil.getObjectJson((String)("OsOAuthConfig_Key_new-" + tginfoCode + "-" + proappCode + "-" + tenantCode), OsOAuthConfigReDomain.class);
        }
        if (null == osOAuthConfigReDomain) {
            osOAuthConfigReDomain = (OsOAuthConfigReDomain)DisUtil.getObjectJson((String)("OsOAuthConfig_Key_new-" + proappCode + "-" + tenantCode), OsOAuthConfigReDomain.class);
        }
        long end1 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.2", (Object)(end1 - end));
        if (null == osOAuthConfigReDomain) {
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.validateLogin.OsOAuthConfig", (Object)(proappCode + "-" + tenantCode + "\u672a\u627e\u5230\u914d\u7f6e\uff01"));
            userSession.setFlag(false);
            userSession.setMsg("\u672a\u627e\u5230\u914d\u7f6e");
            return userSession;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)userPasswd)) {
            userPasswd = "default";
        }
        params.put("userName", userName);
        params.put("password", userPasswd);
        params.put("appmanageIcode", proappCode);
        params.put("tenantCode", tenantCode);
        params.put("isValid", isValid);
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)osOAuthConfigReDomain.getOauthConfigLoginurl())) {
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.OauthConfigLoginurl.isnull", (Object)("tenantCode=" + osOAuthConfigReDomain.getTenantCode() + ";proappCode=" + osOAuthConfigReDomain.getProappCode()));
            throw new ApiException("os.OAUTHSERVER.OsOAuthLoginServiceImpl.makePer.OauthConfigLoginurl.isnull");
        }
        String user = this.internalInvoke(osOAuthConfigReDomain.getOauthConfigLoginurl(), params);
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.internalInvoke:", (Object)user);
        userSession = (UserSessionBean)JsonUtil.buildNonNullBinder().getJsonToObject(user, UserSessionBean.class);
        long end2 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.3", (Object)(end2 - end1));
        if (null == userSession || !userSession.isFlag()) {
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.validateLogin.UserSessionBean", (Object)(user + "=" + ((Object)params).toString()));
            return userSession;
        }
        if (!this.checkquality(userSession.getUserinfoQuality(), proappCode, tenantCode)) {
            this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.uality", (Object)(userSession.getUserinfoQuality() + "-" + proappCode + "-" + tenantCode));
            userSession.setFlag(false);
            userSession.setAction("quality");
            userSession.setMsg("quality");
            return userSession;
        }
        if (!this.checkTginfo(userSession.getUserinfoQuality(), proappCode, tginfoCode, tenantCode, userSession)) {
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.uality", (Object)(userSession.getUserinfoQuality() + "-" + tginfoCode + "-" + proappCode + "-" + tenantCode));
            userSession.setFlag(false);
            userSession.setAction("tginfo");
            userSession.setMsg("\u672a\u5173\u8054!");
            return userSession;
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)channelCode) && MapUtil.isNotEmpty(userSession.getUserinfoAchannelMap())) {
            String bdateStr = userSession.getUserinfoAchannelMap().get(channelCode);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)bdateStr)) {
                this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.channelCode", (Object)(userSession.getUserPcode() + "-" + userSession.getUserinfoAchannelMap() + "-" + channelCode));
                userSession.setFlag(false);
                userSession.setAction("channelCode");
                userSession.setMsg("\u672a\u83b7\u5f97\u767b\u5f55\u6743\u9650");
                return userSession;
            }
            String[] dataS = bdateStr.split("-");
            if (null != dataS) {
                Integer ostate;
                Integer bstate = Integer.valueOf(dataS[0]);
                if (0 != bstate) {
                    userSession.setDataState(2);
                }
                if (dataS.length > 1 && (ostate = Integer.valueOf(dataS[1])) != 0) {
                    this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.channelCodeDate", (Object)(userSession.getUserPcode() + "-" + ostate + "-" + channelCode));
                    userSession.setFlag(false);
                    userSession.setDataState(ostate);
                    userSession.setMsg("\u7528\u6237\u767b\u5f55\u88ab\u9650\u5236,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
                    return userSession;
                }
            }
        }
        long end3 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.4", (Object)(end3 - end2));
        this.makeUserbean(userSession);
        long end4 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.5", (Object)(end4 - end3));
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)osOAuthConfigReDomain.getOauthConfigAuthurl())) {
            HashMap<String, String> paramsopen = new HashMap<String, String>();
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)openid) && !openid.equals(userSession.getOpenId())) {
                userSession.setOpenId(openid);
                paramsopen.put("openid", openid);
            }
            paramsopen.put("userCode", userSession.getUserCode());
            paramsopen.put("tenantCode", tenantCode);
            HashMap<String, String> paramsend = new HashMap<String, String>();
            paramsend.put("map", JsonUtil.buildNormalBinder().toJson(paramsopen));
            this.internalInvoke(osOAuthConfigReDomain.getOauthConfigAuthurl(), paramsend);
        }
        long end5 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.6", (Object)(end5 - end4));
        userSession = this.loginUserSession(osOAuthConfigReDomain.getAppmanageGroup(), tenantCode, osOAuthConfigReDomain, params, userSession, memberCode);
        long end6 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.7", (Object)(end6 - end5));
        Map<String, UserSessionBean> umap = this.makeOrgUsercode(userSession, params, osOAuthConfigReDomain, browType, tenantCode, memberCode);
        if (null != umap && !umap.isEmpty()) {
            this.logger.info("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.10", (Object)JsonUtil.buildNormalBinder().toJson(umap));
            userSession.setUserMap(this.mapCopy(umap));
            userSession.setOneUserSessionTockid(userSession.getTicketTokenid());
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)orgUserCode)) {
                userSession.setTwoUserSessionTockid(umap.get(orgUserCode).getTicketTokenid());
            }
            for (String key : umap.keySet()) {
                UserSessionBean orguserSession = umap.get(key);
                orguserSession.setUserMap(this.mapCopy(umap));
                orguserSession.setOneUserSessionTockid(userSession.getTicketTokenid());
                OAuthTokenCacheImpl.getInstance().setUserSession(orguserSession.getTicketTokenid() + "-" + osOAuthConfigReDomain.getAppmanageGroup(), orguserSession, orguserSession.getOauthTokenExpireIn());
                OAuthTokenCacheImpl.getInstance().setTokenExit(orguserSession.getUserName(), orguserSession.getTenantCode(), browType, orguserSession.getTicketTokenid());
            }
            OAuthTokenCacheImpl.getInstance().setUserSession(userSession.getTicketTokenid() + "-" + osOAuthConfigReDomain.getAppmanageGroup(), userSession, userSession.getOauthTokenExpireIn());
        }
        long end7 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.8", (Object)(end7 - end6));
        long end8 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.dologin.9", (Object)(end8 - end7));
        userSession.setFlag(true);
        return userSession;
    }

    private void makeUserbean(UserSessionBean userSessionBean) {
        if (null == userSessionBean) {
            return;
        }
        String userCode = userSessionBean.getUserCode();
        String userinfoCode = userSessionBean.getUserPcode();
        String tenantCode = userSessionBean.getTenantCode();
        String roleStr = userSessionBean.getRoleCode();
        HashMap<String, String> opver = new HashMap<String, String>();
        userSessionBean.setOpver(opver);
        String cacheOpver = "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)roleStr)) {
            String[] roleS;
            for (String role : roleS = roleStr.split(TAGFIX)) {
                cacheOpver = DisUtil.get((String)(this.cacheOpkey + "_" + tenantCode + "-1-" + role));
                if (null == cacheOpver) {
                    cacheOpver = "";
                }
                opver.put(tenantCode + "-1-" + role, cacheOpver);
            }
        }
        if (null == (cacheOpver = DisUtil.get((String)(this.cacheOpkey + "_" + tenantCode + "-0-" + userCode)))) {
            cacheOpver = "";
        }
        opver.put(tenantCode + "-0-" + userCode, cacheOpver);
        cacheOpver = DisUtil.get((String)(this.cacheUserkey + "_" + tenantCode + "-" + userCode));
        if (null == cacheOpver) {
            cacheOpver = "";
        }
        userSessionBean.setUserver(cacheOpver);
        cacheOpver = DisUtil.get((String)(this.cacheInfokey + "_" + tenantCode + "-" + userinfoCode));
        if (null == cacheOpver) {
            cacheOpver = "";
        }
        userSessionBean.setUserinfover(cacheOpver);
        cacheOpver = DisUtil.getMap((String)this.cacheInfoUpdatekey, (String)(tenantCode + "-" + userinfoCode));
        if (null == cacheOpver) {
            cacheOpver = "";
        }
        userSessionBean.setUserinfoverUpdate(cacheOpver);
    }

    private UserSessionBean loginUserSession(String browType, String tenantCode, OsOAuthConfigReDomain osOAuthConfigReDomain, Map<String, Object> params, UserSessionBean userSession, String memberCode) {
        long end1 = System.currentTimeMillis();
        this.makeUeserSessionbean(osOAuthConfigReDomain, userSession);
        long end2 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.loginUserSession.1", (Object)(end2 - end1));
        String tokenid = OAuthTokenCacheImpl.getInstance().getTokenExit(userSession.getUserName(), userSession.getTenantCode(), browType);
        UserSessionBean olduserSesionBean = OAuthTokenCacheImpl.getInstance().getUserSession(tokenid + "-" + osOAuthConfigReDomain.getAppmanageGroup());
        long end3 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.loginUserSession.2", (Object)(end3 - end2));
        List<OsOAuthConfigListReDomain> list_config = osOAuthConfigReDomain.getOsOAuthConfigListReDomainList();
        OsOAuthConfigListReDomain oslist = null;
        if (list_config != null && list_config.size() > 0) {
            oslist = list_config.get(0);
        }
        String accTokenType = "";
        String time = "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)tokenid) && olduserSesionBean != null) {
            if (oslist != null) {
                time = null == oslist.getOauthConfigTime() ? "60000" : oslist.getOauthConfigTime().toString();
                accTokenType = oslist.getOauthConfigTokenplo();
            } else {
                time = "60000";
                accTokenType = "1";
            }
        } else {
            time = osOAuthConfigReDomain.getOauthConfigTime().toString();
            if (oslist != null) {
                time = oslist.getOauthConfigTime().toString();
            }
            accTokenType = "1";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)accTokenType)) {
            accTokenType = "1";
        }
        long end4 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.loginUserSession.3", (Object)(end4 - end3));
        userSession = OAuthTokenCacheImpl.getInstance().getSessionbyType(userSession, browType, accTokenType, time);
        long end5 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.loginUserSession.4", (Object)(end5 - end4));
        this.makePer(tenantCode, osOAuthConfigReDomain, params, userSession);
        long end6 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.loginUserSession.5", (Object)(end6 - end5));
        if (null != userSession) {
            userSession.setGroup(osOAuthConfigReDomain.getAppmanageGroup());
        }
        long end7 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.loginUserSession.6", (Object)(end7 - end6));
        userSession.setMemberCode(memberCode);
        String mapJson = SupDisUtil.getMap((String)"DisChannel-memberCode", (String)(memberCode + "-0-" + tenantCode));
        this.logger.info("os.OAUTHSERVER.OsOAuthLoginServiceImpl.loginUserSession.dischannel", (Object)mapJson);
        if (StringUtils.isEmpty((String)mapJson)) {
            mapJson = SupDisUtil.getMap((String)"DisChannel-memberCode", (String)(memberCode + "-2-" + tenantCode));
        }
        this.logger.info("os.OAUTHSERVER.OsOAuthLoginServiceImpl.loginUserSession.dischannel.1", (Object)mapJson);
        if (!StringUtils.isEmpty((String)mapJson)) {
            Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToObject(mapJson, Map.class);
            this.logger.info("os.OAUTHSERVER.OsOAuthLoginServiceImpl.loginUserSession.dischannel.2", (Object)JsonUtil.buildNonNullBinder().toJson((Object)jsonToMap));
            userSession.setChannelCode(String.valueOf(jsonToMap.get("channelCode")));
        }
        OAuthTokenCacheImpl.getInstance().setUserSession(userSession.getTicketTokenid() + "-" + osOAuthConfigReDomain.getAppmanageGroup(), userSession, userSession.getOauthTokenExpireIn());
        long end8 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.loginUserSession.7", (Object)(end8 - end7));
        OAuthTokenCacheImpl.getInstance().setTokenExit(userSession.getUserName(), userSession.getTenantCode(), browType, userSession.getTicketTokenid());
        long end9 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.loginUserSession.8", (Object)(end9 - end8));
        return userSession;
    }

    private Map<String, UserSessionBean> makeOrgUsercode(UserSessionBean userSession, Map<String, Object> params, OsOAuthConfigReDomain osOAuthConfigReDomain, String browType, String tenantCode, String memberCode) {
        if (null == userSession || null == params || params.isEmpty()) {
            return null;
        }
        HashMap<String, UserSessionBean> map = new HashMap<String, UserSessionBean>();
        String str = DisUtil.getMap((String)"OrgEmployee-orgUsercode", (String)(userSession.getUserCode() + "-" + userSession.getUserPcode() + "-" + userSession.getTenantCode()));
        UserSessionBean twoUserSessionBean = this.make(str, map, params, osOAuthConfigReDomain, browType, tenantCode, memberCode);
        if (null != twoUserSessionBean) {
            userSession.setCompanyCode(twoUserSessionBean.getCompanyCode());
            userSession.setEmpType(twoUserSessionBean.getEmpType());
            userSession.setEmpTypecode(twoUserSessionBean.getEmpTypecode());
            userSession.setTwoUserSessionTockid(twoUserSessionBean.getTicketTokenid());
        }
        str = DisUtil.getMap((String)"OrgDepartEmp-orgUsercode", (String)(userSession.getUserCode() + "-" + userSession.getUserPcode() + "-" + userSession.getTenantCode()));
        this.make(str, map, params, osOAuthConfigReDomain, browType, tenantCode, memberCode);
        str = DisUtil.getMap((String)"OrgGroup-orgUsercode", (String)(userSession.getUserCode() + "-" + userSession.getUserPcode() + "-" + userSession.getTenantCode()));
        this.make(str, map, params, osOAuthConfigReDomain, browType, tenantCode, memberCode);
        return map;
    }

    private UserSessionBean make(String str, Map<String, UserSessionBean> map, Map<String, Object> params, OsOAuthConfigReDomain osOAuthConfigReDomain, String browType, String tenantCode, String memberCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)str) || null == map || null == params || params.isEmpty()) {
            return null;
        }
        String[] s = str.split(TAGFIX);
        UserSessionBean userSession = null;
        String oauthConfigLoginurl = osOAuthConfigReDomain.getOauthConfigLoginurl();
        for (String orgUserCodeStr : s) {
            String[] empstr = orgUserCodeStr.split("\\|");
            String orgUserCode = empstr[0];
            params.put("userName", orgUserCode);
            params.put("isValid", "0");
            String orguser = this.internalInvoke(oauthConfigLoginurl, params);
            UmUserBean umUserBean = (UmUserBean)JsonUtil.buildNonNullBinder().getJsonToObject(orguser, UmUserBean.class);
            if (null == umUserBean || !umUserBean.isFlag()) continue;
            UserSessionBean twouserSession = new UserSessionBean();
            try {
                BeanUtils.copyAllPropertys((Object)twouserSession, (Object)umUserBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            twouserSession.setCompanyCode(empstr[2]);
            twouserSession.setEmpType(empstr[1]);
            twouserSession.setEmpTypecode(empstr[3]);
            twouserSession = this.loginUserSession(osOAuthConfigReDomain.getAppmanageGroup(), tenantCode, osOAuthConfigReDomain, params, twouserSession, memberCode);
            map.put(twouserSession.getUserCode(), twouserSession);
            if (null != userSession) continue;
            userSession = new UserSessionBean();
            try {
                BeanUtils.copyAllPropertys((Object)userSession, (Object)twouserSession);
            }
            catch (Exception e) {
                this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.validateLogin.make", (Throwable)e);
            }
        }
        return userSession;
    }

    private void makePer(String tenantCode, OsOAuthConfigReDomain osOAuthConfigReDomain, Map<String, Object> params, UserSessionBean userSession) {
        if (null == userSession || null == osOAuthConfigReDomain || null == params) {
            return;
        }
        HashMap<String, String> mapRole = new HashMap();
        Map extMap = new HashMap();
        String appicodes = osOAuthConfigReDomain.getProappCode();
        params.clear();
        params.put("tenantCode", userSession.getTenantCode());
        params.put("proappCode", osOAuthConfigReDomain.getProappCode());
        params.put("roleCode", userSession.getRoleCode());
        params.put("userCode", com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userSession.getUserCode()) ? "" : userSession.getUserCode());
        ConcurrentHashMap<String, String> mapWrapper = new ConcurrentHashMap<String, String>();
        mapWrapper.put("map", JsonUtil.buildNonNullBinder().toJson(params));
        long end1 = System.currentTimeMillis();
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)osOAuthConfigReDomain.getAppmanageAppkeyMp())) {
            this.logger.error("os.OAUTHSERVER.OsOAuthLoginServiceImpl.makePer.AppmanageAppkeyMp.isnull", (Object)("tenantCode=" + osOAuthConfigReDomain.getTenantCode() + ";proappCode=" + osOAuthConfigReDomain.getProappCode()));
            throw new ApiException("os.OAUTHSERVER.OsOAuthLoginServiceImpl.makePer.AppmanageAppkeyMp.isnull");
        }
        String rolemrp = this.internalInvoke(osOAuthConfigReDomain.getAppmanageAppkeyMp(), mapWrapper);
        long end2 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.makePer.1", (Object)(end2 - end1));
        Map rolemap = (Map)JsonUtil.buildNonNullBinder().getJsonToObject(rolemrp, Map.class);
        if (mapRole.isEmpty()) {
            mapRole = rolemap;
        } else {
            mapRole.putAll(rolemap);
        }
        params.put("tenantCode", tenantCode);
        params.put("loginTenantCode", userSession.getTenantCode());
        mapWrapper.put("map", JsonUtil.buildNonNullBinder().toJson(params));
        String extGetapiCode = osOAuthConfigReDomain.getExtensionsGetapi();
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)extGetapiCode)) {
            String extmrp = this.internalInvoke(extGetapiCode, mapWrapper);
            if (extMap.isEmpty()) {
                extMap = (Map)JsonUtil.buildNonNullBinder().getJsonToObject(extmrp, Map.class);
            } else {
                extMap.putAll((Map)JsonUtil.buildNonNullBinder().getJsonToObject(extmrp, Map.class));
            }
        }
        long end3 = System.currentTimeMillis();
        this.logger.debug("os.OAUTHSERVER.OsOAuthLoginServiceImpl.makePer.2", (Object)(end3 - end2));
        userSession.setExtensions(extMap);
        userSession.setMap(mapRole);
        userSession.setAppIcodes(appicodes);
    }

    private void makeUeserSessionbean(OsOAuthConfigReDomain osOAuthConfigReDomain, UserSessionBean userSession) {
        if (null == osOAuthConfigReDomain || null == userSession) {
            return;
        }
        userSession.setProappCode(osOAuthConfigReDomain.getProappCode());
        userSession.setCookieDomain(osOAuthConfigReDomain.getOauthConfigCookie());
        userSession.setAuthurl(osOAuthConfigReDomain.getOauthConfigAuthurl());
        userSession.setCookiePath(osOAuthConfigReDomain.getOauthConfigCookiep());
        userSession.setCookieUrl(osOAuthConfigReDomain.getOauthConfigCookie());
        userSession.setLoginUrl(osOAuthConfigReDomain.getOauthConfigUrl());
        userSession.setNoperurl(osOAuthConfigReDomain.getOauthConfigNoperurl());
        userSession.setNoresurl(osOAuthConfigReDomain.getOauthConfigNoresurl());
        userSession.setLoginIndexUrl(osOAuthConfigReDomain.getOauthConfigIndexurl());
        userSession.setAction(osOAuthConfigReDomain.getOauthConfigIndexurl());
    }

    @Override
    public Map<String, Object> LoginOut(String oauthTokenToken, String browType, String appmanageIcode, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("oauthTokenToken", oauthTokenToken);
        param.put("browType", browType);
        param.put("proappCode", appmanageIcode);
        param.put("tenantCode", tenantCode);
        return this.LoginOutCore(param);
    }

    public Map<String, Object> LoginOutCore(Map<String, Object> param) {
        UserSessionBean userSessionBean;
        if (null == param || param.isEmpty()) {
            return null;
        }
        String oauthTokenToken = (String)param.get("oauthTokenToken");
        String browType = (String)param.get("browType");
        String appmanageIcode = (String)param.get("proappCode");
        String tginfoCode = (String)param.get("tginfoCode");
        String tenantCode = (String)param.get("tenantCode");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)oauthTokenToken)) {
            this.logger.debug(SYS_CODE, (Object)".LoginOut.\u53c2\u6570\u4e3a\u7a7a\uff01");
            result.put("flag", false);
            return result;
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)browType)) {
            this.logger.debug(SYS_CODE, (Object)".LoginOut.\u53c2\u6570\u4e3a\u7a7a\uff01");
            result.put("flag", false);
            return result;
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)appmanageIcode)) {
            this.logger.debug(SYS_CODE, (Object)".LoginOut.\u53c2\u6570\u4e3a\u7a7a\uff01");
            result.put("flag", false);
            return result;
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)tenantCode)) {
            this.logger.debug(SYS_CODE, (Object)".LoginOut.\u53c2\u6570\u4e3a\u7a7a\uff01");
            result.put("flag", false);
            return result;
        }
        String appmanageGroup = GroupUtil.getGroupByCache(appmanageIcode, tenantCode);
        OsOAuthToken osOAuthToken = OAuthTokenCacheImpl.getInstance().getToken(oauthTokenToken);
        if (null != osOAuthToken) {
            OAuthTokenCacheImpl.getInstance().removeToken(oauthTokenToken);
            OAuthTokenDeleteProcess.getInstance().put(osOAuthToken);
        }
        if (null != (userSessionBean = OAuthTokenCacheImpl.getInstance().getUserSession(oauthTokenToken + "-" + appmanageGroup))) {
            DisUtil.del((String)(oauthTokenToken + "-" + appmanageGroup));
            String tokenid = OAuthTokenCacheImpl.getInstance().getTokenExit(userSessionBean.getUserName(), userSessionBean.getTenantCode(), browType);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)tokenid)) {
                OAuthTokenCacheImpl.getInstance().clearTokenExit(userSessionBean.getUserName(), userSessionBean.getTenantCode(), browType);
            }
        }
        OsOAuthConfigDomain osOAuthConfigReDomain = null;
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)tginfoCode)) {
            osOAuthConfigReDomain = (OsOAuthConfigReDomain)DisUtil.getObjectJson((String)("OsOAuthConfig_Key_new-" + tginfoCode + "-" + appmanageIcode + "-" + tenantCode), OsOAuthConfigReDomain.class);
        }
        if (null == osOAuthConfigReDomain) {
            osOAuthConfigReDomain = (OsOAuthConfigReDomain)DisUtil.getObjectJson((String)("OsOAuthConfig_Key_new-" + appmanageIcode + "-" + tenantCode), OsOAuthConfigReDomain.class);
        }
        if (null != osOAuthConfigReDomain && com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)osOAuthConfigReDomain.getOauthConfigRefurl())) {
            HashMap<String, String> map = new HashMap<String, String>();
            param.put("userSessionBean", userSessionBean);
            map.put("map", JsonUtil.buildNonNullBinder().toJson(param));
            this.internalInvoke(osOAuthConfigReDomain.getOauthConfigRefurl(), map);
        }
        result.put("flag", true);
        return result;
    }

    private String checkparam(String userName, String userPasswd, String browType, String appmanageIcode, String tenantCode) {
        String result = "";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)userName)) {
            result = "userName\u4e3a\u7a7a";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)appmanageIcode)) {
            result = result + ",appmanageIcode\u4e3a\u7a7a";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)tenantCode)) {
            result = result + ",tenantCode\u4e3a\u7a7a";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isEmpty((String)tenantCode)) {
            result = result + ",browType\u4e3a\u7a7a";
        }
        return result;
    }

    @Override
    public void reLoadUserSession(String oauthTokenToken, String key, String value, String appmanageIcode, String tenantCode) {
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)oauthTokenToken) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)key) || com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)appmanageIcode)) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthLoginServiceImpl.reLoadUserSession.null", "\u53c2\u6570\u4e3a\u7a7a!");
        }
        String appmanageGroup = GroupUtil.getGroupByCache(appmanageIcode, tenantCode);
        UserSessionBean userSession = OAuthTokenCacheImpl.getInstance().getUserSession(oauthTokenToken + "-" + appmanageGroup);
        Class<?> userCla = userSession.getClass();
        try {
            Field fs = userCla.getDeclaredField(key);
            fs.setAccessible(true);
            fs.set(userSession, value);
        }
        catch (Exception e) {
            throw new ApiException("os.OAUTHSERVER.OsOAuthLoginServiceImpl.reLoadUserSession." + e, "\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
        }
        OAuthTokenCacheImpl.getInstance().setUserSession(oauthTokenToken + "-" + appmanageGroup, userSession, userSession.getOauthTokenExpireIn());
    }

    @Override
    public UserSessionBean validateLogin(String userName, String browType, String app_id, String tenantCode) {
        return this.dologin(userName, "", browType, app_id, tenantCode, "0", null, null, null, null, null);
    }

    public String paserTenantCode(String tenantCode, int index) {
        if (tenantCode.indexOf(TAGFIX) > -1) {
            String[] tcs = tenantCode.split(TAGFIX);
            if (tcs.length < index + 1) {
                return "";
            }
            return tcs[index];
        }
        return tenantCode;
    }

    @Override
    public UserSessionBean validateLoginByAll(Map<String, String> map) {
        String userName = map.get("userName");
        String orgUserCode = map.get("orgUserCode");
        String userPasswd = map.get("userPasswd");
        String browType = map.get("browType");
        String appmanageIcode = map.get("appmanageIcode");
        String tenantCode = map.get("tenantCode");
        String loginType = map.get("loginType");
        String openid = map.get("openid");
        String isValid = "1";
        String channelCode = map.get("channelCode");
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)loginType)) {
            if ("0".equals(loginType) || "_userName_nopwd".equals(loginType)) {
                isValid = "0";
            } else if ("2".equals(loginType) || "_userPhone_nopwd".equals(loginType)) {
                isValid = "2";
            }
        }
        return this.dologin(userName, userPasswd, browType, appmanageIcode, tenantCode, isValid, null, orgUserCode, openid, null, channelCode);
    }

    @Override
    public String login(String userName, String passWord, String browType, String app_id, String tenantCode) {
        String validate = "1";
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)passWord)) {
            validate = "0";
        }
        UserSessionBean userSessionBean = this.dologin(userName, passWord, browType, app_id, tenantCode, validate, null, null, null, null, null);
        return JsonUtil.buildNormalBinder().toJson((Object)userSessionBean);
    }

    @Override
    public UserSessionBean validateLoginMap(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        String userName = (String)map.get("userName");
        String orgUserCode = (String)map.get("orgUserCode");
        String userPasswd = (String)map.get("userPasswd");
        String browType = (String)map.get("browType");
        String proappCode = (String)map.get("proappCode");
        String tginfoCode = (String)map.get("tginfoCode");
        String tenantCode = (String)map.get("tenantCode");
        String openid = (String)map.get("openid");
        String memberCode = (String)map.get("memberCode");
        String channelCode = (String)map.get("channelCode");
        String isValid = "1";
        if (PhoneFormatCheckUtils.isPhoneLegal((String)userName)) {
            isValid = "2";
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userPasswd)) {
            isValid = "0";
        }
        return this.dologin(userName, userPasswd, browType, proappCode, tenantCode, isValid, tginfoCode, orgUserCode, openid, memberCode, channelCode);
    }

    @Override
    public Map<String, Object> LoginOutMap(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        return this.LoginOutCore(map);
    }
}

