/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.dd.DdTransUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.dao.PtePtradeDailyMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeDailyDomain;
import com.yqbsoft.laser.service.paytradeengine.enumc.DicactorEnum;
import com.yqbsoft.laser.service.paytradeengine.enumc.PtradeDataStateEnum;
import com.yqbsoft.laser.service.paytradeengine.enumc.PtradpdeTypeEnum;
import com.yqbsoft.laser.service.paytradeengine.enumc.StatDataScopeEnum;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradeDaily;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradeParticipantChannel;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeDailyService;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.util.CollectionUtils;

public class PtePtradeDailyServiceImpl
extends BaseServiceImpl
implements PtePtradeDailyService {
    private static final String SYS_CODE = "pte.PtePtradeDailyServiceImpl";
    private static final String STAT_ORDER_INFO = "pte.ptrade.statOrderInfo";
    private static final String PAYMENT_DIC_ACTOR_CACHE_KEY = "PtPtradeParticipant-dicActorCode-paymentActorCode";
    private static final String QUERY_PTRADE_BY_PTRADE_TYPE_AND_ACOTR_TYPE = "pte.ptradeParticipant.queryByPtradeTypeAndDicActorType";
    @Resource
    private PtePtradeDailyMapper ptePtradeDailyMapper;

    @Override
    public List<PtePtradeDaily> statPtePtradeDaily(Map<String, Object> map) {
        if (CollectionUtils.isEmpty(map) || !map.containsKey("dataScope")) {
            throw new ApiException("pte.PtePtradeDailyServiceImpl.statPtePtradeDaily", "Illegal argument \u65e0\u6548\u7684\u53c2\u6570");
        }
        return this.ptePtradeDailyMapper.statPtePtradeDaily(map);
    }

    @Override
    public void updatePtePtradeDaily(PtePtradeDailyDomain ptradeDailyDomain) {
        if (ptradeDailyDomain == null || ptradeDailyDomain.getPtradeDailyId() == null) {
            throw new ApiException("pte.PtePtradeDailyServiceImpl.updatePtePtradeDaily", "Illegal argument");
        }
        PtePtradeDaily pteptradeDaily = new PtePtradeDaily();
        BeanUtils.copyProperties((Object)ptradeDailyDomain, (Object)pteptradeDaily);
        this.updatePtePtradeDailyModelByPrimaryKey(pteptradeDaily);
    }

    @Override
    public String savePtePtradeDaily(PtePtradeDailyDomain ptradeDailyDomain) {
        this.checkPtePtradeDaily(ptradeDailyDomain);
        PtePtradeDaily ptePtradeDaily = new PtePtradeDaily();
        BeanUtils.copyProperties((Object)ptradeDailyDomain, (Object)ptePtradeDaily);
        this.setPtePTradeDailyDefault(ptePtradeDaily);
        this.savePtePtradeDailyModel(ptePtradeDaily);
        return ptePtradeDaily.getPtradeDailyCode();
    }

    @Override
    public List<PtePtradeDaily> statPtradeIncomeInTime(Map<String, Object> map) {
        if (CollectionUtils.isEmpty(map)) {
            throw new ApiException("pte.PtePtradeDailyServiceImpl.statPtradeRealTime", "query params is null");
        }
        List<PtePtradeParticipantChannel> participantChannels = this.getPaymentAndRechargeParticipantChannel(map);
        if (CollectionUtils.isEmpty(participantChannels)) {
            return Collections.emptyList();
        }
        HashMap<String, PtePtradeDaily> resultMap = new HashMap<String, PtePtradeDaily>(5);
        for (PtePtradeParticipantChannel participantChannel : participantChannels) {
            String dateStr = DateUtils.getDateString((Date)participantChannel.getGmtCreate(), (String)"yyyy-MM-dd");
            String keyStr = String.format("%s-%s-%s-%s", participantChannel.getTenantCode(), participantChannel.getMerchantCode(), participantChannel.getFchannelCode(), dateStr);
            this.aggregateByKeyStr(keyStr, participantChannel, resultMap);
        }
        return new ArrayList<PtePtradeDaily>(resultMap.values());
    }

    private List<PtePtradeParticipantChannel> getPaymentAndRechargeParticipantChannel(Map<String, Object> map) {
        if (CollectionUtils.isEmpty(map)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(map);
        QueryResult<PtePtradeParticipantChannel> queryResult = this.getRechargeAndBankChannel(params);
        ArrayList<PtePtradeParticipantChannel> dataSouces = new ArrayList<PtePtradeParticipantChannel>();
        if (queryResult != null && !CollectionUtils.isEmpty((Collection)queryResult.getList())) {
            dataSouces.addAll(queryResult.getList());
        }
        params.clear();
        params.putAll(map);
        QueryResult<PtePtradeParticipantChannel> paymentPtradeResult = this.getPaymentChannel(params);
        if (paymentPtradeResult != null && !CollectionUtils.isEmpty((Collection)paymentPtradeResult.getList())) {
            dataSouces.addAll(paymentPtradeResult.getList());
        }
        return dataSouces;
    }

    @Override
    public void statPtrade() throws ApiException {
        String yesterDayStr = DateUtils.getDayInPast((Date)Calendar.getInstance().getTime(), (int)1, (String)"yyyy-MM-dd");
        this.logger.info("pte.PtePtradeDailyServiceImpl.statPtrade", (Object)String.format("task is runing ptrade date: %s", yesterDayStr));
        this.statPtradeScopeMerchant(yesterDayStr);
        this.statPtradeScopeFchannelAndMerchant(yesterDayStr);
    }

    @Override
    public void statPtradeScopeMerchant(String dateStr) throws ApiException {
        if (StringUtils.isBlank((String)dateStr)) {
            throw new ApiException("pte.PtePtradeDailyServiceImpl.statPtradeScopeMerchant", "dateStr is null");
        }
        this.logger.info("pte.PtePtradeDailyServiceImpl.statPtradeScopeMerchant", (Object)String.format("start sstatPtradeScopeMerchant date: %s", dateStr));
        List ptradeDailyList = (List)this.readObj(STAT_ORDER_INFO, this.getQueryMapParam("gmtPaid,ptradpdeCode,tenantCode,merchantCode", new Object[]{dateStr, PtradpdeTypeEnum.PAYMENT.getCode(), "", ""}), "list", new Object[]{PtePtradeDaily.class});
        if (CollectionUtils.isEmpty((Collection)ptradeDailyList)) {
            return;
        }
        for (PtePtradeDaily daily : ptradeDailyList) {
            this.saveOrInsert(daily);
        }
    }

    @Override
    public void statPtradeScopeFchannelAndMerchant(String dateStr) throws ApiException {
        if (StringUtils.isBlank((String)dateStr)) {
            throw new ApiException("pte.PtePtradeDailyServiceImpl.statPtradeScopeFchannel", "dateStr is null");
        }
        this.logger.info("pte.PtePtradeDailyServiceImpl.statPtradeScopeFchannelAndMerchant", (Object)String.format("start statPtradeScopeFchannelAndMerchant date: %s", dateStr));
        this.statPaymentPtradeScopeFchannelAndMerchant(dateStr);
        this.statRechargePtradeScopeFchannelAndMerchant(dateStr);
    }

    @Override
    public void statRechargePtradeScopeFchannelAndMerchant(String dateStr) {
        if (StringUtils.isBlank((String)dateStr)) {
            throw new ApiException("pte.PtePtradeDailyServiceImpl.statRechargePtradeScopeFchannelAndMerchant", "dateStr is null");
        }
        QueryResult<PtePtradeParticipantChannel> queryResult = this.getRechargeAndBankChannel(this.getQueryMapParam("gmtPaid", new Object[]{dateStr}));
        this.statPtePtradeParticipantChannel(queryResult);
    }

    private QueryResult<PtePtradeParticipantChannel> getRechargeAndBankChannel(Map<String, Object> map) {
        assert (!CollectionUtils.isEmpty(map));
        map.put("dicActorCode", DicactorEnum.BANK.getCode());
        map.put("ptradpdeCode", PtradpdeTypeEnum.RECHARGE.getCode());
        return this.queryPtradeByPtradeTypeAndAcotrType(map);
    }

    private QueryResult<PtePtradeParticipantChannel> queryPtradeByPtradeTypeAndAcotrType(Map<String, Object> map) {
        assert (!CollectionUtils.isEmpty(map));
        return this.getQueryResutl(QUERY_PTRADE_BY_PTRADE_TYPE_AND_ACOTR_TYPE, this.getQueryMapParam("map", new Object[]{map}), PtePtradeParticipantChannel.class);
    }

    @Override
    public void statPaymentPtradeScopeFchannelAndMerchant(String dateStr) throws ApiException {
        if (StringUtils.isBlank((String)dateStr)) {
            throw new ApiException("pte.PtePtradeDailyServiceImpl.statPaymentPtradeScopeFchannelAndMerchant", "dateStr is null");
        }
        this.logger.info("pte.PtePtradeDailyServiceImpl.statPaymentPtradeScopeFchannelAndMerchant", (Object)String.format("start statPaymentPtradeScopeFchannelAndMerchant date: %s", dateStr));
        QueryResult<PtePtradeParticipantChannel> queryResult = this.getPaymentChannel(this.getQueryMapParam("gmtPaid", new Object[]{dateStr}));
        this.statPtePtradeParticipantChannel(queryResult);
    }

    private QueryResult<PtePtradeParticipantChannel> getPaymentChannel(Map<String, Object> map) {
        String dicActorCodes = DdTransUtil.getDdValue((String)PAYMENT_DIC_ACTOR_CACHE_KEY);
        if (StringUtils.isBlank((String)dicActorCodes)) {
            this.logger.error("pte.PtePtradeDailyServiceImpl.statPaymentPtradeScopeFchannelAndMerchant.pre-condition", (Object)"pre-condition did not meet, sf_dd dicActorCode config missing");
            return null;
        }
        map.put("dicActorCodes", dicActorCodes);
        map.put("ptradpdeCode", PtradpdeTypeEnum.PAYMENT.getCode());
        return this.queryPtradeByPtradeTypeAndAcotrType(map);
    }

    private void statPtePtradeParticipantChannel(QueryResult<PtePtradeParticipantChannel> queryResult) {
        if (queryResult == null || CollectionUtils.isEmpty((Collection)queryResult.getList())) {
            this.logger.info("pte.PtePtradeDailyServiceImpl.statPtradeScopeFchannelAndMerchant", (Object)"PtePtradeParticipantChannel records is null");
            return;
        }
        HashMap<String, PtePtradeDaily> statResult = new HashMap<String, PtePtradeDaily>(16);
        for (PtePtradeParticipantChannel participantChannel : queryResult.getList()) {
            String keyStr = String.format("%s-%s-%s", participantChannel.getTenantCode(), participantChannel.getMerchantCode(), participantChannel.getFchannelCode());
            this.aggregateByKeyStr(keyStr, participantChannel, statResult);
        }
        for (PtePtradeDaily daily : statResult.values()) {
            daily.setDataScope(StatDataScopeEnum.DATA_SCOPE_FCHANNEL_MERCHANT.getCode());
            this.saveOrInsert(daily);
        }
    }

    private void aggregateByKeyStr(String keyStr, PtePtradeParticipantChannel participantChannel, Map<String, PtePtradeDaily> container) {
        PtePtradeDaily ptradeDaily;
        if (container.containsKey(keyStr)) {
            ptradeDaily = container.get(keyStr);
        } else {
            ptradeDaily = this.createPtePtradeDaily(participantChannel);
            container.put(keyStr, ptradeDaily);
        }
        this.aggregate(participantChannel, ptradeDaily);
    }

    private PtePtradeDaily createPtePtradeDaily(PtePtradeParticipantChannel participantChannel) {
        PtePtradeDaily result = new PtePtradeDaily();
        result.setTenantCode(participantChannel.getTenantCode());
        result.setMerchantCode(participantChannel.getMerchantCode());
        result.setFchannelCode(participantChannel.getFchannelCode());
        result.setPtradeDate(DateUtils.getDateString((Date)participantChannel.getGmtCreate(), (String)"yyyy-MM-dd"));
        result.setPtradeAmount(BigDecimal.ZERO);
        result.setPtradePayAmount(BigDecimal.ZERO);
        result.setFchannelCharges(BigDecimal.ZERO);
        result.setPtradePayCount(0);
        result.setPtradeCount(0);
        return result;
    }

    private void aggregate(PtePtradeParticipantChannel record, PtePtradeDaily sumInfo) {
        assert (record != null && sumInfo != null);
        String ptradeSuccessStr = DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-pte-ptradeSuccess");
        if (StringUtils.isBlank((String)ptradeSuccessStr)) {
            ptradeSuccessStr = org.apache.commons.lang3.StringUtils.join(Arrays.asList(PtradeDataStateEnum.PTRADE_PAID.getCode(), PtradeDataStateEnum.PTRADE_FINISH.getCode(), PtradeDataStateEnum.PTRADE_REFUNDED.getCode()), (String)",");
        }
        if (ptradeSuccessStr.contains(String.valueOf(record.getDataState()))) {
            sumInfo.setPtradePayAmount(sumInfo.getPtradePayAmount().add(record.getOrderAmount()));
            sumInfo.setPtradePayCount(sumInfo.getPtradePayCount() + 1);
            sumInfo.setFchannelCharges(sumInfo.getFchannelCharges().add(this.getFchannelFee(record.getFchannelFee(), record.getOrderAmount())));
        }
        sumInfo.setPtradeAmount(sumInfo.getPtradeAmount().add(record.getOrderAmount()));
        sumInfo.setPtradeCount(sumInfo.getPtradeCount() + 1);
    }

    private BigDecimal getFchannelFee(BigDecimal fchannelFee, BigDecimal orderAmount) {
        if (fchannelFee == null || orderAmount == null) {
            return BigDecimal.ZERO;
        }
        return this.toPercent(fchannelFee).multiply(orderAmount).setScale(2, 1);
    }

    private BigDecimal toPercent(BigDecimal fchannelFee) {
        assert (fchannelFee != null);
        return fchannelFee.divide(new BigDecimal(100), new MathContext(5, RoundingMode.FLOOR));
    }

    @Override
    public PtePtradeDaily queryPtradeDailyByCode(Map<String, Object> map) {
        return this.ptePtradeDailyMapper.getByCode(map);
    }

    @Override
    public PtePtradeDaily queryPtradeDaily(String dataScope, String ptradeDate, String tenantCode, String merchantCode, String fchannelCode) {
        assert (!StringUtils.hasBlank((String[])new String[]{dataScope, ptradeDate, tenantCode, merchantCode}));
        try {
            return this.ptePtradeDailyMapper.getByUnique(this.getQueryMapParam("dataScope,ptradeDate,tenantCode,merchantCode,fchannelCode", new Object[]{dataScope, ptradeDate, tenantCode, merchantCode, fchannelCode}));
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeDailyServiceImpl.queryPtradeDaily", (Object)e.getMessage());
            return null;
        }
    }

    private void saveOrInsert(PtePtradeDaily ptePtradeDaily) {
        assert (ptePtradeDaily != null);
        PtePtradeDaily existed = this.queryPtradeDaily(ptePtradeDaily.getDataScope(), ptePtradeDaily.getPtradeDate(), ptePtradeDaily.getTenantCode(), ptePtradeDaily.getMerchantCode(), ptePtradeDaily.getFchannelCode());
        try {
            if (existed != null) {
                ptePtradeDaily.setPtradeDailyId(existed.getPtradeDailyId());
                this.updatePtePtradeDailyModelByPrimaryKey(ptePtradeDaily);
            } else {
                this.setPtePTradeDailyDefault(ptePtradeDaily);
                this.savePtePtradeDailyModel(ptePtradeDaily);
            }
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeDailyServiceImplsaveOrInsert.ex", (Throwable)e);
        }
    }

    private void checkPtePtradeDaily(PtePtradeDailyDomain ptePtradeDailyDomain) {
        String errMsg = null;
        if (ptePtradeDailyDomain == null) {
            errMsg = "ptePtradeDailyDomain is null";
        } else if (StringUtils.isBlank((String)ptePtradeDailyDomain.getTenantCode())) {
            errMsg = "tenantCode is null";
        } else if (StringUtils.isBlank((String)ptePtradeDailyDomain.getDataScope())) {
            errMsg = "data scope is null";
        } else if (StringUtils.isBlank((String)ptePtradeDailyDomain.getPtradeDate())) {
            errMsg = "ptrade date is null";
        }
        if (errMsg != null) {
            throw new ApiException("pte.PtePtradeDailyServiceImpl.checkPtePtradeDaily", errMsg);
        }
    }

    private void savePtePtradeDailyModel(PtePtradeDaily ptePtradeDaily) {
        if (null == ptePtradeDaily) {
            return;
        }
        try {
            this.ptePtradeDailyMapper.insert(ptePtradeDaily);
        }
        catch (Exception e) {
            if (e instanceof DuplicateKeyException) {
                throw new ApiException("Union_ErrorCode", "\u4e3b\u952e\u51b2\u7a81");
            }
            throw new ApiException("pte.PtePtradeDailyServiceImpl.savePtradeInfoModel.ex", (Throwable)e);
        }
    }

    private void updatePtePtradeDailyModelByPrimaryKey(PtePtradeDaily ptePtradeDaily) {
        int rows;
        if (ptePtradeDaily == null || ptePtradeDaily.getPtradeDailyId() == null) {
            return;
        }
        this.setPtePtraqdeDailyUpdateDefault(ptePtradeDaily);
        try {
            rows = this.ptePtradeDailyMapper.updateByPrimaryKeySelective(ptePtradeDaily);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeDailyServiceImpl.updatePtePtradeDailyModelByPrimaryKey.ex", e.getMessage());
        }
        if (rows <= 0) {
            throw new ApiException("pte.PtePtradeDailyServiceImpl.updatePtePtradeDailyModelByPrimaryKey.null", "nothing change");
        }
    }

    private void setPtePtraqdeDailyUpdateDefault(PtePtradeDaily ptePtradeDaily) {
        if (ptePtradeDaily == null) {
            return;
        }
        ptePtradeDaily.setGmtModified(this.getSysDate());
    }

    private void setPtePTradeDailyDefault(PtePtradeDaily ptePtradeDaily) {
        if (null == ptePtradeDaily) {
            return;
        }
        if (null == ptePtradeDaily.getDataState()) {
            ptePtradeDaily.setDataState(0);
        }
        if (null == ptePtradeDaily.getGmtCreate()) {
            ptePtradeDaily.setGmtCreate(this.getSysDate());
        }
        ptePtradeDaily.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptePtradeDaily.getPtradeDailyCode())) {
            ptePtradeDaily.setPtradeDailyCode(this.createUUIDString());
        }
    }

    private Date getSysDate() {
        try {
            return this.ptePtradeDailyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeDailyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }
}

