/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.dao.PteBalancelistMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.CpBankPaymentDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.CpRechargeDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.CrpUrechargelistReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.InvInvlist;
import com.yqbsoft.laser.service.paytradeengine.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalancelistDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalancelistOpDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalancelistReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteChannelsendDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.UmUserinfoapply;
import com.yqbsoft.laser.service.paytradeengine.domain.UpmUpointsClearDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceamt;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalancelist;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalancelistOp;
import com.yqbsoft.laser.service.paytradeengine.model.PteChannelsend;
import com.yqbsoft.laser.service.paytradeengine.send.SendPutThread;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceamtService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalancelistOpService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalancelistService;
import com.yqbsoft.laser.service.paytradeengine.service.PteChannelsendService;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PteChannelsendServiceImpl;
import com.yqbsoft.laser.service.paytradeengine.util.WordToPdfAndBase64;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class PteBalancelistServiceImpl
extends BaseServiceImpl
implements PteBalancelistService {
    private static final String SYS_CODE = "pte.PteBalancelistServiceImpl";
    private PteBalancelistMapper pteBalancelistMapper;
    private PteBalanceamtService pteBalanceamtService;
    private PteChannelsendService pteChannelsendService;
    PteBalancelistOpService pteBalancelistOpService;

    public void setPteBalancelistMapper(PteBalancelistMapper pteBalancelistMapper) {
        this.pteBalancelistMapper = pteBalancelistMapper;
    }

    public void setPteBalanceamtService(PteBalanceamtService pteBalanceamtService) {
        this.pteBalanceamtService = pteBalanceamtService;
    }

    public void setPteChannelsendService(PteChannelsendService pteChannelsendService) {
        this.pteChannelsendService = pteChannelsendService;
    }

    private Date getSysDate() {
        try {
            return this.pteBalancelistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBalancelist(PteBalancelistDomain pteBalancelistDomain) {
        if (null == pteBalancelistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pteBalancelistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setBalancelistDefault(PteBalancelist pteBalancelist) {
        if (null == pteBalancelist) {
            return;
        }
        if (null == pteBalancelist.getDataState()) {
            pteBalancelist.setDataState(PteConstants.PTE_LIST_DATA_STATE_0);
        }
        Date date = this.getSysDate();
        if (null == pteBalancelist.getGmtCreate()) {
            pteBalancelist.setGmtCreate(date);
        }
        pteBalancelist.setGmtModified(date);
        if (StringUtils.isBlank((String)pteBalancelist.getBalancelistCode())) {
            pteBalancelist.setBalancelistCode(this.getNo(null, "PteBalancelist", "pteBalancelist", pteBalancelist.getTenantCode()));
        }
        if (null != pteBalancelist.getBalanceTime() && !"0".equals(pteBalancelist.getBalanceTime())) {
            long outDate = date.getTime() + (long)(Integer.valueOf(pteBalancelist.getBalanceTime()) * 60) * 1000L;
            pteBalancelist.setGmtPaySubmit(new Date(outDate));
        } else {
            pteBalancelist.setDataState(PteConstants.PTE_LIST_DATA_Already);
        }
    }

    private int getBalancelistMaxCode() {
        int code = 0;
        try {
            return this.pteBalancelistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getBalancelistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBalancelistUpdataDefault(PteBalancelist pteBalancelist) {
        if (null == pteBalancelist) {
            return;
        }
        pteBalancelist.setGmtModified(this.getSysDate());
    }

    private void saveBalancelistModel(PteBalancelist pteBalancelist) throws ApiException {
        if (null == pteBalancelist) {
            return;
        }
        try {
            this.pteBalancelistMapper.insert(pteBalancelist);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.saveBalancelistModel.ex", (Throwable)e);
        }
    }

    private void saveBalancelistBatchModel(List<PteBalancelist> pteBalancelistList) throws ApiException {
        if (null == pteBalancelistList || pteBalancelistList.isEmpty()) {
            return;
        }
        try {
            this.pteBalancelistMapper.insertBatch(pteBalancelistList);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.saveBalancelistBatchModel.ex", (Throwable)e);
        }
    }

    private PteBalancelist getBalancelistModelById(Integer balancelistId) {
        if (null == balancelistId) {
            return null;
        }
        try {
            return this.pteBalancelistMapper.selectByPrimaryKey(balancelistId);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getBalancelistModelById", (Throwable)e);
            return null;
        }
    }

    private PteBalancelist getBalancelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteBalancelistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.getBalancelistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void updateBalancelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.updateAmtByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelistModelByCode.ex", map.toString(), (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelistModelByCode.num", map.toString());
        }
    }

    private void delBalancelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.delBalancelistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalancelistServiceImpl.delBalancelistModelByCode.num");
        }
    }

    private void deleteBalancelistModel(Integer balancelistId) throws ApiException {
        if (null == balancelistId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.deleteByPrimaryKey(balancelistId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.deleteBalancelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalancelistServiceImpl.deleteBalancelistModel.num");
        }
    }

    private void updateBalancelistModel(PteBalancelist pteBalancelist) throws ApiException {
        if (null == pteBalancelist) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.updateByPrimaryKey(pteBalancelist);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelistModel.num");
        }
    }

    private void updateStateBalancelistModel(Integer balancelistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == balancelistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balancelistId", balancelistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModel.ex" + map, (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModel.null" + map);
        }
    }

    private void updateStateBalancelistModelByCode(String tenantCode, String balancelistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balancelistCode", balancelistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateStateBalancelistModelByCode.null");
        }
    }

    private PteBalancelist makeBalancelist(PteBalancelistDomain pteBalancelistDomain, PteBalancelist pteBalancelist) {
        if (null == pteBalancelistDomain) {
            return null;
        }
        if (null == pteBalancelist) {
            pteBalancelist = new PteBalancelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelist, (Object)pteBalancelistDomain);
            return pteBalancelist;
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.makeBalancelist", (Throwable)e);
            return null;
        }
    }

    private PteBalancelistReDomain makePteBalancelistReDomain(PteBalancelist pteBalancelist) {
        if (null == pteBalancelist) {
            return null;
        }
        PteBalancelistReDomain pteBalancelistReDomain = new PteBalancelistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelistReDomain, (Object)pteBalancelist);
            return pteBalancelistReDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.makePteBalancelistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PteBalancelist> queryBalancelistModelPage(Map<String, Object> parammap) {
        try {
            return this.pteBalancelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.queryBalancelistModel", (Throwable)e);
            return null;
        }
    }

    private int countBalancelist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteBalancelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.countBalancelist", (Throwable)e);
        }
        return i;
    }

    private PteBalancelist createPteBalancelist(PteBalancelistDomain pteBalancelistDomain) {
        String msg = this.checkBalancelist(pteBalancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalancelistServiceImpl.saveBalancelist.checkBalancelist", msg);
        }
        PteBalancelist pteBalancelist = this.makeBalancelist(pteBalancelistDomain, null);
        this.setBalancelistDefault(pteBalancelist);
        pteBalancelistDomain.setBalancelistCode(pteBalancelist.getBalancelistCode());
        return pteBalancelist;
    }

    @Override
    public String saveBalancelist(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        PteBalancelist pteBalancelist = this.createPteBalancelist(pteBalancelistDomain);
        this.saveBalancelistModel(pteBalancelist);
        return pteBalancelist.getBalancelistCode();
    }

    public PteBalancelistOpService getPteBalancelistOpService() {
        return this.pteBalancelistOpService;
    }

    public void setPteBalancelistOpService(PteBalancelistOpService pteBalancelistOpService) {
        this.pteBalancelistOpService = pteBalancelistOpService;
    }

    private PteBalancelist saveBalancelistModel(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        PteBalancelist pteBalancelist = this.createPteBalancelist(pteBalancelistDomain);
        this.saveBalancelistModel(pteBalancelist);
        if (ListUtil.isNotEmpty(pteBalancelistDomain.getPteBalancelistOpDomainList())) {
            for (PteBalancelistOpDomain pteBalancelistOpDomain : pteBalancelistDomain.getPteBalancelistOpDomainList()) {
                pteBalancelistOpDomain.setBalancelistCode(pteBalancelistDomain.getBalancelistCode());
                pteBalancelistOpDomain.setTenantCode(pteBalancelistDomain.getTenantCode());
            }
            this.pteBalancelistOpService.savepteBalancelistOpBatch(pteBalancelistDomain.getPteBalancelistOpDomainList());
        }
        return pteBalancelist;
    }

    @Override
    public String saveBalancelistBatch(List<PteBalancelistDomain> pteBalancelistDomainList) throws ApiException {
        if (null == pteBalancelistDomainList || pteBalancelistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteBalancelist> pteBalancelistList = new ArrayList<PteBalancelist>();
        String code = "";
        for (PteBalancelistDomain pteBalancelistDomain : pteBalancelistDomainList) {
            PteBalancelist pteBalancelist = this.createPteBalancelist(pteBalancelistDomain);
            code = pteBalancelist.getBalancelistCode();
            pteBalancelistList.add(pteBalancelist);
        }
        this.saveBalancelistBatchModel(pteBalancelistList);
        return code;
    }

    @Override
    public List<PteChannelsend> savePteBalanceamtByPteBalancelist(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        String msg = this.checkBalancelist(pteBalancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalancelistServiceImpl.savePteBalanceamtByPteBalancelist.checkBalancelist", msg);
        }
        PteBalancelistDomain balancelistDomain = this.pteBalanceamtService.saveBalanceamtByBalancelist(pteBalancelistDomain);
        PteBalancelist pteBalancelist = this.saveBalancelistModel(balancelistDomain);
        ArrayList<PteBalancelist> list = new ArrayList<PteBalancelist>();
        list.add(pteBalancelist);
        return this.buidChannelsend(list, "insert");
    }

    @Override
    public List<PteChannelsend> savePteBalanceamtByPteBalancelistRebate(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        String msg = this.checkBalancelist(pteBalancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalancelistServiceImpl.savePteBalanceamtByPteBalancelistRebate.checkBalancelist", msg);
        }
        PteBalancelistDomain balancelistDomain = this.pteBalanceamtService.saveBalanceamtByBalancelistRebate(pteBalancelistDomain);
        PteBalancelist pteBalancelist = this.saveBalancelistModel(balancelistDomain);
        ArrayList<PteBalancelist> list = new ArrayList<PteBalancelist>();
        list.add(pteBalancelist);
        return this.buidChannelsendRebate(list, pteBalancelistDomain.getBalanceType() + pteBalancelistDomain.getPtradeType());
    }

    @Override
    public void updateBalancelistState(Integer balancelistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == balancelistId) {
            return;
        }
        try {
            PteBalancelist balancelistModelById = this.getBalancelistModelById(balancelistId);
            HashMap<String, Object> templateParam = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((String)balancelistModelById.getGoodsClass())) {
                BigDecimal balanceAmount2;
                BigDecimal balanceAmount3;
                BigDecimal balanceAmount;
                String[] split = balancelistModelById.getGoodsClass().split("-");
                templateParam.put("year", split[0]);
                templateParam.put("month", split[1]);
                templateParam.put("company", balancelistModelById.getMemberBname());
                BigDecimal balanceAmount4 = balancelistModelById.getBalanceAmount4();
                if (null == balanceAmount4) {
                    balanceAmount4 = BigDecimal.ZERO;
                }
                BigDecimal balanceAmount5 = BigDecimal.ZERO;
                BigDecimal balanceAmount1 = balancelistModelById.getBalanceAmount1();
                if (null == balanceAmount1) {
                    balanceAmount1 = BigDecimal.ZERO;
                }
                if (null == (balanceAmount = balancelistModelById.getBalanceAmount())) {
                    balanceAmount = BigDecimal.ZERO;
                }
                if (null == (balanceAmount3 = balancelistModelById.getBalanceAmount3())) {
                    balanceAmount3 = BigDecimal.ZERO;
                }
                if (null == (balanceAmount2 = balancelistModelById.getBalanceAmount2())) {
                    balanceAmount2 = BigDecimal.ZERO;
                }
                balanceAmount = balanceAmount.subtract(balanceAmount3);
                balanceAmount2 = balanceAmount.subtract(balanceAmount2);
                balanceAmount5 = balanceAmount4.add(balanceAmount).subtract(balanceAmount1);
                templateParam.put("openBalance", balanceAmount4.setScale(4, 5).toString());
                templateParam.put("currentSend", balanceAmount.setScale(4, 5).toString());
                templateParam.put("saleBack", balanceAmount1.setScale(4, 5).toString());
                templateParam.put("curBalance", balanceAmount5.setScale(4, 5).toString());
                templateParam.put("pendAmount", balanceAmount2.setScale(4, 5).toString());
                String memo = null;
                if (MapUtil.isEmpty(map)) {
                    map = new HashMap<String, Object>();
                }
                if (null != map.get("balanceBank")) {
                    memo = map.get("balanceBank").toString();
                }
                templateParam.put("memo", memo);
                if (null != map.get("appId")) {
                    if ("0".equals(map.get("appId"))) {
                        templateParam.put("y", "\u221a");
                    } else {
                        templateParam.put("x", "\u221a");
                    }
                }
                templateParam.put("date", this.getdate());
                this.logger.error("pte.PteBalancelistServiceImpl.updateBalancelistState.templateParam", templateParam);
                String generate = WordToPdfAndBase64.generate(templateParam, balancelistModelById.getTenantCode());
                this.logger.error("pte.PteBalancelistServiceImpl.updateBalancelistState.generate", (Object)generate);
                if (MapUtil.isEmpty(map)) {
                    map = new HashMap<String, Object>();
                    map.put("balanceopExtension", generate);
                }
                map.put("balanceopExtension", generate);
            }
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.updateBalancelistState.Exception", (Throwable)e);
            e.printStackTrace();
        }
        this.logger.error("pte.PteBalancelistServiceImpl.updateBalancelistState.map", map);
        this.updateStateBalancelistModel(balancelistId, dataState, oldDataState, map);
        this.updateStateAfter(null, null, dataState, oldDataState, balancelistId);
    }

    private String getdate() {
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return now.format(formatter);
    }

    private Map<String, Object> makeMap(Integer dataState, Map<String, Object> map) {
        if (null == dataState) {
            return map;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != map && !map.isEmpty()) {
            param.putAll(map);
        }
        if (PteConstants.PTE_LIST_DATA_Already.equals(dataState)) {
            param.put("gmtPaySubmit", this.getSysDate());
        }
        if (PteConstants.PTE_LIST_DATA_Cancel.equals(dataState)) {
            param.put("gmtPayout", this.getSysDate());
        }
        if (PteConstants.PTE_LIST_DATA_Stay.equals(dataState)) {
            param.put("gmtPaid", this.getSysDate());
        }
        return param;
    }

    @Override
    public void updateBalancelistStateByCode(String tenantCode, String balancelistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        map = this.makeMap(dataState, map);
        this.updateStateBalancelistModelByCode(tenantCode, balancelistCode, dataState, oldDataState, map);
        this.updateStateAfter(tenantCode, balancelistCode, dataState, oldDataState, null);
    }

    private void updateStateAfter(String tenantCode, String balancelistCode, Integer dataState, Integer oldDataState, Integer balancelistId) {
        PteBalancelist balancelist = null;
        if (StringUtils.isNotBlank((String)tenantCode) && StringUtils.isNotBlank((String)balancelistCode)) {
            balancelist = this.getBalancelistByCode(tenantCode, balancelistCode);
        }
        if (null == balancelist && null != balancelistId) {
            balancelist = this.getBalancelist(balancelistId);
        }
        if (null == balancelist) {
            return;
        }
        List<PteChannelsend> pteChannelsends = null;
        if (dataState.equals(balancelist.getDataState())) {
            ArrayList<PteBalancelist> list = new ArrayList<PteBalancelist>();
            list.add(balancelist);
            String old = null == oldDataState ? "all" : String.valueOf(oldDataState);
            pteChannelsends = this.buidChannelsend(list, "updateState-" + old);
        }
        if (ListUtil.isNotEmpty(pteChannelsends)) {
            PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteChannelsends));
        }
    }

    @Override
    public void updateBalancelist(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        String msg = this.checkBalancelist(pteBalancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelist.checkBalancelist", msg);
        }
        PteBalancelist oldPteBalancelist = this.getBalancelistModelById(pteBalancelistDomain.getBalancelistId());
        if (null == oldPteBalancelist) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteBalancelist pteBalancelist = this.makeBalancelist(pteBalancelistDomain, oldPteBalancelist);
        this.setBalancelistUpdataDefault(pteBalancelist);
        this.updateBalancelistModel(pteBalancelist);
    }

    @Override
    public PteBalancelist getBalancelist(Integer balancelistId) {
        if (null == balancelistId) {
            return null;
        }
        return this.getBalancelistModelById(balancelistId);
    }

    @Override
    public void deleteBalancelist(Integer balancelistId) throws ApiException {
        if (null == balancelistId) {
            return;
        }
        this.deleteBalancelistModel(balancelistId);
    }

    @Override
    public QueryResult<PteBalancelist> queryBalancelistPage(Map<String, Object> map) {
        List<PteBalancelist> pteBalancelistList = this.queryBalancelistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBalancelist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteBalancelistList);
        return queryResult;
    }

    @Override
    public PteBalancelist getBalancelistByCode(String tenantCode, String balancelistCode) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balancelistCode", balancelistCode);
        return this.getBalancelistModelByCode(map);
    }

    @Override
    public void deleteBalancelistByCode(String tenantCode, String balancelistCode) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balancelistCode", balancelistCode);
        this.delBalancelistModelByCode(map);
    }

    private List<PteChannelsend> buidChannelsend(List<PteBalancelist> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<PteChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<PteChannelsendDomain> disChannelsendDomainList = new ArrayList<PteChannelsendDomain>();
        for (PteBalancelist promotion : pmPromotionList) {
            PteChannelsendDomain pmChannelsendDomain = new PteChannelsendDomain();
            pmChannelsendDomain.setPtradeSeqno(promotion.getBalancelistCode());
            pmChannelsendDomain.setChannelsendType("pteBalancelist");
            pmChannelsendDomain.setChannelsendDir(dri + "-" + promotion.getDataState());
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.pteChannelsendService.saveChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    private List<PteChannelsend> buidChannelsendRebate(List<PteBalancelist> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<PteChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<PteChannelsendDomain> disChannelsendDomainList = new ArrayList<PteChannelsendDomain>();
        for (PteBalancelist promotion : pmPromotionList) {
            PteChannelsendDomain pmChannelsendDomain = new PteChannelsendDomain();
            pmChannelsendDomain.setPtradeSeqno(promotion.getBalancelistCode());
            pmChannelsendDomain.setChannelsendType("pteBalancelist");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.pteChannelsendService.saveChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public String saveTransferList(PteBalancelist pteBalancelist) {
        if (null == pteBalancelist) {
            return "error";
        }
        UpmUpointsClearDomain upmUpointsClearDomain = new UpmUpointsClearDomain();
        upmUpointsClearDomain.setMemberCode(pteBalancelist.getMemberCode());
        upmUpointsClearDomain.setMemberName(pteBalancelist.getMemberName());
        upmUpointsClearDomain.setPointsRuleApi("pte.balancelist.saveTransferList");
        upmUpointsClearDomain.setTenantCode(pteBalancelist.getTenantCode());
        upmUpointsClearDomain.setUpointsClearOpcode(pteBalancelist.getBusinessOrderno());
        upmUpointsClearDomain.setUpointsClearDirection("7");
        upmUpointsClearDomain.setUpointsClearNum(pteBalancelist.getBalanceopAmount());
        upmUpointsClearDomain.setMemberCcode(pteBalancelist.getMemberBcode());
        upmUpointsClearDomain.setMemberCname(pteBalancelist.getMemberBname());
        upmUpointsClearDomain.setUpointsListExcode(pteBalancelist.getMemberBcode());
        upmUpointsClearDomain.setUpointsListExname(pteBalancelist.getMemberBname());
        upmUpointsClearDomain.setUpointsType("1");
        upmUpointsClearDomain.setLevelUserqua("dis");
        this.saveSendUpointsClear(upmUpointsClearDomain);
        return "success";
    }

    private void saveSendUpointsClear(UpmUpointsClearDomain upmUpointsClearDomain) {
        if (null == upmUpointsClearDomain) {
            return;
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("upmUpointsClearDomain", JsonUtil.buildNormalBinder().toJson((Object)upmUpointsClearDomain));
        String str = this.internalInvoke("upm.upointsClearBase.sendUpointsClear", pmap);
        if (!"success".equals(str)) {
            this.logger.error("pte.PteBalancelistServiceImpl.savesendTransferList" + str, (Object)JsonUtil.buildNormalBinder().toJson((Object)upmUpointsClearDomain));
        }
    }

    @Override
    public String saveBalancelistByOc(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        this.saveBalancelistToByOc(pteBalancelistDomain);
        return "success";
    }

    @Override
    public void updateBalanceamtPay(String balancelistCode, String tenantCode, BigDecimal amt) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || StringUtils.isBlank((String)tenantCode) || null == amt) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalanceamtPay.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteBalancelist pteBalancelist = this.getBalancelistByCode(tenantCode, balancelistCode);
        if (null == pteBalancelist) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalanceamtPay.pteBalancelist", tenantCode + "=" + balancelistCode);
        }
        this.updateBalancelistModelByCode(this.getQueryMapParam("balancelistCode,tenantCode,balanceAmount2,dataState", new Object[]{balancelistCode, tenantCode, amt, pteBalancelist.getDataState()}));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", pteBalancelist.getMemberCode());
        map.put("tenantCode", pteBalancelist.getTenantCode());
        QueryResult<PteBalanceamt> qlist = this.pteBalanceamtService.queryBalanceamtPage(map);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalanceamtPay.qlist", tenantCode + "=" + balancelistCode);
        }
        this.pteBalanceamtService.updateBalanceamtPay(((PteBalanceamt)qlist.getList().get(0)).getBalanceamtCode(), tenantCode, amt);
    }

    @Override
    public void updateBalanceamtOrder(String balancelistCode, String tenantCode, BigDecimal amt) throws ApiException {
        if (StringUtils.isBlank((String)balancelistCode) || StringUtils.isBlank((String)tenantCode) || null == amt) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalanceamtOrder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteBalancelist pteBalancelist = this.getBalancelistByCode(tenantCode, balancelistCode);
        if (null == pteBalancelist) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalanceamtOrder.pteBalancelist", tenantCode + "=" + balancelistCode);
        }
        this.updateBalancelistModelByCode(this.getQueryMapParam("balancelistCode,tenantCode,balanceAmount1,dataState", new Object[]{balancelistCode, tenantCode, amt, pteBalancelist.getDataState()}));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", pteBalancelist.getMemberCode());
        map.put("tenantCode", pteBalancelist.getTenantCode());
        QueryResult<PteBalanceamt> qlist = this.pteBalanceamtService.queryBalanceamtPage(map);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalanceamtOrder.qlist", tenantCode + "=" + balancelistCode);
        }
        this.pteBalanceamtService.updateBalanceamtOrder(((PteBalanceamt)qlist.getList().get(0)).getBalanceamtCode(), tenantCode, amt);
    }

    @Override
    public void updateBalancelistDescription(String tenantCode, String balancelistCode, Map<String, Object> map) throws ApiException {
        if (null == balancelistCode || null == tenantCode) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelistDescription.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("balancelistCode", balancelistCode);
        map1.put("tenantCode", tenantCode);
        if (null != map && !map.isEmpty()) {
            map1.putAll(map);
        }
        this.updateBalancelistDescriptionModelByCode(map1);
    }

    @Override
    public String sendBalancelistRefund(OcRefundReDomain ocRefundDomain) throws ApiException {
        PteBalancelist pteBalancelist;
        this.logger.error("pte.PteBalancelistServiceImpl.sendBalancelistRefund", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            return "error";
        }
        UmUserinfoapply umUserinfoapply = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocRefundDomain.getTenantCode());
        map.put("businessOrder", ocRefundDomain.getRefundCode());
        QueryResult<PteBalancelistOp> pteBalancelistOpQueryResult = this.pteBalancelistOpService.querypteBalancelistOpPage(map);
        if (pteBalancelistOpQueryResult != null && !CollectionUtils.isEmpty((Collection)pteBalancelistOpQueryResult.getList())) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendBalancelistRefund.querypteBalancelistOpPage.\u5df2\u7ecf\u7edf\u8ba1\u8fc7\u65e0\u9700\u7edf\u8ba1", map);
            return "success";
        }
        Date date = new Date();
        String nowMoth = DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", ocRefundDomain.getTenantCode());
        param.put("memberBcode", ocRefundDomain.getMemberBcode());
        param.put("channelCode", ocRefundDomain.getChannelCode());
        param.put("goodsClass", nowMoth);
        List<PteBalancelist> pteBalancelists1 = this.queryBalancelistModelPage(param);
        umUserinfoapply = this.getUmUserinfoapply(ocRefundDomain.getTenantCode(), ocRefundDomain.getMemberBcode(), ocRefundDomain.getChannelCode());
        if (null == umUserinfoapply) {
            this.logger.error("pte.PteBalancelistServiceImpl.umUserinfoapply", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoapply));
            return "error";
        }
        if (!CollectionUtils.isEmpty(pteBalancelists1)) {
            pteBalancelist = pteBalancelists1.get(0);
        } else {
            PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
            pteBalancelistDomain.setGoodsClass(nowMoth);
            pteBalancelistDomain.setTenantCode(ocRefundDomain.getTenantCode());
            pteBalancelistDomain.setMemberBcode(ocRefundDomain.getMemberBcode());
            pteBalancelistDomain.setMemberBname(ocRefundDomain.getMemberBname());
            pteBalancelistDomain.setChannelCode(ocRefundDomain.getChannelCode());
            pteBalancelistDomain.setChannelName(ocRefundDomain.getChannelName());
            pteBalancelistDomain.setPartnerCode(umUserinfoapply.getUserinfoInvite());
            pteBalancelistDomain.setOpuserCode(umUserinfoapply.getUserinfoChannelcode());
            pteBalancelistDomain.setOpuserName(umUserinfoapply.getUserinfoChannelname());
            pteBalancelistDomain.setBalanceAmount3(ocRefundDomain.getRefundMoney());
            String beforeMoth = DateUtils.getDateString((Date)DateUtils.addMonths((Date)date, (int)-1), (String)"yyyy-MM-dd");
            param.put("goodsClass", beforeMoth);
            List<PteBalancelist> pteBalancelists2 = this.queryBalancelistModelPage(param);
            if (!CollectionUtils.isEmpty(pteBalancelists2)) {
                pteBalancelistDomain.setBalanceAmount3(pteBalancelists2.get(0).getBalanceAmount4());
            }
            this.saveBalancelist(pteBalancelistDomain);
            param.put("goodsClass", nowMoth);
            List<PteBalancelist> pteBalancelists3 = this.queryBalancelistModelPage(param);
            pteBalancelist = pteBalancelists3.get(0);
        }
        PteBalancelistOpDomain pteBalancelistOpDomain = new PteBalancelistOpDomain();
        pteBalancelistOpDomain.setBalancelistCode(pteBalancelist.getBalancelistCode());
        pteBalancelistOpDomain.setTenantCode(ocRefundDomain.getTenantCode());
        pteBalancelistOpDomain.setMemberBcode(ocRefundDomain.getMemberBcode());
        pteBalancelistOpDomain.setMemberBname(ocRefundDomain.getMemberBname());
        pteBalancelistOpDomain.setChannelCode(ocRefundDomain.getChannelCode());
        pteBalancelistOpDomain.setBusinessOrder(ocRefundDomain.getRefundCode());
        pteBalancelistOpDomain.setBusinessType("OcRefundRe");
        pteBalancelistOpDomain.setPtradeType("OcRefundRe");
        pteBalancelistOpDomain.setBusinessDes1(ocRefundDomain.getRefundOcode());
        pteBalancelistOpDomain.setBusinessDes2(ocRefundDomain.getContractBbillcode());
        pteBalancelistOpDomain.setBusinessDes3(ocRefundDomain.getContractNbbillcode());
        pteBalancelistOpDomain.setBalanceAmount(ocRefundDomain.getRefundMoney().multiply(new BigDecimal("-1")));
        pteBalancelistOpDomain.setOrderPortion(ocRefundDomain.getGoodsNum());
        pteBalancelistOpDomain.setBalanceopCode(pteBalancelist.getBalanceopCode());
        pteBalancelistOpDomain.setOpuserCode(umUserinfoapply.getUserinfoChannelcode());
        pteBalancelistOpDomain.setOpuserName(umUserinfoapply.getUserinfoChannelname());
        pteBalancelistOpDomain.setPartnerCode(umUserinfoapply.getUserinfoInvite());
        pteBalancelistOpDomain.setGmtPaySubmit(date);
        this.pteBalancelistOpService.savepteBalancelistOp(pteBalancelistOpDomain);
        BigDecimal balanceAmount = pteBalancelist.getBalanceAmount() == null ? BigDecimal.ZERO : pteBalancelist.getBalanceAmount();
        pteBalancelist.setBalanceAmount(balanceAmount.add(pteBalancelistOpDomain.getBalanceAmount()));
        PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)pteBalancelist);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceSgSendgoods.copyAllPropertys", (Throwable)e);
        }
        this.updateBalancelist(pteBalancelistDomain);
        return "success";
    }

    private String getString() {
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        return now.format(formatter);
    }

    @Override
    public String sendByBalanceSgSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) throws ApiException {
        PteBalancelist pteBalancelist;
        this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceSgSendgoods", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        if (null == sgSendgoodsDomain) {
            return "error";
        }
        UmUserinfoapply umUserinfoapply = null;
        if (ListUtil.isEmpty(sgSendgoodsDomain.getSgSendgoodsGoodsDomainList())) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceSgSendgoods.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            return "error";
        }
        umUserinfoapply = this.getUmUserinfoapply(sgSendgoodsDomain.getTenantCode(), sgSendgoodsDomain.getMemberBcode(), sgSendgoodsDomain.getChannelCode());
        if (null == umUserinfoapply) {
            this.logger.error("pte.PteBalancelistServiceImplsendByBalanceSgSendgoods.umUserinfoapply", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfoapply));
            return "error";
        }
        BigDecimal sumMoney = BigDecimal.ZERO;
        BigDecimal sum = BigDecimal.ZERO;
        for (SgSendgoodsGoodsDomain ocContractGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
            if (null == ocContractGoodsDomain.getContractGoodsPrice()) {
                ocContractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getSendgoodsGoodsCamount()) {
                ocContractGoodsDomain.setSendgoodsGoodsCamount(BigDecimal.ZERO);
            }
            sumMoney = sumMoney.add(ocContractGoodsDomain.getContractGoodsPrice().multiply(ocContractGoodsDomain.getSendgoodsGoodsCamount()));
            sum = sum.add(ocContractGoodsDomain.getSendgoodsGoodsCamount());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", sgSendgoodsDomain.getTenantCode());
        map.put("businessOrder", sgSendgoodsDomain.getSendgoodsCode());
        QueryResult<PteBalancelistOp> pteBalancelistOpQueryResult = this.pteBalancelistOpService.querypteBalancelistOpPage(map);
        if (pteBalancelistOpQueryResult != null && !CollectionUtils.isEmpty((Collection)pteBalancelistOpQueryResult.getList())) {
            this.logger.error("pte.PteBalancelistServiceImpl.querypteBalancelistOpPage.\u5df2\u7ecf\u7edf\u8ba1\u8fc7\u65e0\u9700\u7edf\u8ba1", map);
            return "success";
        }
        Date date = new Date();
        String nowMoth = DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", sgSendgoodsDomain.getTenantCode());
        param.put("memberBcode", sgSendgoodsDomain.getMemberBcode());
        param.put("channelCode", sgSendgoodsDomain.getChannelCode());
        param.put("goodsClass", nowMoth);
        List<PteBalancelist> pteBalancelists1 = this.queryBalancelistModelPage(param);
        if (!CollectionUtils.isEmpty(pteBalancelists1)) {
            pteBalancelist = pteBalancelists1.get(0);
        } else {
            PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
            pteBalancelistDomain.setGoodsClass(nowMoth);
            pteBalancelistDomain.setPartnerCode(umUserinfoapply.getUserinfoInvite());
            pteBalancelistDomain.setTenantCode(sgSendgoodsDomain.getTenantCode());
            pteBalancelistDomain.setMemberBcode(sgSendgoodsDomain.getMemberBcode());
            pteBalancelistDomain.setMemberBname(sgSendgoodsDomain.getMemberBname());
            pteBalancelistDomain.setChannelCode(sgSendgoodsDomain.getChannelCode());
            pteBalancelistDomain.setOpuserCode(umUserinfoapply.getUserinfoChannelcode());
            pteBalancelistDomain.setOpuserName(umUserinfoapply.getUserinfoChannelname());
            String beforeMoth = DateUtils.getDateString((Date)DateUtils.addMonths((Date)date, (int)-1), (String)"yyyy-MM-dd");
            param.put("goodsClass", beforeMoth);
            List<PteBalancelist> pteBalancelists2 = this.queryBalancelistModelPage(param);
            if (!CollectionUtils.isEmpty(pteBalancelists2)) {
                pteBalancelistDomain.setBalanceAmount3(pteBalancelists2.get(0).getBalanceAmount4());
            }
            this.saveBalancelist(pteBalancelistDomain);
            param.put("goodsClass", nowMoth);
            List<PteBalancelist> pteBalancelists3 = this.queryBalancelistModelPage(param);
            pteBalancelist = pteBalancelists3.get(0);
        }
        PteBalancelistOpDomain pteBalancelistOpDomain = new PteBalancelistOpDomain();
        pteBalancelistOpDomain.setTenantCode(sgSendgoodsDomain.getTenantCode());
        pteBalancelistOpDomain.setMemberBcode(sgSendgoodsDomain.getMemberBcode());
        pteBalancelistOpDomain.setMemberBname(sgSendgoodsDomain.getMemberBname());
        pteBalancelistOpDomain.setChannelCode(sgSendgoodsDomain.getChannelCode());
        pteBalancelistOpDomain.setBusinessOrder(sgSendgoodsDomain.getSendgoodsCode());
        pteBalancelistOpDomain.setBusinessType("SgSendgoods");
        pteBalancelistOpDomain.setPtradeType("SgSendgoods");
        pteBalancelistOpDomain.setBusinessDes1(sgSendgoodsDomain.getContractObillcode());
        pteBalancelistOpDomain.setBusinessDes2(sgSendgoodsDomain.getContractBbillcode());
        pteBalancelistOpDomain.setBusinessDes3(sgSendgoodsDomain.getContractNbbillcode());
        pteBalancelistOpDomain.setBalanceAmount(sumMoney);
        pteBalancelistOpDomain.setOrderPortion(sum);
        pteBalancelistOpDomain.setBalanceopCode(pteBalancelist.getBalanceopCode());
        pteBalancelistOpDomain.setBalancelistCode(pteBalancelist.getBalancelistCode());
        pteBalancelistOpDomain.setOpuserCode(umUserinfoapply.getUserinfoChannelcode());
        pteBalancelistOpDomain.setOpuserName(umUserinfoapply.getUserinfoChannelname());
        pteBalancelistOpDomain.setPartnerCode(umUserinfoapply.getUserinfoInvite());
        pteBalancelistOpDomain.setGmtPaySubmit(sgSendgoodsDomain.getSendgoodsGddate());
        this.pteBalancelistOpService.savepteBalancelistOp(pteBalancelistOpDomain);
        BigDecimal balanceAmount = pteBalancelist.getBalanceAmount() == null ? BigDecimal.ZERO : pteBalancelist.getBalanceAmount();
        BigDecimal num = balanceAmount.add(sum);
        pteBalancelist.setBalanceAmount(num);
        PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)pteBalancelist);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceSgSendgoods.copyAllPropertys", (Throwable)e);
        }
        this.updateBalancelist(pteBalancelistDomain);
        return "success";
    }

    public UmUserinfoapply getUmUserinfoapply(String tenantCode, String userinfoCode, String channelCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)channelCode)) {
            throw new ApiException("pte.PteBalancelistServiceImpl.getUmUserinfoapply", "param is null");
        }
        HashMap<String, Object> userinfoParamMap3 = new HashMap<String, Object>();
        userinfoParamMap3.put("userinfoChannelCode", channelCode);
        userinfoParamMap3.put("dateState", 1);
        userinfoParamMap3.put("userinfoCode", userinfoCode);
        userinfoParamMap3.put("tenantCode", tenantCode);
        HashMap<String, String> invokeMap3 = new HashMap<String, String>();
        invokeMap3.put("map", JsonUtil.buildNonNullBinder().toJson(userinfoParamMap3));
        QueryResult quresult3 = this.getQueryResutl("um.umUserinfoapply.queryUserinfoapplyPage", invokeMap3, UmUserinfoapply.class);
        if (quresult3.getList() == null || CollectionUtils.isEmpty((Collection)quresult3.getList())) {
            this.logger.error("pte.PteBalancelistServiceImpl.getUmUserinfoapply", userinfoParamMap3);
            return null;
        }
        UmUserinfoapply umUserinfoapply = (UmUserinfoapply)quresult3.getList().get(0);
        return umUserinfoapply;
    }

    @Override
    public String sendByBalanceInvInvlist(InvInvlist invInvlist) throws ApiException {
        this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceInvInvlist", (Object)JsonUtil.buildNormalBinder().toJson((Object)invInvlist));
        if (null == invInvlist) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", invInvlist.getTenantCode());
        map.put("businessType", "SgSendgoods");
        map.put("businessOrder", invInvlist.getInvlistOpcode());
        QueryResult<PteBalancelistOp> pteBalancelistOpQueryResult = this.pteBalancelistOpService.querypteBalancelistOpPage(map);
        if (ListUtil.isEmpty((Collection)pteBalancelistOpQueryResult.getList())) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceInvInvlist.getList", (Object)JsonUtil.buildNormalBinder().toJson((Object)invInvlist));
            return "error";
        }
        for (PteBalancelistOp pteBalancelistOp : pteBalancelistOpQueryResult.getList()) {
            PteBalancelistOpDomain pteBalancelistOpDomain = new PteBalancelistOpDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pteBalancelistOpDomain, (Object)pteBalancelistOp);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceInvInvlistcopyAllPropertys.1", (Throwable)e);
            }
            pteBalancelistOpDomain.setBalanceFee(invInvlist.getInvlistOpamt());
            this.pteBalancelistOpService.updatepteBalancelistOp(pteBalancelistOpDomain);
            PteBalancelist balancelistByCode = this.getBalancelistByCode(pteBalancelistOpDomain.getTenantCode(), pteBalancelistOpDomain.getBalancelistCode());
            if (null == balancelistByCode) continue;
            if (null == balancelistByCode.getBalanceAmount2()) {
                balancelistByCode.setBalanceAmount2(BigDecimal.ZERO);
            }
            BigDecimal num = balancelistByCode.getBalanceAmount2().add(invInvlist.getInvlistOpamt());
            balancelistByCode.setBalanceAmount2(num);
            PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)balancelistByCode);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceInvInvlist.copyAllPropertys", (Throwable)e);
            }
            this.updateBalancelist(pteBalancelistDomain);
        }
        return "success";
    }

    @Override
    public String sendByBalanceRecharge(CpRechargeDomain cpRechargeDomain) throws ApiException {
        this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceRecharge", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomain));
        if (null == cpRechargeDomain) {
            return "error";
        }
        if (StringUtils.isEmpty((String)cpRechargeDomain.getRechargeOpcode())) {
            return "success";
        }
        if (cpRechargeDomain.getRechargeOpcode().contains("BK") || cpRechargeDomain.getRechargeOpcode().contains("NB") || "\u5176\u4ed6\u5e94\u4ed8\u6b3e\u8d37\u9879\u8c03\u6574".equals(cpRechargeDomain.getRechargeOpcode2()) || "\u4fdd\u8bc1\u91d1-\u5e94\u6536\uff08\u8d37\u9879\uff09\u8c03\u6574".equals(cpRechargeDomain.getRechargeOpcode2()) || "\u4fdd\u8bc1\u91d1\u8d37\u9879\u8c03\u6574".equals(cpRechargeDomain.getRechargeOpcode2()) || "\u4fdd\u8bc1\u91d1-\u5e94\u6536\uff08\u501f\u9879\uff09\u8c03\u6574".equals(cpRechargeDomain.getRechargeOpcode2()) || "\u4fdd\u8bc1\u91d1\u501f\u9879\u8c03\u6574".equals(cpRechargeDomain.getRechargeOpcode2())) {
            PteBalancelist pteBalancelist;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", cpRechargeDomain.getTenantCode());
            map.put("businessOrder", cpRechargeDomain.getRechargeCode());
            QueryResult<PteBalancelistOp> pteBalancelistOpQueryResult = this.pteBalancelistOpService.querypteBalancelistOpPage(map);
            if (pteBalancelistOpQueryResult != null && !CollectionUtils.isEmpty((Collection)pteBalancelistOpQueryResult.getList())) {
                this.logger.error("pte.PteBalancelistServiceImpl.querypteBalancelistOpPage.\u5df2\u7ecf\u7edf\u8ba1\u8fc7\u65e0\u9700\u7edf\u8ba1", map);
                return "success";
            }
            Date date = new Date();
            String nowMoth = DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantCode", cpRechargeDomain.getTenantCode());
            param.put("memberBcode", cpRechargeDomain.getUserinfoCode());
            param.put("channelCode", cpRechargeDomain.getChannelCode());
            param.put("goodsClass", nowMoth);
            List<PteBalancelist> pteBalancelists1 = this.queryBalancelistModelPage(param);
            if (!CollectionUtils.isEmpty(pteBalancelists1)) {
                pteBalancelist = pteBalancelists1.get(0);
            } else {
                PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
                pteBalancelistDomain.setGoodsClass(nowMoth);
                pteBalancelistDomain.setPartnerCode(cpRechargeDomain.getRechargeOpcode10());
                pteBalancelistDomain.setTenantCode(cpRechargeDomain.getTenantCode());
                pteBalancelistDomain.setMemberBcode(cpRechargeDomain.getUserinfoCode());
                pteBalancelistDomain.setMemberBname(cpRechargeDomain.getUserinfoName());
                pteBalancelistDomain.setChannelCode(cpRechargeDomain.getChannelCode());
                pteBalancelistDomain.setOpuserCode(cpRechargeDomain.getOrganizationalCode());
                pteBalancelistDomain.setOpuserName(cpRechargeDomain.getOrganizationalName());
                pteBalancelistDomain.setChannelCode(cpRechargeDomain.getChannelCode());
                String beforeMoth = DateUtils.getDateString((Date)DateUtils.addMonths((Date)date, (int)-1), (String)"yyyy-MM-dd");
                param.put("goodsClass", beforeMoth);
                List<PteBalancelist> pteBalancelists2 = this.queryBalancelistModelPage(param);
                if (!CollectionUtils.isEmpty(pteBalancelists2)) {
                    pteBalancelistDomain.setBalanceAmount3(pteBalancelists2.get(0).getBalanceAmount4());
                }
                this.saveBalancelist(pteBalancelistDomain);
                param.put("goodsClass", nowMoth);
                List<PteBalancelist> pteBalancelists3 = this.queryBalancelistModelPage(param);
                pteBalancelist = pteBalancelists3.get(0);
            }
            PteBalancelistOpDomain pteBalancelistOpDomain = new PteBalancelistOpDomain();
            pteBalancelistOpDomain.setTenantCode(cpRechargeDomain.getTenantCode());
            pteBalancelistOpDomain.setMemberBcode(cpRechargeDomain.getUserinfoCode());
            pteBalancelistOpDomain.setMemberBname(cpRechargeDomain.getUserinfoName());
            pteBalancelistOpDomain.setChannelCode(cpRechargeDomain.getChannelCode());
            pteBalancelistOpDomain.setBusinessOrder(cpRechargeDomain.getRechargeCode());
            pteBalancelistOpDomain.setBusinessType("CpRechargeDomain");
            pteBalancelistOpDomain.setBusinessType("cpRechargedomain");
            pteBalancelistOpDomain.setBusinessDes1(cpRechargeDomain.getRechargeOpcode());
            pteBalancelistOpDomain.setBalanceAmount1(cpRechargeDomain.getRechargeMoney());
            pteBalancelistOpDomain.setOrderPortion(cpRechargeDomain.getRechargeMoney());
            pteBalancelistOpDomain.setBalanceopCode(pteBalancelist.getBalanceopCode());
            pteBalancelistOpDomain.setBalancelistCode(pteBalancelist.getBalancelistCode());
            pteBalancelistOpDomain.setOpuserCode(cpRechargeDomain.getOrganizationalCode());
            pteBalancelistOpDomain.setOpuserName(cpRechargeDomain.getOrganizationalName());
            pteBalancelistOpDomain.setPartnerCode(cpRechargeDomain.getRechargeOpcode10());
            this.pteBalancelistOpService.savepteBalancelistOp(pteBalancelistOpDomain);
            BigDecimal balanceAmount1 = pteBalancelist.getBalanceAmount1() == null ? BigDecimal.ZERO : pteBalancelist.getBalanceAmount1();
            pteBalancelist.setBalanceAmount1(balanceAmount1.add(pteBalancelistOpDomain.getBalanceAmount1()));
            PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)pteBalancelist);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceRecharge.copyAllPropertys", (Throwable)e);
            }
            this.updateBalancelist(pteBalancelistDomain);
        }
        return "success";
    }

    @Override
    public String sendByBalanceCpBankPayment(CpBankPaymentDomain cpBankPaymentDomain) throws ApiException {
        this.logger.error("pte.PteBalancelistServiceImpl.cpBankPaymentDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpBankPaymentDomain));
        if (null == cpBankPaymentDomain) {
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", cpBankPaymentDomain.getTenantCode());
        param.put("memberBcode", cpBankPaymentDomain.getUserinfoCode());
        param.put("opuserCode", cpBankPaymentDomain.getOrganizationalCode());
        String yearMonth = this.getString();
        param.put("goodsClass", yearMonth);
        List<PteBalancelist> pteBalancelists1 = this.queryBalancelistModelPage(param);
        if (ListUtil.isEmpty(pteBalancelists1)) {
            PteBalancelistDomain pteBalancelist = new PteBalancelistDomain();
            pteBalancelist.setGoodsClass(yearMonth);
            pteBalancelist.setPartnerCode(cpBankPaymentDomain.getCustomerCode());
            pteBalancelist.setTenantCode(cpBankPaymentDomain.getTenantCode());
            pteBalancelist.setMemberBcode(cpBankPaymentDomain.getUserinfoCode());
            pteBalancelist.setMemberBname(cpBankPaymentDomain.getCustomerName());
            pteBalancelist.setChannelCode(cpBankPaymentDomain.getChannelCode());
            pteBalancelist.setOpuserCode(cpBankPaymentDomain.getOrganizationalCode());
            pteBalancelist.setOpuserName(cpBankPaymentDomain.getOrganizationalName());
            if (null == pteBalancelist.getBalanceAmount1()) {
                pteBalancelist.setBalanceAmount1(BigDecimal.ZERO);
            }
            if (null == pteBalancelist.getBalanceAmount2()) {
                pteBalancelist.setBalanceAmount2(BigDecimal.ZERO);
            }
            if (null == cpBankPaymentDomain.getGetMoney()) {
                cpBankPaymentDomain.setGetMoney(BigDecimal.ZERO);
            }
            BigDecimal num = pteBalancelist.getBalanceAmount1().add(cpBankPaymentDomain.getGetMoney());
            pteBalancelist.setBalanceAmount1(num);
            this.saveBalancelist(pteBalancelist);
            PteBalancelistOpDomain pteBalancelistOpDomain = new PteBalancelistOpDomain();
            pteBalancelistOpDomain.setTenantCode(cpBankPaymentDomain.getTenantCode());
            pteBalancelistOpDomain.setMemberBcode(cpBankPaymentDomain.getUserinfoCode());
            pteBalancelistOpDomain.setMemberBname(cpBankPaymentDomain.getCustomerName());
            pteBalancelistOpDomain.setChannelCode(cpBankPaymentDomain.getChannelCode());
            pteBalancelistOpDomain.setBusinessOrder(cpBankPaymentDomain.getBankpaymentCode());
            pteBalancelistOpDomain.setBusinessType("CpBankPaymentDomain");
            pteBalancelistOpDomain.setBusinessDes1(cpBankPaymentDomain.getCustomerCode());
            pteBalancelistOpDomain.setOrderOamount(cpBankPaymentDomain.getGetMoney());
            pteBalancelistOpDomain.setOrderPortion(cpBankPaymentDomain.getGetMoney());
            pteBalancelistOpDomain.setBalanceopCode(pteBalancelist.getBalanceopCode());
            pteBalancelistOpDomain.setBalancelistCode(pteBalancelist.getBalancelistCode());
            pteBalancelistOpDomain.setOpuserCode(cpBankPaymentDomain.getOrganizationalCode());
            pteBalancelistOpDomain.setOpuserName(cpBankPaymentDomain.getOrganizationalName());
            pteBalancelistOpDomain.setPartnerCode(cpBankPaymentDomain.getUserinfoCode());
            this.pteBalancelistOpService.savepteBalancelistOp(pteBalancelistOpDomain);
        } else {
            PteBalancelist pteBalancelist = pteBalancelists1.get(0);
            if (null == pteBalancelist.getBalanceAmount()) {
                pteBalancelist.setBalanceAmount(BigDecimal.ZERO);
            }
            if (null == pteBalancelist.getBalanceAmount2()) {
                pteBalancelist.setBalanceAmount2(BigDecimal.ZERO);
            }
            if (null == pteBalancelist.getBalanceAmount1()) {
                pteBalancelist.setBalanceAmount1(BigDecimal.ZERO);
            }
            if (null == cpBankPaymentDomain.getGetMoney()) {
                cpBankPaymentDomain.setGetMoney(BigDecimal.ZERO);
            }
            BigDecimal num = pteBalancelist.getBalanceAmount1().add(cpBankPaymentDomain.getGetMoney());
            pteBalancelist.setBalanceAmount1(num);
            PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)pteBalancelist);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalancelistServiceImpl.cpBankPaymentDomain.copyAllPropertys", (Throwable)e);
            }
            this.updateBalancelist(pteBalancelistDomain);
            PteBalancelistOpDomain pteBalancelistOpDomain = new PteBalancelistOpDomain();
            pteBalancelistOpDomain.setTenantCode(cpBankPaymentDomain.getTenantCode());
            pteBalancelistOpDomain.setMemberBcode(cpBankPaymentDomain.getUserinfoCode());
            pteBalancelistOpDomain.setMemberBname(cpBankPaymentDomain.getUserinfoName());
            pteBalancelistOpDomain.setChannelCode(cpBankPaymentDomain.getChannelCode());
            pteBalancelistOpDomain.setBusinessOrder(cpBankPaymentDomain.getBankpaymentCode());
            pteBalancelistOpDomain.setBusinessType("CpBankPaymentDomain");
            pteBalancelistOpDomain.setBusinessDes1(cpBankPaymentDomain.getCustomerCode());
            pteBalancelistOpDomain.setOrderOamount(cpBankPaymentDomain.getGetMoney());
            pteBalancelistOpDomain.setOrderPortion(cpBankPaymentDomain.getGetMoney());
            pteBalancelistOpDomain.setBalanceopCode(pteBalancelist.getBalanceopCode());
            pteBalancelistOpDomain.setBalancelistCode(pteBalancelist.getBalancelistCode());
            pteBalancelistOpDomain.setOpuserCode(cpBankPaymentDomain.getOrganizationalCode());
            pteBalancelistOpDomain.setOpuserName(cpBankPaymentDomain.getOrganizationalName());
            pteBalancelistOpDomain.setPartnerCode(cpBankPaymentDomain.getUserinfoCode());
            this.pteBalancelistOpService.savepteBalancelistOp(pteBalancelistOpDomain);
        }
        return "success";
    }

    @Override
    public List<Map<String, Object>> getBalancelistCountByType(Map<String, Object> map) {
        if (map == null) {
            this.logger.error("pte.PteBalancelistServiceImplgetBalancelistCountByType.map");
            return null;
        }
        try {
            return this.pteBalancelistMapper.getBalancelistCountByType(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImplgetBalancelistCountByType.e", (Object)map.toString(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String createAmoutStatement(Map<String, Object> map) throws ApiException {
        if (map == null || map.isEmpty()) {
            Date date = new Date();
            Date oneBeforeDay = DateUtils.addDays((Date)date, (int)-1);
            Date startOfDay = DateUtils.getStartOfDay((Date)oneBeforeDay);
            Date endOfDay = DateUtils.getEndOfDay((Date)oneBeforeDay);
            this.createSgAmoutStatement(startOfDay, endOfDay, "");
            this.createAsAmoutStatement(startOfDay, endOfDay, "");
            this.createVdAmoutStatement(startOfDay, endOfDay, "");
            this.createDcrpAmoutStatement(startOfDay, endOfDay);
            this.createCrpAmoutStatement(startOfDay, endOfDay);
        } else {
            String type = String.valueOf(map.get("type"));
            if ("1".equals(type)) {
                String docNo = String.valueOf(map.get("docNo"));
                if (StringUtils.isEmpty((String)docNo)) {
                    this.createSgAmoutStatement(null, null, docNo);
                } else {
                    Date startOfDay = DateUtils.getStartOfDay((Date)DateUtils.getDateToString((String)String.valueOf(map.get("startOfDay")), (String)"yyyy-MM-dd HH:mm:ss"));
                    Date endOfDay = DateUtils.getEndOfDay((Date)DateUtils.getDateToString((String)String.valueOf(map.get("endOfDay")), (String)"yyyy-MM-dd HH:mm:ss"));
                    this.createSgAmoutStatement(startOfDay, endOfDay, "");
                }
            } else if ("2".equals(type)) {
                String docNo = String.valueOf(map.get("docNo"));
                if (StringUtils.isEmpty((String)docNo)) {
                    this.createAsAmoutStatement(null, null, docNo);
                } else {
                    Date startOfDay = DateUtils.getStartOfDay((Date)DateUtils.getDateToString((String)String.valueOf(map.get("startOfDay")), (String)"yyyy-MM-dd HH:mm:ss"));
                    Date endOfDay = DateUtils.getEndOfDay((Date)DateUtils.getDateToString((String)String.valueOf(map.get("endOfDay")), (String)"yyyy-MM-dd HH:mm:ss"));
                    this.createAsAmoutStatement(startOfDay, endOfDay, "");
                }
            } else if ("3".equals(type)) {
                String docNo = String.valueOf(map.get("docNo"));
                if (StringUtils.isEmpty((String)docNo)) {
                    this.createAsAmoutStatement(null, null, docNo);
                } else {
                    Date startOfDay = DateUtils.getStartOfDay((Date)DateUtils.getDateToString((String)String.valueOf(map.get("startOfDay")), (String)"yyyy-MM-dd HH:mm:ss"));
                    Date endOfDay = DateUtils.getEndOfDay((Date)DateUtils.getDateToString((String)String.valueOf(map.get("endOfDay")), (String)"yyyy-MM-dd HH:mm:ss"));
                    this.createAsAmoutStatement(startOfDay, endOfDay, "");
                }
            } else if ("4".equals(type) || "5".equals(type)) {
                // empty if block
            }
        }
        return null;
    }

    private void createCrpAmoutStatement(Date startOfDay, Date endOfDay) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "728243877368496147");
        map.put("gmtCreateQstart", startOfDay);
        map.put("gmtCreateQend", endOfDay);
        map.put("fundType", "05");
        List<CpRechargeDomain> cpRechargeDomains = this.queryRechargePage(map);
        if (!CollectionUtils.isEmpty(cpRechargeDomains)) {
            for (CpRechargeDomain cpRechargeDomain : cpRechargeDomains) {
                try {
                    this.sendCrpRecharge(cpRechargeDomain);
                }
                catch (Exception e) {
                    this.logger.error("pte.PteBalancelistServiceImpl.createCrpAmoutStatement.sendCrpRecharge", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomain), (Throwable)e);
                }
            }
        }
        map.remove("fundType");
        map.put("fchannelClassifyCode", "DCRP");
        List<CrpUrechargelistReDomain> crpUrechargelistReDomains = this.queryCrpUrechargelistPage(map);
        for (CrpUrechargelistReDomain crpUrechargelistReDomain : crpUrechargelistReDomains) {
            try {
                this.sendCrp(crpUrechargelistReDomain);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalancelistServiceImpl.createCrpAmoutStatement.sendDcrp", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistReDomain), (Throwable)e);
            }
        }
    }

    private void sendCrp(CrpUrechargelistReDomain crpUrechargelistReDomain) {
        PteBalancelist pteBalancelist;
        this.logger.error("pte.PteBalancelistServiceImpl.sendCrp", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistReDomain));
        if (null == crpUrechargelistReDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpUrechargelistReDomain.getTenantCode());
        map.put("businessOrder", crpUrechargelistReDomain.getUrechargelistCode());
        QueryResult<PteBalancelistOp> pteBalancelistOpQueryResult = this.pteBalancelistOpService.querypteBalancelistOpPage(map);
        if (pteBalancelistOpQueryResult != null && !CollectionUtils.isEmpty((Collection)pteBalancelistOpQueryResult.getList())) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendCrp.querypteBalancelistOpPage.\u5df2\u7ecf\u7edf\u8ba1\u8fc7\u65e0\u9700\u7edf\u8ba1", map);
        }
        Date date = new Date();
        String nowMoth = DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", crpUrechargelistReDomain.getTenantCode());
        param.put("memberBcode", crpUrechargelistReDomain.getRechargeOpno1());
        param.put("channelCode", crpUrechargelistReDomain.getChannelCode());
        param.put("goodsClass", nowMoth);
        List<PteBalancelist> pteBalancelists1 = this.queryBalancelistModelPage(param);
        if (!CollectionUtils.isEmpty(pteBalancelists1)) {
            pteBalancelist = pteBalancelists1.get(0);
        } else {
            PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
            pteBalancelistDomain.setGoodsClass(nowMoth);
            pteBalancelistDomain.setPartnerCode(crpUrechargelistReDomain.getRechargeName6());
            pteBalancelistDomain.setTenantCode(crpUrechargelistReDomain.getTenantCode());
            pteBalancelistDomain.setMemberBcode(crpUrechargelistReDomain.getRechargeOpno1());
            pteBalancelistDomain.setMemberBname(crpUrechargelistReDomain.getUserinfoName());
            pteBalancelistDomain.setOpuserCode(crpUrechargelistReDomain.getRechargeName1());
            pteBalancelistDomain.setOpuserName(crpUrechargelistReDomain.getRechargeName3());
            pteBalancelistDomain.setChannelCode(crpUrechargelistReDomain.getChannelCode());
            String beforeMoth = DateUtils.getDateString((Date)DateUtils.addMonths((Date)date, (int)-1), (String)"yyyy-MM-dd");
            param.put("goodsClass", beforeMoth);
            List<PteBalancelist> pteBalancelists2 = this.queryBalancelistModelPage(param);
            if (!CollectionUtils.isEmpty(pteBalancelists2)) {
                pteBalancelistDomain.setBalanceAmount3(pteBalancelists2.get(0).getBalanceAmount4());
            }
            this.saveBalancelist(pteBalancelistDomain);
            param.put("goodsClass", nowMoth);
            List<PteBalancelist> pteBalancelists3 = this.queryBalancelistModelPage(param);
            pteBalancelist = pteBalancelists3.get(0);
        }
        PteBalancelistOpDomain pteBalancelistOpDomain = new PteBalancelistOpDomain();
        pteBalancelistOpDomain.setTenantCode(crpUrechargelistReDomain.getTenantCode());
        pteBalancelistOpDomain.setMemberBcode(crpUrechargelistReDomain.getRechargeOpno1());
        pteBalancelistOpDomain.setMemberBname(crpUrechargelistReDomain.getUserinfoName());
        pteBalancelistOpDomain.setChannelCode(crpUrechargelistReDomain.getChannelCode());
        pteBalancelistOpDomain.setBusinessOrder(crpUrechargelistReDomain.getUrechargelistCode());
        pteBalancelistOpDomain.setBusinessType("CRP_ORDER");
        pteBalancelistOpDomain.setPtradeType("crpCpRechargeDomainMinus");
        BigDecimal rechargeUrl4 = new BigDecimal(crpUrechargelistReDomain.getRechargeUrl4());
        if ("0".equals(crpUrechargelistReDomain.getUrechargelistDir())) {
            rechargeUrl4 = rechargeUrl4.multiply(new BigDecimal("-1"));
        }
        BigDecimal balanceAmount2 = pteBalancelist.getBalanceAmount2() == null ? BigDecimal.ZERO : pteBalancelist.getBalanceAmount2();
        rechargeUrl4 = balanceAmount2.add(rechargeUrl4);
        pteBalancelistOpDomain.setBusinessDes2(crpUrechargelistReDomain.getRechargeName7());
        pteBalancelistOpDomain.setBalanceAmount2(rechargeUrl4);
        pteBalancelistOpDomain.setOrderPortion(new BigDecimal(crpUrechargelistReDomain.getRechargeUrl4()));
        pteBalancelistOpDomain.setBalanceopCode(pteBalancelist.getBalanceopCode());
        pteBalancelistOpDomain.setBalancelistCode(pteBalancelist.getBalancelistCode());
        pteBalancelistOpDomain.setOpuserCode(crpUrechargelistReDomain.getRechargeName1());
        pteBalancelistOpDomain.setOpuserName(crpUrechargelistReDomain.getRechargeName3());
        pteBalancelistOpDomain.setPartnerCode(crpUrechargelistReDomain.getRechargeName6());
        this.pteBalancelistOpService.savepteBalancelistOp(pteBalancelistOpDomain);
        pteBalancelist.setBalanceAmount2(rechargeUrl4);
        PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)pteBalancelist);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceRecharge.copyAllPropertys", (Throwable)e);
        }
        this.updateBalancelist(pteBalancelistDomain);
    }

    private void createDcrpAmoutStatement(Date startOfDay, Date endOfDay) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "728243877368496147");
        map.put("gmtCreateQstart", startOfDay);
        map.put("gmtCreateQend", endOfDay);
        map.put("fundType", "04");
        List<CpRechargeDomain> cpRechargeDomains = this.queryRechargePage(map);
        if (!CollectionUtils.isEmpty(cpRechargeDomains)) {
            for (CpRechargeDomain cpRechargeDomain : cpRechargeDomains) {
                try {
                    this.sendDcrpRecharge(cpRechargeDomain);
                }
                catch (Exception e) {
                    this.logger.error("pte.PteBalancelistServiceImpl.createDcrpAmoutStatement.sendDcrpRecharge", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomain), (Throwable)e);
                }
            }
        }
        map.remove("fundType");
        map.put("fchannelClassifyCode", "DCRP");
        List<CrpUrechargelistReDomain> crpUrechargelistReDomains = this.queryCrpUrechargelistPage(map);
        for (CrpUrechargelistReDomain crpUrechargelistReDomain : crpUrechargelistReDomains) {
            try {
                this.sendDcrp(crpUrechargelistReDomain);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalancelistServiceImpl.createDcrpAmoutStatement.sendDcrp", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistReDomain), (Throwable)e);
            }
        }
    }

    private void sendDcrp(CrpUrechargelistReDomain crpUrechargelistReDomain) {
        PteBalancelist pteBalancelist;
        this.logger.error("pte.PteBalancelistServiceImpl.sendDcrp", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistReDomain));
        if (null == crpUrechargelistReDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpUrechargelistReDomain.getTenantCode());
        map.put("businessOrder", crpUrechargelistReDomain.getUrechargelistCode());
        QueryResult<PteBalancelistOp> pteBalancelistOpQueryResult = this.pteBalancelistOpService.querypteBalancelistOpPage(map);
        if (pteBalancelistOpQueryResult != null && !CollectionUtils.isEmpty((Collection)pteBalancelistOpQueryResult.getList())) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendDcrpRecharge.querypteBalancelistOpPage.\u5df2\u7ecf\u7edf\u8ba1\u8fc7\u65e0\u9700\u7edf\u8ba1", map);
        }
        Date date = new Date();
        String nowMoth = DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", crpUrechargelistReDomain.getTenantCode());
        param.put("memberBcode", crpUrechargelistReDomain.getRechargeOpno1());
        param.put("channelCode", crpUrechargelistReDomain.getChannelCode());
        param.put("goodsClass", nowMoth);
        List<PteBalancelist> pteBalancelists1 = this.queryBalancelistModelPage(param);
        if (!CollectionUtils.isEmpty(pteBalancelists1)) {
            pteBalancelist = pteBalancelists1.get(0);
        } else {
            PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
            pteBalancelistDomain.setGoodsClass(nowMoth);
            pteBalancelistDomain.setPartnerCode(crpUrechargelistReDomain.getRechargeName6());
            pteBalancelistDomain.setTenantCode(crpUrechargelistReDomain.getTenantCode());
            pteBalancelistDomain.setMemberBcode(crpUrechargelistReDomain.getRechargeOpno1());
            pteBalancelistDomain.setMemberBname(crpUrechargelistReDomain.getRechargeName3());
            pteBalancelistDomain.setOpuserCode(crpUrechargelistReDomain.getRechargeName4());
            pteBalancelistDomain.setChannelCode(crpUrechargelistReDomain.getChannelCode());
            String beforeMoth = DateUtils.getDateString((Date)DateUtils.addMonths((Date)date, (int)-1), (String)"yyyy-MM-dd");
            param.put("goodsClass", beforeMoth);
            List<PteBalancelist> pteBalancelists2 = this.queryBalancelistModelPage(param);
            if (!CollectionUtils.isEmpty(pteBalancelists2)) {
                pteBalancelistDomain.setBalanceAmount3(pteBalancelists2.get(0).getBalanceAmount4());
            }
            this.saveBalancelist(pteBalancelistDomain);
            param.put("goodsClass", nowMoth);
            List<PteBalancelist> pteBalancelists3 = this.queryBalancelistModelPage(param);
            pteBalancelist = pteBalancelists3.get(0);
        }
        PteBalancelistOpDomain pteBalancelistOpDomain = new PteBalancelistOpDomain();
        pteBalancelistOpDomain.setTenantCode(crpUrechargelistReDomain.getTenantCode());
        pteBalancelistOpDomain.setMemberBcode(crpUrechargelistReDomain.getRechargeOpno1());
        pteBalancelistOpDomain.setMemberBname(crpUrechargelistReDomain.getRechargeName3());
        pteBalancelistOpDomain.setChannelCode(crpUrechargelistReDomain.getChannelCode());
        pteBalancelistOpDomain.setBusinessOrder(crpUrechargelistReDomain.getUrechargelistCode());
        pteBalancelistOpDomain.setBusinessType("DCRP_ORDER");
        pteBalancelistOpDomain.setPtradeType("dcrpCpRechargeDomainMinus");
        pteBalancelistOpDomain.setBusinessDes2(crpUrechargelistReDomain.getRechargeName7());
        BigDecimal rechargeUrl4 = new BigDecimal(crpUrechargelistReDomain.getRechargeUrl4());
        if ("0".equals(crpUrechargelistReDomain.getUrechargelistDir())) {
            rechargeUrl4 = rechargeUrl4.multiply(new BigDecimal("-1"));
        }
        BigDecimal balanceAmount2 = pteBalancelist.getBalanceAmount2() == null ? BigDecimal.ZERO : pteBalancelist.getBalanceAmount2();
        balanceAmount2 = balanceAmount2.add(rechargeUrl4);
        pteBalancelistOpDomain.setBalanceAmount2(balanceAmount2);
        pteBalancelistOpDomain.setOrderPortion(new BigDecimal(crpUrechargelistReDomain.getRechargeUrl4()));
        pteBalancelistOpDomain.setBalanceopCode(pteBalancelist.getBalanceopCode());
        pteBalancelistOpDomain.setBalancelistCode(pteBalancelist.getBalancelistCode());
        pteBalancelistOpDomain.setOpuserCode(crpUrechargelistReDomain.getRechargeName4());
        pteBalancelistOpDomain.setPartnerCode(crpUrechargelistReDomain.getRechargeName6());
        this.pteBalancelistOpService.savepteBalancelistOp(pteBalancelistOpDomain);
        pteBalancelist.setBalanceAmount2(balanceAmount2);
        PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)pteBalancelist);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceRecharge.copyAllPropertys", (Throwable)e);
        }
        this.updateBalancelist(pteBalancelistDomain);
    }

    private List<CrpUrechargelistReDomain> queryCrpUrechargelistPage(Map<String, Object> map) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult quresult3 = this.getQueryResutl("crp.send.queryCrpUrechargelistPage", paramMap, CrpUrechargelistReDomain.class);
        if (quresult3 == null || CollectionUtils.isEmpty((Collection)quresult3.getList())) {
            return null;
        }
        return quresult3.getList();
    }

    private void sendCrpRecharge(CpRechargeDomain cpRechargeDomain) {
        PteBalancelist pteBalancelist;
        this.logger.error("pte.PteBalancelistServiceImpl.sendDcrpRecharge", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomain));
        if (null == cpRechargeDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", cpRechargeDomain.getTenantCode());
        map.put("businessOrder", cpRechargeDomain.getRechargeCode());
        QueryResult<PteBalancelistOp> pteBalancelistOpQueryResult = this.pteBalancelistOpService.querypteBalancelistOpPage(map);
        if (pteBalancelistOpQueryResult != null && !CollectionUtils.isEmpty((Collection)pteBalancelistOpQueryResult.getList())) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendDcrpRecharge.querypteBalancelistOpPage.\u5df2\u7ecf\u7edf\u8ba1\u8fc7\u65e0\u9700\u7edf\u8ba1", map);
        }
        Date date = new Date();
        String nowMoth = DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", cpRechargeDomain.getTenantCode());
        param.put("memberBcode", cpRechargeDomain.getUserinfoCode());
        param.put("channelCode", cpRechargeDomain.getChannelCode());
        param.put("goodsClass", nowMoth);
        List<PteBalancelist> pteBalancelists1 = this.queryBalancelistModelPage(param);
        if (!CollectionUtils.isEmpty(pteBalancelists1)) {
            pteBalancelist = pteBalancelists1.get(0);
        } else {
            PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
            pteBalancelistDomain.setGoodsClass(nowMoth);
            pteBalancelistDomain.setPartnerCode(cpRechargeDomain.getRechargeOpcode10());
            pteBalancelistDomain.setTenantCode(cpRechargeDomain.getTenantCode());
            pteBalancelistDomain.setMemberBcode(cpRechargeDomain.getUserinfoCode());
            pteBalancelistDomain.setMemberBname(cpRechargeDomain.getUserinfoName());
            pteBalancelistDomain.setOpuserCode(cpRechargeDomain.getOrganizationalCode());
            pteBalancelistDomain.setOpuserName(cpRechargeDomain.getOrganizationalName());
            pteBalancelistDomain.setChannelCode(cpRechargeDomain.getChannelCode());
            String beforeMoth = DateUtils.getDateString((Date)DateUtils.addMonths((Date)date, (int)-1), (String)"yyyy-MM-dd");
            param.put("goodsClass", beforeMoth);
            List<PteBalancelist> pteBalancelists2 = this.queryBalancelistModelPage(param);
            if (!CollectionUtils.isEmpty(pteBalancelists2)) {
                pteBalancelistDomain.setBalanceAmount3(pteBalancelists2.get(0).getBalanceAmount4());
            }
            this.saveBalancelist(pteBalancelistDomain);
            param.put("goodsClass", nowMoth);
            List<PteBalancelist> pteBalancelists3 = this.queryBalancelistModelPage(param);
            pteBalancelist = pteBalancelists3.get(0);
        }
        PteBalancelistOpDomain pteBalancelistOpDomain = new PteBalancelistOpDomain();
        pteBalancelistOpDomain.setTenantCode(cpRechargeDomain.getTenantCode());
        pteBalancelistOpDomain.setMemberBcode(cpRechargeDomain.getUserinfoCode());
        pteBalancelistOpDomain.setMemberBname(cpRechargeDomain.getUserinfoName());
        pteBalancelistOpDomain.setChannelCode(cpRechargeDomain.getChannelCode());
        pteBalancelistOpDomain.setBusinessOrder(cpRechargeDomain.getRechargeCode());
        pteBalancelistOpDomain.setBusinessType("CRP_CpRechargeDomain");
        pteBalancelistOpDomain.setPtradeType("crpCpRechargeDomainAdd");
        pteBalancelistOpDomain.setBusinessDes1(cpRechargeDomain.getRechargeOpcode());
        pteBalancelistOpDomain.setBalanceAmount1(cpRechargeDomain.getRechargeMoney());
        pteBalancelistOpDomain.setOrderPortion(cpRechargeDomain.getRechargeMoney());
        pteBalancelistOpDomain.setBalanceopCode(pteBalancelist.getBalanceopCode());
        pteBalancelistOpDomain.setBalancelistCode(pteBalancelist.getBalancelistCode());
        pteBalancelistOpDomain.setOpuserCode(cpRechargeDomain.getOrganizationalCode());
        pteBalancelistOpDomain.setOpuserName(cpRechargeDomain.getOrganizationalName());
        pteBalancelistOpDomain.setPartnerCode(cpRechargeDomain.getRechargeOpcode10());
        this.pteBalancelistOpService.savepteBalancelistOp(pteBalancelistOpDomain);
        BigDecimal balanceAmount1 = pteBalancelist.getBalanceAmount1() == null ? BigDecimal.ZERO : pteBalancelist.getBalanceAmount1();
        BigDecimal num = balanceAmount1.add(cpRechargeDomain.getRechargeMoney());
        pteBalancelist.setBalanceAmount1(num);
        PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)pteBalancelist);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceRecharge.copyAllPropertys", (Throwable)e);
        }
        this.updateBalancelist(pteBalancelistDomain);
    }

    private void sendDcrpRecharge(CpRechargeDomain cpRechargeDomain) {
        PteBalancelist pteBalancelist;
        this.logger.error("pte.PteBalancelistServiceImpl.sendDcrpRecharge", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomain));
        if (null == cpRechargeDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", cpRechargeDomain.getTenantCode());
        map.put("businessOrder", cpRechargeDomain.getRechargeCode());
        QueryResult<PteBalancelistOp> pteBalancelistOpQueryResult = this.pteBalancelistOpService.querypteBalancelistOpPage(map);
        if (pteBalancelistOpQueryResult != null && !CollectionUtils.isEmpty((Collection)pteBalancelistOpQueryResult.getList())) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendDcrpRecharge.querypteBalancelistOpPage.\u5df2\u7ecf\u7edf\u8ba1\u8fc7\u65e0\u9700\u7edf\u8ba1", map);
        }
        Date date = new Date();
        String nowMoth = DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", cpRechargeDomain.getTenantCode());
        param.put("memberBcode", cpRechargeDomain.getUserinfoCode());
        param.put("channelCode", cpRechargeDomain.getChannelCode());
        param.put("goodsClass", nowMoth);
        List<PteBalancelist> pteBalancelists1 = this.queryBalancelistModelPage(param);
        if (!CollectionUtils.isEmpty(pteBalancelists1)) {
            pteBalancelist = pteBalancelists1.get(0);
        } else {
            PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
            pteBalancelistDomain.setGoodsClass(nowMoth);
            pteBalancelistDomain.setPartnerCode(cpRechargeDomain.getRechargeOpcode10());
            pteBalancelistDomain.setTenantCode(cpRechargeDomain.getTenantCode());
            pteBalancelistDomain.setMemberBcode(cpRechargeDomain.getUserinfoCode());
            pteBalancelistDomain.setMemberBname(cpRechargeDomain.getUserinfoName());
            pteBalancelistDomain.setOpuserCode(cpRechargeDomain.getOrganizationalCode());
            pteBalancelistDomain.setOpuserName(cpRechargeDomain.getOrganizationalName());
            pteBalancelistDomain.setChannelCode(cpRechargeDomain.getChannelCode());
            String beforeMoth = DateUtils.getDateString((Date)DateUtils.addMonths((Date)date, (int)-1), (String)"yyyy-MM-dd");
            param.put("goodsClass", beforeMoth);
            List<PteBalancelist> pteBalancelists2 = this.queryBalancelistModelPage(param);
            if (!CollectionUtils.isEmpty(pteBalancelists2)) {
                pteBalancelistDomain.setBalanceAmount3(pteBalancelists2.get(0).getBalanceAmount4());
            }
            this.saveBalancelist(pteBalancelistDomain);
            param.put("goodsClass", nowMoth);
            List<PteBalancelist> pteBalancelists3 = this.queryBalancelistModelPage(param);
            pteBalancelist = pteBalancelists3.get(0);
        }
        PteBalancelistOpDomain pteBalancelistOpDomain = new PteBalancelistOpDomain();
        pteBalancelistOpDomain.setTenantCode(cpRechargeDomain.getTenantCode());
        pteBalancelistOpDomain.setMemberBcode(cpRechargeDomain.getUserinfoCode());
        pteBalancelistOpDomain.setMemberBname(cpRechargeDomain.getUserinfoName());
        pteBalancelistOpDomain.setChannelCode(cpRechargeDomain.getChannelCode());
        pteBalancelistOpDomain.setBusinessOrder(cpRechargeDomain.getRechargeCode());
        pteBalancelistOpDomain.setBusinessType("DCRP_CpRechargeDomain");
        pteBalancelistOpDomain.setPtradeType("dcrpCpRechargeDomainAdd");
        pteBalancelistOpDomain.setBusinessDes1(cpRechargeDomain.getRechargeOpcode());
        pteBalancelistOpDomain.setBalanceAmount1(cpRechargeDomain.getRechargeMoney());
        pteBalancelistOpDomain.setOrderPortion(cpRechargeDomain.getRechargeMoney());
        pteBalancelistOpDomain.setBalanceopCode(pteBalancelist.getBalanceopCode());
        pteBalancelistOpDomain.setBalancelistCode(pteBalancelist.getBalancelistCode());
        pteBalancelistOpDomain.setOpuserCode(cpRechargeDomain.getOrganizationalCode());
        pteBalancelistOpDomain.setOpuserName(cpRechargeDomain.getOrganizationalName());
        pteBalancelistOpDomain.setPartnerCode(cpRechargeDomain.getRechargeOpcode10());
        this.pteBalancelistOpService.savepteBalancelistOp(pteBalancelistOpDomain);
        BigDecimal balanceAmount1 = pteBalancelist.getBalanceAmount1() == null ? BigDecimal.ZERO : pteBalancelist.getBalanceAmount1();
        pteBalancelist.setBalanceAmount1(balanceAmount1.add(cpRechargeDomain.getRechargeMoney()));
        PteBalancelistDomain pteBalancelistDomain = new PteBalancelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalancelistDomain, (Object)pteBalancelist);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalancelistServiceImpl.sendByBalanceRecharge.copyAllPropertys", (Throwable)e);
        }
        this.updateBalancelist(pteBalancelistDomain);
    }

    private void createVdAmoutStatement(Date startOfDay, Date endOfDay, String rechargeCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "728243877368496147");
        if (StringUtils.isNotBlank((String)rechargeCode)) {
            map.put("rechargeCode", rechargeCode);
        } else {
            map.put("gmtCreateQstart", startOfDay);
            map.put("gmtCreateQend", endOfDay);
        }
        List<CpRechargeDomain> cpRechargeDomains = this.queryRechargePage(map);
        if (!CollectionUtils.isEmpty(cpRechargeDomains)) {
            for (CpRechargeDomain cpRechargeDomain : cpRechargeDomains) {
                try {
                    this.sendByBalanceRecharge(cpRechargeDomain);
                }
                catch (Exception e) {
                    this.logger.error("pte.PteBalancelistServiceImpl.createVdAmoutStatement", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomain), (Throwable)e);
                }
            }
        }
    }

    private List<CpRechargeDomain> queryRechargePage(Map<String, Object> map) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult quresult3 = this.getQueryResutl("cp.recharge.queryRechargePage", paramMap, CpRechargeDomain.class);
        if (quresult3 == null || CollectionUtils.isEmpty((Collection)quresult3.getList())) {
            return null;
        }
        return quresult3.getList();
    }

    private void createAsAmoutStatement(Date startOfDay, Date endOfDay, String refundCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "728243877368496147");
        if (StringUtils.isNotBlank((String)refundCode)) {
            map.put("refundCode", refundCode);
        } else {
            map.put("gmtCreateQstart", startOfDay);
            map.put("gmtCreateQend", endOfDay);
        }
        map.put("refundType", "U07");
        List<OcRefundReDomain> ocRefundReDomains = this.queryRefundPage(map);
        if (!CollectionUtils.isEmpty(ocRefundReDomains)) {
            for (OcRefundReDomain ocRefundReDomain : ocRefundReDomains) {
                try {
                    this.sendBalancelistRefund(ocRefundReDomain);
                }
                catch (Exception e) {
                    this.logger.error("pte.PteBalancelistServiceImpl.createAsAmoutStatement", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundReDomain), (Throwable)e);
                }
            }
        }
    }

    public List<OcRefundReDomain> queryRefundPage(Map<String, Object> map) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult quresult3 = this.getQueryResutl("oc.refund.queryRefundPage", paramMap, OcRefundReDomain.class);
        if (quresult3 == null || CollectionUtils.isEmpty((Collection)quresult3.getList())) {
            return null;
        }
        return quresult3.getList();
    }

    private void createSgAmoutStatement(Date startOfDay, Date endOfDay, String sendgoodsCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "728243877368496147");
        if (StringUtils.isNotBlank((String)sendgoodsCode)) {
            map.put("sendgoodsCode", sendgoodsCode);
        } else {
            map.put("sendgoodsGddateQstart", startOfDay);
            map.put("sendgoodsGddateQend", endOfDay);
        }
        List<SgSendgoodsReDomain> sgSendgoodsReDomains = this.querySendgoodsPage(map);
        if (!CollectionUtils.isEmpty(sgSendgoodsReDomains)) {
            for (SgSendgoodsReDomain sgSendgoodsReDomain : sgSendgoodsReDomains) {
                try {
                    this.sendByBalanceSgSendgoods(sgSendgoodsReDomain);
                }
                catch (Exception e) {
                    this.logger.error("pte.PteBalancelistServiceImpl.createSgAmoutStatement", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsReDomain), (Throwable)e);
                }
            }
        }
    }

    public List<SgSendgoodsReDomain> querySendgoodsPage(Map<String, Object> map) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult quresult3 = this.getQueryResutl("sg.sendgoods.querySendgoodsPage", paramMap, SgSendgoodsReDomain.class);
        if (quresult3 == null || CollectionUtils.isEmpty((Collection)quresult3.getList())) {
            return null;
        }
        return quresult3.getList();
    }

    private void updateBalancelistDescriptionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalancelistMapper.updateBalancelistDescription(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelistDescriptionModelByCode.ex" + map, (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteBalancelistServiceImpl.updateBalancelistDescriptionModelByCode.num" + map);
        }
    }

    private void saveBalancelistToByOc(PteBalancelistDomain pteBalancelistDomain) {
        if (null == pteBalancelistDomain || null == pteBalancelistDomain.getTenantCode() || null == pteBalancelistDomain.getBusinessOrderno()) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("dataState", PteConstants.PTE_LIST_DATA_STATE_0);
        param.put("tenantCode", pteBalancelistDomain.getTenantCode());
        param.put("balanceType", null == pteBalancelistDomain.getBalanceType() ? "shsettl" : pteBalancelistDomain.getBalanceType());
        param.put("balanceTime", "-1");
        param.put("businessOrderno", pteBalancelistDomain.getBusinessOrderno());
        List<PteBalancelist> pteBalancelistList = this.queryBalancelistModelPage(param);
        if (ListUtil.isEmpty(pteBalancelistList)) {
            return;
        }
        for (PteBalancelist pteBalancelist : pteBalancelistList) {
            this.updateBalancelistState(pteBalancelist.getBalancelistId(), PteConstants.PTE_LIST_DATA_Already, PteConstants.PTE_LIST_DATA_STATE_0, null);
        }
    }

    public static void main(String[] args) {
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String yearMonth = now.format(formatter);
        System.out.println("Current Year and Month: " + yearMonth);
        SupQueryResult sgSendgoodsReDomainSupQueryResult = new SupQueryResult();
        List sgSendgoodsReDomains = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsReDomainSupQueryResult.getList()), SgSendgoodsReDomain.class);
    }
}

