/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.check.CheckContext;
import com.yqbsoft.laser.service.paytradeengine.domain.CommitContext;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtrade;
import com.yqbsoft.laser.service.paytradeengine.sdomain.BankHtmlForm;
import com.yqbsoft.laser.service.paytradeengine.sdomain.ChannelRestForm;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PtradeBean;
import com.yqbsoft.laser.service.paytradeengine.send.SendPutThread;
import com.yqbsoft.laser.service.paytradeengine.service.PteMnsService;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeBaseService;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeService;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PteChannelsendServiceImpl;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PtePtradeServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class PtePtradeBaseServiceImpl
extends BaseServiceImpl
implements PtePtradeBaseService {
    public static final String SYS_CODE = "pte.PtePtradeBaseServiceImpl";
    PtePtradeService ptePtradeService;
    @Autowired
    private PteMnsService pteMnsService;

    public void setPtePtradeService(PtePtradeService ptePtradeService) {
        this.ptePtradeService = ptePtradeService;
    }

    @Override
    public String sendSavePtrade(PtePtradeDomain ptePtradeDomain) throws ApiException {
        return this.ptePtradeService.sendSavePtrade(ptePtradeDomain);
    }

    @Override
    public BankHtmlForm sendPtradeAuto(PtePtradeDomain ptePtradeDomain) throws ApiException {
        if (null == ptePtradeDomain) {
            return null;
        }
        PtradeBean ptradeBean = ptePtradeDomain.getPtradeBean();
        if (null == ptradeBean) {
            return null;
        }
        PtePtrade ptePtrade = this.ptePtradeService.savePtradeForm(ptePtradeDomain);
        if (null == ptePtrade) {
            return null;
        }
        CommitContext commitContext = new CommitContext();
        commitContext.setPtePtrade(ptePtrade);
        return this.saveCall(ptradeBean, commitContext);
    }

    private BankHtmlForm saveCall(PtradeBean ptradeBean, CommitContext commitContext) {
        ChannelRestForm channelRestForm;
        if (null == ptradeBean || null == commitContext || null == commitContext.getPtePtrade()) {
            return null;
        }
        if (null != commitContext.getChannelRestForm() && null != commitContext.getChannelRestForm().getBankHtmlForm()) {
            return commitContext.getChannelRestForm().getBankHtmlForm();
        }
        String returnStr = DisUtil.getRemot((String)("PTEQUERY_CALL-" + ptradeBean.getTenantCode() + "-" + ptradeBean.getPtradeSeqno() + "-" + PteConstants.DATA_STATE_1));
        if (StringUtils.isNotBlank((String)returnStr) && (channelRestForm = (ChannelRestForm)JsonUtil.buildNormalBinder().getJsonToObject(returnStr, ChannelRestForm.class)) != null) {
            return channelRestForm.getBankHtmlForm();
        }
        PtePtrade ptePtrade = commitContext.getPtePtrade();
        if (commitContext.isNextflag()) {
            PtePtradeServiceImpl.getPtradeInfoService().putQueue(ptePtrade);
        }
        if ("0".equals(ptradeBean.getFchannelMode())) {
            String bankHtmlForm = this.ptePtradeService.getFormCachStr(ptePtrade.getTenantCode(), ptePtrade.getPtradeSeqno());
            ChannelRestForm channelRestForm2 = (ChannelRestForm)JsonUtil.buildNormalBinder().getJsonToObject(bankHtmlForm, ChannelRestForm.class);
            if (channelRestForm2 != null) {
                return channelRestForm2.getBankHtmlForm();
            }
        } else {
            this.logger.error("pte.PtePtradeBaseServiceImplsaveCall.call", (Object)ptradeBean.getFchannelMode());
            return null;
        }
        return null;
    }

    @Override
    public String commitParticipantByPtrade(PtradeBean ptradeBean) throws ApiException {
        CommitContext commitContext = this.ptePtradeService.saveParticipantByPtrade(ptradeBean);
        if (null == commitContext || null == commitContext.getPtePtrade()) {
            return null;
        }
        PtePtrade ptePtrade = commitContext.getPtePtrade();
        if (commitContext.isNextflag()) {
            PtePtradeServiceImpl.getPtradeInfoService().putQueue(ptePtrade);
        }
        return ptePtrade.getPtradeSeqno();
    }

    @Override
    public BankHtmlForm sendParticipantByPtrade(PtradeBean ptradeBean) throws ApiException {
        CommitContext commitContext = this.ptePtradeService.saveParticipantByPtrade(ptradeBean);
        if (null == commitContext || null == commitContext.getPtePtrade()) {
            return null;
        }
        return this.saveCall(ptradeBean, commitContext);
    }

    @Override
    public CheckContext sendCallBack(Map<String, Object> map) throws ApiException {
        PtePtrade ptePtrade;
        this.logger.debug("sendCallBack params1:" + JSONObject.toJSONString(map));
        long l = System.currentTimeMillis();
        CheckContext checkContext = this.ptePtradeService.saveCallBack(map);
        this.logger.info("pte.PtePtradeBaseServiceImpl.sendCallBack ---->", (Object)(System.currentTimeMillis() - l));
        if (null != checkContext.getPtePtrade()) {
            this.pteMnsService.sendMnsOrder(checkContext.getPtePtrade());
            PtePtradeServiceImpl.getPtradeService().putQueue(checkContext.getPtePtrade());
        } else {
            this.logger.error("pte.PtePtradeBaseServiceImplsendCallBack.checkContext", (Object)map.toString());
        }
        if (null == checkContext) {
            return null;
        }
        if (ListUtil.isNotEmpty(checkContext.getPteChannelsendList())) {
            PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), checkContext.getPteChannelsendList()));
        }
        if (null != checkContext.getPtePtrade() && 2 == (ptePtrade = checkContext.getPtePtrade()).getDataState()) {
            PtePtradeServiceImpl.getPtradeInfoService().putQueue(ptePtrade);
        }
        checkContext.setPteChannelsendList(null);
        checkContext.setPtePtrade(null);
        return checkContext;
    }

    @Override
    public String sendCommitGoods(Map<String, Object> map) throws ApiException {
        return null;
    }
}

