/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.enumc.PtradpdeEnum;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtrade;
import com.yqbsoft.laser.service.paytradeengine.service.PteMnsService;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PteMnsServiceImpl
extends BaseServiceImpl
implements PteMnsService {
    public static final String SYS_CODE = "pte.PteMnsServiceImpl";

    @Override
    public void sendMnsOrder(PtePtrade ptePtrade) throws ApiException {
        try {
            if (ptePtrade == null) {
                return;
            }
            Integer dataState = ptePtrade.getDataState();
            if (dataState != PteConstants.DATA_STATE_3) {
                return;
            }
            HashMap<String, Object> contentMap = new HashMap<String, Object>();
            String merchantCode = ptePtrade.getMerchantCode();
            String ptradpdeCode = ptePtrade.getPtradpdeCode();
            String ptradpdeName = null;
            for (PtradpdeEnum ptradpdeEnum : PtradpdeEnum.values()) {
                if (!ptradpdeEnum.getCode().equals(ptradpdeCode)) continue;
                ptradpdeName = ptradpdeEnum.getRemark();
                break;
            }
            contentMap.put("datetime", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
            contentMap.put("ptradeSeqno", ptePtrade.getPtradeSeqno());
            contentMap.put("orderAmount", ptePtrade.getOrderAmount().setScale(2));
            ConcurrentHashMap<String, String> mnsMap = new ConcurrentHashMap<String, String>();
            String mnsconfigBusType = "o3_" + ptePtrade.getPtradeType();
            mnsMap.put("mnslistSubject", ptradpdeName + "\u4ea4\u6613\u6210\u529f\u901a\u77e5");
            mnsMap.put("mnslistSource", "0");
            mnsMap.put("mnslistBusType", mnsconfigBusType);
            mnsMap.put("mnslistBusName", ptradpdeName + "\u4ea4\u6613\u6210\u529f\u901a\u77e5");
            mnsMap.put("mnslistExp", this.getMnslistExp(contentMap, "sys", "sys", merchantCode, merchantCode, "1", "0", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"), mnsconfigBusType));
            mnsMap.put("tenantCode", ptePtrade.getTenantCode());
            ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
            String json = JsonUtil.buildNormalBinder().toJson(mnsMap);
            sendMap.put("mnsMnslistDomainBean", json);
            this.logger.info("pte.PteMnsServiceImpl.sendMnsOrder", (Object)(ptePtrade.getPtradeSeqno() + " sendMns, param is \u3010" + json + "\u3011"));
            this.inAsyncInvoke("mns.mns.saveSendMnslist", sendMap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteMnsServiceImpl.sendMnsOrder.e", (Object)ptePtrade.getPtradeSeqno(), (Throwable)e);
        }
    }

    private String getMnslistExp(Map<String, Object> contentMap, String imsgSuserCode, String imsgSuserName, String acceptCode, String acceptName, String pushObjType, String pushmsgJpushType, String pushSendDate, String businessObject) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.putAll(contentMap);
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> parm = new HashMap<String, String>();
        parm.put("code", acceptCode);
        parm.put("name", acceptName);
        receiverList.add(parm);
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("receiverList", JsonUtil.buildNormalBinder().toJson(receiverList));
        expMap.put("pushmsgType", pushObjType);
        expMap.put("pushmsgJpushType", pushmsgJpushType);
        expMap.put("pushmsgSenddate", pushSendDate);
        expMap.put("imsgSuserCode", imsgSuserCode);
        expMap.put("imsgSuserName", imsgSuserName);
        expMap.put("mnsconfigBusType", businessObject);
        expMap.put("paramMap", JsonUtil.buildNormalBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(expMap);
    }
}

