/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.cache;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.paytradeengine.cache.SyncTradeFuture;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.cache.repository.BeanRepository;
import com.yqbsoft.laser.service.suppercore.cache.repository.CacheBean;
import com.yqbsoft.laser.service.suppercore.cache.repository.InvokeFuture;
import com.yqbsoft.laser.service.tool.util.StringUtils;

public class PteQueryCall {
    private static final String sys_code = "pte.call";
    protected static final OpenLogUtil logger = new OpenLogUtil(PteQueryCall.class);
    public static final String PTEQUERY = "PTEQUERY";
    public static final String PTEQUERYOK = "PTEQUERYOK";
    public static final String PTEQUERY_CALL = "PTEQUERY_CALL";
    public static final String PTEQUERY_OKCALL = "PTEQUERY_OKCALL";
    public static final long DEFAULT_TIME = 30000L;
    private boolean synFlag = false;
    private String correlationId;
    private long timeout = 0L;

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public static void putSync(String correlationId, SyncTradeFuture syncInvokeFuture, long timeout) {
        if (StringUtils.isBlank((String)correlationId) || null == syncInvokeFuture) {
            return;
        }
        CacheBean bean = new CacheBean();
        bean.setValue((Object)correlationId);
        if (timeout == -1L) {
            bean.setExpire(-1L);
        } else {
            bean.setExpire(timeout + 5000L);
        }
        bean.setFuture((InvokeFuture)syncInvokeFuture);
        bean.setCacheKey(PTEQUERY_CALL);
        BeanRepository.newInstance((String)PTEQUERY, (String)"MEM", (Object)1).put(correlationId, (Object)bean);
    }

    public static void putOkSync(String correlationId, SyncTradeFuture syncInvokeFuture, long timeout) {
        if (StringUtils.isBlank((String)correlationId) || null == syncInvokeFuture) {
            return;
        }
        CacheBean bean = new CacheBean();
        bean.setValue((Object)correlationId);
        if (timeout == -1L) {
            bean.setExpire(-1L);
        } else {
            bean.setExpire(timeout + 5000L);
        }
        bean.setFuture((InvokeFuture)syncInvokeFuture);
        bean.setCacheKey(PTEQUERY_OKCALL);
        BeanRepository.newInstance((String)PTEQUERYOK, (String)"MEM", (Object)1).put(correlationId, (Object)bean);
    }

    public static InvokeFuture getOkSync(String correlationId) {
        if (StringUtils.isBlank((String)correlationId)) {
            return null;
        }
        CacheBean bean = (CacheBean)BeanRepository.newInstance((String)PTEQUERYOK, (String)"MEM", (Object)1).remove(correlationId);
        return bean != null ? bean.getFuture() : null;
    }

    public static InvokeFuture getSync(String correlationId) {
        if (StringUtils.isBlank((String)correlationId)) {
            return null;
        }
        CacheBean bean = (CacheBean)BeanRepository.newInstance((String)PTEQUERY, (String)"MEM", (Object)1).remove(correlationId);
        return bean != null ? bean.getFuture() : null;
    }

    public boolean isSynFlag() {
        return this.synFlag;
    }

    public void setSynFlag(boolean synFlag) {
        this.synFlag = synFlag;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public static void call(String correlationId, String obj) {
        if (StringUtils.isBlank((String)correlationId)) {
            logger.error("pte.call.call", (Object)"correlationId is null");
            return;
        }
        SupDisUtil.set((String)("PTEQUERY_CALL-" + correlationId), (String)obj, (int)172800);
        InvokeFuture invokeFuture = PteQueryCall.getSync(correlationId);
        if (null != invokeFuture) {
            invokeFuture.setDone((Object)obj);
        }
    }

    public static void okCall(String correlationId, String obj) {
        if (StringUtils.isBlank((String)correlationId)) {
            logger.error("pte.call.call", (Object)"correlationId is null");
            return;
        }
        SupDisUtil.set((String)("PTEQUERY_OKCALL-" + correlationId), (String)obj, (int)172800);
        InvokeFuture invokeFuture = PteQueryCall.getOkSync(correlationId);
        if (null != invokeFuture) {
            invokeFuture.setDone((Object)obj);
        }
    }
}

