/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.dao.PteCurrencyMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PteCurrencyDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteCurrencyReDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteCurrency;
import com.yqbsoft.laser.service.paytradeengine.service.PteCurrencyService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PteCurrencyServiceImpl
extends BaseServiceImpl
implements PteCurrencyService {
    private static final String SYS_CODE = "pte.PteCurrencyServiceImpl";
    private PteCurrencyMapper pteCurrencyMapper;

    public void setPteCurrencyMapper(PteCurrencyMapper pteCurrencyMapper) {
        this.pteCurrencyMapper = pteCurrencyMapper;
    }

    private Date getSysDate() {
        try {
            return this.pteCurrencyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PteCurrencyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCurrency(PteCurrencyDomain pteCurrencyDomain) {
        if (null == pteCurrencyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pteCurrencyDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCurrencyDefault(PteCurrency pteCurrency) {
        if (null == pteCurrency) {
            return;
        }
        if (null == pteCurrency.getDataState()) {
            pteCurrency.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pteCurrency.getGmtCreate()) {
            pteCurrency.setGmtCreate(date);
        }
        pteCurrency.setGmtModified(date);
        if (StringUtils.isBlank((String)pteCurrency.getCurrencyCode())) {
            pteCurrency.setCurrencyCode(this.getNo(null, "PteCurrency", "pteCurrency", pteCurrency.getTenantCode()));
        }
    }

    private int getCurrencyMaxCode() {
        int code = 0;
        try {
            return this.pteCurrencyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PteCurrencyServiceImpl.getCurrencyMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCurrencyUpdataDefault(PteCurrency pteCurrency) {
        if (null == pteCurrency) {
            return;
        }
        pteCurrency.setGmtModified(this.getSysDate());
    }

    private void saveCurrencyModel(PteCurrency pteCurrency) throws ApiException {
        if (null == pteCurrency) {
            return;
        }
        try {
            this.pteCurrencyMapper.insert(pteCurrency);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteCurrencyServiceImpl.saveCurrencyModel.ex", (Throwable)e);
        }
    }

    private void saveCurrencyBatchModel(List<PteCurrency> pteCurrencyList) throws ApiException {
        if (null == pteCurrencyList || pteCurrencyList.isEmpty()) {
            return;
        }
        try {
            this.pteCurrencyMapper.insertBatch(pteCurrencyList);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteCurrencyServiceImpl.saveCurrencyBatchModel.ex", (Throwable)e);
        }
    }

    private PteCurrency getCurrencyModelById(Integer currencyId) {
        if (null == currencyId) {
            return null;
        }
        try {
            return this.pteCurrencyMapper.selectByPrimaryKey(currencyId);
        }
        catch (Exception e) {
            this.logger.error("pte.PteCurrencyServiceImpl.getCurrencyModelById", (Throwable)e);
            return null;
        }
    }

    private PteCurrency getCurrencyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteCurrencyMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteCurrencyServiceImpl.getCurrencyModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCurrencyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteCurrencyMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteCurrencyServiceImpl.delCurrencyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteCurrencyServiceImpl.delCurrencyModelByCode.num");
        }
    }

    private void deleteCurrencyModel(Integer currencyId) throws ApiException {
        if (null == currencyId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteCurrencyMapper.deleteByPrimaryKey(currencyId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteCurrencyServiceImpl.deleteCurrencyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteCurrencyServiceImpl.deleteCurrencyModel.num");
        }
    }

    private void updateCurrencyModel(PteCurrency pteCurrency) throws ApiException {
        if (null == pteCurrency) {
            return;
        }
        int i = 0;
        try {
            i = this.pteCurrencyMapper.updateByPrimaryKey(pteCurrency);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteCurrencyServiceImpl.updateCurrencyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteCurrencyServiceImpl.updateCurrencyModel.num");
        }
    }

    private void updateStateCurrencyModel(Integer currencyId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == currencyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("currencyId", currencyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteCurrencyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteCurrencyServiceImpl.updateStateCurrencyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteCurrencyServiceImpl.updateStateCurrencyModel.null");
        }
    }

    private void updateStateCurrencyModelByCode(String tenantCode, String currencyCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)currencyCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("currencyCode", currencyCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteCurrencyMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteCurrencyServiceImpl.updateStateCurrencyModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteCurrencyServiceImpl.updateStateCurrencyModelByCode.null");
        }
    }

    private PteCurrency makeCurrency(PteCurrencyDomain pteCurrencyDomain, PteCurrency pteCurrency) {
        if (null == pteCurrencyDomain) {
            return null;
        }
        if (null == pteCurrency) {
            pteCurrency = new PteCurrency();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteCurrency, (Object)pteCurrencyDomain);
            return pteCurrency;
        }
        catch (Exception e) {
            this.logger.error("pte.PteCurrencyServiceImpl.makeCurrency", (Throwable)e);
            return null;
        }
    }

    private PteCurrencyReDomain makePteCurrencyReDomain(PteCurrency pteCurrency) {
        if (null == pteCurrency) {
            return null;
        }
        PteCurrencyReDomain pteCurrencyReDomain = new PteCurrencyReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteCurrencyReDomain, (Object)pteCurrency);
            return pteCurrencyReDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.PteCurrencyServiceImpl.makePteCurrencyReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PteCurrency> queryCurrencyModelPage(Map<String, Object> parammap) {
        try {
            return this.pteCurrencyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteCurrencyServiceImpl.queryCurrencyModel", (Throwable)e);
            return null;
        }
    }

    private int countCurrency(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteCurrencyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteCurrencyServiceImpl.countCurrency", (Throwable)e);
        }
        return i;
    }

    private PteCurrency createPteCurrency(PteCurrencyDomain pteCurrencyDomain) {
        String msg = this.checkCurrency(pteCurrencyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteCurrencyServiceImpl.saveCurrency.checkCurrency", msg);
        }
        PteCurrency pteCurrency = this.makeCurrency(pteCurrencyDomain, null);
        this.setCurrencyDefault(pteCurrency);
        return pteCurrency;
    }

    @Override
    public String saveCurrency(PteCurrencyDomain pteCurrencyDomain) throws ApiException {
        PteCurrency pteCurrency = this.createPteCurrency(pteCurrencyDomain);
        this.saveCurrencyModel(pteCurrency);
        return pteCurrency.getCurrencyCode();
    }

    @Override
    public String saveCurrencyBatch(List<PteCurrencyDomain> pteCurrencyDomainList) throws ApiException {
        if (null == pteCurrencyDomainList || pteCurrencyDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteCurrency> pteCurrencyList = new ArrayList<PteCurrency>();
        String code = "";
        for (PteCurrencyDomain pteCurrencyDomain : pteCurrencyDomainList) {
            PteCurrency pteCurrency = this.createPteCurrency(pteCurrencyDomain);
            code = pteCurrency.getCurrencyCode();
            pteCurrencyList.add(pteCurrency);
        }
        this.saveCurrencyBatchModel(pteCurrencyList);
        return code;
    }

    @Override
    public void updateCurrencyState(Integer currencyId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == currencyId) {
            return;
        }
        this.updateStateCurrencyModel(currencyId, dataState, oldDataState, map);
    }

    @Override
    public void updateCurrencyStateByCode(String tenantCode, String currencyCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)currencyCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCurrencyModelByCode(tenantCode, currencyCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCurrency(PteCurrencyDomain pteCurrencyDomain) throws ApiException {
        String msg = this.checkCurrency(pteCurrencyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteCurrencyServiceImpl.updateCurrency.checkCurrency", msg);
        }
        PteCurrency oldPteCurrency = this.getCurrencyModelById(pteCurrencyDomain.getCurrencyId());
        if (null == oldPteCurrency) {
            throw new ApiException("pte.PteCurrencyServiceImpl.updateCurrency.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteCurrency pteCurrency = this.makeCurrency(pteCurrencyDomain, oldPteCurrency);
        this.setCurrencyUpdataDefault(pteCurrency);
        this.updateCurrencyModel(pteCurrency);
    }

    @Override
    public PteCurrency getCurrency(Integer currencyId) {
        if (null == currencyId) {
            return null;
        }
        return this.getCurrencyModelById(currencyId);
    }

    @Override
    public void deleteCurrency(Integer currencyId) throws ApiException {
        if (null == currencyId) {
            return;
        }
        this.deleteCurrencyModel(currencyId);
    }

    @Override
    public QueryResult<PteCurrency> queryCurrencyPage(Map<String, Object> map) {
        List<PteCurrency> pteCurrencyList = this.queryCurrencyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCurrency(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteCurrencyList);
        return queryResult;
    }

    @Override
    public PteCurrency getCurrencyByCode(String tenantCode, String currencyCode) throws ApiException {
        if (StringUtils.isBlank((String)currencyCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("currencyCode", currencyCode);
        return this.getCurrencyModelByCode(map);
    }

    @Override
    public void deleteCurrencyByCode(String tenantCode, String currencyCode) throws ApiException {
        if (StringUtils.isBlank((String)currencyCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("currencyCode", currencyCode);
        this.delCurrencyModelByCode(map);
    }
}

