/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.core;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopPmgoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopPmgoodslistDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceop;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceopGoods;
import com.yqbsoft.laser.service.paytradeengine.model.PteChannelsend;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopGoodsService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopPmgoodsService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopPmgoodslistService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Component
public class PteBalanceCore {
    private static final Logger log = LoggerFactory.getLogger(PteBalanceCore.class);
    @Autowired
    private PteBalanceopGoodsService pteBalanceopGoodsService;
    @Autowired
    private PteBalanceopPmgoodsService pteBalanceopPmgoodsService;
    @Autowired
    private PteBalanceopService pteBalanceopService;
    @Autowired
    private PteBalanceopPmgoodslistService pteBalanceopPmgoodslistService;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public List<PteChannelsend> refundBalanceSave(Map<String, PteBalanceopGoods> pteBalanceopGoodsMap, List<PteBalanceopGoodsDomain> opGoodsDOList, List<PteBalanceopPmgoodsDomain> opPmGoodsDOList, PteBalanceopDomain opDo, boolean amt) {
        ArrayList<PteBalanceopGoodsDomain> balanceOpGoodsDoList = new ArrayList<PteBalanceopGoodsDomain>();
        for (PteBalanceopGoodsDomain opGoods : opGoodsDOList) {
            PteBalanceopGoodsDomain balanceOpGoodsDo = new PteBalanceopGoodsDomain();
            PteBalanceopGoods balanceOpGoodsDoOld = pteBalanceopGoodsMap.get(opGoods.getContractGoodsCode());
            if (null == balanceOpGoodsDoOld) continue;
            balanceOpGoodsDo.setBalanceopGoodsId(balanceOpGoodsDoOld.getBalanceopGoodsId());
            balanceOpGoodsDoOld.setContractGoodsRefnum(balanceOpGoodsDoOld.getContractGoodsRefnum() == null ? BigDecimal.ZERO : balanceOpGoodsDoOld.getContractGoodsRefnum());
            balanceOpGoodsDo.setContractGoodsRefnum(balanceOpGoodsDoOld.getContractGoodsRefnum().add(opGoods.getGoodsCamount()));
            balanceOpGoodsDoOld.setPlatDviReAmt(balanceOpGoodsDoOld.getPlatDviReAmt() == null ? BigDecimal.ZERO : balanceOpGoodsDoOld.getPlatDviReAmt());
            balanceOpGoodsDo.setPlatDviReAmt(balanceOpGoodsDoOld.getPlatDviReAmt().add(opGoods.getPlatPromotionDviAmt()));
            balanceOpGoodsDoList.add(balanceOpGoodsDo);
        }
        log.debug("\u66f4\u65b0\u7ed3\u7b97\u8868\u4f63\u91d1\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JsonUtil.buildNormalBinder().toJson(balanceOpGoodsDoList));
        if (ListUtil.isNotEmpty(balanceOpGoodsDoList)) {
            this.pteBalanceopGoodsService.updateDivBalanceopGoodsBatch(balanceOpGoodsDoList);
        }
        String code = this.pteBalanceopService.saveBalanceop(opDo);
        this.pteBalanceopGoodsService.saveBalanceopGoodsBatch(opGoodsDOList);
        this.pteBalanceopPmgoodsService.saveBalanceopPmgoodsBatch(opPmGoodsDOList);
        PteBalanceop pteBalanceop = this.pteBalanceopService.getBalanceopByCode(opDo.getTenantCode(), code);
        if (null == pteBalanceop) {
            throw new ApiException("PteBalanceCore.refundBalanceSave.pteBalanceop.null");
        }
        return this.pteBalanceopService.saveBalanceopToBalancelist(pteBalanceop, null);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void pteBalanceSave(PteBalanceopDomain pteBalanceopDomain) {
        ArrayList<PteBalanceopGoodsDomain> pteBalanceOpGoodsDomains = new ArrayList<PteBalanceopGoodsDomain>();
        ArrayList<PteBalanceopPmgoodsDomain> pteBalanceOpPmGoodsDomain = new ArrayList<PteBalanceopPmgoodsDomain>();
        ArrayList<PteBalanceopPmgoodslistDomain> PteBalanceOpPmGoodsListDomain = new ArrayList<PteBalanceopPmgoodslistDomain>();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u7ed3\u7b97\u521d\u59cb\u5316");
        if (null != pteBalanceopDomain.getPteBalanceopGoodsDomainList() && !pteBalanceopDomain.getPteBalanceopGoodsDomainList().isEmpty()) {
            pteBalanceOpGoodsDomains.addAll(pteBalanceopDomain.getPteBalanceopGoodsDomainList());
            for (PteBalanceopGoodsDomain goods : pteBalanceopDomain.getPteBalanceopGoodsDomainList()) {
                if (null == goods.getPteBalanceopPmgoodsDomainList() || goods.getPteBalanceopPmgoodsDomainList().isEmpty()) continue;
                pteBalanceOpPmGoodsDomain.addAll(goods.getPteBalanceopPmgoodsDomainList());
                for (PteBalanceopPmgoodsDomain pmGoods : goods.getPteBalanceopPmgoodsDomainList()) {
                    if (null == pmGoods.getPteBalanceopPmgoodslistDomainList() || pmGoods.getPteBalanceopPmgoodslistDomainList().isEmpty()) continue;
                    PteBalanceOpPmGoodsListDomain.addAll(pmGoods.getPteBalanceopPmgoodslistDomainList());
                }
            }
        }
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5165\u5e93op");
        String balanceopCode = this.pteBalanceopService.saveBalanceop(pteBalanceopDomain);
        pteBalanceopDomain.setBalanceopCode(balanceopCode);
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5165\u5e93goods");
        this.pteBalanceopGoodsService.saveBalanceOpGoodsList(pteBalanceOpGoodsDomains);
        stopWatch.stop();
        stopWatch.start("\u7ed3\u7b97\u5165\u5e93pmgoods");
        if (!pteBalanceOpPmGoodsDomain.isEmpty()) {
            this.pteBalanceopPmgoodsService.saveBalanceopPmgoodsList(pteBalanceOpPmGoodsDomain);
            stopWatch.stop();
            stopWatch.start("\u7ed3\u7b97\u5165\u5e93pmgoodsList");
            this.pteBalanceopPmgoodslistService.saveBalanceopPmgoodslistBatch(PteBalanceOpPmGoodsListDomain);
        }
        stopWatch.stop();
        log.info("\u7ed3\u7b97\u5355\u5165\u5e93\u8017\u65f6\uff1a{}", (Object)stopWatch.prettyPrint());
    }
}

