/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.dao.PteExratelistMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PteExratelistDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteExratelistReDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteExratelist;
import com.yqbsoft.laser.service.paytradeengine.service.PteExratelistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PteExratelistServiceImpl
extends BaseServiceImpl
implements PteExratelistService {
    private static final String SYS_CODE = "pte.PteExratelistServiceImpl";
    private PteExratelistMapper pteExratelistMapper;

    public void setPteExratelistMapper(PteExratelistMapper pteExratelistMapper) {
        this.pteExratelistMapper = pteExratelistMapper;
    }

    private Date getSysDate() {
        try {
            return this.pteExratelistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PteExratelistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkExratelist(PteExratelistDomain pteExratelistDomain) {
        if (null == pteExratelistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pteExratelistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setExratelistDefault(PteExratelist pteExratelist) {
        if (null == pteExratelist) {
            return;
        }
        if (null == pteExratelist.getDataState()) {
            pteExratelist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pteExratelist.getGmtCreate()) {
            pteExratelist.setGmtCreate(date);
        }
        pteExratelist.setGmtModified(date);
        if (StringUtils.isBlank((String)pteExratelist.getExratelistCode())) {
            pteExratelist.setExratelistCode(this.getNo(null, "PteExratelist", "pteExratelist", pteExratelist.getTenantCode()));
        }
    }

    private int getExratelistMaxCode() {
        int code = 0;
        try {
            return this.pteExratelistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PteExratelistServiceImpl.getExratelistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setExratelistUpdataDefault(PteExratelist pteExratelist) {
        if (null == pteExratelist) {
            return;
        }
        pteExratelist.setGmtModified(this.getSysDate());
    }

    private void saveExratelistModel(PteExratelist pteExratelist) throws ApiException {
        if (null == pteExratelist) {
            return;
        }
        try {
            this.pteExratelistMapper.insert(pteExratelist);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteExratelistServiceImpl.saveExratelistModel.ex", (Throwable)e);
        }
    }

    private void saveExratelistBatchModel(List<PteExratelist> pteExratelistList) throws ApiException {
        if (null == pteExratelistList || pteExratelistList.isEmpty()) {
            return;
        }
        try {
            this.pteExratelistMapper.insertBatch(pteExratelistList);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteExratelistServiceImpl.saveExratelistBatchModel.ex", (Throwable)e);
        }
    }

    private PteExratelist getExratelistModelById(Integer exratelistId) {
        if (null == exratelistId) {
            return null;
        }
        try {
            return this.pteExratelistMapper.selectByPrimaryKey(exratelistId);
        }
        catch (Exception e) {
            this.logger.error("pte.PteExratelistServiceImpl.getExratelistModelById", (Throwable)e);
            return null;
        }
    }

    private PteExratelist getExratelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteExratelistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteExratelistServiceImpl.getExratelistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delExratelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteExratelistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteExratelistServiceImpl.delExratelistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteExratelistServiceImpl.delExratelistModelByCode.num");
        }
    }

    private void deleteExratelistModel(Integer exratelistId) throws ApiException {
        if (null == exratelistId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteExratelistMapper.deleteByPrimaryKey(exratelistId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteExratelistServiceImpl.deleteExratelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteExratelistServiceImpl.deleteExratelistModel.num");
        }
    }

    private void updateExratelistModel(PteExratelist pteExratelist) throws ApiException {
        if (null == pteExratelist) {
            return;
        }
        int i = 0;
        try {
            i = this.pteExratelistMapper.updateByPrimaryKey(pteExratelist);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteExratelistServiceImpl.updateExratelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteExratelistServiceImpl.updateExratelistModel.num");
        }
    }

    private void updateStateExratelistModel(Integer exratelistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == exratelistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exratelistId", exratelistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteExratelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteExratelistServiceImpl.updateStateExratelistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteExratelistServiceImpl.updateStateExratelistModel.null");
        }
    }

    private void updateStateExratelistModelByCode(String tenantCode, String exratelistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)exratelistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exratelistCode", exratelistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteExratelistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteExratelistServiceImpl.updateStateExratelistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteExratelistServiceImpl.updateStateExratelistModelByCode.null");
        }
    }

    private PteExratelist makeExratelist(PteExratelistDomain pteExratelistDomain, PteExratelist pteExratelist) {
        if (null == pteExratelistDomain) {
            return null;
        }
        if (null == pteExratelist) {
            pteExratelist = new PteExratelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteExratelist, (Object)pteExratelistDomain);
            return pteExratelist;
        }
        catch (Exception e) {
            this.logger.error("pte.PteExratelistServiceImpl.makeExratelist", (Throwable)e);
            return null;
        }
    }

    private PteExratelistReDomain makePteExratelistReDomain(PteExratelist pteExratelist) {
        if (null == pteExratelist) {
            return null;
        }
        PteExratelistReDomain pteExratelistReDomain = new PteExratelistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteExratelistReDomain, (Object)pteExratelist);
            return pteExratelistReDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.PteExratelistServiceImpl.makePteExratelistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PteExratelist> queryExratelistModelPage(Map<String, Object> parammap) {
        try {
            return this.pteExratelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteExratelistServiceImpl.queryExratelistModel", (Throwable)e);
            return null;
        }
    }

    private int countExratelist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteExratelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteExratelistServiceImpl.countExratelist", (Throwable)e);
        }
        return i;
    }

    private PteExratelist createPteExratelist(PteExratelistDomain pteExratelistDomain) {
        String msg = this.checkExratelist(pteExratelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteExratelistServiceImpl.saveExratelist.checkExratelist", msg);
        }
        PteExratelist pteExratelist = this.makeExratelist(pteExratelistDomain, null);
        this.setExratelistDefault(pteExratelist);
        return pteExratelist;
    }

    @Override
    public String saveExratelist(PteExratelistDomain pteExratelistDomain) throws ApiException {
        PteExratelist pteExratelist = this.createPteExratelist(pteExratelistDomain);
        this.saveExratelistModel(pteExratelist);
        return pteExratelist.getExratelistCode();
    }

    @Override
    public String saveExratelistBatch(List<PteExratelistDomain> pteExratelistDomainList) throws ApiException {
        if (null == pteExratelistDomainList || pteExratelistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteExratelist> pteExratelistList = new ArrayList<PteExratelist>();
        String code = "";
        for (PteExratelistDomain pteExratelistDomain : pteExratelistDomainList) {
            PteExratelist pteExratelist = this.createPteExratelist(pteExratelistDomain);
            code = pteExratelist.getExratelistCode();
            pteExratelistList.add(pteExratelist);
        }
        this.saveExratelistBatchModel(pteExratelistList);
        return code;
    }

    @Override
    public void updateExratelistState(Integer exratelistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == exratelistId) {
            return;
        }
        this.updateStateExratelistModel(exratelistId, dataState, oldDataState, map);
    }

    @Override
    public void updateExratelistStateByCode(String tenantCode, String exratelistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)exratelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateExratelistModelByCode(tenantCode, exratelistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateExratelist(PteExratelistDomain pteExratelistDomain) throws ApiException {
        String msg = this.checkExratelist(pteExratelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteExratelistServiceImpl.updateExratelist.checkExratelist", msg);
        }
        PteExratelist oldPteExratelist = this.getExratelistModelById(pteExratelistDomain.getExratelistId());
        if (null == oldPteExratelist) {
            throw new ApiException("pte.PteExratelistServiceImpl.updateExratelist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteExratelist pteExratelist = this.makeExratelist(pteExratelistDomain, oldPteExratelist);
        this.setExratelistUpdataDefault(pteExratelist);
        this.updateExratelistModel(pteExratelist);
    }

    @Override
    public PteExratelist getExratelist(Integer exratelistId) {
        if (null == exratelistId) {
            return null;
        }
        return this.getExratelistModelById(exratelistId);
    }

    @Override
    public void deleteExratelist(Integer exratelistId) throws ApiException {
        if (null == exratelistId) {
            return;
        }
        this.deleteExratelistModel(exratelistId);
    }

    @Override
    public QueryResult<PteExratelist> queryExratelistPage(Map<String, Object> map) {
        List<PteExratelist> pteExratelistList = this.queryExratelistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countExratelist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteExratelistList);
        return queryResult;
    }

    @Override
    public PteExratelist getExratelistByCode(String tenantCode, String exratelistCode) throws ApiException {
        if (StringUtils.isBlank((String)exratelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exratelistCode", exratelistCode);
        return this.getExratelistModelByCode(map);
    }

    @Override
    public void deleteExratelistByCode(String tenantCode, String exratelistCode) throws ApiException {
        if (StringUtils.isBlank((String)exratelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("exratelistCode", exratelistCode);
        this.delExratelistModelByCode(map);
    }
}

