/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.cache.PteCachekeyUtil;
import com.yqbsoft.laser.service.paytradeengine.dao.PteFeeMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PteFeeDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteFee;
import com.yqbsoft.laser.service.paytradeengine.service.PteFeeService;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PteFeeServiceImpl
extends BaseServiceImpl
implements PteFeeService {
    public static final String SYS_CODE = "pte.PteFeeServiceImpl";
    private PteFeeMapper pteFeeMapper;

    public void setPteFeeMapper(PteFeeMapper pteFeeMapper) {
        this.pteFeeMapper = pteFeeMapper;
    }

    private Date getSysDate() {
        try {
            return this.pteFeeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFee(PteFeeDomain pteFeeDomain) {
        if (null == pteFeeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFeeDefault(PteFee pteFee) {
        if (null == pteFee) {
            return;
        }
        if (null == pteFee.getDataState()) {
            pteFee.setDataState(0);
        }
        if (null == pteFee.getGmtCreate()) {
            pteFee.setGmtCreate(this.getSysDate());
        }
        pteFee.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)pteFee.getFeeCode())) {
            pteFee.setFeeCode(this.createUUIDString());
        }
    }

    private int getFeeMaxCode() {
        int code = 0;
        try {
            return this.pteFeeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeServiceImpl.getFeeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFeeUpdataDefault(PteFee pteFee) {
        if (null == pteFee) {
            return;
        }
        pteFee.setGmtModified(this.getSysDate());
    }

    private void saveFeeModel(PteFee pteFee) throws ApiException {
        if (null == pteFee) {
            return;
        }
        try {
            this.pteFeeMapper.insert(pteFee);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeServiceImpl.saveFeeModel.ex", (Throwable)e);
        }
    }

    private PteFee getFeeModelById(Integer feeId) {
        if (null == feeId) {
            return null;
        }
        try {
            return this.pteFeeMapper.selectByPrimaryKey(feeId);
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeServiceImpl.getFeeModelById", (Throwable)e);
            return null;
        }
    }

    public PteFee getFeeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteFeeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeServiceImpl.getFeeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFeeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteFeeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeServiceImpl.delFeeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteFeeServiceImpl.delFeeModelByCode.num");
        }
    }

    private void deleteFeeModel(Integer feeId) throws ApiException {
        if (null == feeId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteFeeMapper.deleteByPrimaryKey(feeId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeServiceImpl.deleteFeeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteFeeServiceImpl.deleteFeeModel.num");
        }
    }

    private void updateFeeModel(PteFee pteFee) throws ApiException {
        if (null == pteFee) {
            return;
        }
        try {
            this.pteFeeMapper.updateByPrimaryKeySelective(pteFee);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeServiceImpl.updateFeeModel.ex", (Throwable)e);
        }
    }

    private void updateStateFeeModel(Integer feeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == feeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("feeId", feeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.pteFeeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteFeeServiceImpl.updateStateFeeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteFeeServiceImpl.updateStateFeeModel.null");
        }
    }

    private PteFee makeFee(PteFeeDomain pteFeeDomain, PteFee pteFee) {
        if (null == pteFeeDomain) {
            return null;
        }
        if (null == pteFee) {
            pteFee = new PteFee();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteFee, (Object)pteFeeDomain);
            return pteFee;
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeServiceImpl.makeFee", (Throwable)e);
            return null;
        }
    }

    private List<PteFee> queryFeeModelPage(Map<String, Object> parammap) {
        try {
            return this.pteFeeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeServiceImpl.queryFeeModel", (Throwable)e);
            return null;
        }
    }

    private int countFee(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteFeeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteFeeServiceImpl.countFee", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveFee(PteFeeDomain pteFeeDomain) throws ApiException {
        String msg = this.checkFee(pteFeeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteFeeServiceImpl.saveFee.checkFee", msg);
        }
        PteFee pteFee = this.makeFee(pteFeeDomain, null);
        this.setFeeDefault(pteFee);
        this.saveFeeModel(pteFee);
    }

    @Override
    public void updateFeeState(Integer feeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFeeModel(feeId, dataState, oldDataState);
    }

    @Override
    public void updateFee(PteFeeDomain pteFeeDomain) throws ApiException {
        String msg = this.checkFee(pteFeeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteFeeServiceImpl.updateFee.checkFee", msg);
        }
        PteFee oldPteFee = this.getFeeModelById(pteFeeDomain.getFeeId());
        if (null == oldPteFee) {
            throw new ApiException("pte.PteFeeServiceImpl.updateFee.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteFee pteFee = this.makeFee(pteFeeDomain, oldPteFee);
        this.setFeeUpdataDefault(pteFee);
        this.updateFeeModel(pteFee);
    }

    @Override
    public PteFee getFee(Integer feeId) {
        return this.getFeeModelById(feeId);
    }

    @Override
    public void deleteFee(Integer feeId) throws ApiException {
        this.deleteFeeModel(feeId);
    }

    @Override
    public QueryResult<PteFee> queryFeePage(Map<String, Object> map) {
        List<PteFee> pteFeeList = this.queryFeeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFee(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteFeeList);
        return queryResult;
    }

    @Override
    public PteFee getFeeByCode(Map<String, Object> map) {
        return this.getFeeModelByCode(map);
    }

    @Override
    public void delFeeByCode(Map<String, Object> map) throws ApiException {
        this.delFeeModelByCode(map);
    }

    @Override
    public void queryFeeSettingCache() {
        this.info("pte.PteFeeServiceImpl.queryFeeSettingCache", "=====ptefee==start====" + ServletMain.getAppName());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 1);
        DisUtil.delVer((String)PteCachekeyUtil.CACHEKEY_FEE);
        List<PteFee> pteFeeList = this.queryFeeModelPage(map);
        if (null == pteFeeList || pteFeeList.isEmpty()) {
            this.info("pte.PteFeeServiceImpl.queryFeeSettingCache", "=====ptefee==del==end====" + ServletMain.getAppName());
            return;
        }
        HashMap<String, String> cacheMap = new HashMap<String, String>();
        for (PteFee pteFee : pteFeeList) {
            String key = pteFee.getTenantCode() + "-" + pteFee.getPartnerCode() + "-" + pteFee.getMerchantCode();
            cacheMap.put(key, JsonUtil.buildNormalBinder().toJson((Object)pteFee));
        }
        DisUtil.setMap((String)PteCachekeyUtil.CACHEKEY_FEE, cacheMap);
        this.info("pte.PteFeeServiceImpl.queryFeeSettingCache", "=====ptefee==end====" + ServletMain.getAppName());
    }
}

