/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractReDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceop;
import com.yqbsoft.laser.service.paytradeengine.model.PteChannelsend;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceBaseBusService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopService;
import com.yqbsoft.laser.service.paytradeengine.service.biz.PteBalanceBaseServiceBiz;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PteBalanceBaseBusServiceImpl
extends BaseServiceImpl
implements PteBalanceBaseBusService {
    private static final Logger log = LoggerFactory.getLogger(PteBalanceBaseBusServiceImpl.class);
    private static final String SYS_CODE = "pte.PteBalanceBaseBusServiceImpl";
    @Autowired
    private PteBalanceBaseServiceBiz pteBalanceBaseServiceBiz;
    @Autowired
    private PteBalanceopService pteBalanceopService;

    @Override
    public List<PteChannelsend> saveBalanceOk(List<OcContractReDomain> ocContractDomainList, boolean supplier) {
        if (ListUtil.isEmpty(ocContractDomainList)) {
            return null;
        }
        for (OcContractReDomain ocContractDomain : ocContractDomainList) {
            String balanceopCode = this.pteBalanceBaseServiceBiz.sendBalance(ocContractDomain, supplier);
            if (StringUtils.isBlank((String)balanceopCode)) {
                log.error("pte.PteBalanceBaseBusServiceImpl.saveBalanceOk.balanceopCode");
                throw new ApiException("pte.PteBalanceBaseBusServiceImpl.saveBalanceOk.balanceopCode", "");
            }
            PteBalanceop pteBalanceop = this.pteBalanceopService.getBalanceopByCode(ocContractDomain.getTenantCode(), balanceopCode);
            if (null == pteBalanceop) {
                log.error("pte.PteBalanceBaseBusServiceImpl.saveBalanceOk.pteBalanceop");
                throw new ApiException("pte.PteBalanceBaseBusServiceImpl.saveBalanceOk.pteBalanceop", balanceopCode);
            }
            this.pteBalanceopService.updateBalanceopStateByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceopCode(), PteConstants.BalanceopData_State1, pteBalanceop.getDataState(), null);
        }
        return null;
    }

    @Override
    public List<PteChannelsend> saveBalanceBatch(List<OcContractReDomain> ocContractDomainList, boolean amt, boolean supplier) {
        if (ListUtil.isEmpty(ocContractDomainList)) {
            return null;
        }
        ArrayList<PteChannelsend> pteBalancelistAll = new ArrayList<PteChannelsend>();
        for (OcContractReDomain ocContractDomain : ocContractDomainList) {
            String balanceopCode = this.pteBalanceBaseServiceBiz.sendBalance(ocContractDomain, supplier);
            if (StringUtils.isBlank((String)balanceopCode)) {
                log.error("pte.PteBalanceBaseBusServiceImpl.saveBalanceBatch.balanceopCode");
                throw new ApiException("pte.PteBalanceBaseBusServiceImpl.saveBalanceBatch.balanceopCode", "");
            }
            if (!amt) continue;
            PteBalanceop pteBalanceop = this.pteBalanceopService.getBalanceopByCode(ocContractDomain.getTenantCode(), balanceopCode);
            if (null == pteBalanceop) {
                log.error("pte.PteBalanceBaseBusServiceImpl.saveBalanceBatch.pteBalanceop");
                throw new ApiException("pte.PteBalanceBaseBusServiceImpl.saveBalanceBatch.pteBalanceop", balanceopCode);
            }
            List<PteChannelsend> pteBalancelist = this.pteBalanceopService.saveBalanceopToBalancelist(pteBalanceop, null);
            if (!ListUtil.isNotEmpty(pteBalancelist)) continue;
            pteBalancelistAll.addAll(pteBalancelist);
        }
        return pteBalancelistAll;
    }
}

