/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.dao.PteDpriceConfMapper;
import com.yqbsoft.laser.service.paytradeengine.dao.PteDpriceMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PteDpriceConfDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteDpriceConfReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteDpriceDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteDpriceReDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteDprice;
import com.yqbsoft.laser.service.paytradeengine.model.PteDpriceConf;
import com.yqbsoft.laser.service.paytradeengine.service.PteDpriceService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PteDpriceServiceImpl
extends BaseServiceImpl
implements PteDpriceService {
    private static final String SYS_CODE = "pte.PteDpriceServiceImpl";
    private PteDpriceMapper pteDpriceMapper;
    private PteDpriceConfMapper pteDpriceConfMapper;

    public void setPteDpriceMapper(PteDpriceMapper pteDpriceMapper) {
        this.pteDpriceMapper = pteDpriceMapper;
    }

    public void setPteDpriceConfMapper(PteDpriceConfMapper pteDpriceConfMapper) {
        this.pteDpriceConfMapper = pteDpriceConfMapper;
    }

    private String checkDpriceConf(PteDpriceConfDomain pteDpriceConfDomain) {
        if (null == pteDpriceConfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pteDpriceConfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDpriceConfDefault(PteDpriceConf pteDpriceConf) {
        if (null == pteDpriceConf) {
            return;
        }
        if (null == pteDpriceConf.getDataState()) {
            pteDpriceConf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pteDpriceConf.getGmtCreate()) {
            pteDpriceConf.setGmtCreate(date);
        }
        pteDpriceConf.setGmtModified(date);
        if (StringUtils.isBlank((String)pteDpriceConf.getDpriceConfCode())) {
            pteDpriceConf.setDpriceConfCode(this.getNo(null, "PteDpriceConf", "pteDpriceConf", pteDpriceConf.getTenantCode()));
        }
    }

    private int getDpriceConfMaxCode() {
        int code = 0;
        try {
            return this.pteDpriceConfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.getDpriceConfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDpriceConfUpdataDefault(PteDpriceConf pteDpriceConf) {
        if (null == pteDpriceConf) {
            return;
        }
        pteDpriceConf.setGmtModified(this.getSysDate());
    }

    private void saveDpriceConfModel(PteDpriceConf pteDpriceConf) throws ApiException {
        if (null == pteDpriceConf) {
            return;
        }
        try {
            this.pteDpriceConfMapper.insert(pteDpriceConf);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.saveDpriceConfModel.ex", (Throwable)e);
        }
    }

    private void saveDpriceConfBatchModel(List<PteDpriceConf> pteDpriceConfList) throws ApiException {
        if (null == pteDpriceConfList || pteDpriceConfList.isEmpty()) {
            return;
        }
        try {
            this.pteDpriceConfMapper.insertBatch(pteDpriceConfList);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.saveDpriceConfBatchModel.ex", (Throwable)e);
        }
    }

    private PteDpriceConf getDpriceConfModelById(Integer dpriceConfId) {
        this.logger.error("pte.PteDpriceServiceImpl.getDpriceConfModelById.dpriceConfId", (Object)dpriceConfId);
        if (null == dpriceConfId) {
            return null;
        }
        try {
            return this.pteDpriceConfMapper.selectByPrimaryKey(dpriceConfId);
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.getDpriceConfModelById", (Throwable)e);
            return null;
        }
    }

    private PteDpriceConf getDpriceConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteDpriceConfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.getDpriceConfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDpriceConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteDpriceConfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.delDpriceConfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteDpriceServiceImpl.delDpriceConfModelByCode.num");
        }
    }

    private void deleteDpriceConfModel(Integer dpriceConfId) throws ApiException {
        if (null == dpriceConfId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteDpriceConfMapper.deleteByPrimaryKey(dpriceConfId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.deleteDpriceConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteDpriceServiceImpl.deleteDpriceConfModel.num");
        }
    }

    private void updateDpriceConfModel(PteDpriceConf pteDpriceConf) throws ApiException {
        if (null == pteDpriceConf) {
            return;
        }
        int i = 0;
        try {
            i = this.pteDpriceConfMapper.updateByPrimaryKey(pteDpriceConf);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateDpriceConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateDpriceConfModel.num");
        }
    }

    private void updateDpriceConfForDpriceConfValuen(String dpriceConfValue, String dpriceConfValuen, String tenantCode) throws ApiException {
        if (null == dpriceConfValue || null == dpriceConfValuen || null == tenantCode) {
            return;
        }
        int i = 0;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dpriceConfType", "memberCcode");
            map.put("dpriceConfValue", dpriceConfValue);
            map.put("dpriceConfValuen", dpriceConfValuen);
            map.put("tenantCode", tenantCode);
            i = this.pteDpriceConfMapper.updateDpriceConfValuenForDpriceConfValuen(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateDpriceConfForDpriceConfValuen.ex", (Throwable)e);
        }
        if (0 >= i) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateDpriceConfForDpriceConfValuen.num");
        }
    }

    private void updateStateDpriceConfModel(Integer dpriceConfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dpriceConfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceConfId", dpriceConfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteDpriceConfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateStateDpriceConfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateStateDpriceConfModel.null");
        }
    }

    private void updateStateDpriceConfModelByCode(String tenantCode, String dpriceConfCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dpriceConfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfCode", dpriceConfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteDpriceConfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateStateDpriceConfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateStateDpriceConfModelByCode.null");
        }
    }

    private PteDpriceConf makeDpriceConf(PteDpriceConfDomain pteDpriceConfDomain, PteDpriceConf pteDpriceConf) {
        if (null == pteDpriceConfDomain) {
            return null;
        }
        if (null == pteDpriceConf) {
            pteDpriceConf = new PteDpriceConf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteDpriceConf, (Object)pteDpriceConfDomain);
            return pteDpriceConf;
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.makeDpriceConf", (Throwable)e);
            return null;
        }
    }

    private PteDpriceConfReDomain makePteDpriceConfReDomain(PteDpriceConf pteDpriceConf) {
        if (null == pteDpriceConf) {
            return null;
        }
        PteDpriceConfReDomain pteDpriceConfReDomain = new PteDpriceConfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteDpriceConfReDomain, (Object)pteDpriceConf);
            return pteDpriceConfReDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.makePteDpriceConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PteDpriceConf> queryDpriceConfModelPage(Map<String, Object> parammap) {
        try {
            return this.pteDpriceConfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.queryDpriceConfModel", (Throwable)e);
            return null;
        }
    }

    private int countDpriceConf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteDpriceConfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.countDpriceConf", (Throwable)e);
        }
        return i;
    }

    private PteDpriceConf createPteDpriceConf(PteDpriceConfDomain pteDpriceConfDomain) {
        String msg = this.checkDpriceConf(pteDpriceConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteDpriceServiceImpl.saveDpriceConf.checkDpriceConf", msg);
        }
        PteDpriceConf pteDpriceConf = this.makeDpriceConf(pteDpriceConfDomain, null);
        this.setDpriceConfDefault(pteDpriceConf);
        return pteDpriceConf;
    }

    private Date getSysDate() {
        try {
            return this.pteDpriceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDprice(PteDpriceDomain pteDpriceDomain) {
        if (null == pteDpriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pteDpriceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDpriceDefault(PteDprice pteDprice) {
        if (null == pteDprice) {
            return;
        }
        if (null == pteDprice.getDataState()) {
            pteDprice.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pteDprice.getGmtCreate()) {
            pteDprice.setGmtCreate(date);
        }
        pteDprice.setGmtModified(date);
        if (StringUtils.isBlank((String)pteDprice.getDpriceCode())) {
            pteDprice.setDpriceCode(this.getNo(null, "PteDprice", "pteDprice", pteDprice.getTenantCode()));
        }
    }

    private int getDpriceMaxCode() {
        int code = 0;
        try {
            return this.pteDpriceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.getDpriceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDpriceUpdataDefault(PteDprice pteDprice) {
        if (null == pteDprice) {
            return;
        }
        pteDprice.setGmtModified(this.getSysDate());
    }

    private void saveDpriceModel(PteDprice pteDprice) throws ApiException {
        if (null == pteDprice) {
            return;
        }
        try {
            this.pteDpriceMapper.insert(pteDprice);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.saveDpriceModel.ex", (Throwable)e);
        }
    }

    private void saveDpriceBatchModel(List<PteDprice> pteDpriceList) throws ApiException {
        if (null == pteDpriceList || pteDpriceList.isEmpty()) {
            return;
        }
        try {
            this.pteDpriceMapper.insertBatch(pteDpriceList);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.saveDpriceBatchModel.ex", (Throwable)e);
        }
    }

    private PteDprice getDpriceModelById(Integer dpriceId) {
        if (null == dpriceId) {
            return null;
        }
        try {
            return this.pteDpriceMapper.selectByPrimaryKey(dpriceId);
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.getDpriceModelById", (Throwable)e);
            return null;
        }
    }

    private PteDprice getDpriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteDpriceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.getDpriceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDpriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteDpriceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.delDpriceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteDpriceServiceImpl.delDpriceModelByCode.num");
        }
    }

    private void deleteDpriceModel(Integer dpriceId) throws ApiException {
        if (null == dpriceId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteDpriceMapper.deleteByPrimaryKey(dpriceId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.deleteDpriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteDpriceServiceImpl.deleteDpriceModel.num");
        }
    }

    private void updateDpriceModel(PteDprice pteDprice) throws ApiException {
        if (null == pteDprice) {
            return;
        }
        int i = 0;
        try {
            i = this.pteDpriceMapper.updateByPrimaryKey(pteDprice);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateDpriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateDpriceModel.num");
        }
    }

    private void updateStateDpriceModel(Integer dpriceId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dpriceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceId", dpriceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteDpriceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateStateDpriceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateStateDpriceModel.null");
        }
    }

    private void updateStateDpriceModelByCode(String tenantCode, String dpriceCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dpriceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceCode", dpriceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteDpriceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateStateDpriceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateStateDpriceModelByCode.null");
        }
    }

    private PteDprice makeDprice(PteDpriceDomain pteDpriceDomain, PteDprice pteDprice) {
        if (null == pteDpriceDomain) {
            return null;
        }
        if (null == pteDprice) {
            pteDprice = new PteDprice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteDprice, (Object)pteDpriceDomain);
            return pteDprice;
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.makeDprice", (Throwable)e);
            return null;
        }
    }

    private PteDpriceReDomain makePteDpriceReDomain(PteDprice pteDprice) {
        if (null == pteDprice) {
            return null;
        }
        PteDpriceReDomain pteDpriceReDomain = new PteDpriceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteDpriceReDomain, (Object)pteDprice);
            return pteDpriceReDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.makePteDpriceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PteDprice> queryDpriceModelPage(Map<String, Object> parammap) {
        try {
            return this.pteDpriceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.queryDpriceModel", (Throwable)e);
            return null;
        }
    }

    private int countDprice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteDpriceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PteDpriceServiceImpl.countDprice", (Throwable)e);
        }
        return i;
    }

    private PteDprice createPteDprice(PteDpriceDomain pteDpriceDomain) {
        String msg = this.checkDprice(pteDpriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteDpriceServiceImpl.saveDprice.checkDprice", msg);
        }
        PteDprice pteDprice = this.makeDprice(pteDpriceDomain, null);
        this.setDpriceDefault(pteDprice);
        return pteDprice;
    }

    @Override
    public String saveDprice(PteDpriceDomain pteDpriceDomain) throws ApiException {
        PteDprice pteDprice = this.createPteDprice(pteDpriceDomain);
        this.saveDpriceModel(pteDprice);
        return pteDprice.getDpriceCode();
    }

    @Override
    public String saveDpriceBatch(List<PteDpriceDomain> pteDpriceDomainList) throws ApiException {
        if (null == pteDpriceDomainList || pteDpriceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteDprice> pteDpriceList = new ArrayList<PteDprice>();
        String code = "";
        for (PteDpriceDomain pteDpriceDomain : pteDpriceDomainList) {
            PteDprice pteDprice = this.createPteDprice(pteDpriceDomain);
            code = pteDprice.getDpriceCode();
            pteDpriceList.add(pteDprice);
        }
        this.saveDpriceBatchModel(pteDpriceList);
        return code;
    }

    @Override
    public void updateDpriceState(Integer dpriceId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dpriceId) {
            return;
        }
        this.updateStateDpriceModel(dpriceId, dataState, oldDataState, map);
        if (PteConstants.DpriceData_State != dataState) {
            PteDprice disDprice = this.getDprice(dpriceId);
            this.deleteDpriceCache(disDprice);
        } else if (PteConstants.DpriceData_State == dataState) {
            PteDprice disDprice = this.getDprice(dpriceId);
            this.updateDpriceCache(disDprice);
        }
    }

    private void deleteDpriceCache(PteDprice pteDprice) {
        if (null == pteDprice) {
            return;
        }
        DisUtil.del((String)("PteDpriceConf-key-" + pteDprice.getDpriceCode() + "-" + pteDprice.getTenantCode()));
        DisUtil.del((String)("PteDpriceConf-value-" + pteDprice.getDpriceCode() + "-" + pteDprice.getTenantCode()));
        String json = DisUtil.getRemotMap((String)"PteDprice", (String)(pteDprice.getDpriceType() + "-" + pteDprice.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            return;
        }
        List dlist = JSON.parseArray((String)json, PteDpriceDomain.class);
        ArrayList<PteDpriceDomain> dlist2 = new ArrayList<PteDpriceDomain>();
        if (ListUtil.isNotEmpty((Collection)dlist)) {
            for (PteDpriceDomain disDpriceDomain2 : dlist) {
                if (disDpriceDomain2.getDpriceCode().equals(pteDprice.getDpriceCode())) continue;
                dlist2.add(disDpriceDomain2);
            }
        }
        DisUtil.setMapVer((String)"PteDprice", (String)(pteDprice.getDpriceType() + "-" + pteDprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist2)));
    }

    private void deleteDpriceConfCache(PteDpriceConf pteDpriceConf, PteDprice pteDprice) {
        if (null == pteDpriceConf) {
            return;
        }
        if (StringUtils.isNotBlank((String)pteDpriceConf.getDpriceConfTerm())) {
            pteDpriceConf.setDpriceConfTerm("=");
        }
        if (null == pteDprice) {
            pteDprice = this.getDpriceByCode(pteDpriceConf.getTenantCode(), pteDpriceConf.getDpriceCode());
        }
        if (pteDpriceConf.getDpriceConfTerm().equals("=") || pteDpriceConf.getDpriceConfTerm().equals("!=")) {
            DisUtil.delMapVer((String)("PteDpriceConf-value-" + pteDprice.getDpriceCode() + "-" + pteDprice.getTenantCode()), (String[])new String[]{pteDpriceConf.getDpriceConfType() + "-" + pteDpriceConf.getDpriceConfTerm() + "-" + pteDpriceConf.getDpriceConfValue()});
        } else {
            DisUtil.delMapVer((String)("PteDpriceConf-value-" + pteDprice.getDpriceCode() + "-" + pteDprice.getTenantCode()), (String[])new String[]{pteDpriceConf.getDpriceConfType() + "-" + pteDpriceConf.getDpriceConfTerm()});
        }
    }

    private void updateDpriceCache(PteDprice pteDprice) {
        List<PteDpriceDomain> dlist;
        if (null == pteDprice) {
            return;
        }
        PteDpriceDomain pteDpriceDomain = this.makePteDpriceDomain(pteDprice);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dpriceCode", pteDprice.getDpriceCode());
        confparammap.put("tenantCode", pteDprice.getTenantCode());
        confparammap.put("dataState", PteConstants.DpriceData_State);
        List<PteDpriceConf> upcachelist = this.queryDpriceConfModelPage(confparammap);
        if (ListUtil.isNotEmpty(upcachelist)) {
            HashMap<String, String> keymap = new HashMap<String, String>();
            HashMap<String, String> valuemap = new HashMap<String, String>();
            for (PteDpriceConf disDpriceConf : upcachelist) {
                if (StringUtils.isBlank((String)disDpriceConf.getDpriceConfTerm())) {
                    disDpriceConf.setDpriceConfTerm("=");
                }
                keymap.put(disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm(), disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm());
                if (disDpriceConf.getDpriceConfTerm().equals("=") || disDpriceConf.getDpriceConfTerm().equals("!=")) {
                    valuemap.put(disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm() + "-" + disDpriceConf.getDpriceConfValue(), JsonUtil.buildNormalBinder().toJson((Object)disDpriceConf));
                    continue;
                }
                valuemap.put(disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm(), JsonUtil.buildNormalBinder().toJson((Object)disDpriceConf));
            }
            DisUtil.setMapVer((String)("PteDpriceConf-key-" + pteDprice.getDpriceCode() + "-" + pteDprice.getTenantCode()), keymap);
            DisUtil.setMapVer((String)("PteDpriceConf-value-" + pteDprice.getDpriceCode() + "-" + pteDprice.getTenantCode()), valuemap);
        } else {
            DisUtil.del((String)("PteDpriceConf-key-" + pteDprice.getDpriceCode() + "-" + pteDprice.getTenantCode()));
            DisUtil.del((String)("PteDpriceConf-value-" + pteDprice.getDpriceCode() + "-" + pteDprice.getTenantCode()));
        }
        String json = DisUtil.getRemotMap((String)"PteDprice", (String)(pteDprice.getDpriceType() + "-" + pteDprice.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            dlist = new ArrayList();
            dlist.add(pteDpriceDomain);
            DisUtil.setMapVer((String)"PteDprice", (String)(pteDprice.getDpriceType() + "-" + pteDprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        } else {
            dlist = JSON.parseArray((String)json, PteDpriceDomain.class);
            ArrayList<PteDpriceDomain> redlist = new ArrayList<PteDpriceDomain>();
            if (ListUtil.isNotEmpty(dlist)) {
                boolean flag = false;
                for (PteDpriceDomain disDpriceDomain2 : dlist) {
                    if (disDpriceDomain2.getDpriceCode().equals(pteDprice.getDpriceCode())) {
                        flag = true;
                        redlist.add(pteDpriceDomain);
                        continue;
                    }
                    redlist.add(disDpriceDomain2);
                }
                if (!flag) {
                    redlist.add(pteDpriceDomain);
                }
            } else {
                redlist.add(pteDpriceDomain);
            }
            DisUtil.setMapVer((String)"PteDprice", (String)(pteDprice.getDpriceType() + "-" + pteDprice.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(redlist)));
        }
    }

    private void updateDpriceConfCache(PteDpriceConf disDpriceConf) {
        if (null == disDpriceConf) {
            return;
        }
        if (StringUtils.isBlank((String)disDpriceConf.getDpriceConfTerm())) {
            disDpriceConf.setDpriceConfTerm("=");
        }
        if (1 == disDpriceConf.getDataState()) {
            DisUtil.setMapVer((String)("PteDpriceConf-key-" + disDpriceConf.getDpriceCode() + "-" + disDpriceConf.getTenantCode()), (String)(disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm()), (String)(disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm()));
            if (disDpriceConf.getDpriceConfTerm().equals("=") || disDpriceConf.getDpriceConfTerm().equals("!=")) {
                DisUtil.setMapVer((String)("PteDpriceConf-value-" + disDpriceConf.getDpriceCode() + "-" + disDpriceConf.getTenantCode()), (String)(disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm() + "-" + disDpriceConf.getDpriceConfValue()), (String)JsonUtil.buildNormalBinder().toJson((Object)disDpriceConf));
            } else {
                DisUtil.setMapVer((String)("PteDpriceConf-value-" + disDpriceConf.getDpriceCode() + "-" + disDpriceConf.getTenantCode()), (String)(disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm()), (String)JsonUtil.buildNormalBinder().toJson((Object)disDpriceConf));
            }
        } else if (disDpriceConf.getDpriceConfTerm().equals("=") || disDpriceConf.getDpriceConfTerm().equals("!=")) {
            DisUtil.delMapVer((String)("PteDpriceConf-value-" + disDpriceConf.getDpriceCode() + "-" + disDpriceConf.getTenantCode()), (String[])new String[]{disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm() + "-" + disDpriceConf.getDpriceConfValue()});
        } else {
            DisUtil.delMapVer((String)("PteDpriceConf-value-" + disDpriceConf.getDpriceCode() + "-" + disDpriceConf.getTenantCode()), (String[])new String[]{disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm()});
        }
    }

    @Override
    public void updateDpriceStateByCode(String tenantCode, String dpriceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dpriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateDpriceStateByCodeMake(tenantCode, dpriceCode, dataState, oldDataState, map);
    }

    public void updateDpriceStateByCodeMake(String tenantCode, String dpriceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateDpriceModelByCode(tenantCode, dpriceCode, dataState, oldDataState, map);
        if (PteConstants.DpriceData_State != dataState) {
            PteDprice disDprice = this.getDpriceByCode(tenantCode, dpriceCode);
            this.deleteDpriceCache(disDprice);
        } else if (PteConstants.DpriceData_State == dataState) {
            PteDprice disDprice = this.getDpriceByCode(tenantCode, dpriceCode);
            this.updateDpriceCache(disDprice);
        }
    }

    @Override
    public void updateDprice(PteDpriceDomain pteDpriceDomain) throws ApiException {
        String msg = this.checkDprice(pteDpriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateDprice.checkDprice", msg);
        }
        PteDprice oldPteDprice = this.getDpriceModelById(pteDpriceDomain.getDpriceId());
        if (null == oldPteDprice) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateDprice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteDprice pteDprice = this.makeDprice(pteDpriceDomain, oldPteDprice);
        this.setDpriceUpdataDefault(pteDprice);
        this.updateDpriceModel(pteDprice);
        if (PteConstants.DpriceData_State == pteDprice.getDataState()) {
            this.updateDpriceCache(pteDprice);
        }
    }

    @Override
    public PteDprice getDprice(Integer dpriceId) {
        if (null == dpriceId) {
            return null;
        }
        return this.getDpriceModelById(dpriceId);
    }

    @Override
    public void deleteDprice(Integer dpriceId) throws ApiException {
        if (null == dpriceId) {
            return;
        }
        this.deleteDpriceModel(dpriceId);
    }

    @Override
    public QueryResult<PteDprice> queryDpricePage(Map<String, Object> map) {
        List<PteDprice> pteDpriceList = this.queryDpriceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDprice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteDpriceList);
        return queryResult;
    }

    @Override
    public PteDprice getDpriceByCode(String tenantCode, String dpriceCode) throws ApiException {
        if (StringUtils.isBlank((String)dpriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceCode", dpriceCode);
        return this.getDpriceModelByCode(map);
    }

    @Override
    public void deleteDpriceByCode(String tenantCode, String dpriceCode) throws ApiException {
        if (StringUtils.isBlank((String)dpriceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceCode", dpriceCode);
        this.delDpriceModelByCode(map);
    }

    @Override
    public void queryDpriceLoadCache() {
        this.logger.info("pteDpriceService.queryDpriceLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataStateStr", "1");
        List<PteDprice> disDpriceList = this.queryDpriceModelPage(parammap);
        if (null == disDpriceList || disDpriceList.isEmpty()) {
            Map ddMap = DisUtil.getMapAll((String)"PteDprice");
            DisUtil.delVer((String)"PteDprice");
            if (MapUtil.isNotEmpty((Map)ddMap)) {
                for (String key : ddMap.keySet()) {
                    DisUtil.del((String)("PteDpriceConf-key-" + key));
                    DisUtil.del((String)("PteDpriceConf-value-" + key));
                }
            }
            this.logger.info("DisDpriceService.queryDpriceLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<PteDpriceDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<PteDpriceDomain>>();
        for (PteDprice disDprice : disDpriceList) {
            if (StringUtils.isBlank((String)disDprice.getChannelCode())) {
                disDprice.setChannelCode("all");
            }
            PteDpriceDomain disDpriceDomain = this.makePteDpriceDomain(disDprice);
            confparammap.put("dpriceCode", disDprice.getDpriceCode());
            confparammap.put("tenantCode", disDprice.getTenantCode());
            confparammap.put("dataState", PteConstants.DpriceData_State);
            List<PteDpriceConf> upcachelist = this.queryDpriceConfModelPage(confparammap);
            if (ListUtil.isNotEmpty(upcachelist)) {
                HashMap<String, String> keymap = new HashMap<String, String>();
                HashMap<String, String> valuemap = new HashMap<String, String>();
                for (PteDpriceConf disDpriceConf : upcachelist) {
                    if (StringUtils.isBlank((String)disDpriceConf.getDpriceConfTerm())) {
                        disDpriceConf.setDpriceConfTerm("=");
                    }
                    keymap.put(disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm(), disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm());
                    if (disDpriceConf.getDpriceConfTerm().equals("=") || disDpriceConf.getDpriceConfTerm().equals("!=")) {
                        valuemap.put(disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm() + "-" + disDpriceConf.getDpriceConfValue(), JsonUtil.buildNormalBinder().toJson((Object)disDpriceConf));
                        continue;
                    }
                    valuemap.put(disDpriceConf.getDpriceConfType() + "-" + disDpriceConf.getDpriceConfTerm(), JsonUtil.buildNormalBinder().toJson((Object)disDpriceConf));
                }
                DisUtil.setMapVer((String)("PteDpriceConf-key-" + disDprice.getDpriceCode() + "-" + disDprice.getTenantCode()), keymap);
                DisUtil.setMapVer((String)("PteDpriceConf-value-" + disDprice.getDpriceCode() + "-" + disDprice.getTenantCode()), valuemap);
            } else {
                DisUtil.del((String)("PteDpriceConf-key-" + disDprice.getDpriceCode() + "-" + disDprice.getTenantCode()));
                DisUtil.del((String)("PteDpriceConf-value-" + disDprice.getDpriceCode() + "-" + disDprice.getTenantCode()));
            }
            ArrayList<PteDpriceDomain> dlist = (ArrayList<PteDpriceDomain>)ddListMap.get(disDprice.getDpriceType() + "-" + disDprice.getTenantCode());
            if (null == dlist) {
                dlist = new ArrayList<PteDpriceDomain>();
                ddListMap.put(disDprice.getDpriceType() + "-" + disDprice.getTenantCode(), dlist);
            }
            dlist.add(disDpriceDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.disDomainsort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)"PteDprice", ddMap);
        this.logger.info("DisDpriceService.queryDpriceLoadCache", (Object)"===========add-end==========");
    }

    private List<PteDpriceDomain> disDomainsort(List<PteDpriceDomain> dlist) {
        if (ListUtil.isEmpty(dlist)) {
            return null;
        }
        Collections.sort(dlist, new Comparator<PteDpriceDomain>(){

            @Override
            public int compare(PteDpriceDomain arg0, PteDpriceDomain arg1) {
                if (arg0.getDpriceWeight() > arg1.getDpriceWeight()) {
                    return 1;
                }
                if (arg0.getDpriceWeight() < arg1.getDpriceWeight()) {
                    return -1;
                }
                return arg0.getDpriceWeight().compareTo(arg0.getDpriceWeight());
            }
        });
        return dlist;
    }

    private PteDpriceDomain makePteDpriceDomain(PteDprice pteDprice) {
        if (null == pteDprice) {
            return null;
        }
        PteDpriceDomain pteDpriceDomain = new PteDpriceDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteDpriceDomain, (Object)pteDprice);
            return pteDpriceDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String saveDpriceConf(PteDpriceConfDomain pteDpriceConfDomain) throws ApiException {
        PteDpriceConf pteDpriceConf = this.createPteDpriceConf(pteDpriceConfDomain);
        this.saveDpriceConfModel(pteDpriceConf);
        return pteDpriceConf.getDpriceConfCode();
    }

    @Override
    public String saveDpriceConfBatch(List<PteDpriceConfDomain> pteDpriceConfDomainList) throws ApiException {
        if (null == pteDpriceConfDomainList || pteDpriceConfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteDpriceConf> pteDpriceConfList = new ArrayList<PteDpriceConf>();
        String code = "";
        for (PteDpriceConfDomain pteDpriceConfDomain : pteDpriceConfDomainList) {
            PteDpriceConf pteDpriceConf = this.createPteDpriceConf(pteDpriceConfDomain);
            code = pteDpriceConf.getDpriceConfCode();
            pteDpriceConfList.add(pteDpriceConf);
        }
        this.saveDpriceConfBatchModel(pteDpriceConfList);
        return code;
    }

    @Override
    public void updateDpriceConfState(Integer dpriceConfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dpriceConfId) {
            return;
        }
        this.updateStateDpriceConfModel(dpriceConfId, dataState, oldDataState, map);
        PteDpriceConf dpriceConfByCode = this.getDpriceConf(dpriceConfId);
        this.updateDpriceConfCache(dpriceConfByCode);
    }

    @Override
    public void updateDpriceConfStateByCode(String tenantCode, String dpriceConfCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dpriceConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDpriceConfModelByCode(tenantCode, dpriceConfCode, dataState, oldDataState, map);
        PteDpriceConf dpriceConfByCode = this.getDpriceConfByCode(tenantCode, dpriceConfCode);
        PteDprice disDprice = this.getDpriceByCode(tenantCode, dpriceConfByCode.getDpriceCode());
        this.updateDpriceCache(disDprice);
    }

    @Override
    public void updateDpriceConf(PteDpriceConfDomain pteDpriceConfDomain) throws ApiException {
        this.logger.error("pte.PteDpriceServiceImpl.updateDpriceConf.pteDpriceConfDomain", (Object)pteDpriceConfDomain);
        String msg = this.checkDpriceConf(pteDpriceConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateDpriceConf.checkDpriceConf", msg);
        }
        PteDpriceConf oldPteDpriceConf = this.getDpriceConfModelById(pteDpriceConfDomain.getDpriceConfId());
        this.logger.error("pte.PteDpriceServiceImpl.updateDpriceConf.oldPteDpriceConf", (Object)oldPteDpriceConf);
        if (null == oldPteDpriceConf) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateDpriceConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteDpriceConf pteDpriceConf = this.makeDpriceConf(pteDpriceConfDomain, oldPteDpriceConf);
        this.setDpriceConfUpdataDefault(pteDpriceConf);
        this.updateDpriceConfModel(pteDpriceConf);
        this.updateDpriceConfCache(pteDpriceConf);
    }

    @Override
    public PteDpriceConf getDpriceConf(Integer dpriceConfId) {
        if (null == dpriceConfId) {
            return null;
        }
        return this.getDpriceConfModelById(dpriceConfId);
    }

    @Override
    public void deleteDpriceConf(Integer dpriceConfId) throws ApiException {
        if (null == dpriceConfId) {
            return;
        }
        PteDpriceConf dpriceConf = this.getDpriceConf(dpriceConfId);
        this.deleteDpriceConfModel(dpriceConfId);
        this.deleteDpriceConfCache(dpriceConf, null);
    }

    @Override
    public QueryResult<PteDpriceConf> queryDpriceConfPage(Map<String, Object> map) {
        List<PteDpriceConf> pteDpriceConfList = this.queryDpriceConfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDpriceConf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteDpriceConfList);
        return queryResult;
    }

    @Override
    public PteDpriceConf getDpriceConfByCode(String tenantCode, String dpriceConfCode) throws ApiException {
        if (StringUtils.isBlank((String)dpriceConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfCode", dpriceConfCode);
        return this.getDpriceConfModelByCode(map);
    }

    @Override
    public void deleteDpriceConfByCode(String tenantCode, String dpriceConfCode) throws ApiException {
        if (StringUtils.isBlank((String)dpriceConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dpriceConfCode", dpriceConfCode);
        PteDpriceConf dpriceConfByCode = this.getDpriceConfByCode(tenantCode, dpriceConfCode);
        this.delDpriceConfModelByCode(map);
        this.deleteDpriceConfCache(dpriceConfByCode, null);
    }

    @Override
    public void updateDpriceConfByDpriceConfValue(String dpriceConfValue, String dpriceConfValuen, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)dpriceConfValue) || StringUtils.isBlank((String)dpriceConfValuen) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("pte.PteDpriceServiceImpl.updateDpriceConf.checkDpriceConf", "param is null");
        }
        this.updateDpriceConfForDpriceConfValuen(dpriceConfValue, dpriceConfValuen, tenantCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dpriceConfType", "memberCcode");
        map.put("dpriceConfValue", dpriceConfValue);
        map.put("dpriceConfValuen", dpriceConfValuen);
        map.put("tenantCode", tenantCode);
        List<PteDpriceConf> pteDpriceConfList = this.queryDpriceConfModelPage(map);
        if (ListUtil.isNotEmpty(pteDpriceConfList)) {
            for (PteDpriceConf pteDpriceConf : pteDpriceConfList) {
                this.updateDpriceConfCache(pteDpriceConf);
            }
        }
    }
}

