/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalancelistDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteDpriceDomain;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalance;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceop;
import com.yqbsoft.laser.service.paytradeengine.model.PteChannelsend;
import com.yqbsoft.laser.service.paytradeengine.model.PteDpriceConf;
import com.yqbsoft.laser.service.paytradeengine.model.ShShsettlList;
import com.yqbsoft.laser.service.paytradeengine.send.SendBalancePutThread;
import com.yqbsoft.laser.service.paytradeengine.send.SendPutThread;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceBaseService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceamtService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalancelistService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopGoodsService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopService;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PteBalanceopServiceImpl;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PteChannelsendServiceImpl;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PteBalanceBaseServiceImpl
extends BaseServiceImpl
implements PteBalanceBaseService {
    private static final String SYS_CODE = "pte.PteBalanceBaseServiceImpl";
    private PteBalanceService pteBalanceService;
    private PteBalanceamtService pteBalanceamtService;
    private PteBalancelistService pteBalancelistService;
    private PteBalanceopService pteBalanceopService;
    private PteBalanceopGoodsService pteBalanceopGoodsService;

    public void setPteBalanceopGoodsService(PteBalanceopGoodsService pteBalanceopGoodsService) {
        this.pteBalanceopGoodsService = pteBalanceopGoodsService;
    }

    public PteBalanceService getPteBalanceService() {
        return this.pteBalanceService;
    }

    public void setPteBalanceService(PteBalanceService pteBalanceService) {
        this.pteBalanceService = pteBalanceService;
    }

    public PteBalanceamtService getPteBalanceamtService() {
        return this.pteBalanceamtService;
    }

    public void setPteBalanceamtService(PteBalanceamtService pteBalanceamtService) {
        this.pteBalanceamtService = pteBalanceamtService;
    }

    public PteBalancelistService getPteBalancelistService() {
        return this.pteBalancelistService;
    }

    public void setPteBalancelistService(PteBalancelistService pteBalancelistService) {
        this.pteBalancelistService = pteBalancelistService;
    }

    public PteBalanceopService getPteBalanceopService() {
        return this.pteBalanceopService;
    }

    public void setPteBalanceopService(PteBalanceopService pteBalanceopService) {
        this.pteBalanceopService = pteBalanceopService;
    }

    @Override
    public String saveBalanceopToBalanceamt(PteBalanceop pteBalanceop) {
        if (null == pteBalanceop) {
            return "error";
        }
        this.pteBalancelistService.savePteBalancelist(pteBalanceop);
        this.pteBalanceopService.updateBalanceopStateByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceopCode(), PteConstants.BalanceopData_State1, pteBalanceop.getDataState(), null);
        return "success";
    }

    @Override
    public String sendBalancelist(PteBalancelistDomain pteBalancelistDomain) {
        this.pteBalanceopService.updateBalanceopByCode(pteBalancelistDomain.getTenantCode(), pteBalancelistDomain.getBalancelistCode(), 2, 1, null);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", pteBalancelistDomain.getTenantCode());
        map.put("balanceamtCode", pteBalancelistDomain.getBalanceamtCode());
        map.put("dataState", 0);
        int i = this.pteBalancelistService.countBalancelist(map);
        if (i == 0) {
            this.pteBalanceamtService.updateBalanceamtStateByCode(pteBalancelistDomain.getTenantCode(), pteBalancelistDomain.getBalanceamtCode(), 1, 0, null);
        }
        return null;
    }

    @Override
    public String sendBalanceopToBalanceamtRebate(PteBalanceop PteBalanceop2) {
        if (null == PteBalanceop2) {
            return "error";
        }
        List<PteChannelsend> pteBalancelist = this.pteBalanceopService.sendBalanceopToBalancelistRebate(PteBalanceop2);
        if (ListUtil.isNotEmpty(pteBalancelist)) {
            PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteBalancelist));
        }
        return "success";
    }

    @Override
    public String sendSaveBalanceop(PteBalanceopDomain pteBalanceopDomain) {
        if (null == pteBalanceopDomain) {
            return "error";
        }
        if (StringUtils.isBlank((String)pteBalanceopDomain.getMemberCode())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceopDomain));
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", pteBalanceopDomain.getTenantCode());
        map.put("balanceType", pteBalanceopDomain.getBalanceType());
        map.put("dataState", 0);
        QueryResult<PteBalance> pteBalanceQueryResult = this.pteBalanceService.queryBalancePage(map);
        PteBalance pteBalance = null;
        if (null == pteBalanceQueryResult || !ListUtil.isNotEmpty((Collection)pteBalanceQueryResult.getList())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.queryBalancePage.null", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return "error";
        }
        pteBalance = (PteBalance)pteBalanceQueryResult.getList().get(0);
        if (PteConstants.BALANCE_FEE_STATE_OPEN.equals(pteBalance.getBalanceFeestate())) {
            if ("0".equals(pteBalance.getBalanceFeetype()) && null != pteBalance.getBalanceFee()) {
                pteBalanceopDomain.setBalanceopFee(pteBalance.getBalanceFee());
            } else if ("1".equals(pteBalance.getBalanceFeetype()) && null != pteBalance.getBalanceFee() && null != pteBalanceopDomain.getBalanceopAmount()) {
                pteBalanceopDomain.setBalanceopFee(pteBalanceopDomain.getBalanceopAmount().multiply(pteBalance.getBalanceFee()));
            }
        } else {
            pteBalanceopDomain.setBalanceopFee(BigDecimal.ZERO);
        }
        if ("0".equals(pteBalance.getBalanceAmounttype()) && null != pteBalance.getBalanceAmount()) {
            pteBalanceopDomain.setBalanceopAmount(pteBalance.getBalanceAmount());
        } else if ("1".equals(pteBalance.getBalanceAmounttype()) && null != pteBalance.getBalanceAmount() && null != pteBalanceopDomain.getBalanceopAmount()) {
            pteBalanceopDomain.setBalanceopAmount(pteBalanceopDomain.getBalanceopAmount().multiply(pteBalance.getBalanceAmount()));
        }
        pteBalanceopDomain.setBalanceBank(pteBalance.getBalanceBank());
        pteBalanceopDomain.setBalanceType(pteBalance.getBalanceType());
        ArrayList<PteBalanceopDomain> pteBalanceopDomains = new ArrayList<PteBalanceopDomain>();
        pteBalanceopDomains.add(pteBalanceopDomain);
        List<PteBalanceop> list = this.pteBalanceopService.savePteBalanceoplistBatchRe(pteBalanceopDomains);
        return "success";
    }

    public String sendSaveBalanceopFenYong(PteBalanceopDomain pteBalanceopDomain, OcContractReDomain ocContractDomain) {
        if (null == pteBalanceopDomain) {
            return "error";
        }
        if (StringUtils.isBlank((String)pteBalanceopDomain.getMemberCode())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceopDomain));
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", pteBalanceopDomain.getTenantCode());
        map.put("balanceType", pteBalanceopDomain.getBalanceType());
        map.put("dataState", 1);
        QueryResult<PteBalance> pteBalanceQueryResult = this.pteBalanceService.queryBalancePage(map);
        PteBalance pteBalance = null;
        if (null == pteBalanceQueryResult || !ListUtil.isNotEmpty((Collection)pteBalanceQueryResult.getList())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.queryBalancePage.null", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return "error";
        }
        pteBalance = (PteBalance)pteBalanceQueryResult.getList().get(0);
        if (null != pteBalance.getBalanceStart() && new Date().getTime() < pteBalance.getBalanceStart().getTime()) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.pteBalance.getBalanceStart()", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalance));
            return "error";
        }
        if (null != pteBalance.getBalanceEnd() && new Date().getTime() > pteBalance.getBalanceEnd().getTime()) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.pteBalance.getBalanceEnd()", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalance));
            return "error";
        }
        List disDpriceList = DisUtil.getMapListJson((String)"PteDprice", (String)(pteBalanceopDomain.getBalanceType() + "-" + pteBalanceopDomain.getTenantCode()), PteDpriceDomain.class);
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.disDpriceList.null", (Object)(pteBalanceopDomain.getBalanceType() + "-" + pteBalanceopDomain.getTenantCode()));
            return "error";
        }
        BigDecimal balanceopFee = BigDecimal.ZERO;
        ArrayList<PteBalanceopGoodsDomain> pteBalanceopGoodsList = new ArrayList<PteBalanceopGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getPackageList().get(0).getContractGoodsList()) {
            PteBalanceopGoodsDomain pteBalanceopGoods = new PteBalanceopGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pteBalanceopGoods, (Object)ocContractGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("pte.PteBalanceBaseServiceImpl.makeBalanceop", (Throwable)e);
            }
            this.makeDprice(pteBalanceopGoods, disDpriceList);
            pteBalanceopGoodsList.add(pteBalanceopGoods);
            balanceopFee = balanceopFee.add(pteBalanceopGoods.getPricesetRefrice());
        }
        pteBalanceopDomain.setPteBalanceopGoodsDomainList(pteBalanceopGoodsList);
        pteBalanceopDomain.setBalanceopFee(balanceopFee);
        HashMap<String, String> extMap = new HashMap<String, String>();
        extMap.put("pteBalance", JsonUtil.buildNormalBinder().toJson((Object)pteBalance));
        extMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        pteBalanceopDomain.setBalanceopExtension(JsonUtil.buildNonDefaultBinder().toJson(extMap));
        ArrayList<PteBalanceopDomain> pteBalanceopDomains = new ArrayList<PteBalanceopDomain>();
        pteBalanceopDomains.add(pteBalanceopDomain);
        this.pteBalanceopService.savePteBalanceoplistBatchRe(pteBalanceopDomains);
        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSettlDomain, (Object)ocContractDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        ocContractSettlDomain.setContractSettlType("4");
        ocContractSettlDomain.setContractSettlBlance("PTE");
        ocContractSettlDomain.setContractSettlPmoney(balanceopFee);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ocContractSettlDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractSettlDomain));
        this.getInternalRouter().inInvoke("oc.contract.saveContractSettl", "1.0", "0", paramMap);
        return "success";
    }

    public void makeDprice(PteBalanceopGoodsDomain pteBalanceopGoods, List<PteDpriceDomain> pteDpriceList) {
        if (ListUtil.isEmpty(pteDpriceList)) {
            return;
        }
        Map<String, Object> objMap = this.makeObject(pteBalanceopGoods);
        for (PteDpriceDomain pteDpriceDomain : pteDpriceList) {
            Map keymap = DisUtil.getRemotMapAll((String)("PteDpriceConf-key-" + pteDpriceDomain.getDpriceCode() + "-" + pteDpriceDomain.getTenantCode()));
            String vaulemap = "PteDpriceConf-value-" + pteDpriceDomain.getDpriceCode() + "-" + pteDpriceDomain.getTenantCode();
            this.checkConf(keymap, vaulemap, objMap, (Object)pteDpriceDomain);
            HashMap<String, String> dpricemap = new HashMap<String, String>();
            if ("0".equals(pteDpriceDomain.getDpricePro())) {
                pteBalanceopGoods.setPricesetRefrice(pteDpriceDomain.getDpricePrice().divide(new BigDecimal("100"), 2, 4).multiply(pteBalanceopGoods.getContractGoodsPrice().multiply(pteBalanceopGoods.getGoodsCamount())));
            } else if ("2".equals(pteDpriceDomain.getDpricePro())) {
                pteBalanceopGoods.setPricesetRefrice(pteDpriceDomain.getDpricePrice().multiply(pteBalanceopGoods.getGoodsOrdnum()));
            }
            dpricemap.put("pteDpriceDomain", JsonUtil.buildNormalBinder().toJson((Object)pteDpriceDomain));
            dpricemap.put("goodsRemark", pteBalanceopGoods.getGoodsRemark());
            pteBalanceopGoods.setGoodsRemark(JsonUtil.buildNonDefaultBinder().toJson(dpricemap));
        }
    }

    protected boolean checkConf(Map<String, String> keymap, String valuemap, Object obj, Object mainObj) {
        boolean flag = false;
        String key = keymap.get("skuNo=");
        if (StringUtils.isNotBlank((String)key)) {
            flag = this.checkConf(key, valuemap, obj, mainObj);
        }
        if (StringUtils.isNotBlank((String)(key = keymap.get("classtreeCode="))) && !flag) {
            flag = this.checkConf(key, valuemap, obj, mainObj);
        }
        if (StringUtils.isNotBlank((String)(key = keymap.get("memberCcode="))) && !flag) {
            flag = this.checkConf(key, valuemap, obj, mainObj);
        }
        return flag;
    }

    protected boolean checkConf(String keys, String valuemap, Object obj, Object mainObj) {
        Object objValue;
        if (StringUtils.isBlank((String)keys) || StringUtils.isBlank((String)valuemap)) {
            this.logger.info("pte.PteBalanceBaseServiceImplcheckConf", (Object)("keys=" + keys + "valuemap=" + valuemap));
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        String[] keyStr = keys.split("\\-");
        if (null == keyStr || keyStr.length == 0) {
            return false;
        }
        key = keyStr[0];
        if (keyStr.length > 1) {
            term = keyStr[1];
        }
        if ((objValue = BeanUtils.newForceGetProperty((Object)obj, (String)key)) instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
            String[] otrs = objValue.toString().split("\\,");
            flag = false;
            for (String o : otrs) {
                if (!this.cond(keys, valuemap, term, o, mainObj)) continue;
                flag = true;
                break;
            }
        } else if (!this.cond(keys, valuemap, term, objValue, mainObj)) {
            flag = false;
        }
        return flag;
    }

    protected boolean cond(String keys, String valuemap, String term, Object objValue, Object mainObj) {
        if (StringUtils.isBlank((String)valuemap)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        if (term.equals("=") || term.equals("!=")) {
            keys = keys + "-" + objValue;
        }
        String value = DisUtil.getRemotMap((String)valuemap, (String)keys);
        PteDpriceConf confObj = null;
        if (mainObj instanceof PteDpriceDomain) {
            PteDpriceConf disDpriceConf = null;
            if (StringUtils.isNotBlank((String)value)) {
                disDpriceConf = (PteDpriceConf)JsonUtil.buildNormalBinder().getJsonToObject(value, PteDpriceConf.class);
                value = disDpriceConf.getDpriceConfValue();
                confObj = disDpriceConf;
            }
        }
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue && StringUtils.isNotBlank((String)value)) {
                flag = false;
            }
        } else if (null == objValue && StringUtils.isBlank((String)value)) {
            flag = false;
        }
        if (null != mainObj && flag && null != confObj) {
            PteBalanceBaseServiceImpl.setReturn(mainObj, confObj);
        }
        return flag;
    }

    protected static void setReturn(Object mainObj, Object obj) {
        if (null == mainObj || null == obj) {
            return;
        }
        if (mainObj instanceof PteDpriceDomain && obj instanceof PteDpriceConf) {
            PteDpriceDomain pteDpriceDomain = (PteDpriceDomain)mainObj;
            PteDpriceConf pteDpriceConf = (PteDpriceConf)obj;
            pteDpriceDomain.setPteDpriceConf(pteDpriceConf);
            pteDpriceDomain.setDpricePro(pteDpriceConf.getDpriceConfPro());
            if (null != pteDpriceConf.getDpriceConfPrice() && pteDpriceConf.getDpriceConfPrice().compareTo(BigDecimal.ZERO) > 0) {
                pteDpriceDomain.setDpricePrice(pteDpriceConf.getDpriceConfPrice());
            }
            if (null != pteDpriceConf.getDpriceConfMprice() && pteDpriceConf.getDpriceConfMprice().compareTo(BigDecimal.ZERO) > 0) {
                pteDpriceDomain.setDpriceMprice(pteDpriceConf.getDpriceConfMprice());
            }
            if (null != pteDpriceConf.getDpriceConfPricedef() && pteDpriceConf.getDpriceConfPricedef().compareTo(BigDecimal.ZERO) > 0) {
                pteDpriceDomain.setDpricePricedef(pteDpriceConf.getDpriceConfPricedef());
            }
            if (null != pteDpriceConf.getDpriceConfMpricedef() && pteDpriceConf.getDpriceConfMpricedef().compareTo(BigDecimal.ZERO) > 0) {
                pteDpriceDomain.setDpriceMpricedef(pteDpriceConf.getDpriceConfMpricedef());
            }
        }
    }

    protected Map<String, Object> makeObject(PteBalanceopGoodsDomain pteBalanceopGoods) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (null != pteBalanceopGoods) {
            obj.putAll(JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)pteBalanceopGoods), String.class, Object.class));
        }
        return obj;
    }

    @Override
    public String sendSaveBalanceopRebate(PteBalanceopDomain pteBalanceopDomain) {
        if (null == pteBalanceopDomain) {
            return "error";
        }
        ArrayList<PteBalanceopDomain> pteBalanceopDomains = new ArrayList<PteBalanceopDomain>();
        pteBalanceopDomains.add(pteBalanceopDomain);
        List<PteBalanceop> list = this.pteBalanceopService.savePteBalanceoplistBatchRe(pteBalanceopDomains);
        if (ListUtil.isNotEmpty(list)) {
            PteBalanceopServiceImpl.getSendService().addPutPool(new SendBalancePutThread(PteBalanceopServiceImpl.getSendService(), list));
        } else {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop.list", (Object)JsonUtil.buildNormalBinder().toJson(pteBalanceopDomains));
        }
        return "success";
    }

    @Override
    public String sendShsettlListToBalanceop(ShShsettlList shShsettlList) {
        this.logger.error("pte.PteBalanceBaseServiceImpl.sendShsettlListToBalanceop.shShsettlList", (Object)JsonUtil.buildNormalBinder().toJson((Object)shShsettlList));
        if (null == shShsettlList) {
            return "error";
        }
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        pteBalanceopDomain.setBalanceopAmount(shShsettlList.getShsettlListAmt());
        pteBalanceopDomain.setOrderOamount(shShsettlList.getShsettlOplistOpamt());
        pteBalanceopDomain.setBalanceType("shsettl");
        pteBalanceopDomain.setMemberCode(shShsettlList.getMemberBcode());
        pteBalanceopDomain.setMemberName(shShsettlList.getMemberBname());
        pteBalanceopDomain.setMemberBcode(shShsettlList.getMemberCcode());
        pteBalanceopDomain.setMemberBname(shShsettlList.getMemberCname());
        pteBalanceopDomain.setTenantCode(shShsettlList.getTenantCode());
        pteBalanceopDomain.setBusinessOrderno(shShsettlList.getShsettlOplistOp());
        this.sendSaveBalanceop(pteBalanceopDomain);
        return "success";
    }

    @Override
    public String sendBalance(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "error";
        }
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        pteBalanceopDomain.setMemberCcode(ocContractDomain.getMemberCcode());
        pteBalanceopDomain.setMemberCname(ocContractDomain.getMemberCname());
        pteBalanceopDomain.setBalanceopAmount(ocContractDomain.getContractOrefnum());
        pteBalanceopDomain.setOrderOamount(ocContractDomain.getDataBmoney());
        pteBalanceopDomain.setOrderPortion(ocContractDomain.getContractOrefnum());
        pteBalanceopDomain.setBalanceopExtension(JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractDomain));
        String moom = PteBalanceBaseServiceImpl.getMoom();
        pteBalanceopDomain.setBalanceType(moom);
        pteBalanceopDomain.setBalanceamtCode(moom);
        pteBalanceopDomain.setBalancelistCode(moom + ocContractDomain.getMemberCcode());
        pteBalanceopDomain.setMemberCode(ocContractDomain.getMemberBcode());
        pteBalanceopDomain.setMemberName(ocContractDomain.getMemberBname());
        pteBalanceopDomain.setMemberBcode(ocContractDomain.getMemberBcode());
        pteBalanceopDomain.setMemberBname(ocContractDomain.getMemberBname());
        pteBalanceopDomain.setTenantCode(ocContractDomain.getTenantCode());
        pteBalanceopDomain.setBusinessOrderno(ocContractDomain.getContractBillcode());
        pteBalanceopDomain.setBusinessOrder(ocContractDomain.getContractBbillcode());
        pteBalanceopDomain.setGmtPaySubmit(ocContractDomain.getGmtCreate());
        pteBalanceopDomain.setGmtPaid(ocContractDomain.getGmtModified());
        pteBalanceopDomain.setBusinessDes1("5");
        pteBalanceopDomain.setBusinessDes(ocContractDomain.getContractType());
        return this.sendSaveBalanceopRebate(pteBalanceopDomain);
    }

    @Override
    public void queryBalanceJob() throws ApiException {
    }

    @Override
    public void balanceJob(String tenantCode) throws ApiException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        QueryResult<PteBalance> pteBalanceQueryResult = this.pteBalanceService.queryBalancePage(param);
        if (null == pteBalanceQueryResult || ListUtil.isEmpty((Collection)pteBalanceQueryResult.getList())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.balanceJob.pteBalanceQueryResult is null");
            return;
        }
        PteBalance pteBalance = (PteBalance)pteBalanceQueryResult.getList().get(0);
        int moon = 0;
        if (StringUtils.isNotBlank((String)pteBalance.getBalanceTime())) {
            moon = Integer.valueOf(pteBalance.getBalanceTime());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -(++moon));
        calendar.set(5, 1);
        Date startOfLastMonth = calendar.getTime();
        calendar.set(5, calendar.getActualMaximum(5));
        Date endOfLastMonth = calendar.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gmtPaidQstart", dateFormat.format(startOfLastMonth) + " 00:00:00");
        map.put("gmtPaidQend", dateFormat.format(endOfLastMonth) + " 23:59:59");
        map.put("dataState", PteConstants.BalanceopData_State0);
        map.put("tenantCode", tenantCode);
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.balanceJob.queryResult is null");
            return;
        }
        if (ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            PteBalanceopServiceImpl.getSendService().addPutPool(new SendBalancePutThread(PteBalanceopServiceImpl.getSendService(), queryResult.getList()));
        }
    }

    private static String getMoom() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
        return dateFormat.format(new Date());
    }

    private static Date getDate(int day) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, day);
        return c.getTime();
    }
}

