/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.dao.PteBalanceamtMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceamtDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceamtReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalancelistDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.UmUser;
import com.yqbsoft.laser.service.paytradeengine.domain.UmUserinfo;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalance;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceamt;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceop;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceamtService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PteBalanceamtServiceImpl
extends BaseServiceImpl
implements PteBalanceamtService {
    private static final String SYS_CODE = "pte.pteBalanceamtServiceImpl";
    private PteBalanceamtMapper pteBalanceamtMapper;
    private PteBalanceService pteBalanceService;

    public void setPteBalanceamtMapper(PteBalanceamtMapper pteBalanceamtMapper) {
        this.pteBalanceamtMapper = pteBalanceamtMapper;
    }

    public PteBalanceService getPteBalanceService() {
        return this.pteBalanceService;
    }

    public void setPteBalanceService(PteBalanceService pteBalanceService) {
        this.pteBalanceService = pteBalanceService;
    }

    private Date getSysDate() {
        try {
            return this.pteBalanceamtMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.pteBalanceamtServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBalanceamt(PteBalanceamtDomain pteBalanceamtDomain) {
        if (null == pteBalanceamtDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pteBalanceamtDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setBalanceamtDefault(PteBalanceamt pteBalanceamt) {
        if (null == pteBalanceamt) {
            return;
        }
        if (null == pteBalanceamt.getDataState()) {
            pteBalanceamt.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pteBalanceamt.getGmtCreate()) {
            pteBalanceamt.setGmtCreate(date);
        }
        if (StringUtils.isBlank((String)pteBalanceamt.getBalanceamtCode())) {
            pteBalanceamt.setBalanceamtCode(this.createUUIDString());
        }
    }

    private int getBalanceamtMaxCode() {
        int code = 0;
        try {
            return this.pteBalanceamtMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.pteBalanceamtServiceImpl.getBalanceamtMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBalanceamtUpdataDefault(PteBalanceamt pteBalanceamt) {
        if (null == pteBalanceamt) {
            return;
        }
        pteBalanceamt.setGmtModified(this.getSysDate());
    }

    private void saveBalanceamtModel(PteBalanceamt pteBalanceamt) throws ApiException {
        if (null == pteBalanceamt) {
            return;
        }
        try {
            this.pteBalanceamtMapper.insert(pteBalanceamt);
        }
        catch (Exception e) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.saveBalanceamtModel.ex", (Throwable)e);
        }
    }

    private void saveBalanceamtBatchModel(List<PteBalanceamt> pteBalanceamtList) throws ApiException {
        if (null == pteBalanceamtList || pteBalanceamtList.isEmpty()) {
            return;
        }
        try {
            this.pteBalanceamtMapper.insertBatch(pteBalanceamtList);
        }
        catch (Exception e) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.saveBalanceamtBatchModel.ex", (Throwable)e);
        }
    }

    private PteBalanceamt getBalanceamtModelById(Integer balanceamtId) {
        if (null == balanceamtId) {
            return null;
        }
        try {
            return this.pteBalanceamtMapper.selectByPrimaryKey(balanceamtId);
        }
        catch (Exception e) {
            this.logger.error("pte.pteBalanceamtServiceImpl.getBalanceamtModelById", (Throwable)e);
            return null;
        }
    }

    private PteBalanceamt getBalanceamtModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pteBalanceamtMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.pteBalanceamtServiceImpl.getBalanceamtModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBalanceamtModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalanceamtMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.delBalanceamtModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.delBalanceamtModelByCode.num");
        }
    }

    private void deleteBalanceamtModel(Integer balanceamtId) throws ApiException {
        if (null == balanceamtId) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalanceamtMapper.deleteByPrimaryKey(balanceamtId);
        }
        catch (Exception e) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.deleteBalanceamtModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.deleteBalanceamtModel.num");
        }
    }

    private void updateBalanceamtModel(PteBalanceamt pteBalanceamt) throws ApiException {
        if (null == pteBalanceamt) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalanceamtMapper.updateByPrimaryKey(pteBalanceamt);
        }
        catch (Exception e) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.updateBalanceamtModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.updateBalanceamtModel.num");
        }
    }

    private void balanceAllamountRebateReduce(PteBalanceamt pteBalanceamt) throws ApiException {
        if (null == pteBalanceamt) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalanceamtMapper.balanceAllamountRebateReduce(pteBalanceamt);
        }
        catch (Exception e) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.balanceAllamountRebateReduce.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.balanceAllamountRebateReduce.num");
        }
    }

    private void balanceAllamountRebateIncrease(PteBalanceamt pteBalanceamt) throws ApiException {
        if (null == pteBalanceamt) {
            return;
        }
        int i = 0;
        try {
            i = this.pteBalanceamtMapper.balanceAllamountRebateIncrease(pteBalanceamt);
        }
        catch (Exception e) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.balanceAllamountRebateIncrease.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.balanceAllamountRebateIncrease.num");
        }
    }

    private void updateStateBalanceamtModel(Integer balanceamtId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == balanceamtId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceamtId", balanceamtId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalanceamtMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.updateStateBalanceamtModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.updateStateBalanceamtModel.null");
        }
    }

    private void updateBalanceAmountModel(String tenantCode, String balanceamtCode, BigDecimal balanceAmount, BigDecimal fee) throws ApiException {
        if (null == tenantCode || null == balanceamtCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceamtCode", balanceamtCode);
        map.put("tenantCode", tenantCode);
        map.put("balanceAmount", balanceAmount);
        map.put("balanceFee", fee);
        int i = 0;
        try {
            i = this.pteBalanceamtMapper.updateBalanceAmountModel(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.updateStateBalanceamtModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.updateStateBalanceamtModel.null");
        }
    }

    private void updateStateBalanceamtModelByCode(String tenantCode, String balanceamtCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)balanceamtCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balanceamtCode", balanceamtCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pteBalanceamtMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.updateStateBalanceamtModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.updateStateBalanceamtModelByCode.null");
        }
    }

    private PteBalanceamt makeBalanceamt(PteBalanceamtDomain pteBalanceamtDomain, PteBalanceamt pteBalanceamt) {
        if (null == pteBalanceamtDomain) {
            return null;
        }
        if (null == pteBalanceamt) {
            pteBalanceamt = new PteBalanceamt();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pteBalanceamt, (Object)pteBalanceamtDomain);
            return pteBalanceamt;
        }
        catch (Exception e) {
            this.logger.error("pte.pteBalanceamtServiceImpl.makeBalanceamt", (Throwable)e);
            return null;
        }
    }

    private PteBalanceamtReDomain makePteBalanceamtReDomain(PteBalanceamt pteBalanceamt) {
        if (null == pteBalanceamt) {
            return null;
        }
        PteBalanceamtReDomain pteBalanceamtReDomain = new PteBalanceamtReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalanceamtReDomain, (Object)pteBalanceamt);
            return pteBalanceamtReDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.pteBalanceamtServiceImpl.makePteBalanceamtReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PteBalanceamt> queryBalanceamtModelPage(Map<String, Object> parammap) {
        try {
            return this.pteBalanceamtMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.pteBalanceamtServiceImpl.queryBalanceamtModel", (Throwable)e);
            return null;
        }
    }

    private int countBalanceamt(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pteBalanceamtMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.pteBalanceamtServiceImpl.countBalanceamt", (Throwable)e);
        }
        return i;
    }

    private PteBalanceamt createPteBalanceamt(PteBalanceamtDomain pteBalanceamtDomain) {
        String msg = this.checkBalanceamt(pteBalanceamtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.saveBalanceamt.checkBalanceamt", msg);
        }
        PteBalanceamt pteBalanceamt = this.makeBalanceamt(pteBalanceamtDomain, null);
        this.setBalanceamtDefault(pteBalanceamt);
        return pteBalanceamt;
    }

    @Override
    public String saveBalanceamt(PteBalanceamtDomain pteBalanceamtDomain) throws ApiException {
        PteBalanceamt pteBalanceamt = this.createPteBalanceamt(pteBalanceamtDomain);
        this.saveBalanceamtModel(pteBalanceamt);
        return pteBalanceamt.getBalanceamtCode();
    }

    @Override
    public String saveBalanceamtBatch(List<PteBalanceamtDomain> pteBalanceamtDomainList) throws ApiException {
        if (null == pteBalanceamtDomainList || pteBalanceamtDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PteBalanceamt> pteBalanceamtList = new ArrayList<PteBalanceamt>();
        String code = "";
        for (PteBalanceamtDomain pteBalanceamtDomain : pteBalanceamtDomainList) {
            PteBalanceamt pteBalanceamt = this.createPteBalanceamt(pteBalanceamtDomain);
            code = pteBalanceamt.getBalanceamtCode();
            pteBalanceamtList.add(pteBalanceamt);
        }
        this.saveBalanceamtBatchModel(pteBalanceamtList);
        return code;
    }

    @Override
    public PteBalancelistDomain saveBalanceamtByBalancelist(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", pteBalancelistDomain.getMemberCode());
        map.put("tenantCode", pteBalancelistDomain.getTenantCode());
        PteBalanceamt pteBalanceamt = null;
        PteBalanceamtDomain pteBalanceamtDomain = null;
        QueryResult<PteBalanceamt> pteBalanceamtQueryResult = this.queryBalanceamtPage(map);
        if (null == pteBalanceamtQueryResult || ListUtil.isEmpty((Collection)pteBalanceamtQueryResult.getList())) {
            pteBalanceamtDomain = this.makeBalanceamt(pteBalancelistDomain, pteBalanceamtDomain);
        } else {
            pteBalanceamt = this.makepteBalancelistDomain((PteBalanceamt)pteBalanceamtQueryResult.getList().get(0), pteBalancelistDomain);
        }
        this.logger.error("pte.pteBalanceamtServiceImplsaveBalanceamtByBalancelist.pteBalanceamtDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceamtDomain));
        this.logger.error("pte.pteBalanceamtServiceImplsaveBalanceamtByBalancelist.pteBalanceamt", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceamt));
        if (null != pteBalanceamtDomain) {
            this.saveBalanceamt(pteBalanceamtDomain);
        } else {
            this.updateBalanceamtModel(pteBalanceamt);
        }
        return pteBalancelistDomain;
    }

    @Override
    public PteBalancelistDomain saveBalanceamtByBalancelistRebate(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", pteBalancelistDomain.getMemberCode());
        map.put("tenantCode", pteBalancelistDomain.getTenantCode());
        PteBalanceamt pteBalanceamt = null;
        PteBalanceamtDomain pteBalanceamtDomain = null;
        QueryResult<PteBalanceamt> pteBalanceamtQueryResult = this.queryBalanceamtPage(map);
        if (null == pteBalanceamtQueryResult || ListUtil.isEmpty((Collection)pteBalanceamtQueryResult.getList())) {
            pteBalanceamtDomain = this.makeBalanceamt(pteBalancelistDomain, pteBalanceamtDomain);
        } else {
            pteBalanceamt = (PteBalanceamt)pteBalanceamtQueryResult.getList().get(0);
            pteBalanceamt.setBalanceAllamount(pteBalancelistDomain.getBalanceopAmount());
        }
        if (null != pteBalanceamtDomain) {
            this.saveBalanceamt(pteBalanceamtDomain);
            pteBalancelistDomain.setBalanceAmount(pteBalanceamtDomain.getBalanceAllamount());
        } else if ("05".equals(pteBalancelistDomain.getPtradeType())) {
            this.balanceAllamountRebateReduce(pteBalanceamt);
            if (null != pteBalanceamt) {
                PteBalanceamt balanceamt = this.getBalanceamt(pteBalanceamt.getBalanceamtId());
                pteBalancelistDomain.setBalanceAmount(balanceamt.getBalanceAllamount());
            }
        } else if ("06".equals(pteBalancelistDomain.getPtradeType())) {
            this.balanceAllamountRebateIncrease(pteBalanceamt);
            if (null != pteBalanceamt) {
                PteBalanceamt balanceamt = this.getBalanceamt(pteBalanceamt.getBalanceamtId());
                pteBalancelistDomain.setBalanceAmount(balanceamt.getBalanceAllamount());
            }
        } else {
            this.logger.error("pte.pteBalanceamtServiceImplsaveBalanceamtByBalancelistRebate.pteBalanceamt", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalancelistDomain));
        }
        return pteBalancelistDomain;
    }

    @Override
    public PteBalancelistDomain updateBalanceamtToAll(PteBalancelistDomain pteBalancelistDomain) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", pteBalancelistDomain.getMemberCode());
        map.put("tenantCode", pteBalancelistDomain.getTenantCode());
        PteBalanceamt pteBalanceamt = null;
        QueryResult<PteBalanceamt> pteBalanceamtQueryResult = this.queryBalanceamtPage(map);
        if (null == pteBalanceamtQueryResult || ListUtil.isEmpty((Collection)pteBalanceamtQueryResult.getList())) {
            return null;
        }
        pteBalanceamt = this.makeBalancelistToBalanceamt((PteBalanceamt)pteBalanceamtQueryResult.getList().get(0), pteBalancelistDomain);
        this.logger.error("pte.pteBalanceamtServiceImplsaveBalanceamtByBalancelist.pteBalanceamt", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceamt));
        this.updateBalanceamtModel(pteBalanceamt);
        return pteBalancelistDomain;
    }

    private PteBalanceamt makepteBalancelistDomain(PteBalanceamt pteBalanceamt, PteBalancelistDomain pteBalancelistDomain) {
        if ("0".equals(pteBalancelistDomain.getBalanceTime())) {
            pteBalanceamt.setBalanceAllfee(pteBalanceamt.getBalanceAllfee().add(pteBalancelistDomain.getBalanceopFee()));
            pteBalanceamt.setBalanceAllamount(pteBalanceamt.getBalanceAllamount().add(pteBalancelistDomain.getBalanceopAmount()));
        } else {
            pteBalanceamt.setBalanceFee(pteBalanceamt.getBalanceFee().add(pteBalancelistDomain.getBalanceopFee()));
            pteBalanceamt.setBalanceAmount(pteBalanceamt.getBalanceAmount().add(pteBalancelistDomain.getBalanceopAmount()));
        }
        return pteBalanceamt;
    }

    private PteBalanceamt makeBalancelistToBalanceamt(PteBalanceamt pteBalanceamt, PteBalancelistDomain pteBalancelistDomain) {
        pteBalanceamt.setBalanceAllfee(pteBalanceamt.getBalanceAllfee().add(pteBalancelistDomain.getBalanceopFee()));
        pteBalanceamt.setBalanceAllamount(pteBalanceamt.getBalanceAllamount().add(pteBalancelistDomain.getBalanceopAmount()));
        pteBalanceamt.setBalanceFee(pteBalanceamt.getBalanceFee().subtract(pteBalancelistDomain.getBalanceopFee()));
        pteBalanceamt.setBalanceAmount(pteBalanceamt.getBalanceAmount().subtract(pteBalancelistDomain.getBalanceopAmount()));
        return pteBalanceamt;
    }

    private void makeBalanceFeeAmount(PteBalancelistDomain pteBalancelistDomain, PteBalanceamtDomain pteBalanceamtDomain) {
        if ("0".equals(pteBalancelistDomain.getBalanceTime())) {
            pteBalanceamtDomain.setBalanceAllfee(pteBalancelistDomain.getBalanceopFee());
            pteBalanceamtDomain.setBalanceAllamount(pteBalancelistDomain.getBalanceopAmount());
            pteBalanceamtDomain.setBalanceFee(new BigDecimal("0"));
            pteBalanceamtDomain.setBalanceAmount(new BigDecimal("0"));
        } else {
            pteBalanceamtDomain.setBalanceAllfee(new BigDecimal("0"));
            pteBalanceamtDomain.setBalanceAllamount(new BigDecimal("0"));
            pteBalanceamtDomain.setBalanceFee(pteBalancelistDomain.getBalanceopFee());
            pteBalanceamtDomain.setBalanceAmount(pteBalancelistDomain.getBalanceopAmount());
        }
    }

    private PteBalanceamtDomain makeBalanceamt(PteBalancelistDomain pteBalancelistDomain, PteBalanceamtDomain pteBalanceamtDomain) {
        if (null == pteBalancelistDomain) {
            return null;
        }
        if (null == pteBalanceamtDomain) {
            pteBalanceamtDomain = new PteBalanceamtDomain();
        }
        pteBalanceamtDomain.setTenantCode(pteBalancelistDomain.getTenantCode());
        pteBalanceamtDomain.setPartnerCode(pteBalancelistDomain.getPartnerCode());
        pteBalanceamtDomain.setMemberCode(pteBalancelistDomain.getMemberCode());
        pteBalanceamtDomain.setMemberName(pteBalancelistDomain.getMemberName());
        BigDecimal bigDecima = new BigDecimal(0);
        this.makeBalanceFeeAmount(pteBalancelistDomain, pteBalanceamtDomain);
        pteBalanceamtDomain.setBalanceAllfee1(bigDecima);
        pteBalanceamtDomain.setBalanceAllfee2(bigDecima);
        pteBalanceamtDomain.setBalanceAllfee3(bigDecima);
        pteBalanceamtDomain.setBalanceAllfee4(bigDecima);
        pteBalanceamtDomain.setBalanceAllfee5(bigDecima);
        pteBalanceamtDomain.setBalanceAllamount1(bigDecima);
        pteBalanceamtDomain.setBalanceAllamount2(bigDecima);
        pteBalanceamtDomain.setBalanceAllamount3(bigDecima);
        pteBalanceamtDomain.setBalanceAllamount4(bigDecima);
        pteBalanceamtDomain.setBalanceAllamount5(bigDecima);
        pteBalanceamtDomain.setBalanceFee1(bigDecima);
        pteBalanceamtDomain.setBalanceFee2(bigDecima);
        pteBalanceamtDomain.setBalanceFee3(bigDecima);
        pteBalanceamtDomain.setBalanceFee4(bigDecima);
        pteBalanceamtDomain.setBalanceFee5(bigDecima);
        pteBalanceamtDomain.setBalanceAmount1(bigDecima);
        pteBalanceamtDomain.setBalanceAmount2(bigDecima);
        pteBalanceamtDomain.setBalanceAmount3(bigDecima);
        pteBalanceamtDomain.setBalanceAmount4(bigDecima);
        pteBalanceamtDomain.setBalanceAmount5(bigDecima);
        return pteBalanceamtDomain;
    }

    @Override
    public void updateBalanceamtState(Integer balanceamtId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == balanceamtId) {
            return;
        }
        this.updateStateBalanceamtModel(balanceamtId, dataState, oldDataState, map);
    }

    @Override
    public void updateBalanceamtStateByCode(String tenantCode, String balanceamtCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)balanceamtCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateBalanceamtModelByCode(tenantCode, balanceamtCode, dataState, oldDataState, map);
    }

    @Override
    public void updateBalanceAmount(String tenantCode, String balanceamtCode, BigDecimal balanceAmount, BigDecimal fee) throws ApiException {
        this.updateBalanceAmountModel(tenantCode, balanceamtCode, balanceAmount, fee);
    }

    @Override
    public void updateBalanceamt(PteBalanceamtDomain pteBalanceamtDomain) throws ApiException {
        String msg = this.checkBalanceamt(pteBalanceamtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.updateBalanceamt.checkBalanceamt", msg);
        }
        PteBalanceamt oldPteBalanceamt = this.getBalanceamtModelById(pteBalanceamtDomain.getBalanceamtId());
        if (null == oldPteBalanceamt) {
            throw new ApiException("pte.pteBalanceamtServiceImpl.updateBalanceamt.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PteBalanceamt pteBalanceamt = this.makeBalanceamt(pteBalanceamtDomain, oldPteBalanceamt);
        this.setBalanceamtUpdataDefault(pteBalanceamt);
        this.updateBalanceamtModel(pteBalanceamt);
    }

    @Override
    public PteBalanceamt getBalanceamt(Integer balanceamtId) {
        if (null == balanceamtId) {
            return null;
        }
        return this.getBalanceamtModelById(balanceamtId);
    }

    @Override
    public void deleteBalanceamt(Integer balanceamtId) throws ApiException {
        if (null == balanceamtId) {
            return;
        }
        this.deleteBalanceamtModel(balanceamtId);
    }

    @Override
    public QueryResult<PteBalanceamt> queryBalanceamtPage(Map<String, Object> map) {
        List<PteBalanceamt> pteBalanceamtList = this.queryBalanceamtModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBalanceamt(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pteBalanceamtList);
        return queryResult;
    }

    @Override
    public PteBalanceamt getBalanceamtByCode(String tenantCode, String balanceamtCode) throws ApiException {
        if (StringUtils.isBlank((String)balanceamtCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balanceamtCode", balanceamtCode);
        return this.getBalanceamtModelByCode(map);
    }

    @Override
    public void deleteBalanceamtByCode(String tenantCode, String balanceamtCode) throws ApiException {
        if (StringUtils.isBlank((String)balanceamtCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("balanceamtCode", balanceamtCode);
        this.delBalanceamtModelByCode(map);
    }

    @Override
    public String sendSaveBalanceamtUserinfo(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        if (!"insert".equals(optype)) {
            this.logger.error("pte.pteBalanceamtServiceImploptype==" + optype);
            return "success";
        }
        if (null == umUserinfo) {
            this.logger.error("pte.pteBalanceamtServiceImplsendSaveBalanceamtUserinfo", (Object)"umUserinfo is null");
            return "error";
        }
        PteBalanceamtDomain pteBalanceamtDomain = new PteBalanceamtDomain();
        pteBalanceamtDomain.setTenantCode(umUserinfo.getTenantCode());
        pteBalanceamtDomain.setPartnerCode(umUserinfo.getPartnerCode());
        pteBalanceamtDomain.setMemberCode(umUserinfo.getUserinfoCode());
        pteBalanceamtDomain.setMemberName(umUserinfo.getUserinfoCompname());
        BigDecimal bigDecima = new BigDecimal(0);
        pteBalanceamtDomain.setBalanceAllfee(bigDecima);
        pteBalanceamtDomain.setBalanceAllamount(bigDecima);
        pteBalanceamtDomain.setBalanceFee(bigDecima);
        pteBalanceamtDomain.setBalanceAmount(bigDecima);
        pteBalanceamtDomain.setBalanceAllfee1(bigDecima);
        pteBalanceamtDomain.setBalanceAllfee2(bigDecima);
        pteBalanceamtDomain.setBalanceAllfee3(bigDecima);
        pteBalanceamtDomain.setBalanceAllfee4(bigDecima);
        pteBalanceamtDomain.setBalanceAllfee5(bigDecima);
        pteBalanceamtDomain.setBalanceAllamount1(bigDecima);
        pteBalanceamtDomain.setBalanceAllamount2(bigDecima);
        pteBalanceamtDomain.setBalanceAllamount3(bigDecima);
        pteBalanceamtDomain.setBalanceAllamount4(bigDecima);
        pteBalanceamtDomain.setBalanceAllamount5(bigDecima);
        pteBalanceamtDomain.setBalanceFee1(bigDecima);
        pteBalanceamtDomain.setBalanceFee2(bigDecima);
        pteBalanceamtDomain.setBalanceFee3(bigDecima);
        pteBalanceamtDomain.setBalanceFee4(bigDecima);
        pteBalanceamtDomain.setBalanceFee5(bigDecima);
        pteBalanceamtDomain.setBalanceAmount1(bigDecima);
        pteBalanceamtDomain.setBalanceAmount2(bigDecima);
        pteBalanceamtDomain.setBalanceAmount3(bigDecima);
        pteBalanceamtDomain.setBalanceAmount4(bigDecima);
        pteBalanceamtDomain.setBalanceAmount5(bigDecima);
        this.saveBalanceamt(pteBalanceamtDomain);
        return "success";
    }

    @Override
    public PteBalanceamt saveBalanceamtByBalanceop(PteBalanceop pteBalanceop) throws ApiException {
        PteBalanceamt balanceamt = this.getBalanceamtByCode(pteBalanceop.getTenantCode(), pteBalanceop.getBalanceamtCode());
        if (null == balanceamt) {
            balanceamt = new PteBalanceamt();
            balanceamt.setTenantCode(pteBalanceop.getTenantCode());
            balanceamt.setBalanceamtCode(pteBalanceop.getBalanceamtCode());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", pteBalanceop.getTenantCode());
            QueryResult<PteBalance> queryResult = this.pteBalanceService.queryBalancePage(map);
            if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
                throw new ApiException("pte.pteBalanceamtServiceImpl.saveBalanceamtByBalanceop", "\u53c2\u6570\u9519\u8bef");
            }
            PteBalance pteBalance = (PteBalance)queryResult.getList().get(0);
            BigDecimal balanceFee = pteBalance.getBalanceFee().divide(new BigDecimal(1000));
            balanceamt.setBalanceFee(balanceFee);
            balanceamt.setBalanceTime(pteBalance.getBalanceTime());
            BigDecimal fee = pteBalanceop.getBalanceopAmount().multiply(balanceFee).setScale(2, 4);
            BigDecimal subtract = pteBalanceop.getBalanceopAmount().subtract(fee);
            balanceamt.setBalanceAmount(subtract);
            balanceamt.setBalanceFee1(fee);
            int moon = 0;
            if (StringUtils.isNotBlank((String)pteBalance.getBalanceTime())) {
                moon = Integer.valueOf(pteBalance.getBalanceTime());
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(2, moon + 1);
            calendar.set(5, 1);
            Date startOfLastMonth = calendar.getTime();
            calendar.set(5, calendar.getActualMaximum(5));
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            Date endOfLastMonth = calendar.getTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            balanceamt.setBalanceDate(dateFormat.format(startOfLastMonth));
            balanceamt.setGmtStart(startOfLastMonth);
            balanceamt.setGmtEnd(endOfLastMonth);
            this.setBalanceamtDefault(balanceamt);
            this.saveBalanceamtModel(balanceamt);
        }
        return balanceamt;
    }
}

