/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.dao.PtePtradeInfoMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeInfoDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.service.paytradeengine.enumc.DicactorEnum;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradeInfo;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradeParticipant;
import com.yqbsoft.laser.service.paytradeengine.sdomain.VdFaccountOuter;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeInfoService;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeParticipantService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DuplicateKeyException;

public class PtePtradeInfoServiceImpl
extends BaseServiceImpl
implements PtePtradeInfoService {
    public static final String SYS_CODE = "pte.PtePtradeInfoServiceImpl";
    private PtePtradeInfoMapper ptePtradeInfoMapper;
    PtePtradeParticipantService ptePtradeParticipantService;

    public void setPtePtradeParticipantService(PtePtradeParticipantService ptePtradeParticipantService) {
        this.ptePtradeParticipantService = ptePtradeParticipantService;
    }

    public void setPtePtradeInfoMapper(PtePtradeInfoMapper ptePtradeInfoMapper) {
        this.ptePtradeInfoMapper = ptePtradeInfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptePtradeInfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtradeInfo(PtePtradeInfoDomain ptePtradeInfoDomain) {
        if (null == ptePtradeInfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ptePtradeInfoDomain.getPtradeSeqno())) {
            msg = msg + "PtradeSeqno\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ptePtradeInfoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtradeInfoDefault(PtePtradeInfo ptePtradeInfo) {
        if (null == ptePtradeInfo) {
            return;
        }
        if (null == ptePtradeInfo.getDataState()) {
            ptePtradeInfo.setDataState(0);
        }
        if (null == ptePtradeInfo.getGmtCreate()) {
            ptePtradeInfo.setGmtCreate(this.getSysDate());
        }
        ptePtradeInfo.setGmtModified(this.getSysDate());
        if (null == ptePtradeInfo.getOrderOamount()) {
            ptePtradeInfo.setOrderOamount(ptePtradeInfo.getOrderAmount());
        }
        if (StringUtils.isBlank((String)ptePtradeInfo.getPtradeInfoCode())) {
            ptePtradeInfo.setPtradeInfoCode(this.getNo(null, PtePtradeInfo.class.getSimpleName(), "ptradeInfoCode", ptePtradeInfo.getTenantCode()));
        }
    }

    private int getPtradeInfoMaxCode() {
        int code = 0;
        try {
            return this.ptePtradeInfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.getPtradeInfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtradeInfoUpdataDefault(PtePtradeInfo ptePtradeInfo) {
        if (null == ptePtradeInfo) {
            return;
        }
        ptePtradeInfo.setGmtModified(this.getSysDate());
    }

    private void savePtradeInfoModel(PtePtradeInfo ptePtradeInfo) throws ApiException {
        if (null == ptePtradeInfo) {
            return;
        }
        try {
            this.ptePtradeInfoMapper.insert(ptePtradeInfo);
        }
        catch (Exception e) {
            if (e instanceof DuplicateKeyException) {
                throw new ApiException("Union_ErrorCode", "\u4e3b\u952e\u51b2\u7a81");
            }
            throw new ApiException("pte.PtePtradeInfoServiceImpl.savePtradeInfoModel.ex", (Throwable)e);
        }
    }

    private void savePtradeInfoModelBatch(List<PtePtradeInfo> ptePtradeInfoList) throws ApiException {
        if (null == ptePtradeInfoList || ptePtradeInfoList.isEmpty()) {
            return;
        }
        try {
            this.ptePtradeInfoMapper.insertBatch(ptePtradeInfoList);
        }
        catch (Exception e) {
            if (e instanceof DuplicateKeyException) {
                throw new ApiException("Union_ErrorCode", "\u4e3b\u952e\u51b2\u7a81");
            }
            throw new ApiException("pte.PtePtradeInfoServiceImpl.savePtradeInfoModelBatch.ex", (Throwable)e);
        }
    }

    private PtePtradeInfo getPtradeInfoModelById(Integer ptradeInfoId) {
        if (null == ptradeInfoId) {
            return null;
        }
        try {
            return this.ptePtradeInfoMapper.selectByPrimaryKey(ptradeInfoId);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.getPtradeInfoModelById", (Throwable)e);
            return null;
        }
    }

    public PtePtradeInfo getPtradeInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptePtradeInfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.getPtradeInfoModelByCode", (Throwable)e);
            return null;
        }
    }

    private List<PtePtradeInfo> queryPtradeInfoModelByPtraderCode(Map<String, Object> map) {
        try {
            return this.ptePtradeInfoMapper.query(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.getPtradeInfoModelByCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<PtePtradeInfoDomain> queryPtradeInfoDomainByPtraderCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<PtePtradeInfo> infoList = this.queryPtradeInfoModelByPtraderCode(map);
        if (ListUtil.isEmpty(infoList)) {
            return null;
        }
        ArrayList<PtePtradeInfoDomain> domainList = new ArrayList<PtePtradeInfoDomain>();
        for (PtePtradeInfo ptePtradeInfo : infoList) {
            PtePtradeInfoDomain ptePtradeInfoDomain = new PtePtradeInfoDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ptePtradeInfoDomain, (Object)ptePtradeInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ptePtradeInfoDomain.setPtePtradeParticipantDomainList(this.queryParticipant(ptePtradeInfo, map));
        }
        return domainList;
    }

    @Override
    public List<PtePtradeInfo> queryPtradeInfoByPtraderCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        return this.queryPtradeInfoModelByPtraderCode(map);
    }

    private List<PtePtradeParticipantDomain> queryParticipant(PtePtradeInfo ptePtradeInfo, Map<String, Object> map) {
        if (null == ptePtradeInfo || MapUtil.isEmpty(map)) {
            return null;
        }
        map.put("ptradeInfoCode", ptePtradeInfo.getPtradeInfoCode());
        QueryResult<PtePtradeParticipant> qlist = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        ArrayList<PtePtradeParticipantDomain> domainList = new ArrayList<PtePtradeParticipantDomain>();
        for (PtePtradeParticipant ptePtradeParticipant : qlist.getList()) {
            PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)ptePtradeParticipant);
            }
            catch (Exception exception) {
                // empty catch block
            }
            domainList.add(ptePtradeParticipantDomain);
        }
        return domainList;
    }

    public void delPtradeInfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptePtradeInfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.delPtradeInfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.delPtradeInfoModelByCode.num");
        }
    }

    private void deletePtradeInfoModel(Integer ptradeInfoId) throws ApiException {
        if (null == ptradeInfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptePtradeInfoMapper.deleteByPrimaryKey(ptradeInfoId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.deletePtradeInfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.deletePtradeInfoModel.num");
        }
    }

    private void updatePtradeInfoModel(PtePtradeInfo ptePtradeInfo) throws ApiException {
        if (null == ptePtradeInfo) {
            return;
        }
        try {
            this.ptePtradeInfoMapper.updateByPrimaryKeySelective(ptePtradeInfo);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.updatePtradeInfoModel.ex", (Throwable)e);
        }
    }

    private void updateStatePtradeInfoModel(Integer ptradeInfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ptradeInfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptradeInfoId", ptradeInfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptePtradeInfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.updateStatePtradeInfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.updateStatePtradeInfoModel.null");
        }
    }

    private PtePtradeInfo makePtradeInfo(PtePtradeInfoDomain ptePtradeInfoDomain, PtePtradeInfo ptePtradeInfo) {
        if (null == ptePtradeInfoDomain) {
            return null;
        }
        if (null == ptePtradeInfo) {
            ptePtradeInfo = new PtePtradeInfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeInfo, (Object)ptePtradeInfoDomain);
            return ptePtradeInfo;
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.makePtradeInfo", (Throwable)e);
            return null;
        }
    }

    private List<PtePtradeInfo> queryPtradeInfoModelPage(Map<String, Object> parammap) {
        try {
            return this.ptePtradeInfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.queryPtradeInfoModel", (Throwable)e);
            return null;
        }
    }

    private int countPtradeInfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptePtradeInfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeInfoServiceImpl.countPtradeInfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public String savePtradeInfo(PtePtradeInfoDomain ptePtradeInfoDomain) throws ApiException {
        PtePtradeInfo ptePtradeInfo = this.makePtradeInfo(ptePtradeInfoDomain);
        this.savePtradeInfoModel(ptePtradeInfo);
        return ptePtradeInfo.getPtradeInfoCode();
    }

    private PtePtradeInfo makePtradeInfo(PtePtradeInfoDomain ptePtradeInfoDomain) {
        String msg = this.checkPtradeInfo(ptePtradeInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.savePtradeInfo.checkPtradeInfo", msg);
        }
        PtePtradeInfo ptePtradeInfo = this.makePtradeInfo(ptePtradeInfoDomain, null);
        this.setPtradeInfoDefault(ptePtradeInfo);
        if (!ptePtradeInfo.getOpuserCode().equals(ptePtradeInfo.getMerchantCode())) {
            HashMap map = new HashMap();
            String ptradeExtension = ptePtradeInfo.getPtradeInfoExtension();
            if (StringUtils.isNotBlank((String)ptradeExtension)) {
                Map pa = JsonUtil.buildNormalBinder().getJsonToMap(ptradeExtension, String.class, Object.class);
                map.putAll(pa);
            }
            ptePtradeInfo.setPtradeInfoExtension(JsonUtil.buildNormalBinder().toJson(map));
        }
        return ptePtradeInfo;
    }

    public void makeOrderOamount(PtePtradeInfo ptePtradeInfo, Map<String, Object> partMap) {
        if (partMap.containsKey(DicactorEnum.COUPON.getCode())) {
            Map coupon = (Map)partMap.get(DicactorEnum.COUPON.getCode());
            BigDecimal couponAmount = new BigDecimal(coupon.get("orderAmount").toString());
            BigDecimal sellAmount = ptePtradeInfo.getOrderAmount();
            BigDecimal amount = couponAmount.add(sellAmount);
            ptePtradeInfo.setOrderOamount(amount);
        }
    }

    public Map<String, Object> setMerchant(PtePtradeInfo ptePtradeInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PtePtradeParticipantDomain ptePtradeParticipantDomain = this.makePtePtradeParticipant(ptePtradeInfo, ptePtradeInfo.getMerchantCode(), DicactorEnum.SELL_B.getCode());
        map.put(ptePtradeParticipantDomain.getDicActorCode(), ptePtradeParticipantDomain);
        return map;
    }

    private PtePtradeParticipantDomain makePtePtradeParticipant(PtePtradeInfo ptePtradeInfo, String merchantCode, String dicActioCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("merchantCode", merchantCode);
        String code = merchantCode.substring(0, 1);
        String faccountType = StringUtils.isBlank((String)ptePtradeInfo.getFchannelClassifyCode()) ? code + "01" : ptePtradeInfo.getFchannelClassifyCode();
        pmap.put("faccountType", faccountType);
        pmap.put("tenantCode", ptePtradeInfo.getTenantCode());
        String result = this.internalInvoke("vd.faccountOuter.queryOuterFaccount", pmap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.makePtePtradeParticipant.makePtePtradeParticipant1", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!");
        }
        List vdFaccountOuter = JsonUtil.buildNormalBinder().getJsonToList(result, VdFaccountOuter.class);
        if (ListUtil.isEmpty((Collection)vdFaccountOuter)) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.makePtePtradeParticipant.makePtePtradeParticipant2", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!");
        }
        PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
        ptePtradeParticipantDomain.setTenantCode(((VdFaccountOuter)vdFaccountOuter.get(0)).getTenantCode());
        ptePtradeParticipantDomain.setPartnerCode(ptePtradeInfo.getPartnerCode());
        ptePtradeParticipantDomain.setOpuserCode(merchantCode);
        ptePtradeParticipantDomain.setDicActorCode(dicActioCode);
        ptePtradeParticipantDomain.setFaccountId(((VdFaccountOuter)vdFaccountOuter.get(0)).getFaccountOuterNo());
        ptePtradeParticipantDomain.setFchannelCode("0" + code);
        ptePtradeParticipantDomain.setFchannelClassifyCode(faccountType);
        ptePtradeParticipantDomain.setFundType(ptePtradeInfo.getFundType());
        ptePtradeParticipantDomain.setOrderAmount(ptePtradeInfo.getOrderAmount());
        ptePtradeParticipantDomain.setOrderPortion(ptePtradeInfo.getOrderPortion());
        ptePtradeParticipantDomain.setOrderPrice(ptePtradeInfo.getOrderPrice());
        ptePtradeParticipantDomain.setFaccountName(((VdFaccountOuter)vdFaccountOuter.get(0)).getFaccountOuterName());
        return ptePtradeParticipantDomain;
    }

    @Override
    public String savePtradeInfoBatch(List<PtePtradeInfoDomain> ptePtradeInfoDomainList) throws ApiException {
        if (null == ptePtradeInfoDomainList || ptePtradeInfoDomainList.isEmpty()) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.savePtradeInfoBatch.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<PtePtradeInfo> ptePtradeInfoList = new ArrayList<PtePtradeInfo>();
        for (PtePtradeInfoDomain ptePtradeInfoDomain : ptePtradeInfoDomainList) {
            ptePtradeInfoList.add(this.makePtradeInfo(ptePtradeInfoDomain));
        }
        this.savePtradeInfoModelBatch(ptePtradeInfoList);
        return ((PtePtradeInfo)ptePtradeInfoList.get(0)).getPtradeInfoCode();
    }

    @Override
    public void updatePtradeInfoState(Integer ptradeInfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePtradeInfoModel(ptradeInfoId, dataState, oldDataState);
    }

    @Override
    public void updatePtradeInfo(PtePtradeInfoDomain ptePtradeInfoDomain) throws ApiException {
        String msg = this.checkPtradeInfo(ptePtradeInfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.updatePtradeInfo.checkPtradeInfo", msg);
        }
        PtePtradeInfo oldPtePtradeInfo = this.getPtradeInfoModelById(ptePtradeInfoDomain.getPtradeInfoId());
        if (null == oldPtePtradeInfo) {
            throw new ApiException("pte.PtePtradeInfoServiceImpl.updatePtradeInfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtePtradeInfo ptePtradeInfo = this.makePtradeInfo(ptePtradeInfoDomain, oldPtePtradeInfo);
        this.setPtradeInfoUpdataDefault(ptePtradeInfo);
        this.updatePtradeInfoModel(ptePtradeInfo);
    }

    @Override
    public PtePtradeInfo getPtradeInfo(Integer ptradeInfoId) {
        return this.getPtradeInfoModelById(ptradeInfoId);
    }

    @Override
    public void deletePtradeInfo(Integer ptradeInfoId) throws ApiException {
        this.deletePtradeInfoModel(ptradeInfoId);
    }

    @Override
    public QueryResult<PtePtradeInfo> queryPtradeInfoPage(Map<String, Object> map) {
        List<PtePtradeInfo> ptePtradeInfoList = this.queryPtradeInfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtradeInfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptePtradeInfoList);
        return queryResult;
    }

    @Override
    public PtePtradeInfo getPtradeInfoByCode(Map<String, Object> map) {
        return this.getPtradeInfoModelByCode(map);
    }

    @Override
    public void delPtradeInfoByCode(Map<String, Object> map) throws ApiException {
        this.delPtradeInfoModelByCode(map);
    }
}

