/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.cache.PteCachekeyUtil;
import com.yqbsoft.laser.service.paytradeengine.cache.PteQueryCall;
import com.yqbsoft.laser.service.paytradeengine.cache.SyncTradeFuture;
import com.yqbsoft.laser.service.paytradeengine.check.CheckChian;
import com.yqbsoft.laser.service.paytradeengine.check.CheckContext;
import com.yqbsoft.laser.service.paytradeengine.dao.PtePtradeMapper;
import com.yqbsoft.laser.service.paytradeengine.domain.CallBackContext;
import com.yqbsoft.laser.service.paytradeengine.domain.PteChannelsendDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeBackDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeForm;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeInfoDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PtePtradeReDomain;
import com.yqbsoft.laser.service.paytradeengine.enumc.DicactorEnum;
import com.yqbsoft.laser.service.paytradeengine.enumc.FchannelCodeEnum;
import com.yqbsoft.laser.service.paytradeengine.enumc.PtradpdeEnum;
import com.yqbsoft.laser.service.paytradeengine.enumc.PtradpdeTypeEnum;
import com.yqbsoft.laser.service.paytradeengine.model.PteFee;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtfchannel;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtrade;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradeInfo;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradeParticipant;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradpdeMpg;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradpdeMpgpa;
import com.yqbsoft.laser.service.paytradeengine.sdomain.BankHtmlForm;
import com.yqbsoft.laser.service.paytradeengine.sdomain.ChannelRestForm;
import com.yqbsoft.laser.service.paytradeengine.sdomain.MmMerberDomain;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PayengineForm;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PePaymentDomain;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PePaymentOrderDomain;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PePaymentParticipantDomain;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PtradeBackBean;
import com.yqbsoft.laser.service.paytradeengine.sdomain.PtradeBean;
import com.yqbsoft.laser.service.paytradeengine.sdomain.VdFaccountOuter;
import com.yqbsoft.laser.service.paytradeengine.service.PteChannelsendService;
import com.yqbsoft.laser.service.paytradeengine.service.PteMarketingProcessService;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtfchannelService;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeInfoService;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeParticipantService;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeReorderService;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeService;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PtradeInfoPollThread;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PtradeInfoService;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PtradePollThread;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PtradePutThread;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PtradeService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;

public class PtePtradeServiceImpl
extends BaseServiceImpl
implements PtePtradeService {
    public static final String SYS_CODE = "pte.PtePtradeServiceImpl";
    public PtePtradeMapper ptePtradeMapper;
    public PtePtradeInfoService ptePtradeInfoService;
    @Autowired
    private PteMarketingProcessService pteMarketingProcessService;
    @Autowired
    private PtePtfchannelService ptePtfchannelService;
    public PtePtradeParticipantService ptePtradeParticipantService;
    public PtePtradeReorderService ptePtradeReorderService;
    PteChannelsendService pteChannelsendService;
    private static PtradeService ptradeService;
    private static Object lock;
    private static PtradeInfoService ptradeInfoService;

    public void setPtePtradeInfoService(PtePtradeInfoService ptePtradeInfoService) {
        this.ptePtradeInfoService = ptePtradeInfoService;
    }

    public void setPtePtradeMapper(PtePtradeMapper ptePtradeMapper) {
        this.ptePtradeMapper = ptePtradeMapper;
    }

    public void setPtePtradeParticipantService(PtePtradeParticipantService ptePtradeParticipantService) {
        this.ptePtradeParticipantService = ptePtradeParticipantService;
    }

    public void setPtePtradeReorderService(PtePtradeReorderService ptePtradeReorderService) {
        this.ptePtradeReorderService = ptePtradeReorderService;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtrade(PtePtradeDomain ptePtradeDomain) {
        if (null == ptePtradeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ptePtradeDomain.getMerchantCode())) {
            msg = msg + "\u5546\u6237\u53f7\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ptePtradeDomain.getOpuserCode())) {
            msg = msg + "\u7528\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ptePtradeDomain.getPtradpdeCode())) {
            msg = msg + "\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a;";
        }
        if (ptePtradeDomain.getOrderAmount() == null) {
            msg = msg + "\u4ea4\u6613\u989d\u4e3a\u7a7a;";
        }
        if (ptePtradeDomain.getPartnerCode() == null) {
            msg = msg + "\u5408\u4f5c\u65b9\u7f16\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtradeDefault(PtePtrade ptePtrade) {
        if (null == ptePtrade) {
            return;
        }
        if (null == ptePtrade.getDataState()) {
            ptePtrade.setDataState(0);
        }
        if (null == ptePtrade.getGmtCreate()) {
            ptePtrade.setGmtCreate(this.getSysDate());
        }
        ptePtrade.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptePtrade.getPtradeSeqno())) {
            ptePtrade.setPtradeSeqno(this.getNo(null, PtePtrade.class.getSimpleName(), "ptradeSeqno", ptePtrade.getTenantCode()));
        }
    }

    private int getPtradeMaxCode() {
        int code = 0;
        try {
            return this.ptePtradeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.getPtradeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtradeUpdataDefault(PtePtrade ptePtrade) {
        if (null == ptePtrade) {
            return;
        }
        ptePtrade.setGmtModified(this.getSysDate());
    }

    private void savePtradeModel(PtePtrade ptePtrade) throws ApiException {
        if (null == ptePtrade) {
            return;
        }
        try {
            this.ptePtradeMapper.insert(ptePtrade);
        }
        catch (Exception e) {
            if (e instanceof DuplicateKeyException) {
                throw new ApiException("Union_ErrorCode", "", (Throwable)e);
            }
            throw new ApiException("pte.PtePtradeServiceImpl.savePtradeModel.ex", (Throwable)e);
        }
    }

    private PtePtrade getPtradeModelById(Integer ptradeId) {
        if (null == ptradeId) {
            return null;
        }
        try {
            return this.ptePtradeMapper.selectByPrimaryKey(ptradeId);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.getPtradeModelById", (Throwable)e);
            return null;
        }
    }

    public PtePtrade getPtradeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptePtradeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.getPtradeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPtradeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptePtradeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.delPtradeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PtePtradeServiceImpl.delPtradeModelByCode.num");
        }
    }

    private void deletePtradeModel(Integer ptradeId) throws ApiException {
        if (null == ptradeId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptePtradeMapper.deleteByPrimaryKey(ptradeId);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.deletePtradeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pte.PtePtradeServiceImpl.deletePtradeModel.num");
        }
    }

    private void updatePtradeModel(PtePtrade ptePtrade) throws ApiException {
        if (null == ptePtrade) {
            return;
        }
        try {
            this.ptePtradeMapper.updateByPrimaryKeySelective(ptePtrade);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeModel.ex", (Throwable)e);
        }
    }

    private void updateStatePtradeModel(Integer ptradeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ptradeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptradeId", ptradeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptePtradeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.updateStatePtradeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pte.PtePtradeServiceImpl.updateStatePtradeModel.null");
        }
    }

    private Integer updatePtradeModelById(Integer ptradeId, Integer oldDataState, Map<String, Object> setMap, boolean flag) throws ApiException {
        if (null == ptradeId || null == oldDataState || setMap == null || setMap.isEmpty()) {
            return -1;
        }
        setMap.put("ptradeId", ptradeId);
        setMap.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptePtradeMapper.updateStateByPrimaryKey(setMap);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeModelById.ex", ptradeId + "=" + oldDataState, (Throwable)e);
        }
        if (flag ? i < 0 : i <= 0) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeModelById.null", ptradeId + "=" + oldDataState);
        }
        return i;
    }

    private PtePtrade makePtrade(PtePtradeDomain ptePtradeDomain, PtePtrade ptePtrade) {
        if (null == ptePtradeDomain) {
            return null;
        }
        if (null == ptePtrade) {
            ptePtrade = new PtePtrade();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptePtrade, (Object)ptePtradeDomain);
            return ptePtrade;
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.makePtrade", (Throwable)e);
            return null;
        }
    }

    protected PtePtradeReDomain makePtradeDomain(PtePtrade ptePtrade) {
        if (null == ptePtrade) {
            return null;
        }
        PtePtradeReDomain ptePtradeDomain = new PtePtradeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeDomain, (Object)ptePtrade);
            HashMap<String, Object> pmap = new HashMap<String, Object>();
            pmap.put("ptradeSeqno", ptePtrade.getPtradeSeqno());
            pmap.put("tenantCode", ptePtrade.getTenantCode());
            ptePtradeDomain.setPtePtradeInfoDomainList(this.ptePtradeInfoService.queryPtradeInfoDomainByPtraderCode(pmap));
            return ptePtradeDomain;
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.makePtradeDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtePtrade> queryPtradeModelPage(Map<String, Object> parammap) {
        try {
            return this.ptePtradeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.queryPtradeModel", (Throwable)e);
            return null;
        }
    }

    private int countPtrade(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptePtradeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.countPtrade", (Throwable)e);
        }
        return i;
    }

    private String savePtradeInfo(PtePtrade ptePtrade, List<PtePtradeInfoDomain> ptePtradeInfoDomainList) throws ApiException {
        if (null == ptePtrade) {
            return null;
        }
        if (null == ptePtradeInfoDomainList || ptePtradeInfoDomainList.isEmpty()) {
            ptePtradeInfoDomainList = new ArrayList<PtePtradeInfoDomain>();
            PtePtradeInfoDomain ptePtradeInfoDomain = new PtePtradeInfoDomain();
            ptePtradeInfoDomain.setPaymentOperator(ptePtrade.getPaymentOperator());
            try {
                BeanUtils.copyAllPropertys((Object)ptePtradeInfoDomain, (Object)ptePtrade);
            }
            catch (Exception e) {
                throw new ApiException("pte.PtePtradeServiceImpl.savePtradeInfo.e", (Throwable)e);
            }
            String type = ptePtrade.getMerchantCode().substring(0, 1);
            ptePtradeInfoDomain.setFchannelClassifyCode(type + ptePtrade.getPtradeType());
            ptePtradeInfoDomainList.add(ptePtradeInfoDomain);
        } else {
            for (PtePtradeInfoDomain ptePtradeInfoDomain : ptePtradeInfoDomainList) {
                ptePtradeInfoDomain.setPtradpdeCode(ptePtrade.getPtradpdeCode());
                ptePtradeInfoDomain.setMerchantFaccountType(ptePtrade.getMerchantFaccountType());
                ptePtradeInfoDomain.setPtradeSeqno(ptePtrade.getPtradeSeqno());
                ptePtradeInfoDomain.setPtradeBatchno(ptePtrade.getPtradeBatchno());
            }
        }
        return this.ptePtradeInfoService.savePtradeInfoBatch(ptePtradeInfoDomainList);
    }

    @Override
    public String savePtrade(PtePtradeDomain ptePtradeDomain) throws ApiException {
        PtePtrade ptePtrade = this.savePtradeRe(ptePtradeDomain);
        return ptePtrade.getPtradeSeqno();
    }

    public PtePtrade savePtradeRe(PtePtradeDomain ptePtradeDomain) throws ApiException {
        String msg = this.checkPtrade(ptePtradeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtrade.checkPtrade", msg);
        }
        if (ptePtradeDomain.getOrderOamount() == null) {
            ptePtradeDomain.setOrderOamount(ptePtradeDomain.getOrderAmount());
        }
        PtePtrade ptePtrade = this.makePtrade(ptePtradeDomain, null);
        this.setPtradeDefault(ptePtrade);
        String ptradeInfoCode = this.savePtradeInfo(ptePtrade, ptePtradeDomain.getPtePtradeInfoDomainList());
        if (null != ptePtradeDomain.getPtradeBean() && ListUtil.isNotEmpty(ptePtradeDomain.getPtradeBean().getPartList())) {
            ptePtradeDomain.getPtradeBean().setPtradeSeqno(ptePtrade.getPtradeSeqno());
            for (PtePtradeParticipantDomain ptePtradeParticipantDomain : ptePtradeDomain.getPtradeBean().getPartList()) {
                ptePtradeParticipantDomain.setPtePtradeCode(ptePtrade.getPtradpdeCode());
                ptePtradeParticipantDomain.setPtradeInfoCode(ptradeInfoCode);
                ptePtradeParticipantDomain.setPtradeSeqno(ptePtrade.getPtradeSeqno());
            }
        }
        this.setGmtPayout(ptePtrade, ptePtradeDomain.getMinPayout());
        this.savePtradeModel(ptePtrade);
        return ptePtrade;
    }

    public void makeOrderOamount(PtePtrade ptePtrade, Map<String, Object> partMap) {
        if (partMap.containsKey(DicactorEnum.COUPON.getCode())) {
            Map coupon = (Map)partMap.get(DicactorEnum.COUPON.getCode());
            BigDecimal couponAmount = new BigDecimal(coupon.get("orderAmount").toString());
            PtePtradeParticipantDomain sell = (PtePtradeParticipantDomain)partMap.get(DicactorEnum.SELL_B.getCode());
            BigDecimal sellAmount = sell.getOrderAmount();
            BigDecimal amount = couponAmount.add(sellAmount);
            sell.setOrderAmount(amount);
            ptePtrade.setOrderOamount(amount);
        }
    }

    private void setGmtPayout(PtePtrade ptePtrade, Integer minPayout) {
        if (ptePtrade == null || minPayout == null || minPayout <= 0) {
            return;
        }
        Date createDate = ptePtrade.getGmtCreate();
        String gmtPayout = DateUtil.getAfterCalendarType((String)DateUtil.getDateString((Date)createDate, (String)"yyyy-MM-dd HH:mm:ss"), (int)minPayout, (int)12, (String)"yyyy-MM-dd HH:mm:ss");
        ptePtrade.setGmtPayout(DateUtil.getDateToString((String)gmtPayout, (String)"yyyy-MM-dd HH:mm:ss"));
    }

    @Override
    public String sendSavePtrade(PtePtradeDomain ptePtradeDomain) throws ApiException {
        if (null == ptePtradeDomain) {
            return null;
        }
        String ptradeSeqno = "";
        ptradeSeqno = this.savePtrade(ptePtradeDomain);
        PtradeBean ptradeBean = ptePtradeDomain.getPtradeBean();
        if (ptradeBean != null) {
            ptradeBean.setPtradeSeqno(ptradeSeqno);
            return this.commitParticipantByPtrade(ptradeBean);
        }
        return ptradeSeqno;
    }

    @Override
    public PtePtrade savePtradeAuto(PtePtradeDomain ptePtradeDomain) throws ApiException {
        if (null == ptePtradeDomain) {
            return null;
        }
        PtePtrade ptePtrade = this.savePtradeRe(ptePtradeDomain);
        PtradeBean ptradeBean = ptePtradeDomain.getPtradeBean();
        if (ptradeBean != null) {
            ptradeBean.setPtradeSeqno(ptePtrade.getPtradeSeqno());
            ptePtrade = this.commitParticipantByPtradeRe(ptradeBean);
            this.sendPtradeCommit(ptePtrade);
        }
        return ptePtrade;
    }

    @Override
    public PtePtrade sendPtradeAuto(PtePtradeDomain ptePtradeDomain) throws ApiException {
        PtePtrade ptePtrade = this.savePtradeRe(ptePtradeDomain);
        PtradeBean ptradeBean = ptePtradeDomain.getPtradeBean();
        if (ptradeBean != null) {
            ptradeBean.setPtradeSeqno(ptePtrade.getPtradeSeqno());
            ptePtrade = this.commitParticipantByPtradeRe(ptradeBean);
            this.sendPtradeCommit(ptePtrade);
        }
        return ptePtrade;
    }

    @Override
    public BankHtmlForm sendSavePtradeForm(PtePtradeDomain ptePtradeDomain) throws ApiException {
        String ptradeSeqno = this.savePtrade(ptePtradeDomain);
        PtradeBean ptradeBean = ptePtradeDomain.getPtradeBean();
        if (ptradeBean != null) {
            ptradeBean.setPtradeSeqno(ptradeSeqno);
            return this.sendParticipantByPtrade(ptradeBean);
        }
        return null;
    }

    @Override
    public PtePtrade savePtradeForm(PtePtradeDomain ptePtradeDomain) throws ApiException {
        String ptradeSeqno = this.savePtrade(ptePtradeDomain);
        PtradeBean ptradeBean = ptePtradeDomain.getPtradeBean();
        if (ptradeBean != null) {
            ptradeBean.setPtradeSeqno(ptradeSeqno);
            return this.commitParticipantByPtradeRe(ptradeBean);
        }
        return null;
    }

    @Override
    public void updatePtradeState(Integer ptradeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePtradeModel(ptradeId, dataState, oldDataState);
    }

    @Override
    public void updatePtrade(PtePtradeDomain ptePtradeDomain) throws ApiException {
        String msg = this.checkPtrade(ptePtradeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtrade.checkPtrade", msg);
        }
        PtePtrade oldPtePtrade = this.getPtradeModelById(ptePtradeDomain.getPtradeId());
        if (null == oldPtePtrade) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtrade.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtePtrade ptePtrade = this.makePtrade(ptePtradeDomain, oldPtePtrade);
        this.setPtradeUpdataDefault(ptePtrade);
        this.updatePtradeModel(ptePtrade);
    }

    @Override
    public PtePtrade getPtrade(Integer ptradeId) {
        return this.getPtradeModelById(ptradeId);
    }

    @Override
    public void deletePtrade(Integer ptradeId) throws ApiException {
        this.deletePtradeModel(ptradeId);
    }

    @Override
    public QueryResult<PtePtrade> queryPtradePage(Map<String, Object> map) {
        List<PtePtrade> ptePtradeList = this.queryPtradeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtrade(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptePtradeList);
        return queryResult;
    }

    public Map<String, Object> setMerchant(PtePtradeInfo ptePtradeinfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PtePtradeParticipantDomain ptePtradeParticipantDomain = this.makePtePtradeParticipant(ptePtradeinfo, ptePtradeinfo.getMerchantCode(), DicactorEnum.SELL_B.getCode());
        map.put(ptePtradeParticipantDomain.getDicActorCode(), ptePtradeParticipantDomain);
        return map;
    }

    private PtePtradeParticipantDomain makePtePtradeParticipant(PtePtrade ptePtrade, String merchantCode, String dicActioCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("merchantCode", merchantCode);
        String code = merchantCode.substring(0, 1);
        String faccountType = StringUtils.isBlank((String)ptePtrade.getMerchantFaccountType()) ? code + "01" : ptePtrade.getMerchantFaccountType();
        pmap.put("faccountType", faccountType);
        pmap.put("tenantCode", ptePtrade.getTenantCode());
        String result = this.internalInvoke("vd.faccountOuter.queryOuterFaccount", pmap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!");
        }
        List vdFaccountOuter = (List)JsonUtil.buildNormalBinder().getJsonToList(result, VdFaccountOuter.class);
        if (ListUtil.isEmpty((Collection)vdFaccountOuter)) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!");
        }
        PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
        ptePtradeParticipantDomain.setTenantCode(((VdFaccountOuter)vdFaccountOuter.get(0)).getTenantCode());
        ptePtradeParticipantDomain.setPartnerCode(ptePtrade.getPartnerCode());
        ptePtradeParticipantDomain.setOpuserCode(merchantCode);
        ptePtradeParticipantDomain.setDicActorCode(dicActioCode);
        ptePtradeParticipantDomain.setFaccountId(((VdFaccountOuter)vdFaccountOuter.get(0)).getFaccountOuterNo());
        ptePtradeParticipantDomain.setFchannelCode("0" + code);
        ptePtradeParticipantDomain.setFchannelClassifyCode(faccountType);
        ptePtradeParticipantDomain.setOrderAmount(ptePtrade.getOrderAmount());
        ptePtradeParticipantDomain.setOrderPortion(ptePtrade.getOrderPortion());
        ptePtradeParticipantDomain.setOrderPrice(ptePtrade.getOrderPrice());
        ptePtradeParticipantDomain.setFaccountName(((VdFaccountOuter)vdFaccountOuter.get(0)).getFaccountOuterName());
        return ptePtradeParticipantDomain;
    }

    private PtePtradeParticipantDomain makePtePtradeParticipant(PtePtradeInfo ptePtradeinfo, String merchantCode, String dicActioCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("merchantCode", merchantCode);
        String fundType = ptePtradeinfo.getFundType();
        if (StringUtils.isBlank((String)fundType)) {
            fundType = "01";
        }
        String code = merchantCode.substring(0, 1);
        String faccountType = StringUtils.isBlank((String)ptePtradeinfo.getFchannelClassifyCode()) ? code + fundType : ptePtradeinfo.getFchannelClassifyCode();
        pmap.put("faccountType", faccountType);
        pmap.put("tenantCode", ptePtradeinfo.getTenantCode());
        String result = this.internalInvoke("vd.faccountOuter.queryOuterFaccount", pmap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!" + ((Object)pmap).toString());
        }
        List vdFaccountOuter = (List)JsonUtil.buildNormalBinder().getJsonToList(result, VdFaccountOuter.class);
        if (ListUtil.isEmpty((Collection)vdFaccountOuter)) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!" + ((Object)pmap).toString());
        }
        PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
        ptePtradeParticipantDomain.setTenantCode(((VdFaccountOuter)vdFaccountOuter.get(0)).getTenantCode());
        ptePtradeParticipantDomain.setPartnerCode(ptePtradeinfo.getPartnerCode());
        ptePtradeParticipantDomain.setPtePtradeType("1");
        ptePtradeParticipantDomain.setOpuserCode(merchantCode);
        ptePtradeParticipantDomain.setDicActorCode(dicActioCode);
        ptePtradeParticipantDomain.setFaccountId(((VdFaccountOuter)vdFaccountOuter.get(0)).getFaccountOuterNo());
        ptePtradeParticipantDomain.setFchannelCode("0" + code);
        ptePtradeParticipantDomain.setFchannelClassifyCode(faccountType);
        ptePtradeParticipantDomain.setFundType(ptePtradeinfo.getFundType());
        ptePtradeParticipantDomain.setOrderAmount(ptePtradeinfo.getOrderAmount());
        ptePtradeParticipantDomain.setOrderPortion(ptePtradeinfo.getOrderPortion());
        ptePtradeParticipantDomain.setOrderPrice(ptePtradeinfo.getOrderPrice());
        ptePtradeParticipantDomain.setFaccountName(((VdFaccountOuter)vdFaccountOuter.get(0)).getFaccountOuterName());
        return ptePtradeParticipantDomain;
    }

    private String checkPtradeBean(PtradeBean ptradeBean) {
        String msg = "";
        if (ptradeBean == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)ptradeBean.getPtradeSeqno())) {
            msg = msg + "ptradeSeqno\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)ptradeBean.getFchannelMode())) {
            msg = msg + "\u6e20\u9053\u6a21\u5f0f\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(ptradeBean.getPartList())) {
            msg = msg + "\u4ea4\u6613\u6e20\u9053\u79df\u4fe1\u606f\u4e3a\u7a7a";
        }
        return msg;
    }

    @Override
    public String commitParticipantByPtrade(PtradeBean ptradeBean) throws ApiException {
        PtePtrade ptePtrade = this.commitParticipantByPtradeRe(ptradeBean);
        if (null != ptePtrade) {
            PtePtradeServiceImpl.getPtradeInfoService().putQueue(ptePtrade);
            return ptePtrade.getPtradeSeqno();
        }
        return null;
    }

    private void makePtePtradeInfoList(List<PtePtradeInfo> ptePtradeInfoList) {
        if (ListUtil.isEmpty(ptePtradeInfoList)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        List participantList = null;
        for (PtePtradeInfo ptePtradeInfo : ptePtradeInfoList) {
            if (ListUtil.isNotEmpty(ptePtradeInfo.getParticipantList())) continue;
            map.put("tenantCode", ptePtradeInfo.getTenantCode());
            map.put("ptradeInfoCode", ptePtradeInfo.getPtradeInfoCode());
            QueryResult<PtePtradeParticipant> queryResult = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
            if (queryResult != null && queryResult.getList() != null && !queryResult.getList().isEmpty()) {
                List list = queryResult.getList();
                participantList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)list), PtePtradeParticipantDomain.class);
            }
            ptePtradeInfo.setParticipantList(participantList);
        }
    }

    @Override
    public PtePtrade commitParticipantByPtradeRe(PtradeBean ptradeBean) throws ApiException {
        String msg = this.checkPtradeBean(ptradeBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PtePtradeServiceImpl.commitParticipantByPtrade.null", msg);
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("ptradeSeqno", ptradeBean.getPtradeSeqno());
        pmap.put("tenantCode", ptradeBean.getTenantCode());
        PtePtrade ptePtrade = this.getPtradeModelByCode(pmap);
        if (null == ptePtrade) {
            throw new ApiException("pte.PtePtradeServiceImpl.commitParticipantByPtrade.null", "\u672a\u83b7\u53d6\u5230\u4ea4\u6613\u4fe1\u606f");
        }
        if (PteConstants.DATA_STATE_0 != ptePtrade.getDataState() && PteConstants.DATA_STATE_1 != ptePtrade.getDataState() && PteConstants.DATA_STATE_2 != ptePtrade.getDataState()) {
            throw new ApiException("pte.PtePtradeServiceImpl.commitParticipantByPtrade.getDataState", "\u91cd\u590d\u63d0\u4ea4");
        }
        String oldExtension = ptePtrade.getExtension();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ptePtrade, (Object)ptradeBean);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.commitParticipantByPtrade.copyAllPropertysNotNull", (Throwable)e);
        }
        List<PtePtradeInfo> ptePtradeInfoList = this.ptePtradeInfoService.queryPtradeInfoByPtraderCode(pmap);
        if (null == ptePtradeInfoList || ptePtradeInfoList.isEmpty()) {
            throw new ApiException("pte.PtePtradeServiceImpl.commitParticipantByPtrade.null", "\u672a\u83b7\u53d6\u5230\u4ea4\u6613\u4fe1\u606f");
        }
        this.makePtePtradeInfoList(ptePtradeInfoList);
        ptePtrade.setPtePtradeInfoList(ptePtradeInfoList);
        if (PteConstants.DATA_STATE_2 == ptePtrade.getDataState()) {
            PayengineForm payengineForm;
            boolean flag = true;
            for (PtePtradeInfo ptePtradeInfo : ptePtradeInfoList) {
                if (this.checkChannel(ptradeBean, ptePtradeInfo, oldExtension)) continue;
                flag = false;
                break;
            }
            if (flag && null != (payengineForm = (PayengineForm)JsonUtil.buildNormalBinder().getJsonToObject(ptePtrade.getPaymentReturnparam(), PayengineForm.class)) && null != payengineForm.getChannelRestForm() && null != payengineForm.getChannelRestForm().getBankHtmlForm() && !StringUtils.isBlank((String)payengineForm.getChannelRestForm().getBankHtmlForm().getHtmlStr())) {
                PteQueryCall.call(ptePtrade.getTenantCode() + "-" + ptePtrade.getPtradeSeqno() + "-" + PteConstants.DATA_STATE_2, JsonUtil.buildNonDefaultBinder().toJson((Object)payengineForm.getChannelRestForm()));
                return ptePtrade;
            }
        }
        if (PteConstants.DATA_STATE_1 == ptePtrade.getDataState()) {
            PayengineForm payengineForm = (PayengineForm)JsonUtil.buildNormalBinder().getJsonToObject(ptePtrade.getPaymentReturnparam(), PayengineForm.class);
            if (null != payengineForm && null != payengineForm.getChannelRestForm() && null != payengineForm.getChannelRestForm().getBankHtmlForm() && !StringUtils.isBlank((String)payengineForm.getChannelRestForm().getBankHtmlForm().getHtmlStr())) {
                PteQueryCall.call(ptePtrade.getTenantCode() + "-" + ptePtrade.getPtradeSeqno() + "-" + PteConstants.DATA_STATE_2, JsonUtil.buildNonDefaultBinder().toJson((Object)payengineForm.getChannelRestForm()));
            }
            return ptePtrade;
        }
        Integer i = this.saveParticippant(ptradeBean, ptePtrade, oldExtension, ptePtradeInfoList);
        if (i == 1) {
            return ptePtrade;
        }
        return null;
    }

    private Integer saveParticippant(PtradeBean ptradeBean, PtePtrade ptePtrade, String oldExtension, List<PtePtradeInfo> ptePtradeInfoList) {
        if (null == ptePtradeInfoList || ptePtradeInfoList.isEmpty() || null == ptradeBean || null == ptePtrade) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticippant.null", "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        List<PtePtradpdeMpgpa> list = this.queryPtradpdeMpgpa(ptePtrade);
        if (list == null || list.size() == 0) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticippant.null", "\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        int xu = 0;
        List<PtePtradeParticipantDomain> partList = ptradeBean.getPartList();
        for (PtePtradeInfo ptePtradeInfo : ptePtradeInfoList) {
            ArrayList<PtePtradeParticipantDomain> participantList = new ArrayList<PtePtradeParticipantDomain>();
            Map<String, Object> paramsMap = this.makeParamsMap(0 == xu ? partList : null, ptePtrade, ptePtradeInfo);
            for (PtePtradpdeMpgpa ptePtradpdeMpgpa : list) {
                PtePtradeParticipantDomain ptePtradeParticipantDomain = this.analysisParticipant(ptePtradpdeMpgpa, paramsMap);
                if (ptePtradeParticipantDomain == null) continue;
                ptePtradeParticipantDomain.setPteSplitFlag(PteConstants.PTE_SPLIT_FLAG_0);
                ptePtradeParticipantDomain.setPtradeSeqno(ptradeBean.getPtradeSeqno());
                participantList.add(ptePtradeParticipantDomain);
            }
            ++xu;
            if (participantList == null || participantList.isEmpty()) {
                throw new ApiException("pte.PtePtradeServiceImpl.commitParticipantByPtrade.makeParticipantList", "\u65e0\u89e3\u6790\u6570\u636e");
            }
            ptePtradeInfo.setParticipantList(participantList);
            this.ptePtradeParticipantService.savePtradeParticipantList(participantList);
        }
        Integer state = PteConstants.DATA_STATE_1;
        SupDisUtil.del((String)("PTEQUERY_CALL-" + ptePtrade.getTenantCode() + "-" + ptePtrade.getPtradeSeqno() + "-2"));
        HashMap<String, Object> setMap = new HashMap<String, Object>();
        setMap.put("dataState", state);
        if (StringUtils.isNotBlank((String)ptradeBean.getFchannelPmodeCode())) {
            setMap.put("fchannelPmodeCode", ptradeBean.getFchannelPmodeCode());
        }
        if (StringUtils.isNotBlank((String)ptradeBean.getOrderShowurl())) {
            setMap.put("orderShowurl", ptradeBean.getOrderShowurl());
        }
        if (StringUtils.isNotBlank((String)ptradeBean.getExtension())) {
            if (StringUtils.isNotBlank((String)oldExtension)) {
                Map extMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(oldExtension, String.class, Object.class);
                Map reExtMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(ptradeBean.getExtension(), String.class, Object.class);
                extMap.putAll(reExtMap);
                setMap.put("extension", JsonUtil.buildNormalBinder().toJson((Object)extMap));
            } else {
                setMap.put("extension", ptradeBean.getExtension());
            }
        }
        if (PteConstants.DATA_STATE_0.equals(ptePtrade.getDataState())) {
            setMap.put("ptradeNotstatus", "0");
        }
        Integer i = this.updatePtradeModelById(ptePtrade.getPtradeId(), ptePtrade.getDataState(), setMap, true);
        return i;
    }

    private boolean checkChannel(PtradeBean ptradeBean, PtePtradeInfo ptePtradeInfo, String oldExtension) {
        if (ptradeBean == null || ptePtradeInfo == null) {
            return false;
        }
        List<PtePtradeParticipantDomain> partList = ptradeBean.getPartList();
        if (partList == null || partList.isEmpty()) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ptradeBean.getTenantCode());
        map.put("ptradeInfoCode", ptePtradeInfo.getPtradeInfoCode());
        QueryResult<PtePtradeParticipant> queryResult = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
        if (queryResult != null && queryResult.getList() != null && !queryResult.getList().isEmpty()) {
            HashMap<String, String> participantMap = new HashMap<String, String>();
            for (PtePtradeParticipant ptePtradeParticipant : queryResult.getList()) {
                participantMap.put(ptePtradeParticipant.getFchannelCode(), ptePtradeParticipant.getOrderAmount() + "");
            }
            for (PtePtradeParticipantDomain ptePtradeParticipantDomain : partList) {
                String amount = (String)participantMap.get(ptePtradeParticipantDomain.getFchannelCode());
                if (StringUtils.isBlank((String)amount)) {
                    return false;
                }
                BigDecimal orderAmount = ptePtradeParticipantDomain.getOrderAmount();
                if (new BigDecimal(amount).compareTo(orderAmount) == 0) continue;
                return false;
            }
        }
        String correlationId = ptePtradeInfo.getTenantCode() + "-" + ptradeBean.getPtradeSeqno() + "-" + PteConstants.DATA_STATE_2;
        String returnStr = DisUtil.getRemot((String)("PTEQUERY_CALL-" + correlationId));
        if (StringUtils.isBlank((String)returnStr)) {
            return false;
        }
        return !StringUtils.isNotBlank((String)oldExtension) || !StringUtils.isNotBlank((String)ptradeBean.getExtension()) || oldExtension.equals(ptradeBean.getExtension());
    }

    @Override
    public void sendPtradeCommit(PtePtrade ptePtrade) {
        if (null == ptePtrade || null == ptePtrade.getPtePtradeInfoList()) {
            return;
        }
        List<PtePtradeInfo> ptePtradeInfoList = ptePtrade.getPtePtradeInfoList();
        for (PtePtradeInfo ptePtradeInfo : ptePtradeInfoList) {
            boolean flag;
            List participantList = ptePtradeInfo.getParticipantList();
            if (null == participantList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("tenantCode", ptePtrade.getTenantCode());
                map.put("ptradeInfoCode", ptePtradeInfo.getPtradeInfoCode());
                QueryResult<PtePtradeParticipant> queryResult = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
                if (queryResult != null && queryResult.getList() != null && !queryResult.getList().isEmpty()) {
                    List list = queryResult.getList();
                    participantList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)list), PtePtradeParticipantDomain.class);
                }
            }
            if (!(flag = this.createFeeParticipant(ptePtrade, participantList))) continue;
            ptePtradeInfo.setParticipantList(participantList);
            this.ptePtradeParticipantService.savePtradeParticipantList(participantList);
        }
        String paymentSeqno = this.sendPatment(ptePtrade, "AN");
        if (StringUtils.isBlank((String)paymentSeqno)) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.sendPatment", "\u64cd\u4f5c\u5931\u8d25");
        }
    }

    private PteFee getPteFeeByCach(String tenantCode, String partnserCode, String merchantCode) {
        String key = tenantCode + "-" + partnserCode + "-" + merchantCode;
        PteFee pteFee = (PteFee)DisUtil.getMapJson((String)PteCachekeyUtil.CACHEKEY_FEE, (String)key, PteFee.class);
        if (null == pteFee) {
            key = tenantCode + "-" + partnserCode + "-" + partnserCode;
            pteFee = (PteFee)DisUtil.getMapJson((String)PteCachekeyUtil.CACHEKEY_FEE, (String)key, PteFee.class);
        }
        return pteFee;
    }

    private BigDecimal calFeevalue(PteFee pteFee, BigDecimal orderAmount) {
        if (pteFee == null || orderAmount == null) {
            return null;
        }
        BigDecimal feeMoney = BigDecimal.ZERO;
        int feeType = pteFee.getFeeType();
        BigDecimal feeValue = pteFee.getFeeValue();
        feeValue = feeValue == null ? BigDecimal.ZERO : feeValue;
        BigDecimal maxValue = pteFee.getMaxValue();
        maxValue = maxValue == null ? BigDecimal.ZERO : maxValue;
        switch (feeType) {
            case 1: {
                break;
            }
            case 2: {
                BigDecimal value = orderAmount.multiply(maxValue).divide(new BigDecimal(100), 2);
                if (feeValue.compareTo(value) == 1) {
                    feeMoney = value;
                    break;
                }
                feeMoney = feeValue;
                break;
            }
            case 3: {
                BigDecimal value = orderAmount.multiply(feeValue).divide(new BigDecimal(100), 2);
                feeMoney = value.compareTo(maxValue) == 1 ? maxValue : value;
            }
        }
        return feeMoney;
    }

    private String getPartnerByCache(String tenantCode, String merchantCode) {
        MmMerberDomain merberDomain = (MmMerberDomain)DisUtil.getMapJson((String)"partnerCache", (String)(tenantCode + "-" + merchantCode), MmMerberDomain.class);
        if (null != merberDomain) {
            return merberDomain.getPartnerCode();
        }
        return null;
    }

    private void setDefaultAtt(PtePtradeParticipantDomain newDomain, PtePtradeParticipantDomain oldDomain) {
        if (newDomain == null || oldDomain == null) {
            return;
        }
        newDomain.setPtradeInfoCode(oldDomain.getPtradeInfoCode());
        newDomain.setFaccountIdType(oldDomain.getFaccountIdType());
        newDomain.setFundType(oldDomain.getFundType());
        newDomain.setOrderCurrency(oldDomain.getOrderCurrency());
        newDomain.setOrderPortion(oldDomain.getOrderPortion());
        newDomain.setOrderPrice(oldDomain.getOrderPrice());
    }

    private boolean createFeeParticipant(PtePtrade ptePtrade, List<PtePtradeParticipantDomain> list) {
        try {
            String parentPartnerCode;
            if (ptePtrade == null || list == null) {
                return false;
            }
            if (!PtradpdeEnum.TRANSFER.getCode().equals(ptePtrade.getPtradpdeCode())) {
                return false;
            }
            PtePtrade newPteptrade = new PtePtrade();
            BeanUtils.copyAllPropertys((Object)newPteptrade, (Object)ptePtrade);
            String partnerCode = newPteptrade.getPartnerCode();
            String merchantCode = newPteptrade.getMerchantCode();
            PteFee pteFee = this.getPteFeeByCach(newPteptrade.getTenantCode(), partnerCode, merchantCode);
            BigDecimal feeMoney = this.calFeevalue(pteFee, newPteptrade.getOrderAmount());
            boolean flag = false;
            if (feeMoney != null && !feeMoney.equals(BigDecimal.ZERO)) {
                PtePtradeParticipantDomain domain = list.get(0);
                PtePtradeParticipantDomain sellfeeDomain = this.makePtePtradeParticipant(ptePtrade, merchantCode, DicactorEnum.SELLFEE.getCode());
                sellfeeDomain.setPteSplitFlag(PteConstants.PTE_SPLIT_FLAG_1);
                sellfeeDomain.setPtradeSeqno(ptePtrade.getPtradeSeqno());
                sellfeeDomain.setOrderAmount(feeMoney);
                this.setDefaultAtt(sellfeeDomain, domain);
                list.add(sellfeeDomain);
                PtePtradeParticipantDomain partnerDomain = this.makePtePtradeParticipant(ptePtrade, partnerCode, DicactorEnum.PARTNER.getCode());
                partnerDomain.setOrderAmount(feeMoney);
                partnerDomain.setPtradeSeqno(ptePtrade.getPtradeSeqno());
                partnerDomain.setPteSplitFlag(PteConstants.PTE_SPLIT_FLAG_1);
                this.setDefaultAtt(partnerDomain, domain);
                list.add(partnerDomain);
                flag = true;
            }
            if (StringUtils.isNotBlank((String)(parentPartnerCode = this.getPartnerByCache(newPteptrade.getTenantCode(), partnerCode))) && !parentPartnerCode.equals(partnerCode)) {
                newPteptrade.setPartnerCode(parentPartnerCode);
                newPteptrade.setMerchantCode(partnerCode);
                flag = this.createFeeParticipant(newPteptrade, list);
            }
            return flag;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String sendPatment(PtePtrade ptePtrade, String paymentType) {
        if (ptePtrade.getPtePtradeInfoList() == null || ptePtrade.getPtePtradeInfoList().isEmpty() || ptePtrade == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        List<PtePtradeInfo> ptePtradeInfoList = ptePtrade.getPtePtradeInfoList();
        PePaymentDomain pePaymentDomain = new PePaymentDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pePaymentDomain, (Object)ptePtrade);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.e", (Throwable)e);
        }
        if (StringUtils.isBlank((String)paymentType)) {
            paymentType = "AN";
        }
        pePaymentDomain.setPaymentType(paymentType);
        pePaymentDomain.setPaymentOldseqno(ptePtrade.getPaymentSeqno());
        pePaymentDomain.setPaymentReturnurl("pte.ptradeBase.sendCallBack");
        pePaymentDomain.setPartnerCode(ptePtrade.getPartnerCode());
        pePaymentDomain.setFchannelPmodeCode(ptePtrade.getFchannelPmodeCode());
        pePaymentDomain.setPaymentSeqno(null);
        pePaymentDomain.setDataState(null);
        ArrayList<PePaymentOrderDomain> orderDomainList = new ArrayList<PePaymentOrderDomain>();
        pePaymentDomain.setOrderDomainList(orderDomainList);
        PePaymentOrderDomain pePaymentOrderDomain = new PePaymentOrderDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pePaymentOrderDomain, (Object)ptePtrade);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.e1", (Throwable)e);
        }
        PtePtradpdeMpg ptePtradpdeMpg = (PtePtradpdeMpg)DisUtil.getMapJson((String)"ptePtradpdeMpg_key", (String)(ptePtrade.getTenantCode() + "-" + ptePtrade.getPtradpdeCode()), PtePtradpdeMpg.class);
        if (null == ptePtradpdeMpg) {
            ptePtradpdeMpg = (PtePtradpdeMpg)DisUtil.getMapJson((String)"ptePtradpdeMpg_key", (String)("00000000-" + ptePtrade.getPtradpdeCode()), PtePtradpdeMpg.class);
        }
        pePaymentOrderDomain.setDicPaypdCode(ptePtradpdeMpg.getDicPaypdCode());
        pePaymentOrderDomain.setPaymentOrderMemo(ptePtrade.getPaymentMemo());
        pePaymentOrderDomain.setPtradpdeCode(ptePtrade.getPtradpdeCode());
        pePaymentOrderDomain.setPaymentSeqno(null);
        orderDomainList.add(pePaymentOrderDomain);
        ArrayList<PePaymentParticipantDomain> participantDomainList = new ArrayList<PePaymentParticipantDomain>();
        pePaymentOrderDomain.setParticipantDomainList(participantDomainList);
        for (PtePtradeInfo ptePtradeInfo : ptePtradeInfoList) {
            if (null == ptePtradeInfo || ListUtil.isEmpty(ptePtradeInfo.getParticipantList())) {
                throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.ptePtradeInfo", JsonUtil.buildNormalBinder().toJson((Object)ptePtrade));
            }
            for (PtePtradeParticipantDomain ptePtradeParticipantDomain : ptePtradeInfo.getParticipantList()) {
                PePaymentParticipantDomain p1 = new PePaymentParticipantDomain();
                try {
                    pePaymentOrderDomain.setOrderCurrency(ptePtradeParticipantDomain.getOrderCurrency());
                    BeanUtils.copyAllPropertys((Object)p1, (Object)ptePtradeParticipantDomain);
                }
                catch (Exception e) {
                    throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.e2", (Throwable)e);
                }
                participantDomainList.add(p1);
            }
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pePaymentDomain", JsonUtil.buildNormalBinder().toJson((Object)pePaymentDomain));
        return this.internalInvoke("pe.paymentEngine.sendPayment", paramMap);
    }

    private Map<String, Object> makeParamsMap(List<PtePtradeParticipantDomain> partList, PtePtrade ptePtrade, PtePtradeInfo ptePtradeinfo) {
        Map<String, Object> smap;
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        String ptradeExtension = ptePtrade.getPtradeExtension();
        if (StringUtils.isNotBlank((String)ptradeExtension)) {
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(ptradeExtension, String.class, PtePtradeParticipantDomain.class);
            paramsMap.putAll(map);
        }
        if (null != (smap = this.setMerchant(ptePtradeinfo)) && !smap.isEmpty()) {
            paramsMap.putAll(smap);
        }
        BigDecimal orderAmount = ptePtrade.getOrderAmount();
        BigDecimal tradeAmonut = new BigDecimal(0);
        if (null != partList && !partList.isEmpty()) {
            for (PtePtradeParticipantDomain ptradePartBean : partList) {
                ptradePartBean.setPtePtradeType("0");
                paramsMap.put(ptradePartBean.getDicActorCode(), ptradePartBean);
                tradeAmonut = tradeAmonut.add(ptradePartBean.getOrderAmount());
            }
            String check = "";
            check = PtePtradeServiceImpl.getCheck(ptePtrade.getTenantCode(), "check", "check");
            if (StringUtils.isBlank((String)check) && PtradpdeEnum.PAYMENT.getCode().equals(ptePtrade.getPtradpdeCode()) && orderAmount.compareTo(tradeAmonut) != 0) {
                throw new ApiException("pte.PtePtradeServiceImpl.makeParamsMap \u3010amount not same\u3011", "\u652f\u4ed8\u91d1\u989d\u4e0e\u8ba2\u5355\u91d1\u989d\u4e0d\u543b\u5408");
            }
        }
        paramsMap.put(PtePtrade.class.getSimpleName(), ptePtrade);
        paramsMap.put(PtePtradeInfo.class.getSimpleName(), ptePtradeinfo);
        return paramsMap;
    }

    public static String getCheck(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    private PtePtradeParticipantDomain analysisParticipant(PtePtradpdeMpgpa ptePtradpdeMpgpa, Map<String, Object> paramsMap) {
        if (ptePtradpdeMpgpa == null || paramsMap == null || paramsMap.isEmpty()) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtrade.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        PtePtradeParticipantDomain domain = new PtePtradeParticipantDomain();
        try {
            List<PtePtfchannel> fchannel;
            String dicActorCode = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaActor(), paramsMap);
            if (StringUtils.isBlank((String)dicActorCode)) {
                return null;
            }
            BigDecimal orderAmount = (BigDecimal)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaAmount(), paramsMap);
            if (orderAmount == null) {
                return null;
            }
            String faccountIdType = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFatype(), paramsMap);
            String faccountId = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFaid(), paramsMap);
            String faccountName = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFaname(), paramsMap);
            String faccountBranch = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFabranch(), paramsMap);
            String faccountProvince = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFaprovince(), paramsMap);
            String faccountCity = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFacity(), paramsMap);
            String faccountLocation = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFalocation(), paramsMap);
            String opuserCode = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaUcode(), paramsMap);
            String fchannelCode = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFchannel(), paramsMap);
            String fchannelClassifyCode = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFcclassify(), paramsMap);
            String fundType = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaFund(), paramsMap);
            BigDecimal orderPrice = (BigDecimal)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaPrice(), paramsMap);
            BigDecimal orderPortion = (BigDecimal)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaPortion(), paramsMap);
            String orderCurrency = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaCurrency(), paramsMap);
            String ptePtradeType = (String)ScriptUtil.evel((String)ptePtradpdeMpgpa.getPtradpdeMpgpaType(), paramsMap);
            if (StringUtils.isBlank((String)ptePtradeType)) {
                ptePtradeType = "0";
            }
            domain.setDicActorCode(dicActorCode);
            domain.setPtePtradeType(ptePtradeType);
            domain.setOrderAmount(orderAmount);
            domain.setFaccountId(faccountId);
            domain.setFaccountIdType(faccountIdType);
            domain.setFchannelCode(fchannelCode);
            domain.setFchannelClassifyCode(fchannelClassifyCode);
            domain.setFundType(StringUtils.isBlank((String)fundType) ? "01" : fundType);
            domain.setOrderCurrency(orderCurrency);
            domain.setOrderPortion(null == orderPortion ? BigDecimal.ZERO : orderPortion);
            domain.setOrderPrice(null == orderPrice ? BigDecimal.ZERO : orderPrice);
            domain.setFaccountName(faccountName);
            domain.setFaccountBranch(faccountBranch);
            domain.setFaccountProvince(faccountProvince);
            domain.setFaccountCity(faccountCity);
            domain.setFaccountLocation(faccountLocation);
            PtePtradeInfo ptePtradeInfo = (PtePtradeInfo)paramsMap.get(PtePtradeInfo.class.getSimpleName());
            domain.setPtradeInfoCode(ptePtradeInfo.getPtradeInfoCode());
            domain.setTenantCode(ptePtradeInfo.getTenantCode());
            domain.setPartnerCode(ptePtradeInfo.getPartnerCode());
            domain.setOpuserCode(opuserCode);
            if (DicactorEnum.BANK.getCode().equals(dicActorCode) && ListUtil.isNotEmpty(fchannel = this.ptePtfchannelService.queryPtfchannelReList(this.getQueryParamMap("tenantCode,fchannelCode", new Object[]{ptePtradeInfo.getTenantCode(), fchannelCode})))) {
                domain.setFchannelFee(fchannel.get(0).getFchannelFee());
            }
            if (StringUtils.isNotBlank((String)ptePtradpdeMpgpa.getPtradpdeExt())) {
                Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(ptePtradpdeMpgpa.getPtradpdeExt(), String.class, String.class);
                Set set = map.keySet();
                for (String key : set) {
                    String value = (String)map.get(key);
                    try {
                        String methodName = key.substring(0, 1).toUpperCase() + key.substring(1);
                        Method method = domain.getClass().getMethod("set" + methodName, String.class);
                        method.invoke((Object)domain, (String)ScriptUtil.evel((String)value, paramsMap));
                    }
                    catch (Exception e) {
                        this.logger.error("pte.PtePtradeServiceImpl.analysisParticipant", (Object)(key + "\u5c5e\u6027\u8bbe\u7f6e\u5931\u8d25"));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.analysisParticipant", "\u89e3\u6790\u9519\u8bef", (Throwable)e);
        }
        return domain;
    }

    private List<PtePtradpdeMpgpa> queryPtradpdeMpgpa(PtePtrade ptradeBean) {
        if (ptradeBean == null) {
            return null;
        }
        PtePtradpdeMpg ptePtradpdeMpg = (PtePtradpdeMpg)DisUtil.getMapJson((String)"ptePtradpdeMpg_key", (String)(ptradeBean.getTenantCode() + "-" + ptradeBean.getPtradpdeCode()), PtePtradpdeMpg.class);
        if (null == ptePtradpdeMpg) {
            ptePtradpdeMpg = (PtePtradpdeMpg)DisUtil.getMapJson((String)"ptePtradpdeMpg_key", (String)("00000000-" + ptradeBean.getPtradpdeCode()), PtePtradpdeMpg.class);
        }
        if (ptePtradpdeMpg == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.queryPtradpdeMpgpa.getPtradpdeMpgByCode", "\u6570\u636e\u4e3a\u7a7a" + ptradeBean.getPtradpdeCode());
        }
        List list = DisUtil.getMapListJson((String)"ptePtradpdeMpgpa_key", (String)(ptradeBean.getTenantCode() + "-" + ptePtradpdeMpg.getPtradpdeMpgCode()), PtePtradpdeMpgpa.class);
        if (ListUtil.isEmpty((Collection)list)) {
            list = DisUtil.getMapListJson((String)"ptePtradpdeMpgpa_key", (String)("00000000-" + ptePtradpdeMpg.getPtradpdeMpgCode()), PtePtradpdeMpgpa.class);
        }
        if (list == null || list.isEmpty()) {
            throw new ApiException("pte.PtePtradeServiceImpl.queryPtradpdeMpgpa.queryPtradpdeMpgpaPage1", "\u6570\u636e\u4e3a\u7a7a" + ptePtradpdeMpg.getPtradpdeMpgCode());
        }
        return list;
    }

    @Override
    public String getGateway(PtradeBean ptradeBean) {
        if (ptradeBean == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.getGateway.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String returnparam = "";
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("ptradeSeqno", ptradeBean.getPtradeSeqno());
        pmap.put("tenantCode", ptradeBean.getTenantCode());
        PtePtrade ptePtrade = this.getPtradeModelByCode(pmap);
        if (null == ptePtrade) {
            throw new ApiException("pte.PtePtradeServiceImpl.getGateway.null", "\u672a\u83b7\u53d6\u5230\u4ea4\u6613\u4fe1\u606f");
        }
        if (PteConstants.DATA_STATE_1 == ptePtrade.getDataState()) {
            returnparam = this.getCachStrByThread(ptradeBean.getTenantCode() + "-" + ptradeBean.getPtradeSeqno() + "-" + PteConstants.DATA_STATE_2, 10000L);
        } else if (PteConstants.DATA_STATE_2 == ptePtrade.getDataState()) {
            returnparam = ptePtrade.getPaymentReturnparam();
        } else {
            throw new ApiException("pte.PtePtradeServiceImpl.getGateway.stateError", "\u72b6\u6001\u4fe1\u606f\u6709\u8bef");
        }
        return returnparam;
    }

    private Map<String, PtePtradeParticipant> makeBackParticipant(PtePtrade ptePtrade, PtradeBackBean ptradeBackBean) {
        if (null == ptePtrade) {
            return null;
        }
        String businessOrder = ptradeBackBean.getBusinessOrder();
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("ptradeOldseqno", ptePtrade.getPtradeSeqno());
        pmap.put("tenantCode", ptePtrade.getTenantCode());
        pmap.put("dataStateStr", "3,4,5");
        List<PtePtrade> relist = this.queryPtradeModelPage(pmap);
        if (ListUtil.isEmpty(relist)) {
            return null;
        }
        if (null == ptePtrade.getOrderAmount()) {
            ptePtrade.setOrderAmount(BigDecimal.ZERO);
        }
        BigDecimal backAmt = BigDecimal.ZERO;
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, PtePtradeParticipant> remap = new HashMap<String, PtePtradeParticipant>();
        for (PtePtrade backPtePtrade : relist) {
            PtePtradeParticipant oldPtePtradeParticipant;
            QueryResult<PtePtradeParticipant> rsQueryResult;
            if (StringUtils.isBlank((String)ptePtrade.getPtradeBatchno())) {
                if (null == backPtePtrade.getOrderAmount()) {
                    backPtePtrade.setOrderAmount(BigDecimal.ZERO);
                }
                backAmt = backAmt.add(backPtePtrade.getOrderAmount());
                map.put("ptradeSeqno", backPtePtrade.getPtradeSeqno());
                map.put("tenantCode", backPtePtrade.getTenantCode());
                rsQueryResult = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
                if (rsQueryResult == null || rsQueryResult.getList().size() == 0) {
                    throw new ApiException("pte.PtePtradeServiceImpl.makeBackParticipant.rsQueryResult", ((Object)map).toString());
                }
                for (PtePtradeParticipant ptePtradeParticipant : rsQueryResult.getList()) {
                    if (null == ptePtradeParticipant.getOrderAmount()) {
                        ptePtradeParticipant.setOrderAmount(BigDecimal.ZERO);
                    }
                    if (null == (oldPtePtradeParticipant = (PtePtradeParticipant)remap.get(ptePtradeParticipant.getDicActorCode()))) {
                        oldPtePtradeParticipant = ptePtradeParticipant;
                        remap.put(ptePtradeParticipant.getDicActorCode(), oldPtePtradeParticipant);
                        continue;
                    }
                    if (null == oldPtePtradeParticipant.getOrderAmount()) {
                        oldPtePtradeParticipant.setOrderAmount(BigDecimal.ZERO);
                    }
                    oldPtePtradeParticipant.setOrderAmount(oldPtePtradeParticipant.getOrderAmount().add(ptePtradeParticipant.getOrderAmount()));
                }
                continue;
            }
            boolean flag = false;
            if (StringUtils.isNotBlank((String)businessOrder) && businessOrder.equals(backPtePtrade.getBusinessOrder())) {
                flag = true;
            }
            if (null == backPtePtrade.getOrderAmount()) {
                backPtePtrade.setOrderAmount(BigDecimal.ZERO);
            }
            backAmt = backAmt.add(backPtePtrade.getOrderAmount());
            map.put("ptradeSeqno", backPtePtrade.getPtradeSeqno());
            map.put("tenantCode", backPtePtrade.getTenantCode());
            rsQueryResult = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
            if (rsQueryResult == null || rsQueryResult.getList().size() == 0) {
                throw new ApiException("pte.PtePtradeServiceImpl.makeBackParticipant.rsQueryResult", ((Object)map).toString());
            }
            for (PtePtradeParticipant ptePtradeParticipant : rsQueryResult.getList()) {
                if (!flag && !"BANK".equals(ptePtradeParticipant.getDicActorCode()) && !"BUY_B".equals(ptePtradeParticipant.getDicActorCode())) continue;
                if (null == ptePtradeParticipant.getOrderAmount()) {
                    ptePtradeParticipant.setOrderAmount(BigDecimal.ZERO);
                }
                if (null == (oldPtePtradeParticipant = (PtePtradeParticipant)remap.get(ptePtradeParticipant.getDicActorCode()))) {
                    oldPtePtradeParticipant = ptePtradeParticipant;
                    remap.put(ptePtradeParticipant.getDicActorCode(), oldPtePtradeParticipant);
                    continue;
                }
                if (null == oldPtePtradeParticipant.getOrderAmount()) {
                    oldPtePtradeParticipant.setOrderAmount(BigDecimal.ZERO);
                }
                oldPtePtradeParticipant.setOrderAmount(oldPtePtradeParticipant.getOrderAmount().add(ptePtradeParticipant.getOrderAmount()));
            }
        }
        ptePtrade.setOrderAmount(ptePtrade.getOrderAmount().subtract(backAmt));
        return remap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String saveParticipantByPtradeBack(PtradeBackBean ptradeBackBean) throws ApiException {
        if (null == ptradeBackBean) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)ptradeBackBean.getAcquireSeqno())) {
            ptradeBackBean.setAcquireSeqno(ptradeBackBean.getBusinessOrderno());
        }
        if (null == ptradeBackBean.getAcquireSeqno()) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.null", "\u9000\u56de\u4e1a\u52a1\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (null == ptradeBackBean.getPtradpdeCode()) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.null", "\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((String)ptradeBackBean.getAcquireSeqno_new())) {
            ptradeBackBean.setAcquireSeqno_new(ptradeBackBean.getRefundOrderno());
        }
        if (null == ptradeBackBean.getAcquireSeqno_new()) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.null", "\u65b0\u8ba2\u5355\u7f16\u7801\u4e3a\u7a7a\uff01");
        }
        String backAmountType = ptradeBackBean.getBackAmountType();
        if (StringUtils.isBlank((String)backAmountType)) {
            backAmountType = "0";
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("ptradeSeqno", ptradeBackBean.getPtradeSeqno());
        pmap.put("tenantCode", ptradeBackBean.getTenantCode());
        PtePtrade ptePtrade = this.getPtradeByCode(pmap);
        if (null == ptePtrade) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.ptePtrade", ((Object)pmap).toString());
        }
        ptePtrade.setPtradeOldseqno(ptradeBackBean.getPtradeSeqno());
        if (StringUtils.isNotBlank((String)ptradeBackBean.getExtension())) {
            ptePtrade.setExtension(ptradeBackBean.getExtension());
        }
        Map<String, PtePtradeParticipant> backmap = this.makeBackParticipant(ptePtrade, ptradeBackBean);
        BigDecimal allMoney = ptePtrade.getOrderAmount();
        if (allMoney.compareTo(BigDecimal.ZERO) <= 0) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.allMoney", ((Object)pmap).toString());
        }
        pmap.clear();
        pmap.put("tenantCode", ptradeBackBean.getTenantCode());
        pmap.put("ptradeSeqno", ptePtrade.getPtradeSeqno());
        QueryResult<PtePtradeInfo> qRptePtradeInfo = this.ptePtradeInfoService.queryPtradeInfoPage(pmap);
        if (qRptePtradeInfo == null || qRptePtradeInfo.getList().size() == 0) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.qRptePtradeInfo", ((Object)pmap).toString());
        }
        PtePtradeInfo ptePtradeInfoRel = null;
        String checkMsg = this.checkAllowRefund(ptePtrade);
        if (StringUtils.isNotBlank((String)checkMsg)) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.checkAllowRefund", "\u8be5\u8ba2\u5355\u4e0d\u5141\u8bb8\u9000\u6b3e\u3010" + checkMsg + "\u3011");
        }
        ptePtrade.setGmtPaid(null);
        ptePtrade.setGmtCreate(null);
        ptePtrade.setPtradeSeqno(null);
        ptePtrade.setPtradeId(null);
        ptePtrade.setPtradpdeCode(ptradeBackBean.getPtradpdeCode());
        if (ptradeBackBean.getOrderAmount() != null && ptradeBackBean.getOrderAmount().compareTo(BigDecimal.ZERO) == 1 && ptradeBackBean.getOrderAmount().compareTo(ptePtrade.getOrderAmount()) == -1) {
            ptePtrade.setOrderAmount(ptradeBackBean.getOrderAmount());
        }
        ptePtrade.setAcquireSeqno(ptradeBackBean.getAcquireSeqno_new());
        ptePtrade.setPtradeType(PtradpdeTypeEnum.PAYMENTBACK.getName());
        this.setPtradeDefault(ptePtrade);
        ptePtrade.setDataState(PteConstants.DATA_STATE_1);
        ptePtrade.setPaymentNotifyurl(ptradeBackBean.getPaymentNotifyurl());
        ptePtrade.setBusinessOrder(ptradeBackBean.getBusinessOrder());
        ptePtrade.setBusinessOrderno(ptradeBackBean.getAcquireSeqno_new());
        ptePtrade.setBusinessType(ptradeBackBean.getBusinessType());
        ArrayList<PtePtradeInfo> ptePtradeInfoList = new ArrayList<PtePtradeInfo>();
        PtePtradeInfo ptePtradeInfo = new PtePtradeInfo();
        ptePtradeInfoList.add(ptePtradeInfo);
        PtePtradeInfoDomain ptePtradeInfoDomain = new PtePtradeInfoDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeInfoDomain, (Object)ptePtrade);
            BeanUtils.copyAllPropertys((Object)ptePtradeInfo, (Object)ptePtrade);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack", (Throwable)e);
        }
        String ptePtradeInfoCode = this.ptePtradeInfoService.savePtradeInfo(ptePtradeInfoDomain);
        PtePtradeInfo oldPtePtradeInfo = (PtePtradeInfo)qRptePtradeInfo.getList().get(0);
        String oldptePtradeInfoCode = oldPtePtradeInfo.getPtradeInfoCode();
        ArrayList<PtePtradeParticipantDomain> participantList = new ArrayList<PtePtradeParticipantDomain>();
        ArrayList<PtePtradeParticipantDomain> sellparticipantList = new ArrayList<PtePtradeParticipantDomain>();
        ArrayList<PtePtradeParticipantDomain> buyparticipantList = new ArrayList<PtePtradeParticipantDomain>();
        Map<Object, Object> partMap = new HashMap();
        PtePtradeParticipant bankOrderAmount = null;
        if (ptradeBackBean.getPartList() == null || ptradeBackBean.getPartList().size() == 0) {
            QueryResult<PtePtradeParticipant> rs;
            HashMap<String, Object> map;
            ArrayList ptePtradeParticipantList = new ArrayList();
            boolean flag = true;
            ptePtradeInfoRel = oldPtePtradeInfo;
            if (StringUtils.isNotBlank((String)ptePtrade.getPtradeBatchno())) {
                for (PtePtradeInfo ptePtradeInfo1 : qRptePtradeInfo.getList()) {
                    if (!ptePtradeInfo1.getBusinessOrder().equals(ptradeBackBean.getBusinessOrder()) || !ptePtradeInfo1.getBusinessOrderno().equals(ptradeBackBean.getBusinessOrderno())) continue;
                    ptePtradeInfoRel = ptePtradeInfo1;
                    flag = false;
                }
            }
            if (!flag) {
                map = new HashMap<String, Object>();
                map.put("ptradeInfoCode", oldptePtradeInfoCode);
                map.put("ptePtradeType", "0");
                map.put("tenantCode", ptradeBackBean.getTenantCode());
                rs = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
                if (rs == null || rs.getList().size() == 0) {
                    throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.rs", ((Object)map).toString());
                }
                ptePtradeParticipantList.addAll(rs.getList());
                map.put("ptradeInfoCode", ptePtradeInfoRel.getPtradeInfoCode());
                map.remove("ptePtradeType");
                QueryResult<PtePtradeParticipant> allrs = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
                if (allrs == null || allrs.getList().size() == 0) {
                    throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.rs", ((Object)map).toString());
                }
                ptePtradeParticipantList.addAll(allrs.getList());
            } else {
                map = new HashMap();
                map.put("ptradeInfoCode", oldptePtradeInfoCode);
                map.put("tenantCode", ptradeBackBean.getTenantCode());
                rs = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
                if (rs == null || rs.getList().size() == 0) {
                    throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.rs3", ((Object)map).toString());
                }
                ptePtradeParticipantList.addAll(rs.getList());
            }
            boolean devflag = false;
            if (null == ptePtrade.getOrderAmount()) {
                ptePtrade.setOrderAmount(BigDecimal.ZERO);
            }
            if (ptePtrade.getOrderAmount().compareTo(allMoney) != 0) {
                devflag = true;
            }
            BigDecimal refundMoney = ptePtrade.getOrderAmount();
            partMap = this.makePact(ptePtradeParticipantList, backmap, backAmountType, refundMoney);
            bankOrderAmount = (PtePtradeParticipant)partMap.remove("bankOrderAmount");
            if (MapUtil.isEmpty(partMap)) {
                throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.partMap", "\u6ca1\u6709\u53ef\u9000\u6b3e\u91d1\u989d");
            }
            BigDecimal sellsun = ptePtrade.getOrderAmount();
            BigDecimal sellnomoney = BigDecimal.ZERO;
            BigDecimal buysun = ptePtrade.getOrderAmount();
            BigDecimal buynomoney = BigDecimal.ZERO;
            if (devflag) {
                if ("0".equals(backAmountType)) {
                    PtePtradeParticipantDomain domain;
                    PtePtradeParticipant ptePtradeParticipant;
                    void var32_42;
                    String buyStr = "";
                    String string = "";
                    for (String string2 : partMap.keySet()) {
                        if (string2.indexOf("SELL_") >= 0) {
                            void var32_44;
                            if (StringUtils.isNotBlank((String)var32_42)) {
                                String string3 = (String)var32_42 + ",";
                            }
                            String string4 = (String)var32_44 + string2;
                            continue;
                        }
                        if (StringUtils.isNotBlank((String)buyStr)) {
                            buyStr = buyStr + ",";
                        }
                        buyStr = buyStr + string2;
                    }
                    for (String keys : buyStr.split(",")) {
                        ptePtradeParticipant = (PtePtradeParticipant)partMap.remove(keys);
                        if (null != ptePtradeParticipant) {
                            domain = this.makeBackDomain(ptePtrade, ptePtradeInfoCode, ptePtradeParticipant);
                            buynomoney = domain.getOrderAmount().divide(allMoney, 2, 6).multiply(ptePtrade.getOrderAmount());
                            domain.setOrderAmount(buynomoney);
                            buysun = buysun.subtract(buynomoney);
                            buyparticipantList.add(domain);
                        }
                        if (buysun.compareTo(BigDecimal.ZERO) <= 0) break;
                    }
                    for (String keys : var32_42.split(",")) {
                        ptePtradeParticipant = (PtePtradeParticipant)partMap.remove(keys);
                        if (null != ptePtradeParticipant) {
                            domain = this.makeBackDomain(ptePtrade, ptePtradeInfoCode, ptePtradeParticipant);
                            sellnomoney = domain.getOrderAmount().divide(allMoney, 2, 6).multiply(ptePtrade.getOrderAmount());
                            domain.setOrderAmount(sellnomoney);
                            sellsun = sellsun.subtract(sellnomoney);
                            sellparticipantList.add(domain);
                        }
                        if (sellsun.compareTo(BigDecimal.ZERO) > 0) {
                            continue;
                        }
                        break;
                    }
                } else if ("1".equals(backAmountType)) {
                    PtePtradeParticipantDomain domain;
                    PtePtradeParticipant ptePtradeParticipant;
                    void var32_47;
                    String buyStr = "";
                    String string = "";
                    for (String string5 : partMap.keySet()) {
                        void var32_49;
                        if (string5.indexOf("BUY_") >= 0) {
                            if (StringUtils.isNotBlank((String)buyStr)) {
                                buyStr = buyStr + ",";
                            }
                            buyStr = buyStr + string5;
                            continue;
                        }
                        if (string5.indexOf("SELL_") < 0) continue;
                        if (StringUtils.isNotBlank((String)var32_47)) {
                            String string6 = (String)var32_47 + ",";
                        }
                        String string7 = (String)var32_49 + string5;
                    }
                    for (String keys : buyStr.split(",")) {
                        ptePtradeParticipant = (PtePtradeParticipant)partMap.remove(keys);
                        if (null != ptePtradeParticipant) {
                            domain = this.makeBackDomain(ptePtrade, ptePtradeInfoCode, ptePtradeParticipant);
                            buynomoney = ptePtradeParticipant.getOrderAmount();
                            domain.setOrderAmount(buynomoney);
                            buysun = buysun.subtract(buynomoney);
                            buyparticipantList.add(domain);
                        }
                        if (buysun.compareTo(BigDecimal.ZERO) <= 0) break;
                    }
                    if (buysun.compareTo(BigDecimal.ZERO) > 0 && null != (ptePtradeParticipant = (PtePtradeParticipant)partMap.remove("BANK"))) {
                        domain = this.makeBackDomain(ptePtrade, ptePtradeInfoCode, ptePtradeParticipant);
                        buynomoney = ptePtradeParticipant.getOrderAmount();
                        domain.setOrderAmount(buynomoney);
                        buysun = buysun.subtract(buynomoney);
                        buyparticipantList.add(domain);
                    }
                    for (String keys : var32_47.split(",")) {
                        ptePtradeParticipant = (PtePtradeParticipant)partMap.remove(keys);
                        if (null != ptePtradeParticipant) {
                            domain = this.makeBackDomain(ptePtrade, ptePtradeInfoCode, ptePtradeParticipant);
                            sellnomoney = domain.getOrderAmount().divide(allMoney, 2, 6).multiply(ptePtrade.getOrderAmount());
                            domain.setOrderAmount(sellnomoney);
                            sellsun = sellsun.subtract(sellnomoney);
                            sellparticipantList.add(domain);
                        }
                        if (sellsun.compareTo(BigDecimal.ZERO) > 0) {
                            continue;
                        }
                        break;
                    }
                } else if ("2".equals(backAmountType)) {
                    PtePtradeParticipantDomain domain;
                    void var32_52;
                    String buyStr = "";
                    String string = "";
                    for (String string8 : partMap.keySet()) {
                        void var32_54;
                        if (string8.indexOf("SELL_") < 0) {
                            if (StringUtils.isNotBlank((String)buyStr)) {
                                buyStr = buyStr + ",";
                            }
                            buyStr = buyStr + string8;
                            continue;
                        }
                        if (string8.indexOf("SELL_") < 0) continue;
                        if (StringUtils.isNotBlank((String)var32_52)) {
                            String string9 = (String)var32_52 + ",";
                        }
                        String string10 = (String)var32_54 + string8;
                    }
                    PtePtradeParticipant ptePtradeParticipant = (PtePtradeParticipant)partMap.remove("BANK");
                    if (null != ptePtradeParticipant) {
                        domain = this.makeBackDomain(ptePtrade, ptePtradeInfoCode, ptePtradeParticipant);
                        buynomoney = ptePtradeParticipant.getOrderAmount();
                        domain.setOrderAmount(buynomoney);
                        buysun = buysun.subtract(buynomoney);
                        buyparticipantList.add(domain);
                    }
                    if (buysun.compareTo(BigDecimal.ZERO) > 0) {
                        for (String keys : buyStr.split(",")) {
                            ptePtradeParticipant = (PtePtradeParticipant)partMap.remove(keys);
                            if (null != ptePtradeParticipant) {
                                domain = this.makeBackDomain(ptePtrade, ptePtradeInfoCode, ptePtradeParticipant);
                                buynomoney = ptePtradeParticipant.getOrderAmount();
                                domain.setOrderAmount(buynomoney);
                                buysun = buysun.subtract(buynomoney);
                                buyparticipantList.add(domain);
                            }
                            if (buysun.compareTo(BigDecimal.ZERO) <= 0) break;
                        }
                    }
                    for (String keys : var32_52.split(",")) {
                        ptePtradeParticipant = (PtePtradeParticipant)partMap.remove(keys);
                        if (null != ptePtradeParticipant) {
                            domain = this.makeBackDomain(ptePtrade, ptePtradeInfoCode, ptePtradeParticipant);
                            sellnomoney = domain.getOrderAmount().divide(allMoney, 2, 6).multiply(ptePtrade.getOrderAmount());
                            domain.setOrderAmount(sellnomoney);
                            sellsun = sellsun.subtract(sellnomoney);
                            sellparticipantList.add(domain);
                        }
                        if (sellsun.compareTo(BigDecimal.ZERO) > 0) {
                            continue;
                        }
                        break;
                    }
                } else if ("3".equals(backAmountType)) {
                    PtePtradeParticipantDomain domain;
                    PtePtradeParticipant ptePtradeParticipant;
                    void var32_57;
                    String buyStr = "";
                    String string = "";
                    for (String string11 : partMap.keySet()) {
                        void var32_59;
                        if (string11.indexOf("SELL_") < 0) {
                            if (StringUtils.isNotBlank((String)buyStr)) {
                                buyStr = buyStr + ",";
                            }
                            buyStr = buyStr + string11;
                            continue;
                        }
                        if (string11.indexOf("SELL_") < 0) continue;
                        if (StringUtils.isNotBlank((String)var32_57)) {
                            String string12 = (String)var32_57 + ",";
                        }
                        String string13 = (String)var32_59 + string11;
                    }
                    if (buysun.compareTo(BigDecimal.ZERO) > 0) {
                        for (String keys : buyStr.split(",")) {
                            ptePtradeParticipant = (PtePtradeParticipant)partMap.remove(keys);
                            if (null != ptePtradeParticipant) {
                                domain = this.makeBackDomain(ptePtrade, ptePtradeInfoCode, ptePtradeParticipant);
                                buynomoney = ptePtradeParticipant.getOrderAmount();
                                domain.setOrderAmount(buynomoney);
                                buysun = buysun.subtract(buynomoney);
                                buyparticipantList.add(domain);
                            }
                            if (buysun.compareTo(BigDecimal.ZERO) <= 0) break;
                        }
                    }
                    for (String keys : var32_57.split(",")) {
                        ptePtradeParticipant = (PtePtradeParticipant)partMap.remove(keys);
                        if (null != ptePtradeParticipant) {
                            domain = this.makeBackDomain(ptePtrade, ptePtradeInfoCode, ptePtradeParticipant);
                            sellnomoney = domain.getOrderAmount().divide(allMoney, 2, 6).multiply(ptePtrade.getOrderAmount());
                            domain.setOrderAmount(sellnomoney);
                            sellsun = sellsun.subtract(sellnomoney);
                            sellparticipantList.add(domain);
                        }
                        if (sellsun.compareTo(BigDecimal.ZERO) > 0) {
                            continue;
                        }
                        break;
                    }
                }
                ((PtePtradeParticipantDomain)sellparticipantList.get(sellparticipantList.size() - 1)).setOrderAmount(((PtePtradeParticipantDomain)sellparticipantList.get(sellparticipantList.size() - 1)).getOrderAmount().add(sellsun));
                ((PtePtradeParticipantDomain)buyparticipantList.get(buyparticipantList.size() - 1)).setOrderAmount(((PtePtradeParticipantDomain)buyparticipantList.get(buyparticipantList.size() - 1)).getOrderAmount().add(buysun));
                participantList.addAll(sellparticipantList);
                participantList.addAll(buyparticipantList);
            } else {
                for (String string : partMap.keySet()) {
                    PtePtradeParticipant ptePtradeParticipant = (PtePtradeParticipant)partMap.get(string);
                    PtePtradeParticipantDomain domain = this.makeBackDomain(ptePtrade, ptePtradeInfoCode, ptePtradeParticipant);
                    if (null == domain.getOrderAmount()) {
                        domain.setOrderAmount(BigDecimal.ZERO);
                    }
                    if (domain.getOrderAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                    participantList.add(domain);
                }
            }
        } else {
            for (PtePtradeParticipantDomain ptePtradeParticipantDomain : ptradeBackBean.getPartList()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("dicActorCode", ptePtradeParticipantDomain.getDicActorCode());
                map.put("faccountId", ptePtradeParticipantDomain.getFaccountId());
                map.put("ptradeInfoCode", oldptePtradeInfoCode);
                map.put("tenantCode", ptradeBackBean.getTenantCode());
                QueryResult<PtePtradeParticipant> rs = this.ptePtradeParticipantService.queryPtradeParticipantPage(map);
                if (rs == null || rs.getList().size() == 0) {
                    throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack", "\u6e20\u9053\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
                }
                PtePtradeParticipantDomain domain = new PtePtradeParticipantDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)domain, rs.getList().get(0));
                }
                catch (Exception e) {
                    throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.e1", (Throwable)e);
                }
                domain.setPtePtradeId(null);
                domain.setPtePtradeCode(null);
                domain.setPtradeInfoCode(ptePtradeInfoCode);
                domain.setOrderAmount(ptePtradeParticipantDomain.getOrderAmount());
                domain.setPtradeSeqno(ptePtrade.getPtradeSeqno());
                participantList.add(domain);
            }
        }
        this.ptePtradeParticipantService.savePtradeParticipantList(participantList);
        this.polishBackExtension(ptePtrade, allMoney, bankOrderAmount);
        ptePtradeInfo.setParticipantList(participantList);
        ptePtrade.setPtePtradeInfoList(ptePtradeInfoList);
        String paymentSeqno = this.sendPatment(ptePtrade, "AB");
        if (StringUtils.isBlank((String)paymentSeqno)) {
            throw new ApiException("pte.PtePtradeServiceImplsaveParticipantByPtradeBack.sendPatment", "\u53d1\u9001\u652f\u4ed8\u5931\u8d25\uff01");
        }
        ptePtrade.setPaymentSeqno(paymentSeqno);
        this.savePtradeModel(ptePtrade);
        return ptePtradeInfoCode;
    }

    private PtePtradeParticipantDomain makeBackDomain(PtePtrade ptePtrade, String ptePtradeInfoCode, PtePtradeParticipant ptePtradeParticipant) {
        PtePtradeParticipantDomain domain = new PtePtradeParticipantDomain();
        try {
            BeanUtils.copyAllPropertys((Object)domain, (Object)ptePtradeParticipant);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByPtradeBack.e", (Throwable)e);
        }
        domain.setPtePtradeId(null);
        domain.setPtePtradeCode(null);
        domain.setPtradeInfoCode(ptePtradeInfoCode);
        domain.setPtradeSeqno(ptePtrade.getPtradeSeqno());
        return domain;
    }

    public Map<String, PtePtradeParticipant> makePact(List<PtePtradeParticipant> ptePtradeParticipantList, Map<String, PtePtradeParticipant> backmap, String backAmountType, BigDecimal refundMoney) {
        if (ListUtil.isEmpty(ptePtradeParticipantList)) {
            return null;
        }
        HashMap<String, PtePtradeParticipant> map = new HashMap<String, PtePtradeParticipant>();
        for (PtePtradeParticipant ptePtradeParticipant : ptePtradeParticipantList) {
            PtePtradeParticipant backPtePtradeParticipant;
            if (null == ptePtradeParticipant.getOrderAmount()) {
                ptePtradeParticipant.setOrderAmount(BigDecimal.ZERO);
            }
            if ("BANK".equals(ptePtradeParticipant.getDicActorCode())) {
                PtePtradeParticipant ptePtradeParticipant1 = new PtePtradeParticipant();
                ptePtradeParticipant1.setOrderAmount(ptePtradeParticipant.getOrderAmount());
                map.put("bankOrderAmount", ptePtradeParticipant1);
            }
            if (MapUtil.isNotEmpty(backmap) && null != (backPtePtradeParticipant = backmap.get(ptePtradeParticipant.getDicActorCode()))) {
                ptePtradeParticipant.setOrderAmount(ptePtradeParticipant.getOrderAmount().subtract(backPtePtradeParticipant.getOrderAmount()));
            }
            if (ptePtradeParticipant.getOrderAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            map.put(ptePtradeParticipant.getDicActorCode(), ptePtradeParticipant);
        }
        if ("3".equals(backAmountType)) {
            for (PtePtradeParticipant ptePtradeParticipant : ptePtradeParticipantList) {
                if (!"BANK".equals(ptePtradeParticipant.getDicActorCode())) continue;
                PtePtradeParticipant buy_b = (PtePtradeParticipant)map.get("BUY_B");
                if (null != buy_b) {
                    buy_b.setOrderAmount(refundMoney);
                    map.put(buy_b.getDicActorCode(), buy_b);
                    continue;
                }
                PtePtradeParticipant bank = (PtePtradeParticipant)map.remove("BANK");
                if (null == bank) continue;
                bank.setDicActorCode("BUY_B");
                HashMap<String, String> pmap = new HashMap<String, String>();
                pmap.put("merchantCode", bank.getOpuserCode());
                String fundType = "01";
                String code = bank.getOpuserCode().substring(0, 1);
                String faccountType = code + fundType;
                pmap.put("faccountType", faccountType);
                pmap.put("tenantCode", bank.getTenantCode());
                String result = this.internalInvoke("vd.faccountOuter.queryOuterFaccount", pmap);
                if (StringUtils.isBlank((String)result)) {
                    throw new ApiException("pte.PtePtradeServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!" + ((Object)pmap).toString());
                }
                List vdFaccountOuter = (List)JsonUtil.buildNormalBinder().getJsonToList(result, VdFaccountOuter.class);
                if (ListUtil.isEmpty((Collection)vdFaccountOuter)) {
                    throw new ApiException("pte.PtePtradeServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!" + ((Object)pmap).toString());
                }
                bank.setFaccountId(((VdFaccountOuter)vdFaccountOuter.get(0)).getFaccountOuterNo());
                bank.setFchannelCode("01");
                bank.setFchannelClassifyCode("101");
                bank.setFundType("01");
                bank.setOrderAmount(refundMoney);
                map.put("BUY_B", bank);
            }
            map.remove("BANK");
        }
        return map;
    }

    public static void main(String[] args) {
        BigDecimal nomoney = BigDecimal.ZERO;
        BigDecimal sun = new BigDecimal("1");
        BigDecimal allMoney = new BigDecimal("1");
        for (int i = 0; i < 2; ++i) {
            BigDecimal a = new BigDecimal("1");
            nomoney = a.divide(allMoney, 4, 6).multiply(allMoney);
            sun = sun.subtract(nomoney);
            System.out.println(nomoney);
        }
    }

    private void polishBackExtension(PtePtrade ptePtrade, BigDecimal orderAmount, PtePtradeParticipant bankOrderAmount) {
        if (ptePtrade == null) {
            return;
        }
        String extJson = ptePtrade.getExtension();
        Map<String, BigDecimal> extMap = null;
        if (!StringUtils.isBlank((String)extJson)) {
            extMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(extJson, String.class, Object.class);
        }
        if (extMap == null) {
            extMap = new HashMap<String, BigDecimal>();
        }
        extMap.put("orderAmount", orderAmount);
        if (null != bankOrderAmount) {
            extMap.put("bankOrderAmount", bankOrderAmount.getOrderAmount());
        }
        ptePtrade.setExtension(JsonUtil.buildNormalBinder().toJson(extMap));
    }

    @Override
    public CheckContext sendCallBack(Map<String, Object> map) throws ApiException {
        return this.saveCallBack(map);
    }

    @Override
    public CheckContext saveCallBack(Map<String, Object> map) throws ApiException {
        long start = System.currentTimeMillis();
        String tenantCode = (String)map.get("tenantCode");
        String ptradeSeqno = (String)map.get("ptradeSeqno");
        String paymentSeqno = (String)map.get("paymentSeqno");
        String paymentReorderMemo = (String)map.get("paymentReorderMemo");
        PayengineForm payengineForm = (PayengineForm)JsonUtil.buildNormalBinder().getJsonToObject(paymentReorderMemo, PayengineForm.class);
        String paymentstate = "";
        if (null != payengineForm && null != payengineForm.getCallmap() && null != payengineForm.getChannelRestForm()) {
            String state = payengineForm.getChannelRestForm().getState();
            paymentstate = (String)payengineForm.getCallmap().get("paymentstate");
            if ("3".equals(state)) {
                paymentstate = PteConstants.DATA_STATE_FAIL + "";
            }
            map.put("paymentstate", paymentstate);
        }
        if (StringUtils.isBlank((String)paymentstate)) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveCallBack.paymentstate", ptradeSeqno + "\u56de\u8c03\u72b6\u6001\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)ptradeSeqno)) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveCallBack.ptradeSeqno", "\u4ea4\u6613\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff01");
        }
        this.logger.info("=====saveCallBack====1=", (Object)(ptradeSeqno + "=" + (System.currentTimeMillis() - start)));
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("ptradeSeqno", ptradeSeqno);
        pmap.put("tenantCode", tenantCode);
        PtePtrade ptePtrade = this.getPtradeByCode(pmap);
        if (ptePtrade == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveCallBack.ptePtrade", ((Object)pmap).toString() + ":\u65e0\u6548\u4ea4\u6613\u6d41\u6c34\uff01");
        }
        this.logger.info("=====saveCallBack====2=", (Object)(ptradeSeqno + "=" + (System.currentTimeMillis() - start)));
        CheckContext checkResult = this.checkOrder(ptePtrade, this, map);
        this.logger.info("=====saveCallBack====3=", (Object)(ptradeSeqno + "=" + (System.currentTimeMillis() - start) + "=" + checkResult.isNext()));
        if (checkResult.isNext()) {
            pmap.clear();
            pmap.put("paymentSeqno", paymentSeqno);
            pmap.put("paymentReturnparam", paymentReorderMemo);
            pmap.put("dataState", Integer.parseInt(paymentstate));
            pmap.put("ptradeNotstatus", "1");
            if (PteConstants.DATA_STATE_5.equals(Integer.parseInt(paymentstate)) || PteConstants.DATA_STATE_3.equals(Integer.parseInt(paymentstate))) {
                pmap.put("gmtPaid", new Date());
            }
            this.updatePtradeModelById(ptePtrade.getPtradeId(), ptePtrade.getDataState(), pmap, false);
            this.logger.info("=====saveCallBack====4=", (Object)(ptradeSeqno + "=" + (System.currentTimeMillis() - start)));
            if (paymentstate.equals(ptePtrade.getDataState() + "")) {
                this.logger.error("pte.PtePtradeServiceImpl.saveCallBack.dataState", (Object)(ptradeSeqno + "=" + paymentstate));
                return checkResult;
            }
            this.processExtPtrade(ptePtrade, pmap, map);
            ChannelRestForm channelRestForm = payengineForm.getChannelRestForm();
            PteQueryCall.call(tenantCode + "-" + ptradeSeqno + "-" + paymentstate, JsonUtil.buildNonDefaultBinder().toJson((Object)channelRestForm));
            ptePtrade.setDataState(Integer.parseInt(paymentstate));
            checkResult.setPtePtrade(ptePtrade);
        } else if (checkResult.isBack()) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            PtradeBackBean ptradeBackBean = this.makeRefund(ptePtrade);
            paramMap.put("ptradeBackBean", JsonUtil.buildNormalBinder().toJson((Object)ptradeBackBean));
            this.internalInvoke("pa.payment.savePyamentToPteBack", paramMap);
        }
        ArrayList<PteChannelsendDomain> pteChannelsendDomainList = new ArrayList<PteChannelsendDomain>();
        PteChannelsendDomain pteChannelsendDomain = new PteChannelsendDomain();
        pteChannelsendDomain.setChannelsendDir(paymentstate);
        pteChannelsendDomain.setChannelsendType("ptePtrade");
        pteChannelsendDomain.setPtradeSeqno(ptradeSeqno);
        pteChannelsendDomain.setTenantCode(tenantCode);
        pteChannelsendDomainList.add(pteChannelsendDomain);
        this.logger.info("=====saveCallBack====5=", (Object)(ptradeSeqno + "=" + (System.currentTimeMillis() - start)));
        checkResult.setPteChannelsendList(this.pteChannelsendService.saveChannelsendBatch(pteChannelsendDomainList));
        this.logger.info("=====saveCallBack====6=", (Object)(ptradeSeqno + "=" + (System.currentTimeMillis() - start)));
        return checkResult;
    }

    public void setPteChannelsendService(PteChannelsendService pteChannelsendService) {
        this.pteChannelsendService = pteChannelsendService;
    }

    private PtradeBackBean makeRefund(PtePtrade ptePtrade) {
        PtradeBackBean ptradeBackBean = new PtradeBackBean();
        ptradeBackBean.setAcquireSeqno(ptePtrade.getAcquireSeqno());
        ptradeBackBean.setOrderAmount(ptePtrade.getOrderAmount());
        ptradeBackBean.setPartnerCode(ptePtrade.getPartnerCode());
        ptradeBackBean.setTenantCode(ptePtrade.getTenantCode());
        ptradeBackBean.setPtradeSeqno(ptePtrade.getPtradeSeqno());
        return ptradeBackBean;
    }

    private void processExtPtrade(PtePtrade ptePtrade, Map<String, Object> pmap, Map<String, Object> callBackMap) {
        if (StringUtils.isBlank((String)ptePtrade.getPtradeOldseqno())) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptradeSeqno", ptePtrade.getPtradeOldseqno());
        map.put("tenantCode", ptePtrade.getTenantCode());
        PtePtrade extPtePtrade = this.getPtradeByCode(map);
        if (extPtePtrade == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.processExtPtrade", "\u76f8\u5173\u4ea4\u6613\u6d41\u6c34\u672a\u627e\u5230\uff01");
        }
        if (PtradpdeEnum.PAYMENTREPLACE.getCode().equals(ptePtrade.getPtradpdeCode())) {
            pmap.put("paymentSeqno", null);
            this.updatePtradeModelById(extPtePtrade.getPtradeId(), extPtePtrade.getDataState(), pmap, false);
            try {
                extPtePtrade.setPtradeOldseqno(ptePtrade.getPtradeSeqno());
                BeanUtils.copyAllPropertys((Object)ptePtrade, (Object)extPtePtrade);
            }
            catch (Exception e) {
                throw new ApiException("pte.PtePtradeServiceImpl.processExtPtrade", "\u5c5e\u6027\u8f6c\u6362\u51fa\u9519\uff01");
            }
        }
    }

    @Override
    public BankHtmlForm sendParticipantByPtrade(PtradeBean ptradeBean) throws ApiException {
        PtePtrade ptePtrade = this.saveParticipantByPtrade(ptradeBean);
        if (null == ptePtrade) {
            return null;
        }
        PtePtradeServiceImpl.getPtradeInfoService().putQueue(ptePtrade);
        if ("0".equals(ptradeBean.getFchannelMode())) {
            String bankHtmlForm = this.getFormCachStr(ptradeBean.getTenantCode(), ptradeBean.getPtradeSeqno());
            ChannelRestForm channelRestForm = (ChannelRestForm)JsonUtil.buildNormalBinder().getJsonToObject(bankHtmlForm, ChannelRestForm.class);
            if (channelRestForm != null) {
                return channelRestForm.getBankHtmlForm();
            }
        } else {
            this.logger.error("pte.PtePtradeServiceImpl.sendParticipantByPtradeStr", (Object)ptradeBean.getFchannelMode());
            return null;
        }
        return null;
    }

    @Override
    public PtePtrade saveParticipantByPtrade(PtradeBean ptradeBean) throws ApiException {
        PtePtrade ptePtrade = this.commitParticipantByPtradeRe(ptradeBean);
        return ptePtrade;
    }

    private String getCachStrByThread(String correlationId, long timeOut) {
        SyncTradeFuture syncTradeFuture = new SyncTradeFuture();
        this.logger.info("PTEQUERY_CALL.req", (Object)correlationId);
        String returnStr = DisUtil.getRemot((String)("PTEQUERY_CALL-" + correlationId));
        this.logger.info("PTEQUERY_CALL.res", (Object)returnStr);
        if (StringUtils.isBlank((String)returnStr)) {
            PteQueryCall.putSync(correlationId, syncTradeFuture, timeOut);
            returnStr = (String)syncTradeFuture.get(timeOut);
            this.logger.info("putSync.res", (Object)returnStr);
        }
        return returnStr;
    }

    @Override
    public String getFormCachStr(String tenantCode, String ptradeSeqno) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)ptradeSeqno)) {
            throw new ApiException("pte.PtePtradeServiceImpl.getFormCachStr", "\u53c2\u6570\u4fe1\u606f\u4e3a\u7a7a");
        }
        return this.getCachStrByThread(tenantCode + "-" + ptradeSeqno + "-" + PteConstants.DATA_STATE_2, 10000L);
    }

    @Override
    public String getCachStr(String token) {
        if (StringUtils.isBlank((String)token)) {
            throw new ApiException("pte.PtePtradeServiceImpl.getCachStr", "\u53c2\u6570\u4fe1\u606f\u4e3a\u7a7a");
        }
        return this.getCachStrByThread(token + "-" + PteConstants.DATA_STATE_2, 10000L);
    }

    @Override
    public void addCharStr(String token, String obj) {
        PteQueryCall.call(token + "-" + PteConstants.DATA_STATE_2, obj);
    }

    @Override
    public void savePtradeCallback(PtePtrade ptePtrade) {
        if (ptePtrade == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.sendPtradeCallback.ptePtrade", "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)ptePtrade.getPaymentNotifyurl())) {
            this.logger.error("pte.PtePtradeServiceImpl.savePtradeCallback.callurl", (Object)"paymentNotifyurl \u56de\u8c03\u5730\u5740\u4e3a\u7a7a\uff01");
            return;
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptradeSeqno", String.valueOf(ptePtrade.getPtradeSeqno()));
        map.put("tenantCode", String.valueOf(ptePtrade.getTenantCode()));
        map.put("acquireSeqno", String.valueOf(ptePtrade.getAcquireSeqno()));
        map.put("dataState", ptePtrade.getDataState());
        map.put("ptradpdeCode", String.valueOf(ptePtrade.getPtradpdeCode()));
        map.put("contractBbillcode", String.valueOf(ptePtrade.getBusinessOrderno()));
        map.put("contractBillcode", String.valueOf(ptePtrade.getBusinessOrderno()));
        map.put("refundCode", String.valueOf(ptePtrade.getBusinessOrderno()));
        map.put("businessOrderno", String.valueOf(ptePtrade.getBusinessOrderno()));
        map.put("businessOrder", String.valueOf(ptePtrade.getBusinessOrder()));
        map.put("trade_amount", String.valueOf(ptePtrade.getOrderAmount()));
        map.put("gmt_create", String.valueOf(ptePtrade.getGmtCreate()));
        map.put("to_app_id", ptePtrade.getAppId());
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        pmap.put("refundCode", String.valueOf(ptePtrade.getBusinessOrderno()));
        pmap.put("ptradeSeqno", String.valueOf(ptePtrade.getPtradeSeqno()));
        pmap.put("acquireSeqno", String.valueOf(ptePtrade.getAcquireSeqno()));
        pmap.put("ptradpdeCode", String.valueOf(ptePtrade.getPtradpdeCode()));
        pmap.put("contractBbillcode", String.valueOf(ptePtrade.getBusinessOrderno()));
        pmap.put("contractBillcode", String.valueOf(ptePtrade.getBusinessOrderno()));
        pmap.put("businessOrderno", String.valueOf(ptePtrade.getBusinessOrderno()));
        pmap.put("businessOrder", String.valueOf(ptePtrade.getBusinessOrder()));
        pmap.put("dataState", String.valueOf(ptePtrade.getDataState()));
        pmap.put("tenantCode", String.valueOf(ptePtrade.getTenantCode()));
        pmap.put("trade_amount", String.valueOf(ptePtrade.getOrderAmount()));
        pmap.put("gmt_create", String.valueOf(ptePtrade.getGmtCreate()));
        pmap.put("to_app_id", ptePtrade.getAppId());
        CallBackContext context = this.loadContext(ptePtrade);
        if (context != null) {
            pmap.put("payment_type", context.getPaymentType());
            if (context.getCashAmount() != null) {
                pmap.put("cash_amount", String.valueOf(context.getCashAmount()));
            }
        }
        this.logger.info("pte.PtePtradeServiceImpl.savePtradeCallback.send", (Object)(ptePtrade.getPaymentNotifyurl() + ":" + ((Object)pmap).toString()));
        String flag = this.internalInvokeCallBack(ptePtrade.getPaymentNotifyurl(), pmap, ptePtrade.getRouterDir());
        this.logger.info("pte.PtePtradeServiceImpl.savePtradeCallback.send.ok", (Object)(ptePtrade.getPaymentNotifyurl() + ":" + ((Object)pmap).toString() + ":" + flag));
        if (!"success".equals(flag) && !"true".equals(flag)) {
            throw new ApiException("pte.PtePtradeServiceImpl.sendPtradeCallback.result", "\u56de\u8c03\u5f02\u5e38:" + ((Object)pmap).toString() + ptePtrade.getRouterDir());
        }
        HashMap<String, Object> setMap = new HashMap<String, Object>();
        setMap.put("ptradeNotstatus", "2");
        this.updatePtradeModelById(ptePtrade.getPtradeId(), ptePtrade.getDataState(), setMap, false);
    }

    private String loadPayType(PtePtrade ptePtrade) {
        String payType = "";
        String ptradeExtSeqno = StringUtils.isNotBlank((String)ptePtrade.getPtradeOldseqno()) ? ptePtrade.getPtradeOldseqno() : ptePtrade.getPtradeSeqno();
        QueryResult<PtePtradeParticipant> result = this.ptePtradeParticipantService.queryPtradeParticipantPage(this.getQueryParamMap("tenantCode,ptradeSeqno", new Object[]{ptePtrade.getTenantCode(), ptradeExtSeqno}));
        if (result != null && ListUtil.isNotEmpty((Collection)result.getList())) {
            for (PtePtradeParticipant part : result.getList()) {
                if (DicactorEnum.BANK.getCode().equals(part.getDicActorCode())) {
                    payType = payType + part.getFchannelClassifyCode() + ",";
                    continue;
                }
                if (!DicactorEnum.BUY_B.getCode().equals(part.getDicActorCode())) continue;
                payType = payType + part.getFchannelClassifyCode() + ",";
            }
        }
        if (!StringUtils.isBlank((String)payType)) {
            payType = payType.substring(0, payType.length() - 1);
        }
        return payType;
    }

    private CallBackContext loadContext(PtePtrade ptePtrade) {
        String payType = "";
        CallBackContext context = null;
        String ptradeExtSeqno = StringUtils.isNotBlank((String)ptePtrade.getPtradeOldseqno()) ? ptePtrade.getPtradeOldseqno() : ptePtrade.getPtradeSeqno();
        QueryResult<PtePtradeParticipant> result = this.ptePtradeParticipantService.queryPtradeParticipantPage(this.getQueryParamMap("tenantCode,ptradeSeqno", new Object[]{ptePtrade.getTenantCode(), ptradeExtSeqno}));
        if (result != null && ListUtil.isNotEmpty((Collection)result.getList())) {
            context = new CallBackContext();
            context.setCashAmount(BigDecimal.ZERO);
            for (PtePtradeParticipant part : result.getList()) {
                if (DicactorEnum.BANK.getCode().equals(part.getDicActorCode())) {
                    payType = payType + part.getFchannelClassifyCode() + ",";
                    if (!FchannelCodeEnum.CASH.getCode().equals(part.getFchannelCode())) continue;
                    context.setCashAmount(part.getOrderAmount());
                    continue;
                }
                if (!StringUtils.isNotBlank((String)part.getDicActorCode()) || !part.getDicActorCode().startsWith("BUY_")) continue;
                payType = payType + part.getFchannelClassifyCode() + ",";
            }
        }
        if (!StringUtils.isBlank((String)payType)) {
            payType = payType.substring(0, payType.length() - 1);
        }
        context.setPaymentType(payType);
        return context;
    }

    @Override
    public void loadPtradeProcess() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            this.logger.info("pte.PtePtradeServiceImpl.loadDb.start", (Object)"============start================");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ptradeNotstatus", "1");
            QueryResult<PtePtrade> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = PtePtradeServiceImpl.getPtradeService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", PtePtradeServiceImpl.getPtradeService().getPage());
                result = this.queryPtradePage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    PtePtradeServiceImpl.getPtradeService().addPutPool(new PtradePutThread(PtePtradeServiceImpl.getPtradeService(), result.getRows()));
                    if (result.getRows().size() == PtePtradeServiceImpl.getPtradeService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            PtePtradeServiceImpl.getPtradeService().initStartRow();
            this.logger.info("pte.PtePtradeServiceImpl.loadDb.end", (Object)"============end================");
        }
        catch (Exception e) {
            this.logger.info("pte.PtePtradeServiceImpl.loadDb.end.e", (Object)"============end================", (Throwable)e);
            throw new ApiException("pte.PtePtradeServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PtradeService getPtradeService() {
        Object object = lock;
        synchronized (object) {
            if (null == ptradeService) {
                ptradeService = new PtradeService((PtePtradeService)SpringApplicationContextUtil.getBean((String)"ptePtradeService"));
                for (int i = 0; i < 60; ++i) {
                    ptradeService.addPollPool(new PtradePollThread(ptradeService));
                }
            }
            return ptradeService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PtradeInfoService getPtradeInfoService() {
        Object object = lock;
        synchronized (object) {
            if (null == ptradeInfoService) {
                ptradeInfoService = new PtradeInfoService((PtePtradeService)SpringApplicationContextUtil.getBean((String)"ptePtradeService"));
                for (int i = 0; i < 100; ++i) {
                    ptradeInfoService.addPollPool(new PtradeInfoPollThread(ptradeInfoService));
                }
            }
            return ptradeInfoService;
        }
    }

    @Override
    public boolean returnPtradeSuccess(String tenantCode, String ptradeSeqno, String dataState) {
        for (int i = 0; i < dataState.split(",").length; ++i) {
            String state = dataState.split(",")[i];
            String correlationId = tenantCode + "-" + ptradeSeqno + "-" + state;
            String str = SupDisUtil.getRemot((String)("PTEQUERY_CALL-" + correlationId));
            if (StringUtils.isBlank((String)str)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String saveCommitGoods(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            this.logger.info("pte.PtePtradeServiceImpl.saveCommitGoods.map");
            return null;
        }
        if (this.savePtradeNext(map)) {
            return "success";
        }
        return "error";
    }

    @Override
    public boolean checkPtradeSuccess(String tenantCode, String ptradeSeqno, String dataState) {
        int time = 10;
        String checkTime = DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-pte-checkPtetime");
        if (StringUtils.isNotBlank((String)checkTime)) {
            time = Integer.parseInt(checkTime);
        }
        int sleepTime = 200;
        try {
            if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)ptradeSeqno) || StringUtils.isBlank((String)dataState)) {
                return false;
            }
            dataState = dataState + "," + PteConstants.DATA_STATE_FAIL;
            for (int num = time * 5; num > 0; --num) {
                for (int i = 0; i < dataState.split(",").length; ++i) {
                    String state = dataState.split(",")[i];
                    String correlationId = tenantCode + "-" + ptradeSeqno + "-" + state;
                    String str = SupDisUtil.getRemot((String)("PTEQUERY_CALL-" + correlationId));
                    if (StringUtils.isBlank((String)str)) continue;
                    return !state.equals(PteConstants.DATA_STATE_FAIL + "");
                }
                Thread.sleep(sleepTime);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return false;
    }

    @Override
    public String savePtradeForm(PtePtradeForm ptePtradeForm) throws ApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        String api = "00000000-pte-returnback";
        String key = "00000000-pay-cashier";
        if (ptePtradeForm == null) {
            return null;
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ptePtradeDomain, (Object)ptePtradeForm);
        }
        catch (Exception e) {
            this.logger.error("pte.PtePtradeServiceImplsavePtradeForm.copyAllPropertysNotNull", (Object)e.getLocalizedMessage());
        }
        ptePtradeDomain.setAppId(ptePtradeForm.getApp_id());
        ptePtradeDomain.setOrderAmount(new BigDecimal(ptePtradeForm.getOrderAmount()));
        if (StringUtils.isNotBlank((String)ptePtradeForm.getGmtPaySubmit())) {
            ptePtradeDomain.setGmtPaySubmit(DateUtil.getDateToString((String)ptePtradeForm.getGmtPaySubmit(), (String)"yyyyMMdd hhmmss"));
        }
        if ("1".equals(ptePtradeForm.getTest_router_flag())) {
            ptePtradeDomain.setRouterDir("6");
        } else {
            ptePtradeDomain.setRouterDir("5");
        }
        ptePtradeDomain.setPaymentNotifyurl(DisUtil.getMap((String)"DdFalgSetting-key", (String)api));
        String ptradeSeqno = "";
        try {
            if (StringUtils.isBlank((String)ptePtradeDomain.getAcquireSeqno())) {
                ptePtradeDomain.setAcquireSeqno(ptePtradeDomain.getBusinessOrderno());
            }
            ptradeSeqno = this.savePtrade(ptePtradeDomain);
        }
        catch (ApiException e) {
            Map pmap;
            List<PtePtrade> list;
            if ("Union_ErrorCode".equals(e.getErrCode()) && (list = this.queryPtradeModelPage(pmap = this.getQueryParamMap("tenantCode,businessOrderno", new Object[]{ptePtradeForm.getTenantCode(), ptePtradeForm.getBusinessOrderno()}))) != null && list.size() > 0) {
                map.put("url", DisUtil.getMap((String)"DdFalgSetting-key", (String)key) + "?ptradeSeqno=" + list.get(0).getPtradeSeqno());
                map.put("ptradeSeqno", list.get(0).getPtradeSeqno());
                return JsonUtil.buildNormalBinder().toJson(map);
            }
            throw e;
        }
        String cahierUrl = DisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-pay-cashier_" + ptePtradeForm.getPtradpdeCode()));
        if (StringUtils.isBlank((String)cahierUrl)) {
            cahierUrl = DisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        }
        map.put("url", cahierUrl + "?ptradeSeqno=" + ptradeSeqno + "&tenantCode=" + ptePtradeForm.getTenantCode());
        map.put("ptradeSeqno", ptradeSeqno);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    public CheckContext checkOrder(PtePtrade ptePtrade, PtePtradeService ptePtradeService, Map<String, Object> callbackMap) {
        CheckContext checkContext = CheckChian.get().execute(ptePtrade, ptePtradeService, callbackMap);
        return checkContext;
    }

    public String checkAllowRefund(PtePtrade ptePtrade) {
        if (!PteConstants.DATA_STATE_3.equals(ptePtrade.getDataState()) && !PteConstants.DATA_STATE_5.equals(ptePtrade.getDataState())) {
            return "\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e3a" + ptePtrade.getDataState();
        }
        if (PtradpdeEnum.PAYMENTESCROW.getCode().equals(ptePtrade.getPtradpdeCode()) && !PteConstants.DATA_STATE_5.equals(ptePtrade.getDataState())) {
            return "\u62c5\u4fdd\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e3a" + ptePtrade.getDataState();
        }
        long diffday = DateUtil.getBetweenDays((Date)ptePtrade.getGmtPaid(), (Date)new Date());
        long refundDay = 30L;
        String refundDiffDay = DisUtil.getMap((String)"DdFalgSetting-key", (String)(ptePtrade.getTenantCode() + "-pte-refundDiffDay"));
        if (StringUtils.isBlank((String)refundDiffDay)) {
            refundDiffDay = DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-pte-refundDiffDay");
        }
        if (StringUtils.isNotBlank((String)refundDiffDay)) {
            refundDay = Long.parseLong(refundDiffDay);
        }
        if (diffday > refundDay) {
            return "\u8d85\u51fa\u9000\u6b3e\u65f6\u95f4";
        }
        return null;
    }

    @Override
    public PtePtrade getPtradeByCode(Map<String, Object> map) {
        return this.getPtradeModelByCode(map);
    }

    @Override
    public void updatePayoutPorcess() {
        this.updatePayoutPtrade();
    }

    @Override
    public String saveParticipantByRefund(PtePtradeBackDomain ptePtradeBackDomain) throws ApiException {
        String ptePtradeInfoCode = "";
        try {
            PtradeBackBean ptradeBackBean = new PtradeBackBean();
            BeanUtils.copyAllPropertysNotNull((Object)ptradeBackBean, (Object)ptePtradeBackDomain);
            ptePtradeInfoCode = this.saveParticipantByPtradeBack(ptradeBackBean);
        }
        catch (Exception ex) {
            throw new ApiException("pte.PtePtradeServiceImpl.saveParticipantByOrderBack.ex", (Throwable)ex);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("ptradeBackCode", ptePtradeInfoCode);
        return JsonUtil.buildNormalBinder().toJson(resultMap);
    }

    private void updatePayoutPtrade() {
        try {
            this.ptePtradeMapper.updatePayoutPtrade();
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePayoutPtrade.ex", (Throwable)e);
        }
    }

    @Override
    public void delPtradeByCode(Map<String, Object> map) throws ApiException {
        this.delPtradeModelByCode(map);
    }

    @Override
    public PtePtrade ptradeUnionQuery(Map<String, Object> map) {
        try {
            List<PtePtrade> list = this.ptePtradeMapper.query(map);
            if (list != null && list.size() > 0) {
                PtePtrade ptePtrade = list.get(0);
                HashMap<String, Object> paraMap = new HashMap<String, Object>();
                paraMap.put("ptradeSeqno", ptePtrade.getPtradeSeqno());
                paraMap.put("tenantCode", ptePtrade.getTenantCode());
                ptePtrade.setPtePtradeInfoList(this.ptePtradeInfoService.queryPtradeInfoPage(paraMap).getList());
                ptePtrade.setPtePtradeParticipantList(this.ptePtradeParticipantService.queryPtradeParticipantPage(paraMap).getList());
                ptePtrade.setPtePtradeReorderList(this.ptePtradeReorderService.queryPtradeReorderPage(paraMap).getList());
                return ptePtrade;
            }
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.ptradeUnionQuery.ex", (Throwable)e);
        }
        return null;
    }

    public boolean savePtradeNext(Map<String, Object> pmap) throws ApiException {
        if (MapUtil.isEmpty(pmap)) {
            return false;
        }
        PtePtrade ptePtrade = this.getPtradeByCode(pmap);
        if (ptePtrade == null) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtradeNext", "\u65e0\u6548\u4ea4\u6613\u6d41\u6c34\uff01");
        }
        if (!PteConstants.DATA_STATE_3.equals(ptePtrade.getDataState())) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtradeNext.state", "\u8ba2\u5355\u72b6\u6001\u65e0\u6548\uff01");
        }
        this.updatePtradeState(ptePtrade.getPtradeId(), PteConstants.DATA_STATE_6, ptePtrade.getDataState());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", ptePtrade.getTenantCode());
        paramMap.put("paymentSeqno", ptePtrade.getPaymentSeqno());
        try {
            this.internalInvoke("pe.paymentEngine.sendPaymentNext", paramMap);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.savePtradeNext.sendPaymentNext", "\u8c03\u7528pe\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return true;
    }

    @Override
    public boolean savePtradeNext(String tenantCode, String ptradeSeqno) throws ApiException {
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("tenantCode", tenantCode);
        pmap.put("ptradeSeqno", ptradeSeqno);
        return this.savePtradeNext(pmap);
    }

    @Override
    public void updatePtradeMoney(String businessOrderno, String ptradeSeqno, String tenantCode, String money, String transferAmount) {
        if (StringUtils.isEmpty((String)businessOrderno) || StringUtils.isEmpty((String)tenantCode) || StringUtils.isEmpty((String)money)) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeMoney.ex", "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessOrderno", businessOrderno);
        if (StringUtils.isNotBlank((String)ptradeSeqno)) {
            map.put("ptradeSeqno", ptradeSeqno);
        }
        map.put("tenantCode", tenantCode);
        PtePtrade ptrade = this.ptePtradeMapper.selectByBusinessOrderno(map);
        if (ptrade == null) {
            return;
        }
        BigDecimal orderAmount = ptrade.getOrderAmount().subtract(new BigDecimal(money));
        BigDecimal saleOrderAmount = ptrade.getOrderOamount().subtract(ptrade.getOrderAmount());
        ptrade.setOrderAmount(new BigDecimal(money));
        ptrade.setOrderOamount(new BigDecimal(money).add(saleOrderAmount));
        ptrade.setGmtModified(this.getSysDate());
        if (StringUtils.isNotBlank((String)transferAmount)) {
            if (StringUtils.isEmpty((String)ptrade.getExtension())) {
                ptrade.setExtension("{\"transferAmount\":\"" + new BigDecimal(transferAmount) + "\"}");
            } else {
                Map extensionMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(ptrade.getExtension(), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)extensionMap)) {
                    extensionMap.put("transferAmount", new BigDecimal(transferAmount));
                }
                ptrade.setExtension(extensionMap.toString());
            }
        }
        this.updatePtradeModel(ptrade);
        map.put("ptradeSeqno", ptrade.getPtradeSeqno());
        List<PtePtradeInfo> ptradeInfoList = this.ptePtradeInfoService.queryPtradeInfoByPtraderCode(map);
        if (null == ptradeInfoList || ptradeInfoList.isEmpty()) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeMoney.ex", "ptradeInfo\u4e3a\u7a7a\uff01");
        }
        PtePtradeInfo ptradeInfo = ptradeInfoList.get(0);
        ptradeInfo.setOrderAmount(ptradeInfo.getOrderAmount().subtract(orderAmount));
        PtePtradeInfoDomain ptradeInfoDomain = new PtePtradeInfoDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptradeInfoDomain, (Object)ptradeInfo);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeMoney.ex");
        }
        this.ptePtradeInfoService.updatePtradeInfo(ptradeInfoDomain);
    }

    @Override
    public void updatePtradeMoneyNew(String businessOrderno, String ptradeSeqno, String tenantCode, String money, String transferAmount) {
        if (StringUtils.isEmpty((String)businessOrderno) || StringUtils.isEmpty((String)tenantCode) || StringUtils.isEmpty((String)money)) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeMoneyNew.ex", "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessOrderno", businessOrderno);
        if (StringUtils.isNotBlank((String)ptradeSeqno)) {
            map.put("ptradeSeqno", ptradeSeqno);
        }
        map.put("tenantCode", tenantCode);
        PtePtrade ptrade = this.ptePtradeMapper.selectByBusinessOrderno(map);
        if (ptrade == null) {
            return;
        }
        ptrade.setOrderAmount(new BigDecimal(money));
        ptrade.setOrderOamount(new BigDecimal(money));
        ptrade.setGmtModified(this.getSysDate());
        if (StringUtils.isNotBlank((String)transferAmount)) {
            if (StringUtils.isEmpty((String)ptrade.getExtension())) {
                ptrade.setExtension("{\"transferAmount\":\"" + new BigDecimal(transferAmount) + "\"}");
            } else {
                Map extensionMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(ptrade.getExtension(), String.class, Object.class);
                if (MapUtil.isNotEmpty((Map)extensionMap)) {
                    extensionMap.put("transferAmount", new BigDecimal(transferAmount));
                }
                ptrade.setExtension(extensionMap.toString());
            }
        }
        this.updatePtradeModel(ptrade);
        map.put("ptradeSeqno", ptrade.getPtradeSeqno());
        List<PtePtradeInfo> ptradeInfoList = this.ptePtradeInfoService.queryPtradeInfoByPtraderCode(map);
        if (null == ptradeInfoList || ptradeInfoList.isEmpty()) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeMoneyNew.ex", "ptradeInfo\u4e3a\u7a7a\uff01");
        }
        PtePtradeInfo ptradeInfo = ptradeInfoList.get(0);
        ptradeInfo.setOrderAmount(new BigDecimal(money));
        ptradeInfo.setOrderOamount(new BigDecimal(money));
        PtePtradeInfoDomain ptradeInfoDomain = new PtePtradeInfoDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptradeInfoDomain, (Object)ptradeInfo);
        }
        catch (Exception e) {
            throw new ApiException("pte.PtePtradeServiceImpl.updatePtradeMoneyNew.ex");
        }
        this.ptePtradeInfoService.updatePtradeInfo(ptradeInfoDomain);
    }

    static {
        lock = new Object();
    }
}

