/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.paytradeengine.dao.PtePtradeMapper;
import com.yqbsoft.laser.service.paytradeengine.enumc.DateTypeEnum;
import com.yqbsoft.laser.service.paytradeengine.enumc.PtradeDataStateEnum;
import com.yqbsoft.laser.service.paytradeengine.enumc.StatDataScopeEnum;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtradeDaily;
import com.yqbsoft.laser.service.paytradeengine.sdomain.StatisticalDomain;
import com.yqbsoft.laser.service.paytradeengine.service.PtradeStatisticalService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.util.CollectionUtils;

public class PtradeStatisticalServiceImpl
extends BaseServiceImpl
implements PtradeStatisticalService {
    public static final String SYS_CODE = "pte.PtradeStaticsticalServiceImpl";
    @Resource
    private PtePtradeMapper ptePtradeMapper;

    @Override
    public List<Map<String, Object>> statisticalPtrade(StatisticalDomain statisticalDomain) throws ApiException {
        String msg = this.checkStatistical(statisticalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pte.PtradeStaticsticalServiceImpl.statisticalPtrade.statisticalPtrade", msg);
        }
        Map<String, Object> map = this.makeDomainToMap(statisticalDomain);
        String dateType = statisticalDomain.getDateType();
        List<Map<String, Object>> list = null;
        if (DateTypeEnum.YEAR.getCode().equals(dateType)) {
            list = this.statisticalTradeByYear(map);
        } else if (DateTypeEnum.QUARTER.getCode().equals(dateType)) {
            list = this.statisticalTradeByQuarter(map);
        } else if (DateTypeEnum.MONTH.getCode().equals(dateType)) {
            list = this.statisticalTradeByMonth(map);
        } else if (DateTypeEnum.WEEK.getCode().equals(dateType)) {
            list = this.statisticalTradeByWeek(map);
        } else if (DateTypeEnum.DAY.getCode().equals(dateType)) {
            list = this.statisticalTradeByDay(map);
        } else if (DateTypeEnum.HOUR.getCode().equals(dateType)) {
            list = this.statisticalTradeByHour(map);
        }
        return list;
    }

    private Map<String, Object> makeDomainToMap(StatisticalDomain statisticalDomain) {
        Map map = null;
        try {
            map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)statisticalDomain), String.class, Object.class);
        }
        catch (Exception e) {
            this.logger.error("pte.PtradeStaticsticalServiceImpl.makeDomainToMap", (Throwable)e);
        }
        if (map != null) {
            map.put("ptradeSuccess", org.apache.commons.lang3.StringUtils.join((Object[])new Serializable[]{PtradeDataStateEnum.PTRADE_PAID.getCode(), ",", PtradeDataStateEnum.PTRADE_FINISH.getCode()}));
        }
        return map;
    }

    private List<Map<String, Object>> statisticalTradeByYear(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptePtradeMapper.statisticalTradeByYear(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("pte.PtradeStaticsticalServiceImpl.statisticalPtradeByDay", (Throwable)e);
            return null;
        }
    }

    private List<Map<String, Object>> statisticalTradeByQuarter(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptePtradeMapper.statisticalTradeByQuarter(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("pte.PtradeStaticsticalServiceImpl.statisticalTradeByQuarter", (Throwable)e);
            return null;
        }
    }

    private List<Map<String, Object>> statisticalTradeByMonth(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptePtradeMapper.statisticalTradeByMonth(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("pte.PtradeStaticsticalServiceImpl.statisticalTradeByMonth", (Throwable)e);
            return null;
        }
    }

    private List<Map<String, Object>> statisticalTradeByWeek(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptePtradeMapper.statisticalTradeByWeek(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("pte.PtradeStaticsticalServiceImpl.statisticalTradeByWeek", (Throwable)e);
            return null;
        }
    }

    private List<Map<String, Object>> statisticalTradeByDay(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptePtradeMapper.statisticalTradeByDay(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("pte.PtradeStaticsticalServiceImpl.statisticalTradeByDay", (Throwable)e);
            return null;
        }
    }

    private List<Map<String, Object>> statisticalTradeByHour(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptePtradeMapper.statisticalTradeByHour(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("pte.PtradeStaticsticalServiceImpl.statisticalTradeByHour", (Throwable)e);
            return null;
        }
    }

    private String checkStatistical(StatisticalDomain statisticalDomain) {
        if (null == statisticalDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)statisticalDomain.getDateType())) {
            msg = msg + "\u7edf\u8ba1\u7ef4\u5ea6\u4e3a\u7a7a";
        }
        return msg;
    }

    @Override
    public List<Map<String, Object>> summaryOrderAmount(StatisticalDomain statisticalDomain) throws ApiException {
        Map<String, Object> map = this.makeDomainToMap(statisticalDomain);
        List<Map<String, Object>> amount = this.summary(map);
        return amount;
    }

    private List<Map<String, Object>> summary(Map<String, Object> map) {
        try {
            return this.ptePtradeMapper.summaryOrderAmount(map);
        }
        catch (Exception e) {
            this.logger.error("pte.PtradeStaticsticalServiceImpl.summaryOrder", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> statUnfinishedPtrade(Map<String, Object> params) throws ApiException {
        if (!params.containsKey("ptradeTypes") || !params.containsKey("tenantCode")) {
            return null;
        }
        return this.ptePtradeMapper.statUnfinishedPtrade(params);
    }

    @Override
    public List<Map<String, Object>> statRevenueExpenditureInfoByPtradeType(Map<String, Object> map) throws ApiException {
        if (map == null || !map.containsKey("tenantCode") || !map.containsKey("ptradeSuccess")) {
            this.logger.error("IllegalArgument", (Object)"tenantCode or ptradeSuccess cant be null");
            return null;
        }
        return this.ptePtradeMapper.statRevenueExpenditureInfoByPtradeType(map);
    }

    @Override
    public List<PtePtradeDaily> statOrderInfo(String gmtPaid, String ptradpdeCode, String tenantCode, String merchantCode) {
        List<PtePtradeDaily> ptePtradeDailyList = this.ptePtradeMapper.statOrderInfo(this.getQueryMapParam("gmtPaid,ptradpdeCode,tenantCode,merchantCode,dataState,dataStateExpre", new Object[]{gmtPaid, ptradpdeCode, tenantCode, merchantCode, PtradeDataStateEnum.PTRADE_PAID.getCode(), ">="}));
        if (!CollectionUtils.isEmpty(ptePtradeDailyList)) {
            for (PtePtradeDaily daily : ptePtradeDailyList) {
                daily.setPtradeDate(gmtPaid);
                daily.setDataScope(StatDataScopeEnum.DATA_SCOPE_MERCHANT.getCode());
            }
        }
        return ptePtradeDailyList;
    }

    @Override
    public List<PtePtradeDaily> statPtradeIncome(Map<String, Object> map) {
        if (CollectionUtils.isEmpty(map)) {
            throw new ApiException("pte.PtradeStaticsticalServiceImpl.statPtradeIncome", "query params is null");
        }
        return null;
    }
}

