/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPtaskexMapper;
import com.yqbsoft.laser.service.pm.dao.PmPtasklistMapper;
import com.yqbsoft.laser.service.pm.domain.PmPromotionInDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskConfigDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskReDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskexBean;
import com.yqbsoft.laser.service.pm.domain.PmPtaskexDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtaskexReDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtasklistDomain;
import com.yqbsoft.laser.service.pm.domain.PmPtasklistReDomain;
import com.yqbsoft.laser.service.pm.domain.PmUserCouponsendDomain;
import com.yqbsoft.laser.service.pm.domain.SkuBean;
import com.yqbsoft.laser.service.pm.model.PmChannelsend;
import com.yqbsoft.laser.service.pm.model.PmPtaskex;
import com.yqbsoft.laser.service.pm.model.PmPtasklist;
import com.yqbsoft.laser.service.pm.service.PmPromotionService;
import com.yqbsoft.laser.service.pm.service.PmPtasklistService;
import com.yqbsoft.laser.service.pm.service.PmUserCouponsendService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;

public class PmPtasklistServiceImpl
extends BaseServiceImpl
implements PmPtasklistService {
    private static final String SYS_CODE = "pm.PmPtasklistServiceImpl";
    @Value(value="${spring.restTemp.isTest:false}")
    private boolean isTest;
    private PmPtasklistMapper pmPtasklistMapper;
    private PmPtaskexMapper pmPtaskexMapper;
    PmUserCouponsendService pmUserCouponsendService;
    PmPromotionService pmPromotionService;

    public void setPmPtasklistMapper(PmPtasklistMapper pmPtasklistMapper) {
        this.pmPtasklistMapper = pmPtasklistMapper;
    }

    public void setPmPtaskexMapper(PmPtaskexMapper pmPtaskexMapper) {
        this.pmPtaskexMapper = pmPtaskexMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmPtasklistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtasklist(PmPtasklistDomain pmPtasklistDomain) {
        if (null == pmPtasklistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPtasklistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtasklistDefault(PmPtasklist pmPtasklist) {
        if (null == pmPtasklist) {
            return;
        }
        if (null == pmPtasklist.getDataState()) {
            pmPtasklist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmPtasklist.getGmtCreate()) {
            pmPtasklist.setGmtCreate(date);
        }
        pmPtasklist.setGmtModified(date);
        if (StringUtils.isBlank((String)pmPtasklist.getPtasklistCode())) {
            pmPtasklist.setPtasklistCode(this.getDefaultCode("PmPtasklist", "pmPtasklist", pmPtasklist.getTenantCode()));
        }
    }

    private String getDefaultCode(String tableName, String columnName, String tenantCode) {
        if (this.isTest) {
            return this.createUUIDString();
        }
        return this.getNo(null, tableName, columnName, tenantCode);
    }

    private int getPtasklistMaxCode() {
        int code = 0;
        try {
            return this.pmPtasklistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.getPtasklistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtasklistUpdataDefault(PmPtasklist pmPtasklist) {
        if (null == pmPtasklist) {
            return;
        }
        pmPtasklist.setGmtModified(this.getSysDate());
    }

    private void savePtasklistModel(PmPtasklist pmPtasklist) throws ApiException {
        if (null == pmPtasklist) {
            return;
        }
        try {
            this.pmPtasklistMapper.insert(pmPtasklist);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.savePtasklistModel.ex", (Throwable)e);
        }
    }

    private void savePtasklistBatchModel(List<PmPtasklist> pmPtasklistList) throws ApiException {
        if (null == pmPtasklistList || pmPtasklistList.isEmpty()) {
            return;
        }
        try {
            this.pmPtasklistMapper.insertBatch(pmPtasklistList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.savePtasklistBatchModel.ex", (Throwable)e);
        }
    }

    private PmPtasklist getPtasklistModelById(Integer ptasklistId) {
        if (null == ptasklistId) {
            return null;
        }
        try {
            return this.pmPtasklistMapper.selectByPrimaryKey(ptasklistId);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.getPtasklistModelById", (Throwable)e);
            return null;
        }
    }

    private PmPtasklist getPtasklistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPtasklistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.getPtasklistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtasklistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtasklistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.delPtasklistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtasklistServiceImpl.delPtasklistModelByCode.num");
        }
    }

    private void deletePtasklistModel(Integer ptasklistId) throws ApiException {
        if (null == ptasklistId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtasklistMapper.deleteByPrimaryKey(ptasklistId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.deletePtasklistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtasklistServiceImpl.deletePtasklistModel.num");
        }
    }

    private void updatePtasklistModel(PmPtasklist pmPtasklist) throws ApiException {
        if (null == pmPtasklist) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtasklistMapper.updateByPrimaryKeySelective(pmPtasklist);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updatePtasklistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updatePtasklistModel.num");
        }
    }

    private void updateStatePtasklistModel(Integer ptasklistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ptasklistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptasklistId", ptasklistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtasklistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updateStatePtasklistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updateStatePtasklistModel.null");
        }
    }

    private void updateStatePtasklistModelByCode(String tenantCode, String ptasklistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ptasklistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptasklistCode", ptasklistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtasklistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updateStatePtasklistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updateStatePtasklistModelByCode.null");
        }
    }

    private PmPtasklist makePtasklist(PmPtasklistDomain pmPtasklistDomain, PmPtasklist pmPtasklist) {
        if (null == pmPtasklistDomain) {
            return null;
        }
        if (null == pmPtasklist) {
            pmPtasklist = new PmPtasklist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPtasklist, (Object)pmPtasklistDomain);
            return pmPtasklist;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.makePtasklist", (Throwable)e);
            return null;
        }
    }

    private PmPtasklistReDomain makePmPtasklistReDomain(PmPtasklist pmPtasklist) {
        if (null == pmPtasklist) {
            return null;
        }
        PmPtasklistReDomain pmPtasklistReDomain = new PmPtasklistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPtasklistReDomain, (Object)pmPtasklist);
            return pmPtasklistReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.makePmPtasklistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPtasklist> queryPtasklistModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPtasklistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.queryPtasklistModel", (Throwable)e);
            return null;
        }
    }

    private int countPtasklist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPtasklistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.countPtasklist", (Throwable)e);
        }
        return i;
    }

    private PmPtasklist createPmPtasklist(PmPtasklistDomain pmPtasklistDomain) {
        String msg = this.checkPtasklist(pmPtasklistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPtasklistServiceImpl.savePtasklist.checkPtasklist", msg);
        }
        PmPtasklist pmPtasklist = this.makePtasklist(pmPtasklistDomain, null);
        this.setPtasklistDefault(pmPtasklist);
        return pmPtasklist;
    }

    @Override
    public String savePtasklist(PmPtasklistDomain pmPtasklistDomain) throws ApiException {
        this.savePtasklist(pmPtasklistDomain, false);
        return pmPtasklistDomain.getPtasklistCode();
    }

    public List<PmChannelsend> savePtasklist(PmPtasklistDomain pmPtasklistDomain, boolean okflag) throws ApiException {
        PmPtasklist pmPtasklist = this.createPmPtasklist(pmPtasklistDomain);
        PmPtaskex pmPtaskex = null;
        String ptaskexCode = null;
        List<PmChannelsend> sendList = null;
        if (StringUtils.isNotBlank((String)pmPtasklistDomain.getPromotionCode())) {
            pmPtaskex = this.getPtask(pmPtasklistDomain.getPromotionCode(), pmPtasklistDomain.getMemberBcode(), pmPtasklistDomain.getTenantCode());
            if (null == pmPtaskex) {
                PmPtaskexDomain pmPtaskexDomain = new PmPtaskexDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)pmPtaskexDomain, (Object)pmPtasklistDomain);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ptaskexCode = this.savePtaskex(pmPtaskexDomain);
            } else {
                ptaskexCode = pmPtaskex.getPtaskexCode();
            }
            if (okflag) {
                this.updatePtaskexStateByCode(pmPtasklistDomain.getTenantCode(), ptaskexCode, 2, 1, null);
                sendList = this.send(pmPtasklist);
            } else {
                this.updatePtaskexStateByCode(pmPtasklistDomain.getTenantCode(), ptaskexCode, 1, null, null);
            }
        }
        this.savePtasklistModel(pmPtasklist);
        pmPtasklistDomain.setPtasklistCode(pmPtasklist.getPtasklistCode());
        return sendList;
    }

    @Override
    public String savePtasklistBatch(List<PmPtasklistDomain> pmPtasklistDomainList) throws ApiException {
        if (null == pmPtasklistDomainList || pmPtasklistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPtasklist> pmPtasklistList = new ArrayList<PmPtasklist>();
        String code = "";
        for (PmPtasklistDomain pmPtasklistDomain : pmPtasklistDomainList) {
            PmPtasklist pmPtasklist = this.createPmPtasklist(pmPtasklistDomain);
            code = pmPtasklist.getPtasklistCode();
            pmPtasklistList.add(pmPtasklist);
        }
        this.savePtasklistBatchModel(pmPtasklistList);
        return code;
    }

    @Override
    public void updatePtasklistState(Integer ptasklistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ptasklistId) {
            return;
        }
        this.updateStatePtasklistModel(ptasklistId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtasklistStateByCode(String tenantCode, String ptasklistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ptasklistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtasklistModelByCode(tenantCode, ptasklistCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtasklist(PmPtasklistDomain pmPtasklistDomain) throws ApiException {
        String msg = this.checkPtasklist(pmPtasklistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updatePtasklist.checkPtasklist", msg);
        }
        PmPtasklist oldPmPtasklist = this.getPtasklistModelById(pmPtasklistDomain.getPtasklistId());
        if (null == oldPmPtasklist) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updatePtasklist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPtasklist pmPtasklist = this.makePtasklist(pmPtasklistDomain, oldPmPtasklist);
        this.setPtasklistUpdataDefault(pmPtasklist);
        this.updatePtasklistModel(pmPtasklist);
    }

    @Override
    public PmPtasklist getPtasklist(Integer ptasklistId) {
        if (null == ptasklistId) {
            return null;
        }
        return this.getPtasklistModelById(ptasklistId);
    }

    @Override
    public void deletePtasklist(Integer ptasklistId) throws ApiException {
        if (null == ptasklistId) {
            return;
        }
        this.deletePtasklistModel(ptasklistId);
    }

    @Override
    public QueryResult<PmPtasklist> queryPtasklistPage(Map<String, Object> map) {
        List<PmPtasklist> pmPtasklistList = this.queryPtasklistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtasklist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPtasklistList);
        return queryResult;
    }

    @Override
    public PmPtasklist getPtasklistByCode(String tenantCode, String ptasklistCode) throws ApiException {
        if (StringUtils.isBlank((String)ptasklistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptasklistCode", ptasklistCode);
        return this.getPtasklistModelByCode(map);
    }

    @Override
    public void deletePtasklistByCode(String tenantCode, String ptasklistCode) throws ApiException {
        if (StringUtils.isBlank((String)ptasklistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptasklistCode", ptasklistCode);
        this.delPtasklistModelByCode(map);
    }

    private String checkPtaskex(PmPtaskexDomain pmPtaskexDomain) {
        if (null == pmPtaskexDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmPtaskexDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtaskexDefault(PmPtaskex pmPtaskex) {
        if (null == pmPtaskex) {
            return;
        }
        if (null == pmPtaskex.getDataState()) {
            pmPtaskex.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmPtaskex.getGmtCreate()) {
            pmPtaskex.setGmtCreate(date);
        }
        pmPtaskex.setGmtModified(date);
        if (StringUtils.isBlank((String)pmPtaskex.getPtaskexCode())) {
            pmPtaskex.setPtaskexCode(this.getDefaultCode("PmPtaskex", "pmPtaskex", pmPtaskex.getTenantCode()));
        }
    }

    private int getPtaskexMaxCode() {
        int code = 0;
        try {
            return this.pmPtaskexMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.getPtaskexMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtaskexUpdataDefault(PmPtaskex pmPtaskex) {
        if (null == pmPtaskex) {
            return;
        }
        pmPtaskex.setGmtModified(this.getSysDate());
    }

    private void savePtaskexModel(PmPtaskex pmPtaskex) throws ApiException {
        if (null == pmPtaskex) {
            return;
        }
        try {
            this.pmPtaskexMapper.insert(pmPtaskex);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.savePtaskexModel.ex", (Throwable)e);
        }
    }

    private void savePtaskexBatchModel(List<PmPtaskex> pmPtaskexList) throws ApiException {
        if (null == pmPtaskexList || pmPtaskexList.isEmpty()) {
            return;
        }
        try {
            this.pmPtaskexMapper.insertBatch(pmPtaskexList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.savePtaskexBatchModel.ex", (Throwable)e);
        }
    }

    private PmPtaskex getPtaskexModelById(Integer ptaskexId) {
        if (null == ptaskexId) {
            return null;
        }
        try {
            return this.pmPtaskexMapper.selectByPrimaryKey(ptaskexId);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.getPtaskexModelById", (Throwable)e);
            return null;
        }
    }

    private PmPtaskex getPtaskexModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmPtaskexMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.getPtaskexModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtaskexModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskexMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.delPtaskexModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtasklistServiceImpl.delPtaskexModelByCode.num");
        }
    }

    private void deletePtaskexModel(Integer ptaskexId) throws ApiException {
        if (null == ptaskexId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskexMapper.deleteByPrimaryKey(ptaskexId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.deletePtaskexModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtasklistServiceImpl.deletePtaskexModel.num");
        }
    }

    private void updatePtaskexModel(PmPtaskex pmPtaskex) throws ApiException {
        if (null == pmPtaskex) {
            return;
        }
        int i = 0;
        try {
            i = this.pmPtaskexMapper.updateByPrimaryKey(pmPtaskex);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updatePtaskexModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updatePtaskexModel.num");
        }
    }

    private void updateStatePtaskexModel(Integer ptaskexId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ptaskexId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptaskexId", ptaskexId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskexMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updateStatePtaskexModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updateStatePtaskexModel.null");
        }
    }

    private void updateStatePtaskexModelByCode(String tenantCode, String ptaskexCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ptaskexCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskexCode", ptaskexCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmPtaskexMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updateStatePtaskexModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updateStatePtaskexModelByCode.null");
        }
    }

    private PmPtaskex makePtaskex(PmPtaskexDomain pmPtaskexDomain, PmPtaskex pmPtaskex) {
        if (null == pmPtaskexDomain) {
            return null;
        }
        if (null == pmPtaskex) {
            pmPtaskex = new PmPtaskex();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskex, (Object)pmPtaskexDomain);
            return pmPtaskex;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.makePtaskex", (Throwable)e);
            return null;
        }
    }

    private PmPtaskexReDomain makePmPtaskexReDomain(PmPtaskex pmPtaskex) {
        if (null == pmPtaskex) {
            return null;
        }
        PmPtaskexReDomain pmPtaskexReDomain = new PmPtaskexReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskexReDomain, (Object)pmPtaskex);
            return pmPtaskexReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.makePmPtaskexReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmPtaskex> queryPtaskexModelPage(Map<String, Object> parammap) {
        try {
            return this.pmPtaskexMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.queryPtaskexModel", (Throwable)e);
            return null;
        }
    }

    private int countPtaskex(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPtaskexMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.countPtaskex", (Throwable)e);
        }
        return i;
    }

    private PmPtaskex createPmPtaskex(PmPtaskexDomain pmPtaskexDomain) {
        String msg = this.checkPtaskex(pmPtaskexDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPtasklistServiceImpl.savePtaskex.checkPtaskex", msg);
        }
        PmPtaskex pmPtaskex = this.makePtaskex(pmPtaskexDomain, null);
        this.setPtaskexDefault(pmPtaskex);
        return pmPtaskex;
    }

    @Override
    public String savePtaskex(PmPtaskexDomain pmPtaskexDomain) throws ApiException {
        PmPtaskex pmPtaskex = this.createPmPtaskex(pmPtaskexDomain);
        this.savePtaskexModel(pmPtaskex);
        return pmPtaskex.getPtaskexCode();
    }

    @Override
    public String savePtaskexBatch(List<PmPtaskexDomain> pmPtaskexDomainList) throws ApiException {
        if (null == pmPtaskexDomainList || pmPtaskexDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmPtaskex> pmPtaskexList = new ArrayList<PmPtaskex>();
        String code = "";
        for (PmPtaskexDomain pmPtaskexDomain : pmPtaskexDomainList) {
            PmPtaskex pmPtaskex = this.createPmPtaskex(pmPtaskexDomain);
            code = pmPtaskex.getPtaskexCode();
            pmPtaskexList.add(pmPtaskex);
        }
        this.savePtaskexBatchModel(pmPtaskexList);
        return code;
    }

    @Override
    public void updatePtaskexState(Integer ptaskexId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ptaskexId) {
            return;
        }
        this.updateStatePtaskexModel(ptaskexId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtaskexStateByCode(String tenantCode, String ptaskexCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ptaskexCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtaskexModelByCode(tenantCode, ptaskexCode, dataState, oldDataState, map);
    }

    public void setPmUserCouponsendService(PmUserCouponsendService pmUserCouponsendService) {
        this.pmUserCouponsendService = pmUserCouponsendService;
    }

    private List<PmChannelsend> send(PmPtasklist pmPtasklist) {
        if (null == pmPtasklist) {
            return null;
        }
        ArrayList<PmUserCouponsendDomain> pmUserCouponsendDomainList = new ArrayList<PmUserCouponsendDomain>();
        PmUserCouponsendDomain pmUserCouponsendDomain = new PmUserCouponsendDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmUserCouponsendDomain, (Object)pmPtasklist);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtasklistServiceImpl.send.e", (Throwable)e);
        }
        pmUserCouponsendDomain.setCouponAmount(pmPtasklist.getPtasklistNum());
        pmUserCouponsendDomain.setUserCouponsendType(1);
        pmUserCouponsendDomain.setUserCouponsendDir(0);
        pmUserCouponsendDomain.setUsercouponOrgin("1");
        pmUserCouponsendDomain.setUsercouponCode(pmPtasklist.getPromotionCode());
        pmUserCouponsendDomain.setChannelCode(pmPtasklist.getChannelCode());
        pmUserCouponsendDomain.setChannelName(pmPtasklist.getChannelName());
        pmUserCouponsendDomain.setMemberBcode(pmPtasklist.getMemberBcode());
        pmUserCouponsendDomain.setMemberBname(pmPtasklist.getMemberBname());
        pmUserCouponsendDomain.setUsercouponOcode(pmPtasklist.getPtasklistOpcode());
        pmUserCouponsendDomainList.add(pmUserCouponsendDomain);
        return this.pmUserCouponsendService.saveuserCouponsendBatch(pmUserCouponsendDomainList);
    }

    @Override
    public void updatePtaskex(PmPtaskexDomain pmPtaskexDomain) throws ApiException {
        String msg = this.checkPtaskex(pmPtaskexDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updatePtaskex.checkPtaskex", msg);
        }
        PmPtaskex oldPmPtaskex = this.getPtaskexModelById(pmPtaskexDomain.getPtaskexId());
        if (null == oldPmPtaskex) {
            throw new ApiException("pm.PmPtasklistServiceImpl.updatePtaskex.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmPtaskex pmPtaskex = this.makePtaskex(pmPtaskexDomain, oldPmPtaskex);
        this.setPtaskexUpdataDefault(pmPtaskex);
        this.updatePtaskexModel(pmPtaskex);
    }

    @Override
    public PmPtaskex getPtaskex(Integer ptaskexId) {
        if (null == ptaskexId) {
            return null;
        }
        return this.getPtaskexModelById(ptaskexId);
    }

    @Override
    public void deletePtaskex(Integer ptaskexId) throws ApiException {
        if (null == ptaskexId) {
            return;
        }
        this.deletePtaskexModel(ptaskexId);
    }

    @Override
    public QueryResult<PmPtaskex> queryPtaskexPage(Map<String, Object> map) {
        List<PmPtaskex> pmPtaskexList = this.queryPtaskexModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtaskex(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPtaskexList);
        return queryResult;
    }

    @Override
    public PmPtaskex getPtaskexByCode(String tenantCode, String ptaskexCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskexCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskexCode", ptaskexCode);
        return this.getPtaskexModelByCode(map);
    }

    @Override
    public void deletePtaskexByCode(String tenantCode, String ptaskexCode) throws ApiException {
        if (StringUtils.isBlank((String)ptaskexCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ptaskexCode", ptaskexCode);
        this.delPtaskexModelByCode(map);
    }

    public void setPmPromotionService(PmPromotionService pmPromotionService) {
        this.pmPromotionService = pmPromotionService;
    }

    @Override
    public List<PmChannelsend> savePtasklistEx(PmPtaskexBean pmPtaskexBean) throws ApiException {
        if (null == pmPtaskexBean) {
            return null;
        }
        SkuBean skuBean = new SkuBean();
        try {
            BeanUtils.copyAllPropertys((Object)skuBean, (Object)pmPtaskexBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        skuBean.setCheckSku("1");
        skuBean.setPmCheckBean(pmPtaskexBean.getPmCheckBean());
        List<PmPromotionInDomain> pmList = this.pmPromotionService.queryPromotionPtask(skuBean);
        if (ListUtil.isEmpty(pmList)) {
            return null;
        }
        return this.createPtask(pmList, pmPtaskexBean);
    }

    private List<PmChannelsend> createPtask(List<PmPromotionInDomain> pmList, PmPtaskexBean pmPtaskexBean) {
        if (ListUtil.isEmpty(pmList) || null == pmPtaskexBean) {
            return null;
        }
        ArrayList<PmChannelsend> sendList = new ArrayList<PmChannelsend>();
        for (PmPromotionInDomain pmPromotionInDomain : pmList) {
            List ptaskList;
            PmPtaskex pmPtaskex = this.getPtask(pmPromotionInDomain.getPromotionCode(), pmPtaskexBean.getMemberBcode(), pmPtaskexBean.getTenantCode());
            if (null != pmPtaskex && pmPtaskex.getDataState() > 1 || ListUtil.isEmpty((Collection)(ptaskList = DisUtil.getListByMapJson((String)"pm-promotion_ptask", PmPtaskReDomain.class)))) continue;
            boolean flag = true;
            boolean okflag = false;
            for (int i = 0; i < ptaskList.size(); ++i) {
                PmPtaskReDomain pmPtaskReDomain = (PmPtaskReDomain)ptaskList.get(0);
                if (i == ptaskList.size() - 1 && flag) {
                    okflag = true;
                }
                if (this.makePtask(pmPtaskex, pmPtaskexBean, pmPtaskReDomain, okflag, sendList)) continue;
                flag = false;
            }
        }
        return sendList;
    }

    private boolean makePtask(PmPtaskex pmPtaskex, PmPtaskexBean pmPtaskexBean, PmPtaskReDomain pmPtaskReDomain, boolean okflag, List<PmChannelsend> sendList) {
        if (null == pmPtaskex || null == pmPtaskexBean || null == pmPtaskReDomain) {
            return false;
        }
        if (ListUtil.isEmpty(pmPtaskReDomain.getPmPtaskConfigDomainList())) {
            return false;
        }
        List<PmPtasklist> relist = this.queryPtasklistModelPage(this.getQueryMapParam("ptaskCode,promotionCode,tenantCode", new Object[]{pmPtaskReDomain.getPtaskCode(), pmPtaskReDomain.getPromotionCode(), pmPtaskReDomain.getTenantCode()}));
        if (ListUtil.isNotEmpty(relist)) {
            return true;
        }
        HashMap<String, String> objmap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)pmPtaskexBean.getPtasklistOptype())) {
            objmap.put(pmPtaskexBean.getPtasklistOptype(), pmPtaskexBean.getPtasklistOpcode());
        }
        if (StringUtils.isNotBlank((String)pmPtaskexBean.getPtasklistOptype1())) {
            objmap.put(pmPtaskexBean.getPtasklistOptype(), pmPtaskexBean.getPtasklistOpcode1());
        }
        if (StringUtils.isNotBlank((String)pmPtaskexBean.getPtasklistOptype2())) {
            objmap.put(pmPtaskexBean.getPtasklistOptype(), pmPtaskexBean.getPtasklistOpcode2());
        }
        if (StringUtils.isNotBlank((String)pmPtaskexBean.getPtasklistOptype3())) {
            objmap.put(pmPtaskexBean.getPtasklistOptype(), pmPtaskexBean.getPtasklistOpcode3());
        }
        if (StringUtils.isNotBlank((String)pmPtaskexBean.getPtasklistOptype4())) {
            objmap.put(pmPtaskexBean.getPtasklistOptype(), pmPtaskexBean.getPtasklistOpcode4());
        }
        if (StringUtils.isNotBlank((String)pmPtaskexBean.getPtasklistOptype5())) {
            objmap.put(pmPtaskexBean.getPtasklistOptype(), pmPtaskexBean.getPtasklistOpcode5());
        }
        if (this.checkConf(this.makeConfiglist(pmPtaskReDomain.getPmPtaskConfigDomainList()), objmap)) {
            PmPtasklistDomain pmPtasklistDomain = new PmPtasklistDomain();
            try {
                BeanUtils.copyAllPropertys((Object)pmPtasklistDomain, (Object)pmPtaskexBean);
                BeanUtils.copyAllPropertys((Object)pmPtasklistDomain, (Object)pmPtaskReDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            List<PmChannelsend> resendList = this.savePtasklist(pmPtasklistDomain, okflag);
            if (ListUtil.isEmpty(resendList)) {
                sendList.addAll(resendList);
            }
            return true;
        }
        return false;
    }

    private Map<String, List<String>> makeConfiglist(List<PmPtaskConfigDomain> pmPtaskConfigDomainList) {
        if (ListUtil.isEmpty(pmPtaskConfigDomainList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (PmPtaskConfigDomain pmPtaskConfigDomain : pmPtaskConfigDomainList) {
            ArrayList<String> list = (ArrayList<String>)map.get(pmPtaskConfigDomain.getPtaskConfigType() + "|=");
            if (null == list) {
                list = new ArrayList<String>();
                map.put(pmPtaskConfigDomain.getPtaskConfigType() + "|=", list);
            }
            list.add(pmPtaskConfigDomain.getPtaskConfigOpcode());
        }
        return map;
    }

    private boolean checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        for (String keys : map.keySet()) {
            String[] keyStr = keys.split("\\|");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)key);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs;
                for (String o : otrs = objValue.toString().split("\\,")) {
                    if (this.cond(valueList, term, o)) break;
                }
                continue;
            }
            if (this.cond(valueList, term, objValue)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private boolean cond(List<String> valueList, String term, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        String value = valueList.get(0);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue.toString())) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (!valueList.contains(objValue.toString())) {
                flag = false;
            }
        }
        return flag;
    }

    private PmPtaskex getPtask(String promotionCode, String memberBcode, String tenantCode) {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List<PmPtaskex> exlist = this.queryPtaskexModelPage(this.getQueryMapParam("promotionCode,memberBcode,tenantCode", new Object[]{promotionCode, memberBcode, tenantCode}));
        if (ListUtil.isEmpty(exlist)) {
            return null;
        }
        PmPtaskex pmPtaskex = exlist.get(0);
        if (null == pmPtaskex.getDataState()) {
            pmPtaskex.setDataState(0);
        }
        return pmPtaskex;
    }
}

