/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmCouponBatchlistMapper;
import com.yqbsoft.laser.service.pm.domain.PmCouponBatchlistDomain;
import com.yqbsoft.laser.service.pm.domain.PmCouponBatchlistReDomain;
import com.yqbsoft.laser.service.pm.model.PmCouponBatchlist;
import com.yqbsoft.laser.service.pm.service.PmCouponBatchlistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PmCouponBatchlistServiceImpl
extends BaseServiceImpl
implements PmCouponBatchlistService {
    private static final String SYS_CODE = "pm.PmCouponBatchlistServiceImpl";
    private PmCouponBatchlistMapper pmCouponBatchlistMapper;

    public void setPmCouponBatchlistMapper(PmCouponBatchlistMapper pmCouponBatchlistMapper) {
        this.pmCouponBatchlistMapper = pmCouponBatchlistMapper;
    }

    private Date getSysDate() {
        try {
            return this.pmCouponBatchlistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pm.PmCouponBatchlistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCouponBatchlist(PmCouponBatchlistDomain pmCouponBatchlistDomain) {
        if (null == pmCouponBatchlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pmCouponBatchlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCouponBatchlistDefault(PmCouponBatchlist pmCouponBatchlist) {
        if (null == pmCouponBatchlist) {
            return;
        }
        if (null == pmCouponBatchlist.getDataState()) {
            pmCouponBatchlist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pmCouponBatchlist.getGmtCreate()) {
            pmCouponBatchlist.setGmtCreate(date);
        }
        pmCouponBatchlist.setGmtModified(date);
        if (StringUtils.isBlank((String)pmCouponBatchlist.getCouponBatchlistCode())) {
            pmCouponBatchlist.setCouponBatchlistCode(this.getNo(null, "PmCouponBatchlist", "pmCouponBatchlist", pmCouponBatchlist.getTenantCode()));
        }
    }

    private int getCouponBatchlistMaxCode() {
        int code = 0;
        try {
            return this.pmCouponBatchlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pm.PmCouponBatchlistServiceImpl.getCouponBatchlistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCouponBatchlistUpdataDefault(PmCouponBatchlist pmCouponBatchlist) {
        if (null == pmCouponBatchlist) {
            return;
        }
        pmCouponBatchlist.setGmtModified(this.getSysDate());
    }

    private void saveCouponBatchlistModel(PmCouponBatchlist pmCouponBatchlist) throws ApiException {
        if (null == pmCouponBatchlist) {
            return;
        }
        try {
            this.pmCouponBatchlistMapper.insert(pmCouponBatchlist);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.saveCouponBatchlistModel.ex", (Throwable)e);
        }
    }

    private void saveCouponBatchlistBatchModel(List<PmCouponBatchlist> pmCouponBatchlistList) throws ApiException {
        if (null == pmCouponBatchlistList || pmCouponBatchlistList.isEmpty()) {
            return;
        }
        try {
            this.pmCouponBatchlistMapper.insertBatch(pmCouponBatchlistList);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.saveCouponBatchlistBatchModel.ex", (Throwable)e);
        }
    }

    private PmCouponBatchlist getCouponBatchlistModelById(Integer couponBatchlistId) {
        if (null == couponBatchlistId) {
            return null;
        }
        try {
            return this.pmCouponBatchlistMapper.selectByPrimaryKey(couponBatchlistId);
        }
        catch (Exception e) {
            this.logger.error("pm.PmCouponBatchlistServiceImpl.getCouponBatchlistModelById", (Throwable)e);
            return null;
        }
    }

    private PmCouponBatchlist getCouponBatchlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pmCouponBatchlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmCouponBatchlistServiceImpl.getCouponBatchlistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCouponBatchlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pmCouponBatchlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.delCouponBatchlistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.delCouponBatchlistModelByCode.num");
        }
    }

    private void deleteCouponBatchlistModel(Integer couponBatchlistId) throws ApiException {
        if (null == couponBatchlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.pmCouponBatchlistMapper.deleteByPrimaryKey(couponBatchlistId);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.deleteCouponBatchlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.deleteCouponBatchlistModel.num");
        }
    }

    private void updateCouponBatchlistModel(PmCouponBatchlist pmCouponBatchlist) throws ApiException {
        if (null == pmCouponBatchlist) {
            return;
        }
        int i = 0;
        try {
            i = this.pmCouponBatchlistMapper.updateByPrimaryKey(pmCouponBatchlist);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.updateCouponBatchlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.updateCouponBatchlistModel.num");
        }
    }

    private void updateStateCouponBatchlistModel(Integer couponBatchlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == couponBatchlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("couponBatchlistId", couponBatchlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmCouponBatchlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.updateStateCouponBatchlistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.updateStateCouponBatchlistModel.null");
        }
    }

    private void updateStateCouponBatchlistModelByCode(String tenantCode, String couponBatchlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("couponBatchlistCode", couponBatchlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pmCouponBatchlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.updateStateCouponBatchlistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.updateStateCouponBatchlistModelByCode.null");
        }
    }

    private PmCouponBatchlist makeCouponBatchlist(PmCouponBatchlistDomain pmCouponBatchlistDomain, PmCouponBatchlist pmCouponBatchlist) {
        if (null == pmCouponBatchlistDomain) {
            return null;
        }
        if (null == pmCouponBatchlist) {
            pmCouponBatchlist = new PmCouponBatchlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pmCouponBatchlist, (Object)pmCouponBatchlistDomain);
            return pmCouponBatchlist;
        }
        catch (Exception e) {
            this.logger.error("pm.PmCouponBatchlistServiceImpl.makeCouponBatchlist", (Throwable)e);
            return null;
        }
    }

    private PmCouponBatchlistReDomain makePmCouponBatchlistReDomain(PmCouponBatchlist pmCouponBatchlist) {
        if (null == pmCouponBatchlist) {
            return null;
        }
        PmCouponBatchlistReDomain pmCouponBatchlistReDomain = new PmCouponBatchlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pmCouponBatchlistReDomain, (Object)pmCouponBatchlist);
            return pmCouponBatchlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("pm.PmCouponBatchlistServiceImpl.makePmCouponBatchlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PmCouponBatchlist> queryCouponBatchlistModelPage(Map<String, Object> parammap) {
        try {
            return this.pmCouponBatchlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PmCouponBatchlistServiceImpl.queryCouponBatchlistModel", (Throwable)e);
            return null;
        }
    }

    private int countCouponBatchlist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmCouponBatchlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmCouponBatchlistServiceImpl.countCouponBatchlist", (Throwable)e);
        }
        return i;
    }

    private PmCouponBatchlist createPmCouponBatchlist(PmCouponBatchlistDomain pmCouponBatchlistDomain) {
        String msg = this.checkCouponBatchlist(pmCouponBatchlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.saveCouponBatchlist.checkCouponBatchlist", msg);
        }
        PmCouponBatchlist pmCouponBatchlist = this.makeCouponBatchlist(pmCouponBatchlistDomain, null);
        this.setCouponBatchlistDefault(pmCouponBatchlist);
        return pmCouponBatchlist;
    }

    @Override
    public String saveCouponBatchlist(PmCouponBatchlistDomain pmCouponBatchlistDomain) throws ApiException {
        PmCouponBatchlist pmCouponBatchlist = this.createPmCouponBatchlist(pmCouponBatchlistDomain);
        this.saveCouponBatchlistModel(pmCouponBatchlist);
        return pmCouponBatchlist.getCouponBatchlistCode();
    }

    @Override
    public String saveCouponBatchlistBatch(List<PmCouponBatchlistDomain> pmCouponBatchlistDomainList) throws ApiException {
        if (null == pmCouponBatchlistDomainList || pmCouponBatchlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PmCouponBatchlist> pmCouponBatchlistList = new ArrayList<PmCouponBatchlist>();
        String code = "";
        for (PmCouponBatchlistDomain pmCouponBatchlistDomain : pmCouponBatchlistDomainList) {
            PmCouponBatchlist pmCouponBatchlist = this.createPmCouponBatchlist(pmCouponBatchlistDomain);
            code = pmCouponBatchlist.getCouponBatchlistCode();
            pmCouponBatchlistList.add(pmCouponBatchlist);
        }
        this.saveCouponBatchlistBatchModel(pmCouponBatchlistList);
        return code;
    }

    @Override
    public void updateCouponBatchlistState(Integer couponBatchlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == couponBatchlistId) {
            return;
        }
        this.updateStateCouponBatchlistModel(couponBatchlistId, dataState, oldDataState, map);
    }

    @Override
    public void updateCouponBatchlistStateByCode(String tenantCode, String couponBatchlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCouponBatchlistModelByCode(tenantCode, couponBatchlistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCouponBatchlist(PmCouponBatchlistDomain pmCouponBatchlistDomain) throws ApiException {
        String msg = this.checkCouponBatchlist(pmCouponBatchlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.updateCouponBatchlist.checkCouponBatchlist", msg);
        }
        PmCouponBatchlist oldPmCouponBatchlist = this.getCouponBatchlistModelById(pmCouponBatchlistDomain.getCouponBatchlistId());
        if (null == oldPmCouponBatchlist) {
            throw new ApiException("pm.PmCouponBatchlistServiceImpl.updateCouponBatchlist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PmCouponBatchlist pmCouponBatchlist = this.makeCouponBatchlist(pmCouponBatchlistDomain, oldPmCouponBatchlist);
        this.setCouponBatchlistUpdataDefault(pmCouponBatchlist);
        this.updateCouponBatchlistModel(pmCouponBatchlist);
    }

    @Override
    public PmCouponBatchlist getCouponBatchlist(Integer couponBatchlistId) {
        if (null == couponBatchlistId) {
            return null;
        }
        return this.getCouponBatchlistModelById(couponBatchlistId);
    }

    @Override
    public void deleteCouponBatchlist(Integer couponBatchlistId) throws ApiException {
        if (null == couponBatchlistId) {
            return;
        }
        this.deleteCouponBatchlistModel(couponBatchlistId);
    }

    @Override
    public QueryResult<PmCouponBatchlist> queryCouponBatchlistPage(Map<String, Object> map) {
        List<PmCouponBatchlist> pmCouponBatchlistList = this.queryCouponBatchlistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCouponBatchlist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmCouponBatchlistList);
        return queryResult;
    }

    @Override
    public PmCouponBatchlist getCouponBatchlistByCode(String tenantCode, String couponBatchlistCode) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("couponBatchlistCode", couponBatchlistCode);
        return this.getCouponBatchlistModelByCode(map);
    }

    @Override
    public void deleteCouponBatchlistByCode(String tenantCode, String couponBatchlistCode) throws ApiException {
        if (StringUtils.isBlank((String)couponBatchlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("couponBatchlistCode", couponBatchlistCode);
        this.delCouponBatchlistModelByCode(map);
    }
}

