/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.pm.domain.PmPromotionInDomain;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
public abstract class PmCacheBaseImpl
extends BaseServiceImpl {
    public static final String PM_PROMOTIONINCODE = "pm-promotionin-code";
    @Value(value="${spring.pm.cache.pmRemotCache:true}")
    private boolean pmRemotCache;

    protected List<String> getCacheList(String key) {
        String remote = "";
        if (!this.pmRemotCache) {
            return DisUtil.getListJson((String)key, String.class);
        }
        remote = DisUtil.getRemot((String)key);
        if (StringUtils.isBlank((String)remote)) {
            return null;
        }
        return JsonUtil.buildNormalBinder().getJsonToList(remote, String.class);
    }

    protected <T> List<T> getRemotCacheList(String key, Class<T> tClass) {
        long l = System.currentTimeMillis();
        String remote = SupDisUtil.getRemot((String)key);
        long l2 = System.currentTimeMillis();
        this.logger.debug("PmCacheBaseImpl.getRemotCacheList getremot key time ", (Object)(key + "=" + (l2 - l)));
        if (StringUtils.isBlank((String)remote)) {
            return null;
        }
        return JsonUtil.buildNormalBinder().getJsonToList(remote, tClass);
    }

    protected PmPromotionInDomain getremotPmCacheObject(String key) {
        long l = System.currentTimeMillis();
        PmPromotionInDomain pmPromotionInDomain = (PmPromotionInDomain)DisUtil.getObjectJson((String)key, PmPromotionInDomain.class);
        if (null != pmPromotionInDomain) {
            return pmPromotionInDomain;
        }
        String remote = "";
        remote = SupDisUtil.getRemot((String)key);
        long l2 = System.currentTimeMillis();
        this.logger.debug("PmCacheBaseImpl.getremotCacheObject getremot key time ", (Object)(key + "=" + (l2 - l)));
        if (StringUtils.isBlank((String)remote)) {
            return null;
        }
        return (PmPromotionInDomain)JsonUtil.buildNormalBinder().getJsonToObject(remote, PmPromotionInDomain.class);
    }

    protected <T> T getremotCacheObject(String key, Class<T> tClass) {
        long l = System.currentTimeMillis();
        String remote = "";
        remote = SupDisUtil.getRemot((String)key);
        long l2 = System.currentTimeMillis();
        this.logger.debug("PmCacheBaseImpl.getremotCacheObject getremot key time ", (Object)(key + "=" + (l2 - l)));
        if (StringUtils.isBlank((String)remote)) {
            return null;
        }
        return (T)JsonUtil.buildNormalBinder().getJsonToObject(remote, tClass);
    }

    protected <T> List<T> getRemotCacheMapList(String key, String field, Class<T> tClass) {
        long l = System.currentTimeMillis();
        String remoteMap = SupDisUtil.getRemotMap((String)key, (String)field);
        long l2 = System.currentTimeMillis();
        this.logger.debug("PmCacheBaseImpl.getRemotCacheMapList getremot key time ", (Object)(key + "=" + (l2 - l)));
        if (StringUtils.isBlank((String)remoteMap)) {
            return null;
        }
        return JsonUtil.buildNormalBinder().getJsonToList(remoteMap, tClass);
    }

    protected <T> T getRemotCacheMap(String key, String field, Class<T> tClass) {
        long l = System.currentTimeMillis();
        String remoteMap = SupDisUtil.getRemotMap((String)key, (String)field);
        long l2 = System.currentTimeMillis();
        this.logger.debug("PmCacheBaseImpl.getRemotCacheMapList getremot key time ", (Object)(key + "=" + (l2 - l)));
        if (StringUtils.isBlank((String)remoteMap)) {
            return null;
        }
        return (T)JsonUtil.buildNormalBinder().getJsonToObject(remoteMap, tClass);
    }
}

