/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pm.service.impl;

import com.yqbsoft.laser.service.esb.annotation.ApiMethod;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pm.dao.PmPtaskCancelMapper;
import com.yqbsoft.laser.service.pm.domain.PmPtaskCancelDomain;
import com.yqbsoft.laser.service.pm.model.PmPtask;
import com.yqbsoft.laser.service.pm.model.PmPtaskCancel;
import com.yqbsoft.laser.service.pm.service.PmPtaskCancelService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PmPtaskCancelServiceImpl
extends BaseServiceImpl
implements PmPtaskCancelService {
    private static final String SYS_CODE = "pm.PmPtaskCancelServiceImpl";
    private PmPtaskCancelMapper pmPtaskCancelMapper;

    public void setPmPtaskCancelMapper(PmPtaskCancelMapper pmPtaskCancelMapper) {
        this.pmPtaskCancelMapper = pmPtaskCancelMapper;
    }

    @Override
    @ApiMethod(code="pm.PmPtask.cancel.queryPtaskCancelPage", name="\u8425\u9500\u6d3b\u52a8\u6838\u92b7\u4efb\u52a1\u5206\u9875\u67e5\u8be2", paramStr="map", description="\u8425\u9500\u6d3b\u52a8\u6838\u92b7\u4efb\u52a1\u5206\u9875\u67e5\u8be2")
    public QueryResult<PmPtask> queryPtaskCancelPage(Map<String, Object> parammap) {
        List<PmPtask> pmPtaskList = this.queryPtaskCancel(parammap);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        int count = 0;
        if (ListUtil.isNotEmpty(pmPtaskList)) {
            count = this.countPtask(parammap);
        }
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pmPtaskList);
        return queryResult;
    }

    @Override
    public String savePtaskCancel(PmPtaskCancelDomain ptaskCancelDomain) throws ApiException {
        PmPtaskCancel ptaskCancel = this.createPmPtaskCancel(ptaskCancelDomain);
        this.savePtaskModel(ptaskCancel);
        return ptaskCancel.getPtaskCancelCode();
    }

    private void savePtaskModel(PmPtaskCancel ptaskCancel) throws ApiException {
        if (null == ptaskCancel) {
            return;
        }
        try {
            this.pmPtaskCancelMapper.insert(ptaskCancel);
        }
        catch (Exception e) {
            throw new ApiException("pm.PmPtaskCancelServiceImpl.savePtaskCancelModel.ex", (Throwable)e);
        }
    }

    private PmPtaskCancel createPmPtaskCancel(PmPtaskCancelDomain ptaskCancelDomain) {
        String msg = this.checkPtask(ptaskCancelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pm.PmPtaskCancelServiceImpl.savePtaskCancel.checkPtaskCancel", msg);
        }
        PmPtaskCancel ptaskCancel = this.makePtask(ptaskCancelDomain, null);
        this.setPtaskCancelDefault(ptaskCancel);
        return ptaskCancel;
    }

    private void setPtaskCancelDefault(PmPtaskCancel ptaskCancel) {
        if (null == ptaskCancel) {
            return;
        }
        if (null == ptaskCancel.getDataState()) {
            ptaskCancel.setDataState(0);
        }
        Date date = new Date();
        if (null == ptaskCancel.getGmtCreate()) {
            ptaskCancel.setGmtCreate(date);
        }
        ptaskCancel.setUpdateTime(date);
        if (StringUtils.isBlank((String)ptaskCancel.getPtaskCode())) {
            ptaskCancel.setPtaskCancelCode(this.getNo(null, "ptaskCancel", "ptaskCancel", ptaskCancel.getTenantCode()));
        }
    }

    private String checkPtask(PmPtaskCancelDomain ptaskCancelDomain) {
        if (null == ptaskCancelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ptaskCancelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private PmPtaskCancel makePtask(PmPtaskCancelDomain ptaskCancelDomain, PmPtaskCancel ptaskCancel) {
        if (null == ptaskCancelDomain) {
            return null;
        }
        if (null == ptaskCancelDomain) {
            ptaskCancel = new PmPtaskCancel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptaskCancel, (Object)ptaskCancelDomain);
            return ptaskCancel;
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskCancelServiceImpl.makePtaskCancel", (Throwable)e);
            return null;
        }
    }

    private List<PmPtask> queryPtaskCancel(Map<String, Object> parammap) {
        try {
            return this.pmPtaskCancelMapper.queryPtaskCancel(parammap);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskCancelServiceImpl.queryPtaskCancel", (Throwable)e);
            return null;
        }
    }

    private int countPtask(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pmPtaskCancelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pm.PmPtaskCancelServiceImpl.countPtask", (Throwable)e);
        }
        return i;
    }
}

