/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtOpContractMapper;
import com.yqbsoft.laser.service.potential.domain.PtOpContractDomain;
import com.yqbsoft.laser.service.potential.domain.PtOpContractImportDomin;
import com.yqbsoft.laser.service.potential.domain.PtOpContractReDomain;
import com.yqbsoft.laser.service.potential.domain.PtOpContractTaskDomain;
import com.yqbsoft.laser.service.potential.domain.PtOpContractZoneDomain;
import com.yqbsoft.laser.service.potential.enums.ContractNatureEnum;
import com.yqbsoft.laser.service.potential.enums.ContractSignTypeEnum;
import com.yqbsoft.laser.service.potential.enums.ContractStatusEnum;
import com.yqbsoft.laser.service.potential.enums.ContractTypeEnum;
import com.yqbsoft.laser.service.potential.enums.ContractUserInfoTypeEnum;
import com.yqbsoft.laser.service.potential.model.PtOpContract;
import com.yqbsoft.laser.service.potential.model.PtOpContractTask;
import com.yqbsoft.laser.service.potential.model.PtOpContractZone;
import com.yqbsoft.laser.service.potential.service.PtOpContractService;
import com.yqbsoft.laser.service.potential.service.PtOpContractTaskService;
import com.yqbsoft.laser.service.potential.service.PtOpContractZoneService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;

public class PtOpContractServiceImpl
extends BaseServiceImpl
implements PtOpContractService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtOpContractServiceImpl";
    @Value(value="${spring.restTemp.isTest:false}")
    private boolean isTest;
    private PtOpContractMapper ptOpContractMapper;
    private PtOpContractTaskService ptOpContractTaskService;
    private PtOpContractZoneService ptOpContractZoneService;

    public void setPtOpContractMapper(PtOpContractMapper ptOpContractMapper) {
        this.ptOpContractMapper = ptOpContractMapper;
    }

    public void setPtOpContractTaskService(PtOpContractTaskService ptOpContractTaskService) {
        this.ptOpContractTaskService = ptOpContractTaskService;
    }

    public void setPtOpContractZoneService(PtOpContractZoneService ptOpContractZoneService) {
        this.ptOpContractZoneService = ptOpContractZoneService;
    }

    private Date getSysDate() {
        try {
            return this.ptOpContractMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtOpContract(PtOpContractDomain domain, Boolean isBatch) {
        if (null == domain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)domain.getTenantCode())) {
            msg = msg + "TenantCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getChannelCode())) {
            msg = msg + "channelCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getOpcontractName())) {
            msg = msg + "\u5408\u540c\u540d\u79f0 \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getOpcontractType())) {
            msg = msg + "\u5408\u540c\u7c7b\u522b \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getOpcontractSignType())) {
            msg = msg + "\u7b7e\u7f72\u7c7b\u578b \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getUserinfoCode())) {
            msg = msg + "\u6f5c\u5ba2/\u5ba2\u6237\u4ee3\u7801 \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getUserinfoName())) {
            msg = msg + "\u6f5c\u5ba2/\u5ba2\u6237\u540d\u79f0\u4e3a \u7a7a;";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getUserinfoType())) {
            msg = msg + "\u7528\u6237\u7c7b\u578b \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getOpcontractChannelType())) {
            msg = msg + "\u6e20\u9053\u7c7b\u578b \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getOpcontractYear())) {
            msg = msg + "\u5408\u540c\u5e74\u4efd \u4e3a\u7a7a";
            return msg;
        }
        if (Objects.isNull(domain.getOpcontractLifeStart())) {
            msg = msg + "\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4 \u4e3a\u7a7a";
            return msg;
        }
        if (Objects.isNull(domain.getOpcontractLifeEnd())) {
            msg = msg + "\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4 \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getOpcontractNature())) {
            msg = msg + "\u5408\u540c\u6027\u8d28 \u4e3a\u7a7a";
            return msg;
        }
        if (!isBatch.booleanValue()) {
            if (Objects.isNull(domain.getContractTaskList())) {
                msg = msg + "\u5408\u540c\u4efb\u52a1\u5217\u8868 \u4e3a\u7a7a";
                return msg;
            }
            if (Objects.isNull(domain.getContractZoneList())) {
                msg = msg + "\u5408\u540c\u6388\u6743\u533a\u57df\u5217\u8868 \u4e3a\u7a7a";
                return msg;
            }
        }
        return msg;
    }

    private void setPtOpContractDefault(PtOpContract ptOpContract) {
        if (null == ptOpContract) {
            return;
        }
        ptOpContract.setOpcontractStatus(ContractStatusEnum.PENDING_APPROVAL.getCode());
        if (null == ptOpContract.getDataState()) {
            ptOpContract.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ptOpContract.getGmtCreate()) {
            ptOpContract.setGmtCreate(date);
        }
        ptOpContract.setGmtModified(date);
        if (StringUtils.isBlank((String)ptOpContract.getOpcontractCode())) {
            ptOpContract.setOpcontractCode(this.getDefaultCode(ptOpContract.getTenantCode()));
        }
    }

    private String getDefaultCode(String tenantCode) {
        if (this.isTest) {
            return this.createUUIDString();
        }
        return this.getNo(null, "PtOpContract", "ptOpContract", tenantCode);
    }

    private int getPtOpContractMaxCode() {
        int code = 0;
        try {
            return this.ptOpContractMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractServiceImpl.getPtOpContractMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtOpContractUpdataDefault(PtOpContract ptOpContract) {
        if (null == ptOpContract) {
            return;
        }
        ptOpContract.setGmtModified(this.getSysDate());
    }

    private void savePtOpContractModel(PtOpContract ptOpContract) throws ApiException {
        if (null == ptOpContract) {
            return;
        }
        try {
            this.ptOpContractMapper.insert(ptOpContract);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.savePtOpContractModel.ex", (Throwable)e);
        }
    }

    private void savePtOpContractBatchModel(List<PtOpContract> ptOpContractList) throws ApiException {
        if (null == ptOpContractList || ptOpContractList.isEmpty()) {
            return;
        }
        try {
            this.ptOpContractMapper.insertBatch(ptOpContractList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.savePtOpContractBatchModel.ex", (Throwable)e);
        }
    }

    private PtOpContractDomain getPtOpContractModelById(Integer opcontractId) {
        if (null == opcontractId) {
            return null;
        }
        try {
            QueryResult<PtOpContractZone> zoneQueryResult;
            final PtOpContract ptOpContract = this.ptOpContractMapper.selectByPrimaryKey(opcontractId);
            if (Objects.isNull(ptOpContract)) {
                return null;
            }
            PtOpContractReDomain contractReDomain = this.makePtOpContractReDomain(ptOpContract);
            HashMap<String, Object> param = new HashMap<String, Object>(){
                {
                    this.put("opcontractCode", ptOpContract.getOpcontractCode());
                    this.put("tenantCode", ptOpContract.getTenantCode());
                }
            };
            QueryResult<PtOpContractTask> taskQueryResult = this.ptOpContractTaskService.queryPtOpContractTaskPage((Map<String, Object>)param);
            if (!taskQueryResult.getList().isEmpty()) {
                ArrayList<PtOpContractTaskDomain> contractTaskList = new ArrayList<PtOpContractTaskDomain>(taskQueryResult.getList().size());
                for (PtOpContractTask task : taskQueryResult.getList()) {
                    PtOpContractTaskDomain taskDomain = new PtOpContractTaskDomain();
                    BeanUtils.copyAllPropertys((Object)taskDomain, (Object)task);
                    contractTaskList.add(taskDomain);
                }
                contractReDomain.setContractTaskList(contractTaskList);
            }
            if (!(zoneQueryResult = this.ptOpContractZoneService.queryPtOpContractZonePage((Map<String, Object>)param)).getList().isEmpty()) {
                ArrayList<PtOpContractZoneDomain> contractZoneList = new ArrayList<PtOpContractZoneDomain>(zoneQueryResult.getList().size());
                for (PtOpContractZone zone : zoneQueryResult.getList()) {
                    PtOpContractZoneDomain zoneDomain = new PtOpContractZoneDomain();
                    BeanUtils.copyAllPropertys((Object)zoneDomain, (Object)zone);
                    contractZoneList.add(zoneDomain);
                }
                contractReDomain.setContractZoneList(contractZoneList);
            }
            return contractReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractServiceImpl.getPtOpContractModelById", (Throwable)e);
            return null;
        }
    }

    private PtOpContract getPtOpContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptOpContractMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractServiceImpl.getPtOpContractModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtOpContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.delPtOpContractModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.delPtOpContractModelByCode.num");
        }
    }

    private void deletePtOpContractModel(Integer opcontractId) throws ApiException {
        if (null == opcontractId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractMapper.deleteByPrimaryKey(opcontractId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.deletePtOpContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.deletePtOpContractModel.num");
        }
    }

    private void updatePtOpContractModel(PtOpContract ptOpContract) throws ApiException {
        if (null == ptOpContract) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractMapper.updateByPrimaryKey(ptOpContract);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.updatePtOpContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.updatePtOpContractModel.num");
        }
    }

    private void updateStatePtOpContractModel(Integer opcontractId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opcontractId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opcontractId", opcontractId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptOpContractMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.updateStatePtOpContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.updateStatePtOpContractModel.null");
        }
    }

    private void updateStatePtOpContractModelByCode(String tenantCode, String opcontractCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opcontractCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractCode", opcontractCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptOpContractMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.updateStatePtOpContractModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.updateStatePtOpContractModelByCode.null");
        }
    }

    private PtOpContract makePtOpContract(PtOpContractDomain ptOpContractDomain, PtOpContract ptOpContract) {
        if (null == ptOpContractDomain) {
            return null;
        }
        if (null == ptOpContract) {
            ptOpContract = new PtOpContract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptOpContract, (Object)ptOpContractDomain);
            return ptOpContract;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractServiceImpl.makePtOpContract", (Throwable)e);
            return null;
        }
    }

    private PtOpContractReDomain makePtOpContractReDomain(PtOpContract ptOpContract) {
        if (null == ptOpContract) {
            return null;
        }
        PtOpContractReDomain ptOpContractReDomain = new PtOpContractReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptOpContractReDomain, (Object)ptOpContract);
            return ptOpContractReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractServiceImpl.makePtOpContractReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtOpContract> queryPtOpContractModelPage(Map<String, Object> parammap) {
        try {
            return this.ptOpContractMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractServiceImpl.queryPtOpContractModel", (Throwable)e);
            return null;
        }
    }

    private int countPtOpContract(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptOpContractMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractServiceImpl.countPtOpContract", (Throwable)e);
        }
        return i;
    }

    private PtOpContract createPtOpContract(PtOpContractDomain contractDomain, Boolean isBatch) {
        String msg = this.checkPtOpContract(contractDomain, isBatch);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.savePtOpContract.checkPtOpContract", msg);
        }
        PtOpContract ptOpContract = this.makePtOpContract(contractDomain, null);
        this.setPtOpContractDefault(ptOpContract);
        if (!isBatch.booleanValue()) {
            contractDomain.getContractTaskList().forEach(contractTask -> {
                contractTask.setOpcontractCode(ptOpContract.getOpcontractCode());
                contractTask.setTenantCode(ptOpContract.getTenantCode());
                contractTask.setChannelCode(ptOpContract.getChannelCode());
                contractTask.setChannelName(ptOpContract.getChannelName());
                contractTask.setUserCode(ptOpContract.getUserCode());
                contractTask.setUserName(ptOpContract.getUserName());
            });
            contractDomain.getContractZoneList().forEach(contractZone -> {
                contractZone.setOpcontractCode(ptOpContract.getOpcontractCode());
                contractZone.setTenantCode(ptOpContract.getTenantCode());
                contractZone.setChannelCode(ptOpContract.getChannelCode());
                contractZone.setChannelName(ptOpContract.getChannelName());
                contractZone.setUserCode(ptOpContract.getUserCode());
                contractZone.setUserName(ptOpContract.getUserName());
            });
        }
        return ptOpContract;
    }

    @Override
    public String savePtOpContract(PtOpContractDomain ptOpContractDomain) throws ApiException {
        PtOpContract ptOpContract = this.createPtOpContract(ptOpContractDomain, false);
        this.savePtOpContractModel(ptOpContract);
        this.ptOpContractTaskService.savePtOpContractTaskBatch(ptOpContractDomain.getContractTaskList());
        this.ptOpContractZoneService.savePtOpContractZoneBatch(ptOpContractDomain.getContractZoneList());
        return ptOpContract.getOpcontractCode();
    }

    @Override
    public String savePtOpContractBatch(List<PtOpContractDomain> ptOpContractDomainList) throws ApiException {
        if (null == ptOpContractDomainList || ptOpContractDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtOpContract> ptOpContractList = new ArrayList<PtOpContract>();
        String code = "";
        for (PtOpContractDomain ptOpContractDomain : ptOpContractDomainList) {
            PtOpContract ptOpContract = this.createPtOpContract(ptOpContractDomain, true);
            code = ptOpContract.getOpcontractCode();
            ptOpContractList.add(ptOpContract);
        }
        this.savePtOpContractBatchModel(ptOpContractList);
        return code;
    }

    @Override
    public void updatePtOpContractState(Integer opcontractId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opcontractId) {
            return;
        }
        this.updateStatePtOpContractModel(opcontractId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtOpContractStateByCode(String tenantCode, String opcontractCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opcontractCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtOpContractModelByCode(tenantCode, opcontractCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtOpContract(PtOpContractDomain ptOpContractDomain) throws ApiException {
        String msg = this.checkPtOpContract(ptOpContractDomain, false);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.updatePtOpContract.checkPtOpContract", msg);
        }
        PtOpContract oldPtOpContract = this.ptOpContractMapper.selectByPrimaryKey(ptOpContractDomain.getOpcontractId());
        if (null == oldPtOpContract) {
            throw new ApiException("pt.POTENTIAL.PtOpContractServiceImpl.updatePtOpContract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtOpContract ptOpContract = this.makePtOpContract(ptOpContractDomain, oldPtOpContract);
        this.setPtOpContractUpdataDefault(ptOpContract);
        this.updatePtOpContractModel(ptOpContract);
        this.ptOpContractTaskService.updatePtOpContractTaskList(ptOpContractDomain);
        this.ptOpContractZoneService.updatePtOpContractZoneList(ptOpContractDomain);
    }

    @Override
    public JSONObject checkImportList(List<PtOpContractImportDomin> importList) throws ApiException {
        JSONObject result = new JSONObject();
        if (Objects.isNull(importList) || importList.isEmpty()) {
            return result;
        }
        ArrayList<PtOpContractDomain> passList = new ArrayList<PtOpContractDomain>(importList.size());
        ArrayList<PtOpContractImportDomin> failList = new ArrayList<PtOpContractImportDomin>();
        for (PtOpContractImportDomin contractExcel : importList) {
            String msg = this.importCheck(contractExcel);
            if (StringUtils.isBlank((String)msg)) {
                PtOpContractDomain domain = new PtOpContractDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)domain, (Object)contractExcel);
                }
                catch (Exception e) {
                    this.logger.error("pt.POTENTIAL.PtOpContractServiceImpl.checkImportList", (Throwable)e);
                }
                domain.setOpcontractCode(this.getDefaultCode(domain.getTenantCode()));
                passList.add(domain);
                continue;
            }
            contractExcel.setMemo(msg);
            failList.add(contractExcel);
        }
        result.put("passList", passList);
        result.put("failList", failList);
        return result;
    }

    private String importCheck(PtOpContractImportDomin domain) {
        String msg = "";
        if (StringUtils.isBlank((String)domain.getTenantCode())) {
            msg = msg + "TenantCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getChannelCode())) {
            msg = msg + "channelCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getOpcontractChannelType())) {
            msg = msg + "\u6e20\u9053\u7c7b\u578b \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getOpcontractTypeStr())) {
            msg = msg + "\u5408\u540c\u7c7b\u522b \u4e3a\u7a7a";
            return msg;
        }
        int contractType = ContractTypeEnum.parseDescription(domain.getOpcontractTypeStr());
        if (contractType < 0) {
            msg = msg + "\u5408\u540c\u7c7b\u522b \u8f93\u5165\u9519\u8bef";
            return msg;
        }
        domain.setOpcontractType(contractType);
        if (StringUtils.isBlank((String)domain.getOpcontractSignTypeStr())) {
            msg = msg + "\u7b7e\u7f72\u7c7b\u578b \u4e3a\u7a7a";
            return msg;
        }
        int contractSignType = ContractSignTypeEnum.parseDescription(domain.getOpcontractSignTypeStr());
        if (contractSignType < 0) {
            msg = msg + "\u7b7e\u7f72\u7c7b\u578b \u8f93\u5165\u9519\u8bef";
            return msg;
        }
        domain.setOpcontractSignType(contractSignType);
        if (StringUtils.isBlank((String)domain.getUserinfoTypeStr())) {
            msg = msg + "\u7528\u6237\u7c7b\u578b \u4e3a\u7a7a";
            return msg;
        }
        int userinfoType = ContractUserInfoTypeEnum.parseDescription(domain.getUserinfoTypeStr());
        if (userinfoType < 0) {
            msg = msg + "\u7528\u6237\u7c7b\u578b \u8f93\u5165\u9519\u8bef";
            return msg;
        }
        domain.setUserinfoType(userinfoType);
        if (StringUtils.isBlank((String)domain.getUserinfoCode())) {
            msg = msg + "\u6f5c\u5ba2/\u5ba2\u6237\u7f16\u7801 \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getUserinfoName())) {
            msg = msg + "\u6f5c\u5ba2/\u5ba2\u6237\u540d\u79f0\u4e3a \u7a7a;";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getOpcontractYear())) {
            msg = msg + "\u5408\u540c\u5e74\u4efd \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getOpcontractName())) {
            msg = msg + "\u5408\u540c\u540d\u79f0 \u4e3a\u7a7a";
            return msg;
        }
        if (Objects.isNull(domain.getOpcontractLifeStart())) {
            msg = msg + "\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4 \u4e3a\u7a7a";
            return msg;
        }
        if (Objects.isNull(domain.getOpcontractLifeEnd())) {
            msg = msg + "\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4 \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getOpcontractNatureStr())) {
            msg = msg + "\u5408\u540c\u6027\u8d28 \u4e3a\u7a7a";
            return msg;
        }
        int contractNature = ContractNatureEnum.parseDescription(domain.getOpcontractNatureStr());
        if (contractNature < 0) {
            msg = msg + "\u5408\u540c\u6027\u8d28 \u8f93\u5165\u9519\u8bef";
            return msg;
        }
        domain.setOpcontractNature(contractNature);
        return msg;
    }

    @Override
    public PtOpContractDomain getPtOpContract(Integer opcontractId) {
        if (null == opcontractId) {
            return null;
        }
        return this.getPtOpContractModelById(opcontractId);
    }

    @Override
    public void deletePtOpContract(Integer opcontractId) throws ApiException {
        if (null == opcontractId) {
            return;
        }
        this.deletePtOpContractModel(opcontractId);
    }

    @Override
    public QueryResult<PtOpContract> queryPtOpContractPage(Map<String, Object> map) {
        List<PtOpContract> ptOpContractList = this.queryPtOpContractModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtOpContract(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptOpContractList);
        return queryResult;
    }

    @Override
    public PtOpContract getPtOpContractByCode(String tenantCode, String opcontractCode) throws ApiException {
        if (StringUtils.isBlank((String)opcontractCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractCode", opcontractCode);
        return this.getPtOpContractModelByCode(map);
    }

    @Override
    public void deletePtOpContractByCode(String tenantCode, String opcontractCode) throws ApiException {
        if (StringUtils.isBlank((String)opcontractCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractCode", opcontractCode);
        this.delPtOpContractModelByCode(map);
    }
}

