/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtOpContractTaskMapper;
import com.yqbsoft.laser.service.potential.domain.PtOpContractDomain;
import com.yqbsoft.laser.service.potential.domain.PtOpContractTaskDomain;
import com.yqbsoft.laser.service.potential.domain.PtOpContractTaskReDomain;
import com.yqbsoft.laser.service.potential.model.PtOpContractTask;
import com.yqbsoft.laser.service.potential.service.PtOpContractTaskService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class PtOpContractTaskServiceImpl
extends BaseServiceImpl
implements PtOpContractTaskService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtOpContractTaskServiceImpl";
    private PtOpContractTaskMapper ptOpContractTaskMapper;

    public void setPtOpContractTaskMapper(PtOpContractTaskMapper ptOpContractTaskMapper) {
        this.ptOpContractTaskMapper = ptOpContractTaskMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptOpContractTaskMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtOpContractTask(PtOpContractTaskDomain domain) {
        if (null == domain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)domain.getTenantCode())) {
            msg = msg + "TenantCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getChannelCode())) {
            msg = msg + "channelCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getOpcontractCode())) {
            msg = msg + "\u5408\u540c\u7f16\u7801 \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getOpcontractTkKind())) {
            msg = msg + "\u5408\u540c\u4efb\u52a1\u7c7b\u578b \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getOpcontractTkType())) {
            msg = msg + "\u5408\u540c\u4efb\u52a1\u79cd\u7c7b \u4e3a\u7a7a";
            return msg;
        }
        return msg;
    }

    private void setPtOpContractTaskDefault(PtOpContractTask ptOpContractTask) {
        if (null == ptOpContractTask) {
            return;
        }
        if (null == ptOpContractTask.getDataState()) {
            ptOpContractTask.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ptOpContractTask.getGmtCreate()) {
            ptOpContractTask.setGmtCreate(date);
        }
        ptOpContractTask.setGmtModified(date);
        if (StringUtils.isBlank((String)ptOpContractTask.getOpcontractTkCode())) {
            ptOpContractTask.setOpcontractTkCode(this.getNo(null, "PtOpContractTask", "ptOpContractTask", ptOpContractTask.getTenantCode()));
        }
    }

    private int getPtOpContractTaskMaxCode() {
        int code = 0;
        try {
            return this.ptOpContractTaskMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.getPtOpContractTaskMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtOpContractTaskUpdataDefault(PtOpContractTask ptOpContractTask) {
        if (null == ptOpContractTask) {
            return;
        }
        ptOpContractTask.setGmtModified(this.getSysDate());
    }

    private void savePtOpContractTaskModel(PtOpContractTask ptOpContractTask) throws ApiException {
        if (null == ptOpContractTask) {
            return;
        }
        try {
            this.ptOpContractTaskMapper.insert(ptOpContractTask);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.savePtOpContractTaskModel.ex", (Throwable)e);
        }
    }

    private void savePtOpContractTaskBatchModel(List<PtOpContractTask> ptOpContractTaskList) throws ApiException {
        if (null == ptOpContractTaskList || ptOpContractTaskList.isEmpty()) {
            return;
        }
        try {
            this.ptOpContractTaskMapper.insertBatch(ptOpContractTaskList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.savePtOpContractTaskBatchModel.ex", (Throwable)e);
        }
    }

    private PtOpContractTask getPtOpContractTaskModelById(Integer opcontractTkId) {
        if (null == opcontractTkId) {
            return null;
        }
        try {
            return this.ptOpContractTaskMapper.selectByPrimaryKey(opcontractTkId);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.getPtOpContractTaskModelById", (Throwable)e);
            return null;
        }
    }

    private PtOpContractTask getPtOpContractTaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptOpContractTaskMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.getPtOpContractTaskModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtOpContractTaskModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.delPtOpContractTaskModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.delPtOpContractTaskModelByCode.num");
        }
    }

    private void deletePtOpContractTaskModel(Integer opcontractTkId) throws ApiException {
        if (null == opcontractTkId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.deleteByPrimaryKey(opcontractTkId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.deletePtOpContractTaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.deletePtOpContractTaskModel.num");
        }
    }

    private void updatePtOpContractTaskModel(PtOpContractTask ptOpContractTask) throws ApiException {
        if (null == ptOpContractTask) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.updateByPrimaryKey(ptOpContractTask);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updatePtOpContractTaskModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updatePtOpContractTaskModel.num");
        }
    }

    private void updateStatePtOpContractTaskModel(Integer opcontractTkId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opcontractTkId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opcontractTkId", opcontractTkId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updateStatePtOpContractTaskModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updateStatePtOpContractTaskModel.null");
        }
    }

    private void updateStatePtOpContractTaskModelByCode(String tenantCode, String opcontractTkCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opcontractTkCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractTkCode", opcontractTkCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updateStatePtOpContractTaskModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updateStatePtOpContractTaskModelByCode.null");
        }
    }

    private PtOpContractTask makePtOpContractTask(PtOpContractTaskDomain ptOpContractTaskDomain, PtOpContractTask ptOpContractTask) {
        if (null == ptOpContractTaskDomain) {
            return null;
        }
        if (null == ptOpContractTask) {
            ptOpContractTask = new PtOpContractTask();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptOpContractTask, (Object)ptOpContractTaskDomain);
            return ptOpContractTask;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.makePtOpContractTask", (Throwable)e);
            return null;
        }
    }

    private PtOpContractTaskReDomain makePtOpContractTaskReDomain(PtOpContractTask ptOpContractTask) {
        if (null == ptOpContractTask) {
            return null;
        }
        PtOpContractTaskReDomain ptOpContractTaskReDomain = new PtOpContractTaskReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptOpContractTaskReDomain, (Object)ptOpContractTask);
            return ptOpContractTaskReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.makePtOpContractTaskReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtOpContractTask> queryPtOpContractTaskModelPage(Map<String, Object> parammap) {
        try {
            return this.ptOpContractTaskMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.queryPtOpContractTaskModel", (Throwable)e);
            return null;
        }
    }

    private int countPtOpContractTask(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptOpContractTaskMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractTaskServiceImpl.countPtOpContractTask", (Throwable)e);
        }
        return i;
    }

    private PtOpContractTask createPtOpContractTask(PtOpContractTaskDomain ptOpContractTaskDomain) {
        String msg = this.checkPtOpContractTask(ptOpContractTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.savePtOpContractTask.checkPtOpContractTask", msg);
        }
        PtOpContractTask ptOpContractTask = this.makePtOpContractTask(ptOpContractTaskDomain, null);
        this.setPtOpContractTaskDefault(ptOpContractTask);
        return ptOpContractTask;
    }

    @Override
    public String savePtOpContractTask(PtOpContractTaskDomain ptOpContractTaskDomain) throws ApiException {
        PtOpContractTask ptOpContractTask = this.createPtOpContractTask(ptOpContractTaskDomain);
        this.savePtOpContractTaskModel(ptOpContractTask);
        return ptOpContractTask.getOpcontractTkCode();
    }

    @Override
    public String savePtOpContractTaskBatch(List<PtOpContractTaskDomain> ptOpContractTaskDomainList) throws ApiException {
        if (null == ptOpContractTaskDomainList || ptOpContractTaskDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtOpContractTask> ptOpContractTaskList = new ArrayList<PtOpContractTask>();
        String code = "";
        for (PtOpContractTaskDomain ptOpContractTaskDomain : ptOpContractTaskDomainList) {
            PtOpContractTask ptOpContractTask = this.createPtOpContractTask(ptOpContractTaskDomain);
            code = ptOpContractTask.getOpcontractTkCode();
            ptOpContractTaskList.add(ptOpContractTask);
        }
        this.savePtOpContractTaskBatchModel(ptOpContractTaskList);
        return code;
    }

    @Override
    public void updatePtOpContractTaskState(Integer opcontractTkId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opcontractTkId) {
            return;
        }
        this.updateStatePtOpContractTaskModel(opcontractTkId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtOpContractTaskStateByCode(String tenantCode, String opcontractTkCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opcontractTkCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtOpContractTaskModelByCode(tenantCode, opcontractTkCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtOpContractTask(PtOpContractTaskDomain ptOpContractTaskDomain) throws ApiException {
        String msg = this.checkPtOpContractTask(ptOpContractTaskDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updatePtOpContractTask.checkPtOpContractTask", msg);
        }
        PtOpContractTask oldPtOpContractTask = this.getPtOpContractTaskModelById(ptOpContractTaskDomain.getOpcontractTkId());
        if (null == oldPtOpContractTask) {
            throw new ApiException("pt.POTENTIAL.PtOpContractTaskServiceImpl.updatePtOpContractTask.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtOpContractTask ptOpContractTask = this.makePtOpContractTask(ptOpContractTaskDomain, oldPtOpContractTask);
        this.setPtOpContractTaskUpdataDefault(ptOpContractTask);
        this.updatePtOpContractTaskModel(ptOpContractTask);
    }

    @Override
    public void updatePtOpContractTaskList(PtOpContractDomain contractDomain) throws ApiException {
        List<PtOpContractTaskDomain> taskDomainList = contractDomain.getContractTaskList();
        if (ListUtil.isEmpty(taskDomainList)) {
            return;
        }
        List idList = taskDomainList.stream().map(PtOpContractTaskDomain::getOpcontractTkId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Integer> dbIdList = this.ptOpContractTaskMapper.queryIdList(contractDomain.getOpcontractCode());
        Collection deleteIdList = CollectionUtils.subtract(dbIdList, idList);
        for (PtOpContractTaskDomain taskDomain : taskDomainList) {
            taskDomain.setOpcontractCode(contractDomain.getOpcontractCode());
            taskDomain.setTenantCode(contractDomain.getTenantCode());
            taskDomain.setChannelCode(contractDomain.getChannelCode());
            taskDomain.setChannelName(contractDomain.getChannelName());
            if (Objects.isNull(taskDomain.getOpcontractTkId())) {
                taskDomain.setOpcontractTkCode(this.getNo(null, "PtOpContractTask", "ptOpContractTask", taskDomain.getTenantCode()));
                taskDomain.setUserCode(contractDomain.getUserCode());
                taskDomain.setUserName(contractDomain.getUserName());
                this.savePtOpContractTask(taskDomain);
                continue;
            }
            taskDomain.setUserEcode(contractDomain.getUserCode());
            taskDomain.setUserEname(contractDomain.getUserName());
            this.updatePtOpContractTask(taskDomain);
        }
        if (ListUtil.isNotEmpty((Collection)deleteIdList)) {
            deleteIdList.forEach(this::deletePtOpContractTask);
        }
    }

    @Override
    public PtOpContractTask getPtOpContractTask(Integer opcontractTkId) {
        if (null == opcontractTkId) {
            return null;
        }
        return this.getPtOpContractTaskModelById(opcontractTkId);
    }

    @Override
    public void deletePtOpContractTask(Integer opcontractTkId) throws ApiException {
        if (null == opcontractTkId) {
            return;
        }
        this.deletePtOpContractTaskModel(opcontractTkId);
    }

    @Override
    public QueryResult<PtOpContractTask> queryPtOpContractTaskPage(Map<String, Object> map) {
        List<PtOpContractTask> ptOpContractTaskList = this.queryPtOpContractTaskModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtOpContractTask(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptOpContractTaskList);
        return queryResult;
    }

    @Override
    public PtOpContractTask getPtOpContractTaskByCode(String tenantCode, String opcontractTkCode) throws ApiException {
        if (StringUtils.isBlank((String)opcontractTkCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractTkCode", opcontractTkCode);
        return this.getPtOpContractTaskModelByCode(map);
    }

    @Override
    public void deletePtOpContractTaskByCode(String tenantCode, String opcontractTkCode) throws ApiException {
        if (StringUtils.isBlank((String)opcontractTkCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractTkCode", opcontractTkCode);
        this.delPtOpContractTaskModelByCode(map);
    }
}

