/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtForecastDemandMaterialMapper;
import com.yqbsoft.laser.service.potential.domain.PtForecastDemandMaterialDomain;
import com.yqbsoft.laser.service.potential.domain.PtForecastDemandMaterialReDomain;
import com.yqbsoft.laser.service.potential.domain.PtForecastDemandSummaryReDomain;
import com.yqbsoft.laser.service.potential.model.PtForecastDemandMaterial;
import com.yqbsoft.laser.service.potential.service.PtForecastDemandMaterialService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;

public class PtForecastDemandMaterialServiceImpl
extends BaseServiceImpl
implements PtForecastDemandMaterialService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtForecastDemandMaterialServiceImpl";
    @Value(value="${spring.restTemp.isTest:false}")
    private boolean isTest;
    private PtForecastDemandMaterialMapper ptForecastDemandMaterialMapper;

    public void setPtForecastDemandMaterialMapper(PtForecastDemandMaterialMapper ptForecastDemandMaterialMapper) {
        this.ptForecastDemandMaterialMapper = ptForecastDemandMaterialMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptForecastDemandMaterialMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtForecastDemandMaterial(PtForecastDemandMaterialReDomain domain) {
        if (null == domain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)domain.getTenantCode())) {
            msg = msg + "TenantCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getChannelCode())) {
            msg = msg + "channelCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getForecastSummaryCode())) {
            msg = msg + "\u9884\u6d4b\u5355\u7f16\u53f7 \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getMaterialCode())) {
            msg = msg + "\u7269\u6599\u6863\u6848\u7f16\u7801 \u4e3a\u7a7a";
            return msg;
        }
        return msg;
    }

    private void setPtForecastDemandMaterialDefault(PtForecastDemandMaterial model) {
        if (null == model) {
            return;
        }
        if (null == model.getDataState()) {
            model.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == model.getGmtCreate()) {
            model.setGmtCreate(date);
        }
        model.setGmtModified(date);
        if (StringUtils.isBlank((String)model.getForecastMaterialCode())) {
            model.setForecastMaterialCode(this.getDefaultCode(model.getTenantCode()));
        }
    }

    private String getDefaultCode(String tenantCode) {
        if (this.isTest) {
            return this.createUUIDString();
        }
        return this.getNo(null, "PtForecastDemandMaterial", "ptForecastDemandMaterial", tenantCode);
    }

    private int getPtForecastDemandMaterialMaxCode() {
        int code = 0;
        try {
            return this.ptForecastDemandMaterialMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.getPtForecastDemandMaterialMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtForecastDemandMaterialUpdataDefault(PtForecastDemandMaterial ptForecastDemandMaterial) {
        if (null == ptForecastDemandMaterial) {
            return;
        }
        ptForecastDemandMaterial.setGmtModified(this.getSysDate());
    }

    private void savePtForecastDemandMaterialModel(PtForecastDemandMaterial ptForecastDemandMaterial) throws ApiException {
        if (null == ptForecastDemandMaterial) {
            return;
        }
        try {
            this.ptForecastDemandMaterialMapper.insert(ptForecastDemandMaterial);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.savePtForecastDemandMaterialModel.ex", (Throwable)e);
        }
    }

    private void savePtForecastDemandMaterialBatchModel(List<PtForecastDemandMaterial> ptForecastDemandMaterialList) throws ApiException {
        if (null == ptForecastDemandMaterialList || ptForecastDemandMaterialList.isEmpty()) {
            return;
        }
        try {
            this.ptForecastDemandMaterialMapper.insertBatch(ptForecastDemandMaterialList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.savePtForecastDemandMaterialBatchModel.ex", (Throwable)e);
        }
    }

    private PtForecastDemandMaterial getPtForecastDemandMaterialModelById(Integer forecastMaterialId) {
        if (null == forecastMaterialId) {
            return null;
        }
        try {
            return this.ptForecastDemandMaterialMapper.selectByPrimaryKey(forecastMaterialId);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.getPtForecastDemandMaterialModelById", (Throwable)e);
            return null;
        }
    }

    private PtForecastDemandMaterial getPtForecastDemandMaterialModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptForecastDemandMaterialMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.getPtForecastDemandMaterialModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtForecastDemandMaterialModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptForecastDemandMaterialMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.delPtForecastDemandMaterialModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.delPtForecastDemandMaterialModelByCode.num");
        }
    }

    private void deletePtForecastDemandMaterialModel(Integer forecastMaterialId) throws ApiException {
        if (null == forecastMaterialId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptForecastDemandMaterialMapper.deleteByPrimaryKey(forecastMaterialId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.deletePtForecastDemandMaterialModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.deletePtForecastDemandMaterialModel.num");
        }
    }

    private void updatePtForecastDemandMaterialModel(PtForecastDemandMaterial ptForecastDemandMaterial) throws ApiException {
        if (null == ptForecastDemandMaterial) {
            return;
        }
        int i = 0;
        try {
            i = this.ptForecastDemandMaterialMapper.updateByPrimaryKey(ptForecastDemandMaterial);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.updatePtForecastDemandMaterialModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.updatePtForecastDemandMaterialModel.num");
        }
    }

    private void updateStatePtForecastDemandMaterialModel(Integer forecastMaterialId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == forecastMaterialId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("forecastMaterialId", forecastMaterialId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptForecastDemandMaterialMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.updateStatePtForecastDemandMaterialModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.updateStatePtForecastDemandMaterialModel.null");
        }
    }

    private void updateStatePtForecastDemandMaterialModelByCode(String tenantCode, String forecastMaterialCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)forecastMaterialCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("forecastMaterialCode", forecastMaterialCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptForecastDemandMaterialMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.updateStatePtForecastDemandMaterialModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.updateStatePtForecastDemandMaterialModelByCode.null");
        }
    }

    private PtForecastDemandMaterial makePtForecastDemandMaterial(PtForecastDemandMaterialReDomain ptForecastDemandMaterialDomain, PtForecastDemandMaterial ptForecastDemandMaterial) {
        if (null == ptForecastDemandMaterialDomain) {
            return null;
        }
        if (null == ptForecastDemandMaterial) {
            ptForecastDemandMaterial = new PtForecastDemandMaterial();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptForecastDemandMaterial, (Object)ptForecastDemandMaterialDomain);
            return ptForecastDemandMaterial;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.makePtForecastDemandMaterial", (Throwable)e);
            return null;
        }
    }

    private PtForecastDemandMaterialReDomain makePtForecastDemandMaterialReDomain(PtForecastDemandMaterial ptForecastDemandMaterial) {
        if (null == ptForecastDemandMaterial) {
            return null;
        }
        PtForecastDemandMaterialReDomain ptForecastDemandMaterialReDomain = new PtForecastDemandMaterialReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptForecastDemandMaterialReDomain, (Object)ptForecastDemandMaterial);
            return ptForecastDemandMaterialReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.makePtForecastDemandMaterialReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtForecastDemandMaterial> queryPtForecastDemandMaterialModelPage(Map<String, Object> parammap) {
        try {
            return this.ptForecastDemandMaterialMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.queryPtForecastDemandMaterialModel", (Throwable)e);
            return null;
        }
    }

    private int countPtForecastDemandMaterial(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptForecastDemandMaterialMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.countPtForecastDemandMaterial", (Throwable)e);
        }
        return i;
    }

    private PtForecastDemandMaterial createPtForecastDemandMaterial(PtForecastDemandMaterialReDomain ptForecastDemandMaterialDomain) {
        String msg = this.checkPtForecastDemandMaterial(ptForecastDemandMaterialDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.savePtForecastDemandMaterial.checkPtForecastDemandMaterial", msg);
        }
        PtForecastDemandMaterial ptForecastDemandMaterial = this.makePtForecastDemandMaterial(ptForecastDemandMaterialDomain, null);
        this.setPtForecastDemandMaterialDefault(ptForecastDemandMaterial);
        return ptForecastDemandMaterial;
    }

    @Override
    public String savePtForecastDemandMaterial(PtForecastDemandMaterialReDomain ptForecastDemandMaterialDomain) throws ApiException {
        PtForecastDemandMaterial ptForecastDemandMaterial = this.createPtForecastDemandMaterial(ptForecastDemandMaterialDomain);
        this.savePtForecastDemandMaterialModel(ptForecastDemandMaterial);
        return ptForecastDemandMaterial.getForecastMaterialCode();
    }

    @Override
    public String savePtForecastDemandMaterialBatch(List<PtForecastDemandMaterialReDomain> ptForecastDemandMaterialDomainList) throws ApiException {
        if (null == ptForecastDemandMaterialDomainList || ptForecastDemandMaterialDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtForecastDemandMaterial> ptForecastDemandMaterialList = new ArrayList<PtForecastDemandMaterial>();
        String code = "";
        for (PtForecastDemandMaterialReDomain ptForecastDemandMaterialDomain : ptForecastDemandMaterialDomainList) {
            PtForecastDemandMaterial ptForecastDemandMaterial = this.createPtForecastDemandMaterial(ptForecastDemandMaterialDomain);
            code = ptForecastDemandMaterial.getForecastMaterialCode();
            ptForecastDemandMaterialList.add(ptForecastDemandMaterial);
        }
        this.savePtForecastDemandMaterialBatchModel(ptForecastDemandMaterialList);
        return code;
    }

    @Override
    public void updatePtForecastDemandMaterialState(Integer forecastMaterialId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == forecastMaterialId) {
            return;
        }
        this.updateStatePtForecastDemandMaterialModel(forecastMaterialId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtForecastDemandMaterialStateByCode(String tenantCode, String forecastMaterialCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)forecastMaterialCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtForecastDemandMaterialModelByCode(tenantCode, forecastMaterialCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtForecastDemandMaterial(PtForecastDemandMaterialReDomain ptForecastDemandMaterialDomain) throws ApiException {
        String msg = this.checkPtForecastDemandMaterial(ptForecastDemandMaterialDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.updatePtForecastDemandMaterial.checkPtForecastDemandMaterial", msg);
        }
        PtForecastDemandMaterial oldPtForecastDemandMaterial = this.getPtForecastDemandMaterialModelById(ptForecastDemandMaterialDomain.getForecastMaterialId());
        if (null == oldPtForecastDemandMaterial) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandMaterialServiceImpl.updatePtForecastDemandMaterial.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtForecastDemandMaterial ptForecastDemandMaterial = this.makePtForecastDemandMaterial(ptForecastDemandMaterialDomain, oldPtForecastDemandMaterial);
        this.setPtForecastDemandMaterialUpdataDefault(ptForecastDemandMaterial);
        this.updatePtForecastDemandMaterialModel(ptForecastDemandMaterial);
    }

    @Override
    public void updatePtForecastDemandMaterialBatch(PtForecastDemandSummaryReDomain forecastSummaryDomain) throws ApiException {
        List<PtForecastDemandMaterialReDomain> materialList = forecastSummaryDomain.getMaterialList();
        if (ListUtil.isEmpty(materialList)) {
            return;
        }
        List idList = materialList.stream().map(PtForecastDemandMaterialDomain::getForecastMaterialId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Integer> dbIdList = this.ptForecastDemandMaterialMapper.queryIdList(forecastSummaryDomain.getForecastSummaryCode());
        Collection deleteIdList = CollectionUtils.subtract(dbIdList, idList);
        for (PtForecastDemandMaterialReDomain materialReDomain : materialList) {
            materialReDomain.setForecastSummaryCode(forecastSummaryDomain.getForecastSummaryCode());
            materialReDomain.setTenantCode(forecastSummaryDomain.getTenantCode());
            materialReDomain.setChannelCode(forecastSummaryDomain.getChannelCode());
            materialReDomain.setChannelName(forecastSummaryDomain.getChannelName());
            if (Objects.isNull(materialReDomain.getForecastMaterialId())) {
                materialReDomain.setForecastMaterialCode(this.getDefaultCode(forecastSummaryDomain.getTenantCode()));
                materialReDomain.setUserCode(forecastSummaryDomain.getUserCode());
                materialReDomain.setUserName(forecastSummaryDomain.getUserName());
                this.savePtForecastDemandMaterial(materialReDomain);
                continue;
            }
            materialReDomain.setUserEcode(forecastSummaryDomain.getUserCode());
            materialReDomain.setUserEname(forecastSummaryDomain.getUserName());
            this.updatePtForecastDemandMaterial(materialReDomain);
        }
        if (ListUtil.isNotEmpty((Collection)deleteIdList)) {
            deleteIdList.forEach(this::deletePtForecastDemandMaterial);
        }
    }

    @Override
    public PtForecastDemandMaterial getPtForecastDemandMaterial(Integer forecastMaterialId) {
        if (null == forecastMaterialId) {
            return null;
        }
        return this.getPtForecastDemandMaterialModelById(forecastMaterialId);
    }

    @Override
    public void deletePtForecastDemandMaterial(Integer forecastMaterialId) throws ApiException {
        if (null == forecastMaterialId) {
            return;
        }
        this.deletePtForecastDemandMaterialModel(forecastMaterialId);
    }

    @Override
    public QueryResult<PtForecastDemandMaterial> queryPtForecastDemandMaterialPage(Map<String, Object> map) {
        List<PtForecastDemandMaterial> ptForecastDemandMaterialList = this.queryPtForecastDemandMaterialModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtForecastDemandMaterial(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptForecastDemandMaterialList);
        return queryResult;
    }

    @Override
    public PtForecastDemandMaterial getPtForecastDemandMaterialByCode(String tenantCode, String forecastMaterialCode) throws ApiException {
        if (StringUtils.isBlank((String)forecastMaterialCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("forecastMaterialCode", forecastMaterialCode);
        return this.getPtForecastDemandMaterialModelByCode(map);
    }

    @Override
    public void deletePtForecastDemandMaterialByCode(String tenantCode, String forecastMaterialCode) throws ApiException {
        if (StringUtils.isBlank((String)forecastMaterialCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("forecastMaterialCode", forecastMaterialCode);
        this.delPtForecastDemandMaterialModelByCode(map);
    }
}

