/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.utils;

import com.yqbsoft.laser.service.esb.annotation.ColumnName;
import com.yqbsoft.laser.service.potential.domain.imports.PtOpContractZoneImportDomin;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DomainToExcelUtil {
    private static boolean INCLUDE_PARENT_FIELDS = false;
    private static final Set<String> FILTER_FIELDS = new HashSet<String>(Arrays.asList("channelCode", "channelName", "goodsClass", "memberMcode", "memberMname", "userCode", "userName", "userEcode", "userEname", "tenantCode", "gmtCreate", "gmtModified", "memo", "dataState"));

    public static void main(String[] args) {
        try {
            String excelFormat = DomainToExcelUtil.exportToExcelFormat(new PtOpContractZoneImportDomin());
            System.out.println(excelFormat);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static String convertJavaTypeToFrontendType(String javaType) {
        switch (javaType) {
            case "String": {
                return "string";
            }
            case "Integer": {
                return "number";
            }
            case "Boolean": {
                return "boolean";
            }
            case "Date": {
                return "number";
            }
            case "BigDecimal": {
                return "number";
            }
        }
        return "--Unknown--";
    }

    public static String exportToExcelFormat(Object domainObject) throws IllegalAccessException {
        Field[] fields;
        StringBuilder excelContent = new StringBuilder();
        excelContent.append("\u5b57\u6bb5").append("\t").append("\u5b57\u6bb5\u53d6\u503c").append("\t").append("\u524d\u7aef\u5bf9\u5e94\u7c7b\u578b").append("\n");
        for (Field field : fields = INCLUDE_PARENT_FIELDS ? DomainToExcelUtil.getAllFields(domainObject.getClass()) : domainObject.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (FILTER_FIELDS.contains(field.getName())) continue;
            ColumnName columnNameAnnotation = field.getAnnotation(ColumnName.class);
            String fieldNameInChinese = columnNameAnnotation != null ? columnNameAnnotation.value() : field.getName();
            String fieldName = field.getName();
            String fieldType = field.getType().getSimpleName();
            String frontendType = DomainToExcelUtil.convertJavaTypeToFrontendType(fieldType);
            excelContent.append(fieldNameInChinese).append("\t").append(fieldName).append("\t").append(frontendType).append("\n");
        }
        return excelContent.toString();
    }

    private static Field[] getAllFields(Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return new Field[0];
        }
        Field[] parentFields = DomainToExcelUtil.getAllFields(clazz.getSuperclass());
        Field[] currentFields = clazz.getDeclaredFields();
        Field[] allFields = new Field[parentFields.length + currentFields.length];
        System.arraycopy(parentFields, 0, allFields, 0, parentFields.length);
        System.arraycopy(currentFields, 0, allFields, parentFields.length, currentFields.length);
        return allFields;
    }
}

