/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.enums;

import java.util.Objects;

public enum ContractNatureEnum {
    MASTER_CONTRACT(1, "\u4e3b\u5408\u540c"),
    SLAVE_CONTRACT(2, "\u526f\u5408\u540c");

    private final int code;
    private final String description;

    private ContractNatureEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static ContractNatureEnum fromCode(int code) {
        for (ContractNatureEnum type : ContractNatureEnum.values()) {
            if (type.getCode() != code) continue;
            return type;
        }
        return null;
    }

    public static boolean check(int code) {
        for (ContractNatureEnum type : ContractNatureEnum.values()) {
            if (type.getCode() != code) continue;
            return true;
        }
        return false;
    }

    public static int parseDescription(String description) {
        for (ContractNatureEnum type : ContractNatureEnum.values()) {
            if (!Objects.equals(type.getDescription(), description)) continue;
            return type.getCode();
        }
        return -1;
    }
}

