/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtOpContractMapper;
import com.yqbsoft.laser.service.potential.dao.PtOpContractZoneMapper;
import com.yqbsoft.laser.service.potential.domain.PtOpContractDomain;
import com.yqbsoft.laser.service.potential.domain.PtOpContractZoneDomain;
import com.yqbsoft.laser.service.potential.domain.PtOpContractZoneReDomain;
import com.yqbsoft.laser.service.potential.domain.imports.PtOpContractZoneImportDomin;
import com.yqbsoft.laser.service.potential.model.PtOpContractZone;
import com.yqbsoft.laser.service.potential.service.PtOpContractZoneService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class PtOpContractZoneServiceImpl
extends BaseServiceImpl
implements PtOpContractZoneService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtOpContractZoneServiceImpl";
    private PtOpContractZoneMapper ptOpContractZoneMapper;
    private PtOpContractMapper ptOpContractMapper;

    public void setPtOpContractZoneMapper(PtOpContractZoneMapper ptOpContractZoneMapper) {
        this.ptOpContractZoneMapper = ptOpContractZoneMapper;
    }

    public void setPtOpContractMapper(PtOpContractMapper ptOpContractMapper) {
        this.ptOpContractMapper = ptOpContractMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptOpContractZoneMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractZoneServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtOpContractZone(PtOpContractZoneDomain domain) {
        if (null == domain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)domain.getTenantCode())) {
            msg = msg + "TenantCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getChannelCode())) {
            msg = msg + "channelCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getOpcontractCode())) {
            msg = msg + "\u5408\u540c\u7f16\u7801 \u4e3a\u7a7a";
            return msg;
        }
        return msg;
    }

    private void setPtOpContractZoneDefault(PtOpContractZone ptOpContractZone) {
        if (null == ptOpContractZone) {
            return;
        }
        if (null == ptOpContractZone.getDataState()) {
            ptOpContractZone.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ptOpContractZone.getGmtCreate()) {
            ptOpContractZone.setGmtCreate(date);
        }
        ptOpContractZone.setGmtModified(date);
        if (StringUtils.isBlank((String)ptOpContractZone.getOpcontractZoCode())) {
            ptOpContractZone.setOpcontractZoCode(this.getNo(null, "PtOpContractZone", "ptOpContractZone", ptOpContractZone.getTenantCode()));
        }
    }

    private int getPtOpContractZoneMaxCode() {
        int code = 0;
        try {
            return this.ptOpContractZoneMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractZoneServiceImpl.getPtOpContractZoneMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtOpContractZoneUpdataDefault(PtOpContractZone ptOpContractZone) {
        if (null == ptOpContractZone) {
            return;
        }
        ptOpContractZone.setGmtModified(this.getSysDate());
    }

    private void savePtOpContractZoneModel(PtOpContractZone ptOpContractZone) throws ApiException {
        if (null == ptOpContractZone) {
            return;
        }
        try {
            this.ptOpContractZoneMapper.insert(ptOpContractZone);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.savePtOpContractZoneModel.ex", (Throwable)e);
        }
    }

    private void savePtOpContractZoneBatchModel(List<PtOpContractZone> ptOpContractZoneList) throws ApiException {
        if (null == ptOpContractZoneList || ptOpContractZoneList.isEmpty()) {
            return;
        }
        try {
            this.ptOpContractZoneMapper.insertBatch(ptOpContractZoneList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.savePtOpContractZoneBatchModel.ex", (Throwable)e);
        }
    }

    private PtOpContractZone getPtOpContractZoneModelById(Integer opcontractZoId) {
        if (null == opcontractZoId) {
            return null;
        }
        try {
            return this.ptOpContractZoneMapper.selectByPrimaryKey(opcontractZoId);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractZoneServiceImpl.getPtOpContractZoneModelById", (Throwable)e);
            return null;
        }
    }

    private PtOpContractZone getPtOpContractZoneModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptOpContractZoneMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractZoneServiceImpl.getPtOpContractZoneModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtOpContractZoneModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractZoneMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.delPtOpContractZoneModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.delPtOpContractZoneModelByCode.num");
        }
    }

    private void deletePtOpContractZoneModel(Integer opcontractZoId) throws ApiException {
        if (null == opcontractZoId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractZoneMapper.deleteByPrimaryKey(opcontractZoId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.deletePtOpContractZoneModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.deletePtOpContractZoneModel.num");
        }
    }

    private void updatePtOpContractZoneModel(PtOpContractZone ptOpContractZone) throws ApiException {
        if (null == ptOpContractZone) {
            return;
        }
        int i = 0;
        try {
            i = this.ptOpContractZoneMapper.updateByPrimaryKey(ptOpContractZone);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.updatePtOpContractZoneModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.updatePtOpContractZoneModel.num");
        }
    }

    private void updateStatePtOpContractZoneModel(Integer opcontractZoId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opcontractZoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opcontractZoId", opcontractZoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptOpContractZoneMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.updateStatePtOpContractZoneModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.updateStatePtOpContractZoneModel.null");
        }
    }

    private void updateStatePtOpContractZoneModelByCode(String tenantCode, String opcontractZoCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opcontractZoCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractZoCode", opcontractZoCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptOpContractZoneMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.updateStatePtOpContractZoneModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.updateStatePtOpContractZoneModelByCode.null");
        }
    }

    private PtOpContractZone makePtOpContractZone(PtOpContractZoneDomain ptOpContractZoneDomain, PtOpContractZone ptOpContractZone) {
        if (null == ptOpContractZoneDomain) {
            return null;
        }
        if (null == ptOpContractZone) {
            ptOpContractZone = new PtOpContractZone();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptOpContractZone, (Object)ptOpContractZoneDomain);
            return ptOpContractZone;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractZoneServiceImpl.makePtOpContractZone", (Throwable)e);
            return null;
        }
    }

    private PtOpContractZoneReDomain makePtOpContractZoneReDomain(PtOpContractZone ptOpContractZone) {
        if (null == ptOpContractZone) {
            return null;
        }
        PtOpContractZoneReDomain ptOpContractZoneReDomain = new PtOpContractZoneReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptOpContractZoneReDomain, (Object)ptOpContractZone);
            return ptOpContractZoneReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractZoneServiceImpl.makePtOpContractZoneReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtOpContractZone> queryPtOpContractZoneModelPage(Map<String, Object> parammap) {
        try {
            return this.ptOpContractZoneMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractZoneServiceImpl.queryPtOpContractZoneModel", (Throwable)e);
            return null;
        }
    }

    private int countPtOpContractZone(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptOpContractZoneMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtOpContractZoneServiceImpl.countPtOpContractZone", (Throwable)e);
        }
        return i;
    }

    private PtOpContractZone createPtOpContractZone(PtOpContractZoneDomain ptOpContractZoneDomain) {
        String msg = this.checkPtOpContractZone(ptOpContractZoneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.savePtOpContractZone.checkPtOpContractZone", msg);
        }
        PtOpContractZone ptOpContractZone = this.makePtOpContractZone(ptOpContractZoneDomain, null);
        this.setPtOpContractZoneDefault(ptOpContractZone);
        return ptOpContractZone;
    }

    @Override
    public String savePtOpContractZone(PtOpContractZoneDomain ptOpContractZoneDomain) throws ApiException {
        PtOpContractZone ptOpContractZone = this.createPtOpContractZone(ptOpContractZoneDomain);
        this.savePtOpContractZoneModel(ptOpContractZone);
        return ptOpContractZone.getOpcontractZoCode();
    }

    @Override
    public String savePtOpContractZoneBatch(List<PtOpContractZoneDomain> ptOpContractZoneDomainList) throws ApiException {
        if (null == ptOpContractZoneDomainList || ptOpContractZoneDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtOpContractZone> ptOpContractZoneList = new ArrayList<PtOpContractZone>();
        String code = "";
        for (PtOpContractZoneDomain ptOpContractZoneDomain : ptOpContractZoneDomainList) {
            PtOpContractZone ptOpContractZone = this.createPtOpContractZone(ptOpContractZoneDomain);
            code = ptOpContractZone.getOpcontractZoCode();
            ptOpContractZoneList.add(ptOpContractZone);
        }
        this.savePtOpContractZoneBatchModel(ptOpContractZoneList);
        return code;
    }

    @Override
    public void updatePtOpContractZoneState(Integer opcontractZoId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opcontractZoId) {
            return;
        }
        this.updateStatePtOpContractZoneModel(opcontractZoId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtOpContractZoneStateByCode(String tenantCode, String opcontractZoCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opcontractZoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtOpContractZoneModelByCode(tenantCode, opcontractZoCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtOpContractZone(PtOpContractZoneDomain ptOpContractZoneDomain) throws ApiException {
        String msg = this.checkPtOpContractZone(ptOpContractZoneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.updatePtOpContractZone.checkPtOpContractZone", msg);
        }
        PtOpContractZone oldPtOpContractZone = this.getPtOpContractZoneModelById(ptOpContractZoneDomain.getOpcontractZoId());
        if (null == oldPtOpContractZone) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.updatePtOpContractZone.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtOpContractZone ptOpContractZone = this.makePtOpContractZone(ptOpContractZoneDomain, oldPtOpContractZone);
        this.setPtOpContractZoneUpdataDefault(ptOpContractZone);
        this.updatePtOpContractZoneModel(ptOpContractZone);
    }

    @Override
    public void updatePtOpContractZoneList(PtOpContractDomain contractDomain) throws ApiException {
        List<PtOpContractZoneDomain> ZoneDomainList = contractDomain.getContractZoneList();
        if (ListUtil.isEmpty(ZoneDomainList)) {
            return;
        }
        List idList = ZoneDomainList.stream().map(PtOpContractZoneDomain::getOpcontractZoId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Integer> dbIdList = this.ptOpContractZoneMapper.queryIdList(contractDomain.getOpcontractCode());
        Collection deleteIdList = CollectionUtils.subtract(dbIdList, idList);
        for (PtOpContractZoneDomain ZoneDomain : ZoneDomainList) {
            ZoneDomain.setOpcontractCode(contractDomain.getOpcontractCode());
            ZoneDomain.setTenantCode(contractDomain.getTenantCode());
            ZoneDomain.setChannelCode(contractDomain.getChannelCode());
            ZoneDomain.setChannelName(contractDomain.getChannelName());
            if (Objects.isNull(ZoneDomain.getOpcontractZoId())) {
                ZoneDomain.setOpcontractZoCode(this.getNo(null, "PtOpContractZone", "ptOpContractZone", ZoneDomain.getTenantCode()));
                ZoneDomain.setUserCode(contractDomain.getUserCode());
                ZoneDomain.setUserName(contractDomain.getUserName());
                this.savePtOpContractZone(ZoneDomain);
                continue;
            }
            ZoneDomain.setUserEcode(contractDomain.getUserCode());
            ZoneDomain.setUserEname(contractDomain.getUserName());
            this.updatePtOpContractZone(ZoneDomain);
        }
        if (ListUtil.isNotEmpty((Collection)deleteIdList)) {
            deleteIdList.forEach(this::deletePtOpContractZone);
        }
    }

    @Override
    public PtOpContractZone getPtOpContractZone(Integer opcontractZoId) {
        if (null == opcontractZoId) {
            return null;
        }
        return this.getPtOpContractZoneModelById(opcontractZoId);
    }

    @Override
    public void deletePtOpContractZone(Integer opcontractZoId) throws ApiException {
        if (null == opcontractZoId) {
            return;
        }
        this.deletePtOpContractZoneModel(opcontractZoId);
    }

    @Override
    public QueryResult<PtOpContractZone> queryPtOpContractZonePage(Map<String, Object> map) {
        List<PtOpContractZone> ptOpContractZoneList = this.queryPtOpContractZoneModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtOpContractZone(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptOpContractZoneList);
        return queryResult;
    }

    @Override
    public PtOpContractZone getPtOpContractZoneByCode(String tenantCode, String opcontractZoCode) throws ApiException {
        if (StringUtils.isBlank((String)opcontractZoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractZoCode", opcontractZoCode);
        return this.getPtOpContractZoneModelByCode(map);
    }

    @Override
    public void deletePtOpContractZoneByCode(String tenantCode, String opcontractZoCode) throws ApiException {
        if (StringUtils.isBlank((String)opcontractZoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opcontractZoCode", opcontractZoCode);
        this.delPtOpContractZoneModelByCode(map);
    }

    @Override
    public JSONObject checkImportList(JSONArray importList) throws ApiException {
        if (Objects.isNull(importList) || importList.isEmpty()) {
            throw new ApiException("pt.POTENTIAL.PtOpContractZoneServiceImpl.checkImportList.ex \u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<PtOpContractZoneDomain> passList = new ArrayList<PtOpContractZoneDomain>(importList.size());
        ArrayList<PtOpContractZoneImportDomin> failList = new ArrayList<PtOpContractZoneImportDomin>();
        List importDomins = importList.toJavaList(PtOpContractZoneImportDomin.class);
        for (PtOpContractZoneImportDomin importZone : importDomins) {
            String msg = this.importCheck(importZone);
            if (StringUtils.isBlank((String)msg)) {
                PtOpContractZoneDomain domain = new PtOpContractZoneDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)domain, (Object)importZone);
                }
                catch (Exception e) {
                    this.logger.error("pt.POTENTIAL.PtOpContractZoneServiceImpl.checkImportList", (Throwable)e);
                }
                passList.add(domain);
                continue;
            }
            importZone.setMemo(msg);
            failList.add(importZone);
        }
        JSONObject result = new JSONObject();
        result.put("passList", passList);
        result.put("failList", failList);
        return result;
    }

    private String importCheck(final PtOpContractZoneImportDomin domain) {
        String msg = "";
        if (StringUtils.isBlank((String)domain.getOpcontractCode())) {
            msg = msg + "\u5408\u540c\u7f16\u7801 \u4e3a\u7a7a";
            return msg;
        }
        int opcontractCodeCount = this.ptOpContractMapper.count((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("opcontractCode", domain.getOpcontractCode());
            }
        });
        if (opcontractCodeCount < 1) {
            msg = msg + "\u5408\u540c\u7f16\u7801 \u4e0d\u5b58\u5728";
            return msg;
        }
        return msg;
    }
}

