/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtStoreDecorationMapper;
import com.yqbsoft.laser.service.potential.domain.DeductItemsDetailDomain;
import com.yqbsoft.laser.service.potential.domain.PtStoreDecorationDomain;
import com.yqbsoft.laser.service.potential.domain.PtStoreDecorationReDomain;
import com.yqbsoft.laser.service.potential.model.PtStoreDecoration;
import com.yqbsoft.laser.service.potential.service.PtStoreDecorationService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;

public class PtStoreDecorationServiceImpl
extends BaseServiceImpl
implements PtStoreDecorationService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtStoreDecorationServiceImpl";
    @Value(value="${spring.restTemp.isTest:false}")
    private boolean isTest;
    private PtStoreDecorationMapper ptStoreDecorationMapper;

    public void setPtStoreDecorationMapper(PtStoreDecorationMapper ptStoreDecorationMapper) {
        this.ptStoreDecorationMapper = ptStoreDecorationMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptStoreDecorationMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreDecorationServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtStoreDecoration(PtStoreDecorationDomain domain) {
        if (null == domain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)domain.getTenantCode())) {
            msg = msg + "TenantCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getChannelCode())) {
            msg = msg + "channelCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((Integer)domain.getStoreId())) {
            msg = msg + "\u95e8\u5e97id \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getStoreCode())) {
            msg = msg + "\u95e8\u5e97\u7f16\u53f7 \u4e3a\u7a7a";
            return msg;
        }
        return msg;
    }

    private void setPtStoreDecorationDefault(PtStoreDecoration ptStoreDecoration) {
        if (null == ptStoreDecoration) {
            return;
        }
        if (null == ptStoreDecoration.getDataState()) {
            ptStoreDecoration.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ptStoreDecoration.getGmtCreate()) {
            ptStoreDecoration.setGmtCreate(date);
        }
        ptStoreDecoration.setGmtModified(date);
        if (StringUtils.isBlank((String)ptStoreDecoration.getStoreDecorationCode())) {
            ptStoreDecoration.setStoreDecorationCode(this.getDefaultCode(ptStoreDecoration.getTenantCode()));
        }
    }

    private String getDefaultCode(String tenantCode) {
        if (this.isTest) {
            return this.createUUIDString();
        }
        return this.getNo(null, "PtStoreDecoration", "ptStoreDecoration", tenantCode);
    }

    private int getPtStoreDecorationMaxCode() {
        int code = 0;
        try {
            return this.ptStoreDecorationMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreDecorationServiceImpl.getPtStoreDecorationMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtStoreDecorationUpdataDefault(PtStoreDecoration ptStoreDecoration) {
        if (null == ptStoreDecoration) {
            return;
        }
        ptStoreDecoration.setGmtModified(this.getSysDate());
    }

    private void savePtStoreDecorationModel(PtStoreDecoration ptStoreDecoration) throws ApiException {
        if (null == ptStoreDecoration) {
            return;
        }
        try {
            this.ptStoreDecorationMapper.insert(ptStoreDecoration);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.savePtStoreDecorationModel.ex", (Throwable)e);
        }
    }

    private void savePtStoreDecorationBatchModel(List<PtStoreDecoration> ptStoreDecorationList) throws ApiException {
        if (null == ptStoreDecorationList || ptStoreDecorationList.isEmpty()) {
            return;
        }
        try {
            this.ptStoreDecorationMapper.insertBatch(ptStoreDecorationList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.savePtStoreDecorationBatchModel.ex", (Throwable)e);
        }
    }

    private PtStoreDecoration getPtStoreDecorationModelById(Integer storeDecorationId) {
        if (null == storeDecorationId) {
            return null;
        }
        try {
            return this.ptStoreDecorationMapper.selectByPrimaryKey(storeDecorationId);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreDecorationServiceImpl.getPtStoreDecorationModelById", (Throwable)e);
            return null;
        }
    }

    private PtStoreDecoration getPtStoreDecorationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptStoreDecorationMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreDecorationServiceImpl.getPtStoreDecorationModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtStoreDecorationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptStoreDecorationMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.delPtStoreDecorationModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.delPtStoreDecorationModelByCode.num");
        }
    }

    private void deletePtStoreDecorationModel(Integer storeDecorationId) throws ApiException {
        if (null == storeDecorationId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptStoreDecorationMapper.deleteByPrimaryKey(storeDecorationId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.deletePtStoreDecorationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.deletePtStoreDecorationModel.num");
        }
    }

    private void updatePtStoreDecorationModel(PtStoreDecoration ptStoreDecoration) throws ApiException {
        if (null == ptStoreDecoration) {
            return;
        }
        int i = 0;
        try {
            i = this.ptStoreDecorationMapper.updateByPrimaryKey(ptStoreDecoration);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.updatePtStoreDecorationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.updatePtStoreDecorationModel.num");
        }
    }

    private void updateStatePtStoreDecorationModel(Integer storeDecorationId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == storeDecorationId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeDecorationId", storeDecorationId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptStoreDecorationMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.updateStatePtStoreDecorationModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.updateStatePtStoreDecorationModel.null");
        }
    }

    private void updateStatePtStoreDecorationModelByCode(String tenantCode, String storeDecorationCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)storeDecorationCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeDecorationCode", storeDecorationCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptStoreDecorationMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.updateStatePtStoreDecorationModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.updateStatePtStoreDecorationModelByCode.null");
        }
    }

    private PtStoreDecoration makePtStoreDecoration(PtStoreDecorationReDomain domain, PtStoreDecoration ptStoreDecoration) {
        if (null == domain) {
            return null;
        }
        if (null == ptStoreDecoration) {
            ptStoreDecoration = new PtStoreDecoration();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptStoreDecoration, (Object)domain);
            if (ListUtil.isNotEmpty(domain.getDeductItemsDetailList())) {
                String jsonString = JSON.toJSONString(domain.getDeductItemsDetailList());
                ptStoreDecoration.setDeductItemsDetail(jsonString);
            }
            return ptStoreDecoration;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreDecorationServiceImpl.makePtStoreDecoration", (Throwable)e);
            return null;
        }
    }

    private PtStoreDecorationReDomain makePtStoreDecorationReDomain(PtStoreDecoration ptStoreDecoration) {
        if (null == ptStoreDecoration) {
            return null;
        }
        PtStoreDecorationReDomain domain = new PtStoreDecorationReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)domain, (Object)ptStoreDecoration);
            if (StringUtils.isNotBlank((String)ptStoreDecoration.getDeductItemsDetail())) {
                List detailDomainList = JSON.parseArray((String)ptStoreDecoration.getDeductItemsDetail(), DeductItemsDetailDomain.class);
                domain.setDeductItemsDetailList(detailDomainList);
                domain.setDeductItemsDetail(null);
            }
            return domain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreDecorationServiceImpl.makePtStoreDecorationReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtStoreDecoration> queryPtStoreDecorationModelPage(Map<String, Object> parammap) {
        try {
            return this.ptStoreDecorationMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreDecorationServiceImpl.queryPtStoreDecorationModel", (Throwable)e);
            return null;
        }
    }

    private int countPtStoreDecoration(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptStoreDecorationMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreDecorationServiceImpl.countPtStoreDecoration", (Throwable)e);
        }
        return i;
    }

    private PtStoreDecoration createPtStoreDecoration(PtStoreDecorationReDomain ptStoreDecorationDomain) {
        String msg = this.checkPtStoreDecoration(ptStoreDecorationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.savePtStoreDecoration.checkPtStoreDecoration", msg);
        }
        PtStoreDecoration ptStoreDecoration = this.makePtStoreDecoration(ptStoreDecorationDomain, null);
        this.setPtStoreDecorationDefault(ptStoreDecoration);
        return ptStoreDecoration;
    }

    @Override
    public String savePtStoreDecoration(PtStoreDecorationReDomain ptStoreDecorationDomain) throws ApiException {
        PtStoreDecoration ptStoreDecoration = this.createPtStoreDecoration(ptStoreDecorationDomain);
        this.savePtStoreDecorationModel(ptStoreDecoration);
        return ptStoreDecoration.getStoreDecorationCode();
    }

    @Override
    public String savePtStoreDecorationBatch(List<PtStoreDecorationReDomain> ptStoreDecorationDomainList) throws ApiException {
        if (null == ptStoreDecorationDomainList || ptStoreDecorationDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtStoreDecoration> ptStoreDecorationList = new ArrayList<PtStoreDecoration>();
        String code = "";
        for (PtStoreDecorationReDomain ptStoreDecorationDomain : ptStoreDecorationDomainList) {
            PtStoreDecoration ptStoreDecoration = this.createPtStoreDecoration(ptStoreDecorationDomain);
            code = ptStoreDecoration.getStoreDecorationCode();
            ptStoreDecorationList.add(ptStoreDecoration);
        }
        this.savePtStoreDecorationBatchModel(ptStoreDecorationList);
        return code;
    }

    @Override
    public void updatePtStoreDecorationState(Integer storeDecorationId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == storeDecorationId) {
            return;
        }
        this.updateStatePtStoreDecorationModel(storeDecorationId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtStoreDecorationStateByCode(String tenantCode, String storeDecorationCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)storeDecorationCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtStoreDecorationModelByCode(tenantCode, storeDecorationCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtStoreDecoration(PtStoreDecorationReDomain ptStoreDecorationDomain) throws ApiException {
        String msg = this.checkPtStoreDecoration(ptStoreDecorationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.updatePtStoreDecoration.checkPtStoreDecoration", msg);
        }
        PtStoreDecoration oldPtStoreDecoration = this.getPtStoreDecorationModelById(ptStoreDecorationDomain.getStoreDecorationId());
        if (null == oldPtStoreDecoration) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.updatePtStoreDecoration.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtStoreDecoration ptStoreDecoration = this.makePtStoreDecoration(ptStoreDecorationDomain, oldPtStoreDecoration);
        this.setPtStoreDecorationUpdataDefault(ptStoreDecoration);
        this.updatePtStoreDecorationModel(ptStoreDecoration);
    }

    @Override
    public void updatePtStoreDecorationSelective(PtStoreDecorationReDomain domain) throws ApiException {
        if (Objects.isNull(domain)) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.updatePtStoreDecorationSelective", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (Objects.isNull(domain.getStoreDecorationId())) {
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.updatePtStoreDecorationSelective", "\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            PtStoreDecoration model = new PtStoreDecoration();
            BeanUtils.copyAllPropertysNotNull((Object)model, (Object)domain);
            this.ptStoreDecorationMapper.updateByPrimaryKeySelective(model);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtStoreDecorationServiceImpl.updatePtStoreDecorationSelective", (Throwable)e);
            throw new ApiException("pt.POTENTIAL.PtStoreDecorationServiceImpl.updatePtStoreDecorationSelective", "\u66f4\u65b0\u5f02\u5e38");
        }
    }

    @Override
    public PtStoreDecorationReDomain getPtStoreDecoration(Integer storeDecorationId) {
        if (null == storeDecorationId) {
            return null;
        }
        PtStoreDecoration storeDecoration = this.getPtStoreDecorationModelById(storeDecorationId);
        return this.makePtStoreDecorationReDomain(storeDecoration);
    }

    @Override
    public void deletePtStoreDecoration(Integer storeDecorationId) throws ApiException {
        if (null == storeDecorationId) {
            return;
        }
        this.deletePtStoreDecorationModel(storeDecorationId);
    }

    @Override
    public QueryResult<PtStoreDecoration> queryPtStoreDecorationPage(Map<String, Object> map) {
        List<PtStoreDecoration> ptStoreDecorationList = this.queryPtStoreDecorationModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtStoreDecoration(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptStoreDecorationList);
        return queryResult;
    }

    @Override
    public PtStoreDecorationReDomain getPtStoreDecorationByCode(String tenantCode, String storeDecorationCode) throws ApiException {
        if (StringUtils.isBlank((String)storeDecorationCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeDecorationCode", storeDecorationCode);
        PtStoreDecoration storeDecoration = this.getPtStoreDecorationModelByCode(map);
        return this.makePtStoreDecorationReDomain(storeDecoration);
    }

    @Override
    public PtStoreDecorationReDomain getPtStoreDecorationByParam(Map<String, Object> map) {
        this.logger.error("pt.POTENTIAL.PtStoreDecorationServiceImpl.getPtStoreDecorationByParam", map);
        List<PtStoreDecoration> ptStoreDecorationList = this.queryPtStoreDecorationModelPage(map);
        if (ptStoreDecorationList != null && !ptStoreDecorationList.isEmpty()) {
            return this.makePtStoreDecorationReDomain(ptStoreDecorationList.get(0));
        }
        return null;
    }

    @Override
    public void deletePtStoreDecorationByCode(String tenantCode, String storeDecorationCode) throws ApiException {
        if (StringUtils.isBlank((String)storeDecorationCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeDecorationCode", storeDecorationCode);
        this.delPtStoreDecorationModelByCode(map);
    }
}

