/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtForecastDemandUserMapper;
import com.yqbsoft.laser.service.potential.domain.PtForecastDemandSummaryReDomain;
import com.yqbsoft.laser.service.potential.domain.PtForecastDemandUserDomain;
import com.yqbsoft.laser.service.potential.domain.PtForecastDemandUserReDomain;
import com.yqbsoft.laser.service.potential.domain.imports.PtForecastDemandUserImportDomain;
import com.yqbsoft.laser.service.potential.model.PtForecastDemandUser;
import com.yqbsoft.laser.service.potential.service.PtForecastDemandUserService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;

public class PtForecastDemandUserServiceImpl
extends BaseServiceImpl
implements PtForecastDemandUserService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtForecastDemandUserServiceImpl";
    @Value(value="${spring.restTemp.isTest:false}")
    private boolean isTest;
    private PtForecastDemandUserMapper ptForecastDemandUserMapper;

    public void setPtForecastDemandUserMapper(PtForecastDemandUserMapper ptForecastDemandUserMapper) {
        this.ptForecastDemandUserMapper = ptForecastDemandUserMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptForecastDemandUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandUserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtForecastDemandUser(PtForecastDemandUserDomain domain) {
        if (null == domain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)domain.getTenantCode())) {
            msg = msg + "TenantCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getChannelCode())) {
            msg = msg + "channelCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getForecastSummaryCode())) {
            msg = msg + "\u9884\u6d4b\u5355\u7f16\u53f7 \u4e3a\u7a7a";
            return msg;
        }
        return msg;
    }

    private void setPtForecastDemandUserDefault(PtForecastDemandUser model) {
        if (null == model) {
            return;
        }
        if (null == model.getDataState()) {
            model.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == model.getGmtCreate()) {
            model.setGmtCreate(date);
        }
        model.setGmtModified(date);
        if (StringUtils.isBlank((String)model.getForecastUserCode())) {
            model.setForecastUserCode(this.getDefaultCode(model.getTenantCode()));
        }
    }

    private String getDefaultCode(String tenantCode) {
        if (this.isTest) {
            return this.createUUIDString();
        }
        return this.getNo(null, "PtForecastDemandUser", "ptForecastDemandUser", tenantCode);
    }

    private int getPtForecastDemandUserMaxCode() {
        int code = 0;
        try {
            return this.ptForecastDemandUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandUserServiceImpl.getPtForecastDemandUserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtForecastDemandUserUpdataDefault(PtForecastDemandUser ptForecastDemandUser) {
        if (null == ptForecastDemandUser) {
            return;
        }
        ptForecastDemandUser.setGmtModified(this.getSysDate());
    }

    private void savePtForecastDemandUserModel(PtForecastDemandUser ptForecastDemandUser) throws ApiException {
        if (null == ptForecastDemandUser) {
            return;
        }
        try {
            this.ptForecastDemandUserMapper.insert(ptForecastDemandUser);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.savePtForecastDemandUserModel.ex", (Throwable)e);
        }
    }

    private void savePtForecastDemandUserBatchModel(List<PtForecastDemandUser> ptForecastDemandUserList) throws ApiException {
        if (null == ptForecastDemandUserList || ptForecastDemandUserList.isEmpty()) {
            return;
        }
        try {
            this.ptForecastDemandUserMapper.insertBatch(ptForecastDemandUserList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.savePtForecastDemandUserBatchModel.ex", (Throwable)e);
        }
    }

    private PtForecastDemandUser getPtForecastDemandUserModelById(Integer forecastUserId) {
        if (null == forecastUserId) {
            return null;
        }
        try {
            return this.ptForecastDemandUserMapper.selectByPrimaryKey(forecastUserId);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandUserServiceImpl.getPtForecastDemandUserModelById", (Throwable)e);
            return null;
        }
    }

    private PtForecastDemandUser getPtForecastDemandUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptForecastDemandUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandUserServiceImpl.getPtForecastDemandUserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtForecastDemandUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptForecastDemandUserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.delPtForecastDemandUserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.delPtForecastDemandUserModelByCode.num");
        }
    }

    private void deletePtForecastDemandUserModel(Integer forecastUserId) throws ApiException {
        if (null == forecastUserId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptForecastDemandUserMapper.deleteByPrimaryKey(forecastUserId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.deletePtForecastDemandUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.deletePtForecastDemandUserModel.num");
        }
    }

    private void updatePtForecastDemandUserModel(PtForecastDemandUser ptForecastDemandUser) throws ApiException {
        if (null == ptForecastDemandUser) {
            return;
        }
        int i = 0;
        try {
            i = this.ptForecastDemandUserMapper.updateByPrimaryKey(ptForecastDemandUser);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.updatePtForecastDemandUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.updatePtForecastDemandUserModel.num");
        }
    }

    private void updateStatePtForecastDemandUserModel(Integer forecastUserId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == forecastUserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("forecastUserId", forecastUserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptForecastDemandUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.updateStatePtForecastDemandUserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.updateStatePtForecastDemandUserModel.null");
        }
    }

    private void updateStatePtForecastDemandUserModelByCode(String tenantCode, String forecastUserCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)forecastUserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("forecastUserCode", forecastUserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptForecastDemandUserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.updateStatePtForecastDemandUserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.updateStatePtForecastDemandUserModelByCode.null");
        }
    }

    private PtForecastDemandUser makePtForecastDemandUser(PtForecastDemandUserDomain ptForecastDemandUserDomain, PtForecastDemandUser ptForecastDemandUser) {
        if (null == ptForecastDemandUserDomain) {
            return null;
        }
        if (null == ptForecastDemandUser) {
            ptForecastDemandUser = new PtForecastDemandUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptForecastDemandUser, (Object)ptForecastDemandUserDomain);
            return ptForecastDemandUser;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandUserServiceImpl.makePtForecastDemandUser", (Throwable)e);
            return null;
        }
    }

    private PtForecastDemandUserReDomain makePtForecastDemandUserReDomain(PtForecastDemandUser ptForecastDemandUser) {
        if (null == ptForecastDemandUser) {
            return null;
        }
        PtForecastDemandUserReDomain ptForecastDemandUserReDomain = new PtForecastDemandUserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptForecastDemandUserReDomain, (Object)ptForecastDemandUser);
            return ptForecastDemandUserReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandUserServiceImpl.makePtForecastDemandUserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtForecastDemandUser> queryPtForecastDemandUserModelPage(Map<String, Object> parammap) {
        try {
            return this.ptForecastDemandUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandUserServiceImpl.queryPtForecastDemandUserModel", (Throwable)e);
            return null;
        }
    }

    private int countPtForecastDemandUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptForecastDemandUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtForecastDemandUserServiceImpl.countPtForecastDemandUser", (Throwable)e);
        }
        return i;
    }

    private PtForecastDemandUser createPtForecastDemandUser(PtForecastDemandUserDomain ptForecastDemandUserDomain) {
        String msg = this.checkPtForecastDemandUser(ptForecastDemandUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.savePtForecastDemandUser.checkPtForecastDemandUser", msg);
        }
        PtForecastDemandUser ptForecastDemandUser = this.makePtForecastDemandUser(ptForecastDemandUserDomain, null);
        this.setPtForecastDemandUserDefault(ptForecastDemandUser);
        return ptForecastDemandUser;
    }

    @Override
    public String savePtForecastDemandUser(PtForecastDemandUserReDomain ptForecastDemandUserDomain) throws ApiException {
        PtForecastDemandUser ptForecastDemandUser = this.createPtForecastDemandUser(ptForecastDemandUserDomain);
        this.savePtForecastDemandUserModel(ptForecastDemandUser);
        return ptForecastDemandUser.getForecastUserCode();
    }

    @Override
    public String savePtForecastDemandUserBatch(List<PtForecastDemandUserReDomain> ptForecastDemandUserDomainList) throws ApiException {
        if (null == ptForecastDemandUserDomainList || ptForecastDemandUserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtForecastDemandUser> ptForecastDemandUserList = new ArrayList<PtForecastDemandUser>();
        String code = "";
        for (PtForecastDemandUserDomain ptForecastDemandUserDomain : ptForecastDemandUserDomainList) {
            PtForecastDemandUser ptForecastDemandUser = this.createPtForecastDemandUser(ptForecastDemandUserDomain);
            code = ptForecastDemandUser.getForecastUserCode();
            ptForecastDemandUserList.add(ptForecastDemandUser);
        }
        this.savePtForecastDemandUserBatchModel(ptForecastDemandUserList);
        return code;
    }

    @Override
    public JSONObject checkImportList(JSONArray importList) throws ApiException {
        if (Objects.isNull(importList) || importList.isEmpty()) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.checkImportList.ex \u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<PtForecastDemandUserReDomain> passList = new ArrayList<PtForecastDemandUserReDomain>(importList.size());
        ArrayList<PtForecastDemandUserImportDomain> failList = new ArrayList<PtForecastDemandUserImportDomain>();
        List importDomins = importList.toJavaList(PtForecastDemandUserImportDomain.class);
        for (PtForecastDemandUserImportDomain importDomin : importDomins) {
            String msg = this.importCheck(importDomin);
            if (StringUtils.isBlank((String)msg)) {
                PtForecastDemandUserReDomain domain = new PtForecastDemandUserReDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)domain, (Object)importDomin);
                }
                catch (Exception e) {
                    this.logger.error("pt.POTENTIAL.PtForecastDemandUserServiceImpl.checkImportList", (Throwable)e);
                }
                passList.add(domain);
                continue;
            }
            importDomin.setMemo(msg);
            failList.add(importDomin);
        }
        JSONObject result = new JSONObject();
        result.put("passList", passList);
        result.put("failList", failList);
        return result;
    }

    private String importCheck(PtForecastDemandUserImportDomain domain) {
        String msg = "";
        if (StringUtils.isBlank((String)domain.getForecastSummaryCode())) {
            msg = msg + "\u9884\u6d4b\u5355\u7f16\u53f7 \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getFsUserCode())) {
            msg = msg + "\u7528\u6237\u7f16\u7801 \u4e3a\u7a7a";
            return msg;
        }
        return msg;
    }

    @Override
    public void updatePtForecastDemandUserState(Integer forecastUserId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == forecastUserId) {
            return;
        }
        this.updateStatePtForecastDemandUserModel(forecastUserId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtForecastDemandUserStateByCode(String tenantCode, String forecastUserCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)forecastUserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtForecastDemandUserModelByCode(tenantCode, forecastUserCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtForecastDemandUser(PtForecastDemandUserReDomain ptForecastDemandUserDomain) throws ApiException {
        String msg = this.checkPtForecastDemandUser(ptForecastDemandUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.updatePtForecastDemandUser.checkPtForecastDemandUser", msg);
        }
        PtForecastDemandUser oldPtForecastDemandUser = this.getPtForecastDemandUserModelById(ptForecastDemandUserDomain.getForecastUserId());
        if (null == oldPtForecastDemandUser) {
            throw new ApiException("pt.POTENTIAL.PtForecastDemandUserServiceImpl.updatePtForecastDemandUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtForecastDemandUser ptForecastDemandUser = this.makePtForecastDemandUser(ptForecastDemandUserDomain, oldPtForecastDemandUser);
        this.setPtForecastDemandUserUpdataDefault(ptForecastDemandUser);
        this.updatePtForecastDemandUserModel(ptForecastDemandUser);
    }

    @Override
    public void updatePtForecastDemandUserBatch(PtForecastDemandSummaryReDomain forecastSummaryDomain) throws ApiException {
        List<PtForecastDemandUserReDomain> userList = forecastSummaryDomain.getUserList();
        if (ListUtil.isEmpty(userList)) {
            return;
        }
        List idList = userList.stream().map(PtForecastDemandUserDomain::getForecastUserId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Integer> dbIdList = this.ptForecastDemandUserMapper.queryIdList(forecastSummaryDomain.getForecastSummaryCode());
        Collection deleteIdList = CollectionUtils.subtract(dbIdList, idList);
        for (PtForecastDemandUserReDomain userReDomain : userList) {
            userReDomain.setForecastSummaryCode(forecastSummaryDomain.getForecastSummaryCode());
            userReDomain.setTenantCode(forecastSummaryDomain.getTenantCode());
            userReDomain.setChannelCode(forecastSummaryDomain.getChannelCode());
            userReDomain.setChannelName(forecastSummaryDomain.getChannelName());
            if (Objects.isNull(userReDomain.getForecastUserId())) {
                userReDomain.setForecastUserCode(this.getDefaultCode(forecastSummaryDomain.getTenantCode()));
                userReDomain.setUserCode(forecastSummaryDomain.getUserCode());
                userReDomain.setUserName(forecastSummaryDomain.getUserName());
                this.savePtForecastDemandUser(userReDomain);
                continue;
            }
            userReDomain.setUserEcode(forecastSummaryDomain.getUserCode());
            userReDomain.setUserEname(forecastSummaryDomain.getUserName());
            this.updatePtForecastDemandUser(userReDomain);
        }
        if (ListUtil.isNotEmpty((Collection)deleteIdList)) {
            deleteIdList.forEach(this::deletePtForecastDemandUser);
        }
    }

    @Override
    public PtForecastDemandUserReDomain getPtForecastDemandUser(Integer forecastUserId) {
        if (null == forecastUserId) {
            return null;
        }
        PtForecastDemandUser ptForecastDemandUser = this.getPtForecastDemandUserModelById(forecastUserId);
        return this.makePtForecastDemandUserReDomain(ptForecastDemandUser);
    }

    @Override
    public void deletePtForecastDemandUser(Integer forecastUserId) throws ApiException {
        if (null == forecastUserId) {
            return;
        }
        this.deletePtForecastDemandUserModel(forecastUserId);
    }

    @Override
    public QueryResult<PtForecastDemandUser> queryPtForecastDemandUserPage(Map<String, Object> map) {
        List<PtForecastDemandUser> ptForecastDemandUserList = this.queryPtForecastDemandUserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtForecastDemandUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptForecastDemandUserList);
        return queryResult;
    }

    @Override
    public PtForecastDemandUserReDomain getPtForecastDemandUserByCode(String tenantCode, String forecastUserCode) throws ApiException {
        if (StringUtils.isBlank((String)forecastUserCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("forecastUserCode", forecastUserCode);
        PtForecastDemandUser ptForecastDemandUserModelByCode = this.getPtForecastDemandUserModelByCode(map);
        return this.makePtForecastDemandUserReDomain(ptForecastDemandUserModelByCode);
    }

    @Override
    public void deletePtForecastDemandUserByCode(String tenantCode, String forecastUserCode) throws ApiException {
        if (StringUtils.isBlank((String)forecastUserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("forecastUserCode", forecastUserCode);
        this.delPtForecastDemandUserModelByCode(map);
    }
}

