/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtRecruitmentPolicyMapper;
import com.yqbsoft.laser.service.potential.domain.PotentialFeePromotionDomain;
import com.yqbsoft.laser.service.potential.domain.PtRecruitmentPolicyReDomain;
import com.yqbsoft.laser.service.potential.domain.PtRecruitmentPolicyUpdateDomain;
import com.yqbsoft.laser.service.potential.model.PtRecruitmentPolicy;
import com.yqbsoft.laser.service.potential.service.PtRecruitmentPolicyService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;

public class PtRecruitmentPolicyServiceImpl
extends BaseServiceImpl
implements PtRecruitmentPolicyService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtRecruitmentPolicyServiceImpl";
    @Value(value="${spring.restTemp.isTest:false}")
    private boolean isTest;
    private PtRecruitmentPolicyMapper ptRecruitmentPolicyMapper;

    public void setPtRecruitmentPolicyMapper(PtRecruitmentPolicyMapper ptRecruitmentPolicyMapper) {
        this.ptRecruitmentPolicyMapper = ptRecruitmentPolicyMapper;
    }

    private String getDefaultCode(String tenantCode) {
        if (this.isTest) {
            return this.createUUIDString();
        }
        return this.getNo(null, "PtRecruitmentPolicy", "ptRecruitmentPolicy", tenantCode);
    }

    private Date getSysDate() {
        try {
            return this.ptRecruitmentPolicyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtRecruitmentPolicy(PtRecruitmentPolicyReDomain domain) {
        if (null == domain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)domain.getTenantCode())) {
            msg = msg + "TenantCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getChannelCode())) {
            msg = msg + "channelCode \u4e3a\u7a7a";
            return msg;
        }
        if (StringUtils.isBlank((String)domain.getRecruitmentPolicyName())) {
            msg = msg + "\u62db\u5546\u653f\u7b56\u540d\u79f0 \u4e3a\u7a7a";
            return msg;
        }
        if (Objects.isNull(domain.getRecruitmentPolicyStart())) {
            msg = msg + "\u653f\u7b56\u5f00\u59cb\u65f6\u95f4 \u4e3a\u7a7a";
            return msg;
        }
        if (Objects.isNull(domain.getRecruitmentPolicyEnd())) {
            msg = msg + "\u653f\u7b56\u7ed3\u675f\u65f6\u95f4 \u4e3a\u7a7a";
            return msg;
        }
        if (ListUtil.isEmpty(domain.getPotentialFeePromotionList())) {
            msg = msg + "\u610f\u5411\u91d1\u5347\u804c\u6bd4\u4f8b\u5217\u8868 \u4e3a\u7a7a";
            return msg;
        }
        return msg;
    }

    private void setPtRecruitmentPolicyDefault(PtRecruitmentPolicy ptRecruitmentPolicy) {
        if (null == ptRecruitmentPolicy) {
            return;
        }
        if (null == ptRecruitmentPolicy.getDataState()) {
            ptRecruitmentPolicy.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ptRecruitmentPolicy.getGmtCreate()) {
            ptRecruitmentPolicy.setGmtCreate(date);
        }
        ptRecruitmentPolicy.setGmtModified(date);
        if (StringUtils.isBlank((String)ptRecruitmentPolicy.getRecruitmentPolicyCode())) {
            ptRecruitmentPolicy.setRecruitmentPolicyCode(this.getDefaultCode(ptRecruitmentPolicy.getTenantCode()));
        }
    }

    private int getPtRecruitmentPolicyMaxCode() {
        int code = 0;
        try {
            return this.ptRecruitmentPolicyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.getPtRecruitmentPolicyMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtRecruitmentPolicyUpdataDefault(PtRecruitmentPolicy ptRecruitmentPolicy) {
        if (null == ptRecruitmentPolicy) {
            return;
        }
        ptRecruitmentPolicy.setGmtModified(this.getSysDate());
    }

    private void savePtRecruitmentPolicyModel(PtRecruitmentPolicy ptRecruitmentPolicy) throws ApiException {
        if (null == ptRecruitmentPolicy) {
            return;
        }
        try {
            this.ptRecruitmentPolicyMapper.insert(ptRecruitmentPolicy);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.savePtRecruitmentPolicyModel.ex", (Throwable)e);
        }
    }

    private void savePtRecruitmentPolicyBatchModel(List<PtRecruitmentPolicy> ptRecruitmentPolicyList) throws ApiException {
        if (null == ptRecruitmentPolicyList || ptRecruitmentPolicyList.isEmpty()) {
            return;
        }
        try {
            this.ptRecruitmentPolicyMapper.insertBatch(ptRecruitmentPolicyList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.savePtRecruitmentPolicyBatchModel.ex", (Throwable)e);
        }
    }

    private PtRecruitmentPolicyReDomain getPtRecruitmentPolicyModelById(Integer recruitmentPolicyId) {
        if (null == recruitmentPolicyId) {
            return null;
        }
        try {
            PtRecruitmentPolicy ptRecruitmentPolicy = this.ptRecruitmentPolicyMapper.selectByPrimaryKey(recruitmentPolicyId);
            return this.makePtRecruitmentPolicyReDomain(ptRecruitmentPolicy);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.getPtRecruitmentPolicyModelById", (Throwable)e);
            return null;
        }
    }

    private PtRecruitmentPolicyReDomain getPtRecruitmentPolicyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            PtRecruitmentPolicy ptRecruitmentPolicy = this.ptRecruitmentPolicyMapper.getByCode(map);
            return this.makePtRecruitmentPolicyReDomain(ptRecruitmentPolicy);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.getPtRecruitmentPolicyModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtRecruitmentPolicyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptRecruitmentPolicyMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.delPtRecruitmentPolicyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.delPtRecruitmentPolicyModelByCode.num");
        }
    }

    private void deletePtRecruitmentPolicyModel(Integer recruitmentPolicyId) throws ApiException {
        if (null == recruitmentPolicyId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptRecruitmentPolicyMapper.deleteByPrimaryKey(recruitmentPolicyId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.deletePtRecruitmentPolicyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.deletePtRecruitmentPolicyModel.num");
        }
    }

    private void updatePtRecruitmentPolicyModel(PtRecruitmentPolicy ptRecruitmentPolicy) throws ApiException {
        if (null == ptRecruitmentPolicy) {
            return;
        }
        int i = 0;
        try {
            i = this.ptRecruitmentPolicyMapper.updateByPrimaryKeyWithBLOBs(ptRecruitmentPolicy);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updatePtRecruitmentPolicyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updatePtRecruitmentPolicyModel.num");
        }
    }

    private void updateStatePtRecruitmentPolicyModel(Integer recruitmentPolicyId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == recruitmentPolicyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recruitmentPolicyId", recruitmentPolicyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptRecruitmentPolicyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updateStatePtRecruitmentPolicyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updateStatePtRecruitmentPolicyModel.null");
        }
    }

    private void updateStatePtRecruitmentPolicyModelByCode(String tenantCode, String recruitmentPolicyCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)recruitmentPolicyCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitmentPolicyCode", recruitmentPolicyCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptRecruitmentPolicyMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updateStatePtRecruitmentPolicyModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updateStatePtRecruitmentPolicyModelByCode.null");
        }
    }

    private PtRecruitmentPolicy makePtRecruitmentPolicy(PtRecruitmentPolicyReDomain domain, PtRecruitmentPolicy ptRecruitmentPolicy) {
        if (null == domain) {
            return null;
        }
        if (null == ptRecruitmentPolicy) {
            ptRecruitmentPolicy = new PtRecruitmentPolicy();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptRecruitmentPolicy, (Object)domain);
            if (ListUtil.isNotEmpty(domain.getPotentialFeePromotionList())) {
                String jsonString = JSON.toJSONString(domain.getPotentialFeePromotionList());
                ptRecruitmentPolicy.setPotentialFeePromotion(jsonString);
            }
            return ptRecruitmentPolicy;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.makePtRecruitmentPolicy", (Throwable)e);
            return null;
        }
    }

    private PtRecruitmentPolicyReDomain makePtRecruitmentPolicyReDomain(PtRecruitmentPolicy ptRecruitmentPolicy) {
        if (null == ptRecruitmentPolicy) {
            return null;
        }
        PtRecruitmentPolicyReDomain domain = new PtRecruitmentPolicyReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)domain, (Object)ptRecruitmentPolicy);
            if (StringUtils.isNotBlank((String)ptRecruitmentPolicy.getPotentialFeePromotion())) {
                List potentialFeePromotionDomains = JSON.parseArray((String)ptRecruitmentPolicy.getPotentialFeePromotion(), PotentialFeePromotionDomain.class);
                domain.setPotentialFeePromotionList(potentialFeePromotionDomains);
                domain.setPotentialFeePromotion(null);
            }
            return domain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.makePtRecruitmentPolicyReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtRecruitmentPolicy> queryPtRecruitmentPolicyModelPage(Map<String, Object> parammap) {
        try {
            return this.ptRecruitmentPolicyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.queryPtRecruitmentPolicyModel", (Throwable)e);
            return null;
        }
    }

    private int countPtRecruitmentPolicy(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptRecruitmentPolicyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.countPtRecruitmentPolicy", (Throwable)e);
        }
        return i;
    }

    private PtRecruitmentPolicy createPtRecruitmentPolicy(PtRecruitmentPolicyReDomain PtRecruitmentPolicyReDomain2) {
        String msg = this.checkPtRecruitmentPolicy(PtRecruitmentPolicyReDomain2);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.savePtRecruitmentPolicy.checkPtRecruitmentPolicy", msg);
        }
        PtRecruitmentPolicy ptRecruitmentPolicy = this.makePtRecruitmentPolicy(PtRecruitmentPolicyReDomain2, null);
        this.setPtRecruitmentPolicyDefault(ptRecruitmentPolicy);
        return ptRecruitmentPolicy;
    }

    @Override
    public String savePtRecruitmentPolicy(PtRecruitmentPolicyReDomain ptRecruitmentPolicyReDomain) throws ApiException {
        PtRecruitmentPolicy ptRecruitmentPolicy = this.createPtRecruitmentPolicy(ptRecruitmentPolicyReDomain);
        this.savePtRecruitmentPolicyModel(ptRecruitmentPolicy);
        return ptRecruitmentPolicy.getRecruitmentPolicyCode();
    }

    @Override
    public String savePtRecruitmentPolicyBatch(List<PtRecruitmentPolicyReDomain> ptRecruitmentPolicyReDomainList) throws ApiException {
        if (null == ptRecruitmentPolicyReDomainList || ptRecruitmentPolicyReDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtRecruitmentPolicy> ptRecruitmentPolicyList = new ArrayList<PtRecruitmentPolicy>();
        String code = "";
        for (PtRecruitmentPolicyReDomain PtRecruitmentPolicyReDomain2 : ptRecruitmentPolicyReDomainList) {
            PtRecruitmentPolicy ptRecruitmentPolicy = this.createPtRecruitmentPolicy(PtRecruitmentPolicyReDomain2);
            code = ptRecruitmentPolicy.getRecruitmentPolicyCode();
            ptRecruitmentPolicyList.add(ptRecruitmentPolicy);
        }
        this.savePtRecruitmentPolicyBatchModel(ptRecruitmentPolicyList);
        return code;
    }

    @Override
    public void updatePtRecruitmentPolicyState(Integer recruitmentPolicyId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == recruitmentPolicyId) {
            return;
        }
        this.updateStatePtRecruitmentPolicyModel(recruitmentPolicyId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtRecruitmentPolicyStateByCode(String tenantCode, String recruitmentPolicyCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)recruitmentPolicyCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtRecruitmentPolicyModelByCode(tenantCode, recruitmentPolicyCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtRecruitmentPolicy(PtRecruitmentPolicyReDomain ptRecruitmentPolicyReDomain) throws ApiException {
        String msg = this.checkPtRecruitmentPolicy(ptRecruitmentPolicyReDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updatePtRecruitmentPolicy.checkPtRecruitmentPolicy", msg);
        }
        PtRecruitmentPolicy oldPtRecruitmentPolicy = this.ptRecruitmentPolicyMapper.selectByPrimaryKey(ptRecruitmentPolicyReDomain.getRecruitmentPolicyId());
        if (null == oldPtRecruitmentPolicy) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updatePtRecruitmentPolicy.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtRecruitmentPolicy ptRecruitmentPolicy = this.makePtRecruitmentPolicy(ptRecruitmentPolicyReDomain, oldPtRecruitmentPolicy);
        this.setPtRecruitmentPolicyUpdataDefault(ptRecruitmentPolicy);
        this.updatePtRecruitmentPolicyModel(ptRecruitmentPolicy);
    }

    @Override
    public void updatePtRecruitmentPolicySelective(PtRecruitmentPolicyUpdateDomain ptRecruitmentPolicyUpdateDomain) throws ApiException {
        if (Objects.isNull(ptRecruitmentPolicyUpdateDomain)) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updatePtRecruitmentPolicySelective", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (Objects.isNull(ptRecruitmentPolicyUpdateDomain.getRecruitmentPolicyId())) {
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updatePtRecruitmentPolicySelective", "\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            PtRecruitmentPolicy ptRecruitmentPolicy = new PtRecruitmentPolicy();
            BeanUtils.copyAllPropertysNotNull((Object)ptRecruitmentPolicy, (Object)ptRecruitmentPolicyUpdateDomain);
            this.ptRecruitmentPolicyMapper.updateByPrimaryKeySelective(ptRecruitmentPolicy);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updatePtRecruitmentPolicySelective", (Throwable)e);
            throw new ApiException("pt.POTENTIAL.PtRecruitmentPolicyServiceImpl.updatePtRecruitmentPolicySelective", "\u66f4\u65b0\u5f02\u5e38");
        }
    }

    @Override
    public PtRecruitmentPolicyReDomain getPtRecruitmentPolicy(Integer recruitmentPolicyId) {
        if (null == recruitmentPolicyId) {
            return null;
        }
        return this.getPtRecruitmentPolicyModelById(recruitmentPolicyId);
    }

    @Override
    public void deletePtRecruitmentPolicy(Integer recruitmentPolicyId) throws ApiException {
        if (null == recruitmentPolicyId) {
            return;
        }
        this.deletePtRecruitmentPolicyModel(recruitmentPolicyId);
    }

    @Override
    public QueryResult<PtRecruitmentPolicy> queryPtRecruitmentPolicyPage(Map<String, Object> map) {
        List<PtRecruitmentPolicy> ptRecruitmentPolicyList = this.queryPtRecruitmentPolicyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtRecruitmentPolicy(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptRecruitmentPolicyList);
        return queryResult;
    }

    @Override
    public PtRecruitmentPolicyReDomain getPtRecruitmentPolicyByCode(String tenantCode, String recruitmentPolicyCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitmentPolicyCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitmentPolicyCode", recruitmentPolicyCode);
        return this.getPtRecruitmentPolicyModelByCode(map);
    }

    @Override
    public void deletePtRecruitmentPolicyByCode(String tenantCode, String recruitmentPolicyCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitmentPolicyCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitmentPolicyCode", recruitmentPolicyCode);
        this.delPtRecruitmentPolicyModelByCode(map);
    }
}

