/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.message;

import com.yqbsoft.laser.service.potential.enums.MessageCategory;
import com.yqbsoft.laser.service.potential.message.MessageService;
import com.yqbsoft.laser.service.potential.message.MessageTemplateDomain;
import com.yqbsoft.laser.service.potential.message.SendMessageRequest;
import com.yqbsoft.laser.service.potential.message.SendMessageResponse;
import com.yqbsoft.laser.service.potential.message.SimpleUserDTO;
import com.yqbsoft.laser.service.potential.message.TemplateService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageSenderTemp {
    private static final Logger log = LoggerFactory.getLogger(MessageSenderTemp.class);
    private final MessageService messageService;
    private final TemplateService templateService;
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");

    public SendMessageResponse send(String templateCode, Map<String, String> params, List<SimpleUserDTO> receivers, List<String> channels, MessageCategory bizCategory, String bizCode) {
        MessageTemplateDomain template = this.templateService.getTemplates().stream().filter(t -> t.getTemplateCode().equals(templateCode)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u6a21\u677f\u4e0d\u5b58\u5728: " + templateCode));
        String content = this.replacePlaceholders(template.getContent(), params);
        SendMessageRequest request = new SendMessageRequest();
        request.setBizCode(bizCode);
        request.setSenderId("SYSTEM");
        request.setSenderName("SYSTEM");
        request.setTemplateCode(templateCode);
        request.setContent(content);
        request.setBizCategory(bizCategory.name());
        request.setSubject(params.getOrDefault("subject", template.getName()));
        request.setParams(params);
        request.setChannels(channels);
        request.setReceivers(receivers);
        log.info("\u53d1\u9001\u6d88\u606f => \u6a21\u677f:{}, \u5206\u7c7b:{}, \u4e1a\u52a1\u7f16\u7801:{}, \u63a5\u6536\u4eba:{}, \u6e20\u9053:{}, \u5185\u5bb9:{}", new Object[]{templateCode, bizCategory, bizCode, receivers, channels, content});
        return this.messageService.sendMessage(request);
    }

    private String replacePlaceholders(String template, Map<String, String> params) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = params.getOrDefault(key, "");
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public void notifyOrderShipped(String orderNo, String trackingNo, SimpleUserDTO user) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderNo", orderNo);
        params.put("trackingNo", trackingNo);
        this.send("ORDER_SHIPPED", params, Collections.singletonList(user), Collections.singletonList("INBOX"), MessageCategory.ORDER, orderNo);
    }

    public void notifyContractExpiring(String customerName, String contractNo, String endDate, SimpleUserDTO user) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customerName", customerName);
        params.put("contractNo", contractNo);
        params.put("endDate", endDate);
        this.send("CONTRACT_EXPIRING", params, Collections.singletonList(user), Arrays.asList("INBOX", "EMAIL"), MessageCategory.CONTRACT, contractNo);
    }

    public void notifyApprovalSubmitted(String approvalNo, String approvalTitle, SimpleUserDTO initiator) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approvalNo", approvalNo);
        params.put("approvalTitle", approvalTitle);
        this.send("APPROVAL_SUBMITTED", params, Collections.singletonList(initiator), Collections.singletonList("INBOX"), MessageCategory.OTHER, approvalNo);
    }

    public void notifyApprovalPending(String approvalNo, String approvalTitle, SimpleUserDTO approver) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approvalNo", approvalNo);
        params.put("approvalTitle", approvalTitle);
        this.send("APPROVAL_PENDING", params, Collections.singletonList(approver), Arrays.asList("INBOX", "EMAIL"), MessageCategory.OTHER, approvalNo);
    }

    public void notifyApprovalApproved(String approvalNo, String approvalTitle, String approverName, SimpleUserDTO initiator) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approvalNo", approvalNo);
        params.put("approvalTitle", approvalTitle);
        params.put("approverName", approverName);
        this.send("APPROVAL_APPROVED", params, Collections.singletonList(initiator), Arrays.asList("INBOX", "EMAIL"), MessageCategory.OTHER, approvalNo);
    }

    public void notifyApprovalRejected(String approvalNo, String approvalTitle, String reason, SimpleUserDTO initiator) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approvalNo", approvalNo);
        params.put("approvalTitle", approvalTitle);
        params.put("reason", reason);
        this.send("APPROVAL_REJECTED", params, Collections.singletonList(initiator), Arrays.asList("INBOX", "EMAIL"), MessageCategory.OTHER, approvalNo);
    }

    public void notifyDepositPending(String orderNo, String depositAmount, SimpleUserDTO user) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderNo", orderNo);
        params.put("depositAmount", depositAmount);
        this.send("DEPOSIT_PENDING", params, Collections.singletonList(user), Arrays.asList("INBOX", "EMAIL"), MessageCategory.ORDER, orderNo);
    }

    public MessageSenderTemp(MessageService messageService, TemplateService templateService) {
        this.messageService = messageService;
        this.templateService = templateService;
    }
}

