/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.enums;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum ContractStatusEnum {
    PENDING_APPROVAL(1, "\u5f85\u5ba1\u6279"),
    PENDING_ADJUSTMENT(2, "\u5f85\u8c03\u6574"),
    PENDING_CREATE_DEPOSIT(3, "\u5f85\u521b\u5efa\u5408\u540c\u4fdd\u8bc1\u91d1"),
    PENDING_PAYMENT_DEPOSIT(4, "\u5f85\u7f34\u7eb3\u5408\u540c\u4fdd\u8bc1\u91d1"),
    PENDING_PUSH(5, "\u5f85\u63a8\u9001"),
    PENDING_SIGNING(6, "\u5f85\u7b7e\u7ea6"),
    LIVE(7, "\u751f\u6548\u4e2d"),
    DEPOSIT_REFUNDING(8, "\u4fdd\u8bc1\u91d1\u9000\u8fd8\u4e2d"),
    DEPOSIT_REFUNDED(9, "\u4fdd\u8bc1\u91d1\u5df2\u9000\u8fd8"),
    DEPOSIT_REFUND_REJECTED(10, "\u4fdd\u8bc1\u91d1\u9000\u8fd8\u9a73\u56de"),
    EXPIRED(0, "\u5df2\u5230\u671f"),
    TERMINATED(-1, "\u5df2\u7ec8\u6b62"),
    CLOSED(-2, "\u5df2\u5173\u95ed");

    private final int code;
    private final String description;

    private ContractStatusEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static ContractStatusEnum fromCode(int code) {
        for (ContractStatusEnum type : ContractStatusEnum.values()) {
            if (type.getCode() != code) continue;
            return type;
        }
        return null;
    }

    public static boolean check(int code) {
        for (ContractStatusEnum type : ContractStatusEnum.values()) {
            if (type.getCode() != code) continue;
            return true;
        }
        return false;
    }

    public static String getStatusValues(ContractStatusEnum ... statuses) {
        return Arrays.stream(statuses).map(e -> String.valueOf(e.getCode())).collect(Collectors.joining(","));
    }

    public static String getStatusValuesAll() {
        return Arrays.stream(ContractStatusEnum.values()).map(e -> String.valueOf(e.getCode())).collect(Collectors.joining(","));
    }
}

